/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tracing;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.tracing.NoopTracingProvider;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.utils.KeycloakSessionUtil;

public class TracingProviderUtil {
    private static final Logger log = Logger.getLogger(TracingProviderUtil.class);
    private static TracingProvider NOOP_PROVIDER;

    public static TracingProvider getTracingProvider(KeycloakSession session) {
        return (TracingProvider)session.getProvider(TracingProvider.class);
    }

    public static TracingProvider getTracingProvider() {
        KeycloakSession session = KeycloakSessionUtil.getKeycloakSession();
        if (session == null) {
            log.warn((Object)"Cannot obtain session from thread to init TracingProvider. Return Noop provider.");
            if (NOOP_PROVIDER == null) {
                NOOP_PROVIDER = new NoopTracingProvider();
            }
            return NOOP_PROVIDER;
        }
        return TracingProviderUtil.getTracingProvider(session);
    }
}

