;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: wasm-opt %s -all -o %t.text.wast -g -S
;; RUN: wasm-as %s -all -g -o %t.wasm
;; RUN: wasm-dis %t.wasm -all -o %t.bin.wast
;; RUN: wasm-as %s -all -o %t.nodebug.wasm
;; RUN: wasm-dis %t.nodebug.wasm -all -o %t.bin.nodebug.wast
;; RUN: cat %t.text.wast | filecheck %s --check-prefix=CHECK-TEXT
;; RUN: cat %t.bin.wast | filecheck %s --check-prefix=CHECK-BIN
;; RUN: cat %t.bin.nodebug.wast | filecheck %s --check-prefix=CHECK-BIN-NODEBUG

(module
 ;; CHECK-TEXT:      (type $0 (func))
 ;; CHECK-BIN:      (type $0 (func))
 ;; CHECK-BIN-NODEBUG:      (type $0 (func))
 (type $0 (func))
 ;; CHECK-TEXT:      (memory $0 23 256 shared)
 ;; CHECK-BIN:      (memory $0 23 256 shared)
 ;; CHECK-BIN-NODEBUG:      (memory $0 23 256 shared)
 (memory $0 23 256 shared)

 ;; CHECK-TEXT:      (func $atomic-loadstore (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i32)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load8_u offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load16_u offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.load offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load8_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load16_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load32_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.load
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store8 offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i32.atomic.store16 offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store8 offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store16 offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (i64.atomic.store32 offset=4
 ;; CHECK-TEXT-NEXT:   (local.get $0)
 ;; CHECK-TEXT-NEXT:   (local.get $1)
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-loadstore (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i32)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load8_u offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load16_u offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.load offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load8_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load16_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load32_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.load
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store8 offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i32.atomic.store16 offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store8 offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store16 offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (i64.atomic.store32 offset=4
 ;; CHECK-BIN-NEXT:   (local.get $0)
 ;; CHECK-BIN-NEXT:   (local.get $1)
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-loadstore (type $0)
  (local $0 i32)
  (local $1 i64)
  (drop
   (i32.atomic.load8_u offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load16_u offset=4
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.load offset=4
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load8_u
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load16_u
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load32_u
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.load
    (local.get $0)
   )
  )
  (i32.atomic.store offset=4 align=4
   (local.get $0)
   (local.get $0)
  )
  (i32.atomic.store8 offset=4 align=1
   (local.get $0)
   (local.get $0)
  )
  (i32.atomic.store16 offset=4
   (local.get $0)
   (local.get $0)
  )
  (i64.atomic.store offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store8 offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store16 offset=4
   (local.get $0)
   (local.get $1)
  )
  (i64.atomic.store32 offset=4
   (local.get $0)
   (local.get $1)
  )
 )

 ;; CHECK-TEXT:      (func $atomic-rmw (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i32)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.add offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.add_u offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw16.and_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.or_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.xchg_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-rmw (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i32)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.add offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.add_u offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw16.and_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.or_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.xchg_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-rmw (type $0)
  (local $0 i32)
  (local $1 i64)
  (drop
   (i32.atomic.rmw.add offset=4
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.rmw8.add_u offset=4
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.rmw16.and_u align=2
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.rmw32.or_u
    (local.get $0)
    (local.get $1)
   )
  )
  (drop
   (i32.atomic.rmw8.xchg_u align=1
    (local.get $0)
    (local.get $0)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-cmpxchg (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i32)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw.cmpxchg offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i32.atomic.rmw8.cmpxchg_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw.cmpxchg offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (i64.atomic.rmw32.cmpxchg_u
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-cmpxchg (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i32)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw.cmpxchg offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i32.atomic.rmw8.cmpxchg_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw.cmpxchg offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (i64.atomic.rmw32.cmpxchg_u
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-cmpxchg (type $0)
  (local $0 i32)
  (local $1 i64)
  (drop
   (i32.atomic.rmw.cmpxchg offset=4
    (local.get $0)
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (i32.atomic.rmw8.cmpxchg_u
    (local.get $0)
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (i64.atomic.rmw.cmpxchg offset=4
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (i64.atomic.rmw32.cmpxchg_u align=4
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-wait-notify (type $0)
 ;; CHECK-TEXT-NEXT:  (local $0 i32)
 ;; CHECK-TEXT-NEXT:  (local $1 i64)
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait32 offset=4
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.notify offset=24
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT:  (drop
 ;; CHECK-TEXT-NEXT:   (memory.atomic.wait64 offset=16
 ;; CHECK-TEXT-NEXT:    (local.get $0)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:    (local.get $1)
 ;; CHECK-TEXT-NEXT:   )
 ;; CHECK-TEXT-NEXT:  )
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-wait-notify (type $0)
 ;; CHECK-BIN-NEXT:  (local $0 i32)
 ;; CHECK-BIN-NEXT:  (local $1 i64)
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait32 offset=4
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.notify offset=24
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT:  (drop
 ;; CHECK-BIN-NEXT:   (memory.atomic.wait64 offset=16
 ;; CHECK-BIN-NEXT:    (local.get $0)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:    (local.get $1)
 ;; CHECK-BIN-NEXT:   )
 ;; CHECK-BIN-NEXT:  )
 ;; CHECK-BIN-NEXT: )
 (func $atomic-wait-notify (type $0)
  (local $0 i32)
  (local $1 i64)
  (drop
   (memory.atomic.wait32
    (local.get $0)
    (local.get $0)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait32 offset=4 align=4
    (local.get $0)
    (local.get $0)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.notify
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (memory.atomic.notify offset=24 align=4
    (local.get $0)
    (local.get $0)
   )
  )
  (drop
   (memory.atomic.wait64
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
  (drop
   (memory.atomic.wait64 offset=16 align=8
    (local.get $0)
    (local.get $1)
    (local.get $1)
   )
  )
 )

 ;; CHECK-TEXT:      (func $atomic-fence (type $0)
 ;; CHECK-TEXT-NEXT:  (atomic.fence)
 ;; CHECK-TEXT-NEXT: )
 ;; CHECK-BIN:      (func $atomic-fence (type $0)
 ;; CHECK-BIN-NEXT:  (atomic.fence)
 ;; CHECK-BIN-NEXT: )
 (func $atomic-fence (type $0)
  (atomic.fence)
 )
)
;; CHECK-BIN-NODEBUG:      (func $0 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load8_u offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load16_u offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.load offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load8_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load16_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load32_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.load
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store8 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i32.atomic.store16 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store8 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store16 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (i64.atomic.store32 offset=4
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $1 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.add offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.add_u offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw16.and_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.or_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.xchg_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $2 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw.cmpxchg offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i32.atomic.rmw8.cmpxchg_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw.cmpxchg offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (i64.atomic.rmw32.cmpxchg_u
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $3 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (local $0 i32)
;; CHECK-BIN-NODEBUG-NEXT:  (local $1 i64)
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait32 offset=4
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.notify offset=24
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT:  (drop
;; CHECK-BIN-NODEBUG-NEXT:   (memory.atomic.wait64 offset=16
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $0)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:    (local.get $1)
;; CHECK-BIN-NODEBUG-NEXT:   )
;; CHECK-BIN-NODEBUG-NEXT:  )
;; CHECK-BIN-NODEBUG-NEXT: )

;; CHECK-BIN-NODEBUG:      (func $4 (type $0)
;; CHECK-BIN-NODEBUG-NEXT:  (atomic.fence)
;; CHECK-BIN-NODEBUG-NEXT: )
