; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68000 --code-model=large | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68010 --code-model=large | FileCheck %s --check-prefix=NO-ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68000 --code-model=large --relocation-model=pic | FileCheck %s --check-prefix=NO-ATOMIC-PIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68010 --code-model=large --relocation-model=pic | FileCheck %s --check-prefix=NO-ATOMIC-PIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68020 --code-model=large | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68030 --code-model=large | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68040 --code-model=large | FileCheck %s --check-prefix=ATOMIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68020 --code-model=large --relocation-model=pic | FileCheck %s --check-prefix=ATOMIC-PIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68030 --code-model=large --relocation-model=pic | FileCheck %s --check-prefix=ATOMIC-PIC
; RUN: llc %s -o - -mtriple=m68k -mcpu=M68040 --code-model=large --relocation-model=pic | FileCheck %s --check-prefix=ATOMIC-PIC

define i8 @atomic_load_i8_unordered(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i8_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i8_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i8, ptr %a unordered, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_monotonic(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i8_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i8_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i8, ptr %a monotonic, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_acquire(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i8_acquire:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i8_acquire:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i8, ptr %a acquire, align 1
  ret i8 %1
}

define i8 @atomic_load_i8_seq_cst(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i8_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i8_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i8_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i8_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i8, ptr %a seq_cst, align 1
  ret i8 %1
}

define i16 @atomic_load_i16_unordered(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i16_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i16_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i16, ptr %a unordered, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_monotonic(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i16_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i16_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i16, ptr %a monotonic, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_acquire(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i16_acquire:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i16_acquire:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i16, ptr %a acquire, align 2
  ret i16 %1
}

define i16 @atomic_load_i16_seq_cst(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i16_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i16_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i16_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i16_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i16, ptr %a seq_cst, align 2
  ret i16 %1
}

define i32 @atomic_load_i32_unordered(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i32_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i32_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i32, ptr %a unordered, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_monotonic(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i32_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i32_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i32, ptr %a monotonic, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_acquire(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i32_acquire:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i32_acquire:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i32, ptr %a acquire, align 4
  ret i32 %1
}

define i32 @atomic_load_i32_seq_cst(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i32_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i32_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i32_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i32_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l (%a0), %d0
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i32, ptr %a seq_cst, align 4
  ret i32 %1
}

define i64 @atomic_load_i64_unordered(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i64_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i64_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #12, %sp
; ATOMIC-PIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #12, %sp
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i64, ptr %a unordered, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_monotonic(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i64_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #0, (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i64_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #12, %sp
; ATOMIC-PIC-NEXT:    move.l #0, (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #12, %sp
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i64, ptr %a monotonic, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_acquire(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_acquire:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #2, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i64_acquire:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #2, (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_acquire:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #2, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i64_acquire:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #12, %sp
; ATOMIC-PIC-NEXT:    move.l #2, (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #12, %sp
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i64, ptr %a acquire, align 8
  ret i64 %1
}

define i64 @atomic_load_i64_seq_cst(ptr %a) nounwind {
; NO-ATOMIC-LABEL: atomic_load_i64_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-NEXT:    move.l #5, (4,%sp)
; NO-ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_load_8
; NO-ATOMIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_load_i64_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #5, (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #12, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_load_i64_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #12, %sp
; ATOMIC-NEXT:    move.l #5, (4,%sp)
; ATOMIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_load_8
; ATOMIC-NEXT:    adda.l #12, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_load_i64_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #12, %sp
; ATOMIC-PIC-NEXT:    move.l #5, (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (16,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_load_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #12, %sp
; ATOMIC-PIC-NEXT:    rts
  %1 = load atomic i64, ptr %a seq_cst, align 8
  ret i64 %1
}

define void @atomic_store_i8_unordered(ptr %a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i8_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i8_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i8 %val, ptr %a unordered, align 1
  ret void
}

define void @atomic_store_i8_monotonic(ptr %a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i8_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i8_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i8 %val, ptr %a monotonic, align 1
  ret void
}

define void @atomic_store_i8_release(ptr %a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i8_release:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i8_release:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i8 %val, ptr %a release, align 1
  ret void
}

define void @atomic_store_i8_seq_cst(ptr %a, i8 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i8_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i8_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i8_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i8_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.b (11,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.b %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i8 %val, ptr %a seq_cst, align 1
  ret void
}

define void @atomic_store_i16_unordered(ptr %a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i16_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i16_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i16 %val, ptr %a unordered, align 2
  ret void
}

define void @atomic_store_i16_monotonic(ptr %a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i16_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i16_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i16 %val, ptr %a monotonic, align 2
  ret void
}

define void @atomic_store_i16_release(ptr %a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i16_release:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i16_release:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i16 %val, ptr %a release, align 2
  ret void
}

define void @atomic_store_i16_seq_cst(ptr %a, i16 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i16_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i16_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i16_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i16_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.w (10,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.w %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i16 %val, ptr %a seq_cst, align 2
  ret void
}

define void @atomic_store_i32_unordered(ptr %a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i32_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i32_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i32 %val, ptr %a unordered, align 4
  ret void
}

define void @atomic_store_i32_monotonic(ptr %a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i32_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i32_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i32 %val, ptr %a monotonic, align 4
  ret void
}

define void @atomic_store_i32_release(ptr %a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i32_release:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i32_release:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i32 %val, ptr %a release, align 4
  ret void
}

define void @atomic_store_i32_seq_cst(ptr %a, i32 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i32_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i32_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i32_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i32_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    move.l (8,%sp), %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l %d0, (%a0)
; ATOMIC-PIC-NEXT:    rts
  store atomic i32 %val, ptr %a seq_cst, align 4
  ret void
}

define void @atomic_store_i64_unordered(ptr %a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_unordered:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i64_unordered:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_unordered:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i64_unordered:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #20, %sp
; ATOMIC-PIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #20, %sp
; ATOMIC-PIC-NEXT:    rts
  store atomic i64 %val, ptr %a unordered, align 8
  ret void
}

define void @atomic_store_i64_monotonic(ptr %a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_monotonic:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i64_monotonic:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #0, (12,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_monotonic:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i64_monotonic:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #20, %sp
; ATOMIC-PIC-NEXT:    move.l #0, (12,%sp)
; ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #20, %sp
; ATOMIC-PIC-NEXT:    rts
  store atomic i64 %val, ptr %a monotonic, align 8
  ret void
}

define void @atomic_store_i64_release(ptr %a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_release:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #3, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i64_release:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #3, (12,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_release:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #3, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i64_release:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #20, %sp
; ATOMIC-PIC-NEXT:    move.l #3, (12,%sp)
; ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #20, %sp
; ATOMIC-PIC-NEXT:    rts
  store atomic i64 %val, ptr %a release, align 8
  ret void
}

define void @atomic_store_i64_seq_cst(ptr %a, i64 %val) nounwind {
; NO-ATOMIC-LABEL: atomic_store_i64_seq_cst:
; NO-ATOMIC:       ; %bb.0:
; NO-ATOMIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-NEXT:    move.l #5, (12,%sp)
; NO-ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-NEXT:    jsr __atomic_store_8
; NO-ATOMIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: atomic_store_i64_seq_cst:
; NO-ATOMIC-PIC:       ; %bb.0:
; NO-ATOMIC-PIC-NEXT:    suba.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    move.l #5, (12,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; NO-ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; NO-ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; NO-ATOMIC-PIC-NEXT:    adda.l #20, %sp
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: atomic_store_i64_seq_cst:
; ATOMIC:       ; %bb.0:
; ATOMIC-NEXT:    suba.l #20, %sp
; ATOMIC-NEXT:    move.l #5, (12,%sp)
; ATOMIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-NEXT:    jsr __atomic_store_8
; ATOMIC-NEXT:    adda.l #20, %sp
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: atomic_store_i64_seq_cst:
; ATOMIC-PIC:       ; %bb.0:
; ATOMIC-PIC-NEXT:    suba.l #20, %sp
; ATOMIC-PIC-NEXT:    move.l #5, (12,%sp)
; ATOMIC-PIC-NEXT:    move.l (32,%sp), (8,%sp)
; ATOMIC-PIC-NEXT:    move.l (28,%sp), (4,%sp)
; ATOMIC-PIC-NEXT:    move.l (24,%sp), (%sp)
; ATOMIC-PIC-NEXT:    jsr (__atomic_store_8@PLT,%pc)
; ATOMIC-PIC-NEXT:    adda.l #20, %sp
; ATOMIC-PIC-NEXT:    rts
  store atomic i64 %val, ptr %a seq_cst, align 8
  ret void
}

define void @store_arid(ptr nonnull align 4 %a) {
; NO-ATOMIC-LABEL: store_arid:
; NO-ATOMIC:         .cfi_startproc
; NO-ATOMIC-NEXT:  ; %bb.0: ; %start
; NO-ATOMIC-NEXT:    moveq #1, %d0
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l %d0, (32,%a0)
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: store_arid:
; NO-ATOMIC-PIC:         .cfi_startproc
; NO-ATOMIC-PIC-NEXT:  ; %bb.0: ; %start
; NO-ATOMIC-PIC-NEXT:    moveq #1, %d0
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l %d0, (32,%a0)
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: store_arid:
; ATOMIC:         .cfi_startproc
; ATOMIC-NEXT:  ; %bb.0: ; %start
; ATOMIC-NEXT:    moveq #1, %d0
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l %d0, (32,%a0)
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: store_arid:
; ATOMIC-PIC:         .cfi_startproc
; ATOMIC-PIC-NEXT:  ; %bb.0: ; %start
; ATOMIC-PIC-NEXT:    moveq #1, %d0
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l %d0, (32,%a0)
; ATOMIC-PIC-NEXT:    rts
start:
  %1 = getelementptr inbounds i32, ptr %a, i32 8
  store atomic i32 1, ptr %1 seq_cst, align 4
  br label %exit

exit:                                              ; preds = %start
  ret void
}

define i32 @load_arid(ptr nonnull align 4 %a) {
; NO-ATOMIC-LABEL: load_arid:
; NO-ATOMIC:         .cfi_startproc
; NO-ATOMIC-NEXT:  ; %bb.0: ; %start
; NO-ATOMIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-NEXT:    move.l (32,%a0), %d0
; NO-ATOMIC-NEXT:    rts
;
; NO-ATOMIC-PIC-LABEL: load_arid:
; NO-ATOMIC-PIC:         .cfi_startproc
; NO-ATOMIC-PIC-NEXT:  ; %bb.0: ; %start
; NO-ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; NO-ATOMIC-PIC-NEXT:    move.l (32,%a0), %d0
; NO-ATOMIC-PIC-NEXT:    rts
;
; ATOMIC-LABEL: load_arid:
; ATOMIC:         .cfi_startproc
; ATOMIC-NEXT:  ; %bb.0: ; %start
; ATOMIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-NEXT:    move.l (32,%a0), %d0
; ATOMIC-NEXT:    rts
;
; ATOMIC-PIC-LABEL: load_arid:
; ATOMIC-PIC:         .cfi_startproc
; ATOMIC-PIC-NEXT:  ; %bb.0: ; %start
; ATOMIC-PIC-NEXT:    move.l (4,%sp), %a0
; ATOMIC-PIC-NEXT:    move.l (32,%a0), %d0
; ATOMIC-PIC-NEXT:    rts
start:
  %1 = getelementptr inbounds i32, ptr %a, i32 8
  %2 = load atomic i32, ptr %1 seq_cst, align 4
  br label %exit

exit:                                              ; preds = %start
  ret i32 %2
}
