/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.core.variants.IResourceVariant;

public class ResourceVariantFileRevision
extends FileRevision
implements IAdaptable {
    private final IResourceVariant variant;

    public ResourceVariantFileRevision(IResourceVariant variant) {
        this.variant = variant;
    }

    @Override
    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return this.variant.getStorage(monitor);
    }

    @Override
    public String getName() {
        return this.variant.getName();
    }

    @Override
    public String getContentIdentifier() {
        return this.variant.getContentIdentifier();
    }

    public IResourceVariant getVariant() {
        return this.variant;
    }

    @Override
    public boolean isPropertyMissing() {
        return false;
    }

    @Override
    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return this;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResourceVariant.class) {
            return (T)this.variant;
        }
        Object object = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (object != null) {
            return (T)object;
        }
        IResourceVariant iResourceVariant = this.variant;
        if (iResourceVariant instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)iResourceVariant;
            return (T)adaptable.getAdapter(adapter);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceVariantFileRevision) {
            ResourceVariantFileRevision fileRevision = (ResourceVariantFileRevision)obj;
            return fileRevision.getVariant().equals(this.getVariant());
        }
        return false;
    }

    public int hashCode() {
        return this.getVariant().hashCode();
    }
}

