/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import java.io.UnsupportedEncodingException;

public final class URISpecification {
    private static final String PUNCT = ",;:$&+=";
    private static final String RESERVED = ",;:$&+=?/[]@";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private URISpecification() {
    }

    public static String getURL(String href) {
        if ((href = href.trim()).startsWith("url(") && href.indexOf(")") != -1) {
            if ((href = href.substring(4, href.lastIndexOf(")")).trim()).startsWith("'") && href.endsWith("'")) {
                href = href.substring(1, href.length() - 1);
            } else if (href.startsWith("\"") && href.endsWith("\"")) {
                href = href.substring(1, href.length() - 1);
            }
        }
        return href;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isAlpha(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isHexDigit(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    private static boolean isReserved(char ch) {
        if (RESERVED.indexOf(ch) >= 0) {
            return true;
        }
        return '#' == ch;
    }

    private static boolean isUnreserved(char ch) {
        if (URISpecification.isDigit(ch) || URISpecification.isAlpha(ch)) {
            return true;
        }
        return "_-!.~'()*".indexOf(ch) >= 0;
    }

    private static void appendEscape(StringBuffer sb, byte b) {
        sb.append('%').append(HEX_DIGITS[b >> 4 & 0xF]).append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    public static String escapeURI(String uri) {
        uri = URISpecification.getURL(uri);
        StringBuffer sb = new StringBuffer();
        int c = uri.length();
        for (int i = 0; i < c; ++i) {
            char ch = uri.charAt(i);
            if (ch == '%' && i < c - 3 && URISpecification.isHexDigit(uri.charAt(i + 1)) && URISpecification.isHexDigit(uri.charAt(i + 2))) {
                sb.append(ch);
                continue;
            }
            if (URISpecification.isReserved(ch) || URISpecification.isUnreserved(ch)) {
                sb.append(ch);
                continue;
            }
            try {
                byte[] utf8;
                for (byte anUtf8 : utf8 = Character.toString(ch).getBytes("UTF-8")) {
                    URISpecification.appendEscape(sb, anUtf8);
                }
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("Incompatible JVM. UTF-8 not supported.");
            }
        }
        return sb.toString();
    }
}

