/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.ArgumentCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorCondition;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.ConditionalSelector;
import io.sf.carte.doc.style.css.nsac.ElementSelector;
import io.sf.carte.doc.style.css.nsac.PositionalCondition;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import java.io.Serializable;

public class Specificity
implements Serializable {
    private static final long serialVersionUID = 2L;
    short id_count = 0;
    short attrib_classes_count = 0;
    short names_pseudoelements_count = 0;
    private final SelectorMatcher selectorMatcher;

    public Specificity(Selector selector, SelectorMatcher matcher) {
        this.selectorMatcher = matcher;
        this.specificity(selector);
    }

    private void add(Specificity specificity) {
        this.id_count = (short)(this.id_count + specificity.id_count);
        this.attrib_classes_count = (short)(this.attrib_classes_count + specificity.attrib_classes_count);
        this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + specificity.names_pseudoelements_count);
    }

    private void specificity(Selector selector) {
        switch (selector.getSelectorType()) {
            case ELEMENT: {
                String elname = ((ElementSelector)selector).getLocalName();
                if (elname == null || elname.equals("*")) break;
                this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + 1);
                break;
            }
            case CONDITIONAL: {
                ConditionalSelector condsel = (ConditionalSelector)selector;
                SimpleSelector simple = condsel.getSimpleSelector();
                this.specificity(simple);
                this.conditionSpecificity(condsel.getCondition());
                break;
            }
            case DESCENDANT: 
            case CHILD: 
            case DIRECT_ADJACENT: 
            case SUBSEQUENT_SIBLING: {
                this.specificity(((CombinatorSelector)selector).getSecondSelector());
                this.specificity(((CombinatorSelector)selector).getSelector());
                break;
            }
        }
    }

    private void conditionSpecificity(Condition cond) {
        switch (cond.getConditionType()) {
            case POSITIONAL: {
                PositionalCondition pcond = (PositionalCondition)cond;
                SelectorList ofList = pcond.getOfList();
                if (ofList != null) {
                    this.mostSpecific(ofList);
                }
            }
            case CLASS: 
            case ATTRIBUTE: 
            case ONE_OF_ATTRIBUTE: 
            case BEGIN_HYPHEN_ATTRIBUTE: 
            case BEGINS_ATTRIBUTE: 
            case ENDS_ATTRIBUTE: 
            case SUBSTRING_ATTRIBUTE: 
            case PSEUDO_CLASS: 
            case LANG: 
            case ONLY_CHILD: 
            case ONLY_TYPE: {
                this.attrib_classes_count = (short)(this.attrib_classes_count + 1);
                break;
            }
            case PSEUDO_ELEMENT: {
                this.names_pseudoelements_count = (short)(this.names_pseudoelements_count + 1);
                break;
            }
            case ID: {
                this.id_count = (short)(this.id_count + 1);
                break;
            }
            case AND: {
                CombinatorCondition comb = (CombinatorCondition)cond;
                int len = comb.getLength();
                for (int i = 0; i < len; ++i) {
                    this.conditionSpecificity(comb.getCondition(i));
                }
                break;
            }
            case SELECTOR_ARGUMENT: {
                ArgumentCondition acond = (ArgumentCondition)cond;
                String name = acond.getName();
                if ("where".equalsIgnoreCase(name)) break;
                SelectorList argList = acond.getSelectors();
                this.mostSpecific(argList);
                break;
            }
        }
    }

    private void mostSpecific(SelectorList selectorList) {
        int sz = selectorList.getLength();
        Selector selector = selectorList.item(0);
        Specificity spMost = new Specificity(selector, this.selectorMatcher);
        for (int i = 1; i < sz; ++i) {
            Selector sel = selectorList.item(i);
            Specificity sp = new Specificity(sel, this.selectorMatcher);
            if (Specificity.selectorCompare(spMost, sp) >= 0) continue;
            spMost = sp;
        }
        this.add(spMost);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attrib_classes_count;
        result = 31 * result + this.id_count;
        result = 31 * result + this.names_pseudoelements_count;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Specificity)) {
            return false;
        }
        Specificity other = (Specificity)obj;
        if (this.attrib_classes_count != other.attrib_classes_count) {
            return false;
        }
        if (this.id_count != other.id_count) {
            return false;
        }
        return this.names_pseudoelements_count == other.names_pseudoelements_count;
    }

    public static int selectorCompare(Specificity s1, Specificity s2) {
        return (s1.id_count - s2.id_count) * 16384 + (s1.attrib_classes_count - s2.attrib_classes_count) * 128 + (s1.names_pseudoelements_count - s2.names_pseudoelements_count);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(82);
        buf.append("id: ").append(this.id_count).append(", attributes and pseudo-classes: ").append(this.attrib_classes_count).append(", element names and pseudo-elements: ").append(this.names_pseudoelements_count);
        return buf.toString();
    }
}

