---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性レポート
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- 脆弱性の修正アクティビティアイコンは、[`vulnerability_report_vr_badge`](https://gitlab.com/gitlab-org/gitlab/-/issues/486549) という名前のフラグが設定されたGitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/15036)されました。デフォルトでは無効になっています。
- GitLab 17.6では、[デフォルトで有効になっています](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)。

{{< /history >}}

{{< alert type="flag" >}}

脆弱性の修正アクティビティアイコンの利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

脆弱性レポートには、コードベースで見つかったセキュリティの脆弱性に関する統合ビューが用意されています。重大度、レポートの種類、スキャナー（プロジェクトのみ）、その他の属性で脆弱性を並べ替えて、最初に対応が必要なイシューを判断します。ステータスインジケーターと、修正の進捗状況を示すアクティビティアイコンを使用して、ライフサイクル全体を通して脆弱性を追跡します。

共通脆弱性評価システム（CVSS）のスコアや、利用可能な場合はファイルロケーションなど、各脆弱性に関する詳細情報にアクセスできます。類似した脆弱性をフィルタリングしてグループ化し、体系的に対処します。

{{< alert type="note" >}}

GitLab.comでは、脆弱性は最終更新から1年後にアーカイブされます。詳細については、[脆弱性のアーカイブ](../vulnerability_archival/_index.md)を参照してください。

{{< /alert >}}

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> 概要については、[脆弱性管理](https://www.youtube.com/watch?v=alMRIq5UPbw)を参照してください。

## 脆弱性レポートの内容

レポートにはデフォルトブランチのデータが含まれており、成功したすべてのセキュリティスキャンジョブからの累積結果が表示されます。スキャンの結果は、ジョブの完了後、またはパイプラインが手動ジョブによってブロックされている場合に表示されます。

プロジェクトおよびグループの場合、脆弱性レポートには以下が含まれます。

- 重大度レベルごとの脆弱性の合計。
- 一般的な脆弱性属性のフィルター。
- テーブル形式で表示される各脆弱性の詳細。

一部の脆弱性では、詳細にデフォルトブランチ内の関連ファイルと行番号へのリンクが含まれます。CVEの脆弱性については、脆弱性レポートでKEVステータスとCVSSおよびEPSSスコアを表示することもできます。セキュリティスコアの詳細については、[脆弱性リスク評価データ](../vulnerabilities/risk_assessment_data.md)を参照してください。

プロジェクトの場合、脆弱性レポートには以下も含まれます。

- タイムスタンプは、デフォルトブランチが最後に更新された時刻を示し、最新のパイプラインへのリンクが含まれています。デフォルト以外のブランチに対して実行されるパイプラインは、タイムスタンプを更新しません。
- 最新のパイプラインで発生した失敗の数。エラー通知を選択して、パイプラインのページの**失敗したジョブ**タブを表示します。

**アクティビティ**列には、その行の脆弱性に対して行われたアクティビティ（ある場合）を示すアイコンが含まれています。

- イシュー {{< icon name="issues" >}}: 脆弱性に対して作成されたイシューへのリンク。詳細については、[脆弱性のGitLabイシューを作成する](../vulnerabilities/_index.md#create-a-gitlab-issue-for-a-vulnerability)を参照してください。
- マージリクエスト {{< icon name="merge-request" >}}: 脆弱性に対して作成されたマージリクエストへのリンク。詳細については、[マージリクエストで脆弱性を解決する](../vulnerabilities/_index.md#resolve-a-vulnerability-with-a-merge-request)を参照してください。
- チェックされた円 {{< icon name="check-circle-dashed" >}}: 脆弱性は修正されました。
- 誤検出 {{< icon name="false-positive" >}}: スキャナーは、この脆弱性が誤検出であると判断しました。
- 解決策 {{< icon name="bulb" >}}: 脆弱性に対処策が利用可能であることを示します。
- 脆弱性の修正 {{< icon name="tanuki-ai" >}}: 脆弱性に利用可能なAI修正があることを示します。

脆弱性に対して作成されたイシューを開くには、**アクティビティ**エントリにカーソルを合わせ、リンクを選択します。イシューアイコン（{{< icon name="issues" >}}）は、イシューのステータスを示します。[Jiraのイシューサポート](../../../integration/jira/configure.md)が有効になっている場合、**アクティビティ**エントリにあるイシューリンクは、Jira のイシューにリンクします。GitLabイシューとは異なり、JiraのイシューのステータスはGitLab UIには表示されません。

![プロジェクト脆弱性レポートの例](img/vulnerability_report_v17_0.png)

脆弱性が複数プロジェクトのパイプライン設定から発生した場合、このページには、選択したプロジェクトから発生した脆弱性が表示されます。

## 脆弱性レポートを表示する

脆弱性レポートを表示して、プロジェクトまたはグループ内のすべての脆弱性を一覧表示します。

前提要件:

- プロジェクトまたはグループのデベロッパーロール以上を持っている必要があります。

脆弱性レポートを表示するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを検索します。
1. **セキュリティ ＞ 脆弱性レポート**を選択します。

## 脆弱性をフィルタリングする

{{< history >}}

- GitLab 17.7で、**識別子**フィルターが [フラグ](../../../administration/feature_flags.md) `vulnerability_filtering_by_identifier` で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/452492)されました。デフォルトで有効になっています。
- GitLab 17.9で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/502930)になりました。機能フラグ`vulnerability_filtering_by_identifier`は削除されました。

{{< /history >}}

脆弱性レポートの脆弱性をフィルタリングすることで、より効率的にトリアージできます。

以下でフィルタリングできます。

<!-- vale gitlab_base.SubstitutionWarning = NO -->

- **ステータス**: トリアージが必要、確認済み、削除済み、解決済みのいずれかです。各ステータスの意味の詳細については、[脆弱性ステータスの値](../vulnerabilities/_index.md#vulnerability-status-values)を参照してください。却下された脆弱性は、却下された理由によってまとめて、または個別にフィルタリングできます。
- **重大度**: クリティカル、高、中、低、情報、不明のいずれかです。
- **レポートの種類**: 詳細については、[レポートタイプのフィルター](#report-type-filter)を参照してください。
- **スキャナー**: 詳細については、[スキャナーフィルター](#scanner-filter)を参照してください。
- **アクティビティ**: 詳細については、[アクティビティフィルター](#activity-filter)を参照してください。
- **識別子**: 脆弱性の識別子でフィルタリングします（プロジェクトでのみ使用可能、グループのサポートは[イシュー508713](https://gitlab.com/gitlab-org/gitlab/-/issues/508713)で提案されています）。
- **プロジェクト**: 特定のプロジェクトの脆弱性をフィルタリングします（グループでのみ使用可能）。

<!-- vale gitlab_base.SubstitutionWarning = YES -->

### 脆弱性をフィルタリングする

{{< history >}}

- GitLab 16.9で、改善されたフィルタリングが[フラグ](../../../administration/feature_flags.md)`vulnerability_report_advanced_filtering` で[導入](https://gitlab.com/groups/gitlab-org/-/epics/13339)されました。デフォルトでは無効になっています。
- GitLab 17.4の[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/437128)。
- GitLab 17.2で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157172)になりました。機能フラグ`vulnerability_report_advanced_filtering`は削除されました。

{{< /history >}}

脆弱性レポートをフィルタリングして、脆弱性のサブセットに焦点を当てます。

脆弱性のリストをフィルタリングするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ ＞ 脆弱性レポート**を選択します。
1. （オプション）デフォルトのフィルターを削除するには、**クリア**（{{< icon name="clear" >}}）を選択します。
1. 脆弱性のリストの上にある、フィルターバーを選択します。
1. 表示されるドロップダウンリストで、フィルタリングする属性を選択し、ドロップダウンリストから値を選択します。
1. フィルターフィールドの外側を選択します。脆弱性の重大度の合計と、一致する脆弱性のリストが更新されます。
1. 複数の属性でフィルタリングするには、前の3つの手順を繰り返します。複数の属性は、論理積で結合されます。

### レポートタイプのフィルター

脆弱性を検出したレポートの種類に基づいて、脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートにはすべてのレポートタイプの脆弱性がリストされます。

**手動で追加されました**属性を使用して、手動で追加された脆弱性をフィルタリングします。

### スキャナーフィルター

プロジェクトの場合、脆弱性を検出したスキャナーに基づいて脆弱性をフィルタリングできます。デフォルトでは、脆弱性レポートにはすべてのスキャナーからの脆弱性がリストされます。利用可能な各スキャナーの詳細については、[セキュリティスキャンツール](../detect/_index.md)を参照してください。

### プロジェクトフィルター

プロジェクトフィルターの内容は異なります。

- **セキュリティセンター**: [個人のセキュリティセンターに追加](../security_dashboard/_index.md#adding-projects-to-the-security-center)したプロジェクトのみ。
- **グループ**: グループ内のすべてのプロジェクト。
- **プロジェクト**: 該当なし。

### アクティビティフィルター

{{< history >}}

- GitLab 16.7で、`activity_filter_has_remediations`という名前の[フラグ](../../../administration/feature_flags.md)とともに導入されました。デフォルトでは無効になっています。
- GitLab 16.9で、[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/429262)になりました。機能フラグ`activity_filter_has_remediations`は削除されました。
- アクティビティフィルターオプション **GitLab Duo（AI）** は、[`vulnerability_report_vr_filter`](https://gitlab.com/gitlab-org/gitlab/-/issues/486534) という名前のフラグが設定されたGitLab 17.5で[導入](https://gitlab.com/groups/gitlab-org/-/epics/15036)されました。デフォルトでは無効になっています。
- GitLab 17.6では、[デフォルトで有効になっています](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171718)。

{{< /history >}}

{{< alert type="flag" >}}

アクティビティフィルターオプション**GitLab Duo（AI）**の利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

アクティビティフィルターは、他のフィルターとは動作が異なります。各カテゴリで選択できる値は1つだけです。フィルターを削除するには、アクティビティフィルターのドロップダウンリストから、削除するフィルターを選択します。

アクティビティフィルターを使用する場合の選択の動作は、次の通りです。

- **アクティビティ**
  - **すべてのアクティビティー**: アクティビティステータスが任意（このフィルターを無視するのと同じ）の脆弱性。これを選択すると、他のすべてのアクティビティフィルターオプションの選択が解除されます。
- **検出**
  - **まだ検出されています** (デフォルト): `default`ブランチの最新のパイプラインスキャンでまだ検出されている脆弱性。
  - **検出されませんでした**: `default`ブランチの最新のパイプラインスキャンで検出されなくなった脆弱性。
- **イシュー**
  - **Has issues（イシューがある）**: 1つ以上の関連するイシューがある脆弱性。
  - **イシューはありません**: 関連するイシューがない脆弱性。
- **マージリクエスト**
  - **マージリクエストがあります**: 1つ以上の関連するマージリクエストがある脆弱性。
  - **マージリクエストはありません**: 関連するマージリクエストがない脆弱性。
- **利用可能な解決策**
  - **解決策あり**: 利用可能な解決策がある脆弱性。
  - **解決策がありません**: 利用可能な解決策がない脆弱性。
- **GitLab Duo（AI）**:
  - **脆弱性の解決策は利用可能**: 利用可能なAI修正がある脆弱性。
  - **脆弱性の解決策は利用不可**: 利用可能なAI修正がない脆弱性。

**GitLab Duo（AI）**フィルターは、以下の場合に利用できます。

- セキュリティセンターの脆弱性レポート: [セキュリティセンター](../security_dashboard/_index.md#adding-projects-to-the-security-center)のすべてのプロジェクトで、**GitLab Duo**の切替がオンになっているとき。
- グループ脆弱性レポート: グループの場合、**GitLab Duo機能**が**デフォルトでオン**に設定されているとき。
- プロジェクト脆弱性レポート: プロジェクトの場合、**GitLab Duo**切替がオンになっているとき。

## 脆弱性をグループ化する

{{< history >}}

- GitLab 16.4で、プロジェクトごとの脆弱性のグループ化が[フラグ](../../../administration/feature_flags.md)`vulnerability_report_grouping`で[導入](https://gitlab.com/groups/gitlab-org/-/epics/10164)されました。デフォルトでは無効になっています。
- GitLab 16.5では、プロジェクトごとの脆弱性のグループ化が[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134073)になっています。
- GitLab 16.6で、プロジェクトごとの脆弱性のグループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/422509)されました。機能フラグ`vulnerability_report_grouping`は削除されました。
- GitLab 16.7で、グループごとの脆弱性のグループ化が[`group_level_vulnerability_report_grouping`](https://gitlab.com/gitlab-org/gitlab/-/issues/432778) という名前のフラグで[導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137778)されました。デフォルトでは無効になっています。
- GitLab 17.2では、グループごとの脆弱性のグループ化が[GitLab Self-Managed および GitLab Dedicated で有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157949)になっています。
- GitLab 17.3で、グループごとの脆弱性のグループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/472669)されました。機能フラグ`group_level_vulnerability_report_grouping`は削除されました。
- GitLab 16.8で、グループごとの脆弱性のOWASPトップ10グループ化が[フラグ](../../../administration/feature_flags.md)`vulnerability_owasp_top_10_group`で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/432618)されました。デフォルトでは無効になっています。
- GitLab 17.4では、グループごとの脆弱性のOWASPトップ10グループ化が [GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/437253)になっています。
- GitLab 17.4で、グループごとの脆弱性のOWASP Top 10グループ化が[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/437253)されました。機能フラグ`vulnerability_owasp_top_10_group`は削除されました。
- GitLab 17.1で、OWASP Top 10グループ化の非 OWASPカテゴリが[フラグ](../../../administration/feature_flags.md)`owasp_top_10_null_filtering`で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/442526)されました。デフォルトでは無効になっています。
- GitLab 17.5では、OWASPトップ10グループ化の非 OWASPカテゴリが[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/463783)になっています。
- GitLab 17.6で、OWASPトップ10グループ化の非OWASPカテゴリが[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/463783)されました。機能フラグ`owasp_top_10_null_filtering`は削除されました。

{{< /history >}}

脆弱性レポートページで脆弱性をグループ化して、より効率的にトリアージできます。

以下によってグループ化できます。

- ステータス
- 重大度
- レポートタイプ
- スキャナー
- OWASPトップ10 2017

### 脆弱性をグループ化する

脆弱性をグループ化するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトまたはグループを検索します。
1. **セキュリティ ＞ 脆弱性レポート**を選択します。
1. **グループごと**ドロップダウンリストから、グループを選択します。

脆弱性は、選択したグループに従ってグループ化されます。各グループは折りたたまれ、グループごとの脆弱性の合計数が名前の横に表示されます。各グループの脆弱性を表示するには、グループの名前を選択します。

## 脆弱性の詳細を表示する

脆弱性の詳細を表示するには、脆弱性の**説明**を選択します。[脆弱性の詳細](../vulnerabilities/_index.md)ページが開きます。

## 脆弱性のステータスを変更する

{{< history >}}

- GitLab 16.0で、コメントと却下理由の提供が[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/408366)されました。

{{< /history >}}

脆弱性のトリアージを行う際に、脆弱性を無視するなど、ステータスを変更できます。

脆弱性が無視された場合、監査ログには、誰がいつ無視したか、そしてその理由が記録されます。脆弱性のレコードは削除できないため、永続的な記録が常に残ります。

前提要件:

- プロジェクトのメンテナーロール以上を持っている必要があります。`admin_vulnerability`権限は、GitLab 17.0のデベロッパーロールから[削除](https://gitlab.com/gitlab-org/gitlab/-/issues/412693)されました。

脆弱性のステータスを変更するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ ＞ 脆弱性レポート**を選択します。
1. 選択方法は次の通りです。
   - 1つ以上の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **ステータスの設定**ドロップダウンリストで、必要なステータスを選択します。
1. **Dismiss（無視する）**ステータスを選択した場合は、**Set dismissal reason（無視する理由を設定）**ドロップダウンリストで必要な理由を選択します。
1. **コメントを追加**インプットに、コメントを入力できます。**無視する**ステータスの場合、コメントは必須です。
1. **ステータスを変更**を選択します。

選択した脆弱性のステータスが更新され、脆弱性レポートの内容が更新されます。

![プロジェクト脆弱性レポート](img/project_security_dashboard_status_change_v16_0.png)

## 脆弱性の重大度を変更またはオーバーライドする

{{< history >}}

- GitLab 17.9で、`vulnerability_severity_override`という名前の[フラグとともに](../../../administration/feature_flags.md)[導入](https://gitlab.com/groups/gitlab-org/-/epics/16157)されました。デフォルトでは無効になっています。
- GitLab 17.10の[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効になりました](https://gitlab.com/groups/gitlab-org/-/epics/16157)。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については履歴を参照してください。

{{< /alert >}}

場合によっては、組織の優先順位をより適切に反映するために、検出された脆弱性の重大度を調整する必要があります。たとえば、スキャナーが低い重大度を報告する可能性がありますが、環境または設定に基づいて、より重大であると見なす場合があります。この機能を使用すると、スキャナーによって割り当てられたデフォルトの重大度を上書きできます。

前提要件:

- プロジェクトまたは`admin_vulnerability`権限に対して、少なくともメンテナーロールを持っている必要があります。

脆弱性の重大度を手動でオーバーライドするには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ ＞ 脆弱性レポート**に移動します。
1. 脆弱性を選択します。
   - 個々の脆弱性を選択するには、各脆弱性の横にあるチェックボックスを選択します。
   - ページ上のすべての脆弱性を選択するには、テーブルヘッダーのチェックボックスを選択します。
1. **アクションを選択**ドロップダウンリストで、**重大度の変更**を選択します。
1. **重大度の選択**ドロップダウンリストで、目的の重大度レベルを選択します。
1. **Add reason（理由を追加）**テキストボックスに、重大度を変更する理由の簡単な説明を追加します。
1. **重大度の変更**を選択します。

脆弱性を選択すると、その都度次の通りとなります。

- その重大度は、**脆弱性の詳細ページ**と**脆弱性レポート**の両方で更新されます。
- 重大度にバッジが追加され、重大度がオーバーライドされたことが示されます。
- 手動による重大度の調整は、脆弱性の**履歴**に記録されます。

![脆弱性の重大度のオーバーライド](img/vulnerability_severity_change_v17_10.png)

## 検出された日付で脆弱性をソートする

デフォルトでは、脆弱性は重大度レベルでソートされ、最も重大度の高い脆弱性がリストの一番上に表示されます。

各脆弱性が検出された日付で脆弱性をソートするには、Detected（検出）列ヘッダーを選択します。

## 脆弱性の詳細をエクスポートする

{{< history >}}

- GitLab 16.8で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/434076)されたCSVエクスポートの列として「Dismissal Reason（無視する理由）」を追加しました。

{{< /history >}}

脆弱性レポートにリストされている脆弱性の詳細をエクスポートできます。エクスポート形式はCSV（カンマ区切り値）です。フィルタはエクスポートに適用されないため、すべての脆弱性が含まれます。

含まれるフィールドは次のとおりです。

- ステータス（ステータス値がどのようにエクスポートされるかの詳細については、次のテーブルを参照してください）
- グループ名
- プロジェクト名
- レポートタイプ
- スキャナー名
- 脆弱性
- 基本的な詳細
- 追加情報
- 重大度
- [CVE](https://cve.mitre.org/)（共通脆弱性評価システム（CVSS））
- [CWE](https://cwe.mitre.org/)（共通脆弱性評価システム（CVSS））
- その他の識別子
- 検出日時
- 場所
- アクティビティ: デフォルトブランチで脆弱性が解決された場合は`true`を返し、そうでない場合は`false`を返します。
- コメント
- フルパス
- CVSSベクター
- [無視する理由](../vulnerabilities/_index.md#vulnerability-dismissal-reasons)

{{< alert type="note" >}}

完全な詳細については、[ジョブアーティファクトAPI](../../../api/job_artifacts.md#download-a-single-artifact-file-from-specific-tag-or-branch)をご覧ください。`gl-*-report.json`レポートファイル名のいずれかを`*artifact_path`の代わりに使用して、たとえば、脆弱性が検出されたファイルへのパスを取得します。

{{< /alert >}}

脆弱性レポートに表示されるStatus（ステータス）フィールドの値は、脆弱性エクスポートに含まれる値とは異なります。それらを一致させるには、次の参照テーブルを使用します。

| 脆弱性レポート | 脆弱性エクスポート |
|:---------------------|:---------------------|
| トリアージが必要         | 検出済み             |
| 削除済み            | 削除済み            |
| 解決済み             | 解決済み             |
| 確認済み            | 確認済み            |

### 詳細をCSV形式でエクスポートする

脆弱性レポートにリストされているすべての脆弱性の詳細をエクスポートするには、**エクスポート**を選択します。

詳細はデータベースから取得され、CSVファイルがローカルコンピューターにダウンロードされます。

{{< alert type="note" >}}

プロジェクトに何千もの脆弱性が含まれている場合、ダウンロードが開始されるまでに数分かかることがあります。ダウンロードが完了するまでページを閉じないでください。一部のCSVリーダーは、行数または列のサイズに制限があり、大規模なエクスポートと互換性がない場合があります。脆弱性エクスポートは、個々のプログラムの制限を考慮していません。

{{< /alert >}}

## 脆弱性を手動で追加する

{{< history >}}

- [機能フラグ`new_vulnerability_form`](https://gitlab.com/gitlab-org/gitlab/-/issues/359049)は、GitLab 15.0で削除されました。

{{< /history >}}

GitLab脆弱性データベースで使用できない場合は、脆弱性を手動で追加します。プロジェクトの脆弱性レポートでのみ脆弱性を追加できます。

脆弱性を手動で追加するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **セキュリティ ＞ 脆弱性レポート**を選択します。
1. **脆弱性を送信**を選択します。
1. フィールドに入力してフォームを送信します。

新しく作成された脆弱性の詳細ページが開きます。

## 運用上の脆弱性

**運用上の脆弱性**タブには、[運用コンテナスキャン（OCS）](../../clusters/agent/vulnerabilities.md)によって検出された脆弱性がリスト表示されます。このタブは、プロジェクト、グループ、およびセキュリティセンターの脆弱性レポートに表示されます。

![運用上の脆弱性タブ](img/operational_vulnerability_tab_v14_6.png)
