/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.txoj.lockstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.txoj.lockstore.LockStoreList;
import com.arjuna.ats.txoj.exceptions.LockStoreException;

class LockStoreSegment {
    private LockStoreList headOfList = null;

    public synchronized boolean write_committed(Uid u, String tName, OutputObjectState state) {
        if (state.size() <= 0) {
            return false;
        }
        LockStoreList ptr = this.find(tName);
        if (ptr == null) {
            ptr = new LockStoreList(tName);
            ptr.setNext(this.headOfList);
            this.headOfList = ptr;
        }
        ptr.add(u, state);
        return true;
    }

    public synchronized InputObjectState read_state(Uid u, String tName) throws LockStoreException {
        LockStoreList ptr = this.find(tName);
        if (ptr == null) {
            return null;
        }
        return ptr.get(u);
    }

    public synchronized boolean remove_state(Uid u, String tName) {
        boolean found = false;
        LockStoreList ptr = this.headOfList;
        while (!found && ptr != null) {
            if (ptr.name().compareTo(tName) == 0) {
                found = true;
                continue;
            }
            ptr = ptr.getNext();
        }
        if (!found) {
            return true;
        }
        ptr.remove(u);
        return true;
    }

    public synchronized boolean remove_segment(String tName) {
        boolean found = false;
        LockStoreList ptr = this.headOfList;
        LockStoreList trail = null;
        while (!found && ptr != null) {
            if (ptr.name().compareTo(tName) == 0) {
                found = true;
                continue;
            }
            trail = ptr;
            ptr = ptr.getNext();
        }
        if (!found) {
            return true;
        }
        if (trail == null) {
            this.headOfList = ptr.getNext();
        } else {
            trail.setNext(ptr.getNext());
        }
        ptr = null;
        return true;
    }

    private LockStoreList find(String tName) {
        boolean found = false;
        LockStoreList ptr = this.headOfList;
        while (!found && ptr != null) {
            if (ptr.name().compareTo(tName) == 0) {
                found = true;
                continue;
            }
            ptr = ptr.getNext();
        }
        return ptr;
    }
}

