/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreebankLanguagePack;

public class GrammaticalFunctionTreeNormalizer
extends TreeNormalizer {
    private static final long serialVersionUID = -2270472762938163327L;
    private final int nodeCleanup;
    private final String root;
    protected final TreebankLanguagePack tlp;

    public GrammaticalFunctionTreeNormalizer(TreebankLanguagePack tlp, int nodeCleanup) {
        this.tlp = tlp;
        this.nodeCleanup = nodeCleanup;
        this.root = tlp.startSymbol();
    }

    public String normalizeNonterminal(String category) {
        return this.cleanUpLabel(category).intern();
    }

    protected String cleanUpLabel(String label) {
        if (label == null) {
            return this.root;
        }
        if (this.nodeCleanup == 1) {
            return this.tlp.categoryAndFunction(label);
        }
        if (this.nodeCleanup == 2) {
            return this.tlp.basicCategory(label);
        }
        return label;
    }
}

