/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.digest.draftv4;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import com.github.fge.jsonschema.keyword.digest.Digester;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class RequiredDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new RequiredDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private RequiredDigester() {
        super("required", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ArrayNode required = FACTORY.arrayNode();
        ret.set(this.keyword, required);
        ArrayList<JsonNode> list = Lists.newArrayList(schema.get(this.keyword));
        Collections.sort(list, new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.textValue().compareTo(o2.textValue());
            }
        });
        required.addAll(list);
        return ret;
    }
}

