/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.Version;
import org.opensearch.common.Explicit;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.DerivedKnnByteVectorField;
import org.opensearch.knn.index.DerivedKnnFloatVectorField;
import org.opensearch.knn.index.KNNVectorSimilarityFunction;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.qframe.QuantizationConfigParser;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorTransformer;
import org.opensearch.knn.index.mapper.VectorValidator;

public class EngineFieldMapper
extends KNNVectorFieldMapper {
    private final FieldType vectorFieldType;
    private final PerDimensionProcessor perDimensionProcessor;
    private final PerDimensionValidator perDimensionValidator;
    private final VectorValidator vectorValidator;
    private final VectorTransformer vectorTransformer;
    private final boolean isLuceneEngine;

    public static EngineFieldMapper createFieldMapper(String fullname, String simpleName, Map<String, String> metaValue, final KNNMethodConfigContext knnMethodConfigContext, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, final OriginalMappingParameters originalMappingParameters) {
        final KNNMethodContext methodContext = originalMappingParameters.getResolvedKnnMethodContext();
        final KNNLibraryIndexingContext libraryContext = methodContext.getKnnEngine().getKNNLibraryIndexingContext(methodContext, knnMethodConfigContext);
        boolean isLuceneEngine = KNNEngine.LUCENE.equals(methodContext.getKnnEngine());
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, knnMethodConfigContext.getVectorDataType(), new KNNMappingConfig(){

            @Override
            public Optional<KNNMethodContext> getKnnMethodContext() {
                return Optional.of(methodContext);
            }

            @Override
            public int getDimension() {
                return knnMethodConfigContext.getDimension();
            }

            @Override
            public Mode getMode() {
                return Mode.fromName(originalMappingParameters.getMode());
            }

            @Override
            public CompressionLevel getCompressionLevel() {
                return knnMethodConfigContext.getCompressionLevel();
            }

            @Override
            public Version getIndexCreatedVersion() {
                return knnMethodConfigContext.getVersionCreated();
            }

            @Override
            public QuantizationConfig getQuantizationConfig() {
                return Optional.ofNullable(libraryContext).map(KNNLibraryIndexingContext::getQuantizationConfig).orElse(QuantizationConfig.EMPTY);
            }

            @Override
            public KNNLibraryIndexingContext getKnnLibraryIndexingContext() {
                return libraryContext;
            }
        });
        return new EngineFieldMapper(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, knnMethodConfigContext, originalMappingParameters, isLuceneEngine);
    }

    private EngineFieldMapper(String name, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodConfigContext knnMethodConfigContext, OriginalMappingParameters originalMappingParameters, boolean isLuceneEngine) {
        super(name, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, knnMethodConfigContext.getVersionCreated(), originalMappingParameters);
        this.isLuceneEngine = isLuceneEngine;
        this.updateEngineStats();
        KNNMappingConfig knnMappingConfig = mappedFieldType.getKnnMappingConfig();
        VectorDataType vectorDataType = mappedFieldType.getVectorDataType();
        KNNMethodContext resolvedKnnMethodContext = originalMappingParameters.getResolvedKnnMethodContext();
        KNNVectorSimilarityFunction knnVectorSimilarityFunction = resolvedKnnMethodContext.getSpaceType().getKnnVectorSimilarityFunction();
        KNNLibraryIndexingContext knnLibraryIndexingContext = resolvedKnnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(resolvedKnnMethodContext, knnMethodConfigContext);
        if (this.isLuceneEngine) {
            this.fieldType = vectorDataType.createKnnVectorFieldType(knnMappingConfig.getDimension(), knnVectorSimilarityFunction);
            this.vectorFieldType = this.hasDocValues ? KNNVectorFieldMapperUtil.buildDocValuesFieldType(resolvedKnnMethodContext.getKnnEngine()) : null;
            this.vectorTransformer = null;
        } else {
            this.vectorFieldType = null;
            this.useLuceneBasedVectorField = KNNVectorFieldMapperUtil.useLuceneKNNVectorsFormat(this.indexCreatedVersion);
            KNNEngine knnEngine = resolvedKnnMethodContext.getKnnEngine();
            QuantizationConfig quantizationConfig = knnLibraryIndexingContext.getQuantizationConfig();
            this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
            this.fieldType.putAttribute("dimension", String.valueOf(knnMappingConfig.getDimension()));
            this.fieldType.putAttribute("spaceType", resolvedKnnMethodContext.getSpaceType().getValue());
            if (quantizationConfig != null && quantizationConfig != QuantizationConfig.EMPTY) {
                this.fieldType.putAttribute("qframe_config", QuantizationConfigParser.toCsv(quantizationConfig));
            }
            this.fieldType.putAttribute("data_type", vectorDataType.getValue());
            this.fieldType.putAttribute("engine", knnEngine.getName());
            try {
                this.fieldType.putAttribute("parameters", XContentFactory.jsonBuilder().map(knnLibraryIndexingContext.getLibraryParameters()).toString());
            }
            catch (IOException ioe) {
                throw new RuntimeException(String.format("Unable to create KNNVectorFieldMapper: %s", ioe), ioe);
            }
            if (this.useLuceneBasedVectorField) {
                int adjustedDimension = mappedFieldType.vectorDataType == VectorDataType.BINARY ? knnMappingConfig.getDimension() / 8 : knnMappingConfig.getDimension();
                VectorEncoding encoding = mappedFieldType.vectorDataType == VectorDataType.FLOAT ? VectorEncoding.FLOAT32 : VectorEncoding.BYTE;
                VectorSimilarityFunction similarityFunction = this.findBestMatchingVectorSimilarityFunction(resolvedKnnMethodContext.getSpaceType());
                this.fieldType.setVectorAttributes(adjustedDimension, encoding, similarityFunction);
            } else {
                this.fieldType.setDocValuesType(DocValuesType.BINARY);
            }
            this.fieldType.freeze();
            this.vectorTransformer = knnLibraryIndexingContext.getVectorTransformer();
        }
        this.perDimensionProcessor = knnLibraryIndexingContext.getPerDimensionProcessor();
        this.perDimensionValidator = knnLibraryIndexingContext.getPerDimensionValidator();
        this.vectorValidator = knnLibraryIndexingContext.getVectorValidator();
    }

    private VectorSimilarityFunction findBestMatchingVectorSimilarityFunction(SpaceType spaceType) {
        if (this.indexCreatedVersion.onOrAfter(Version.V_3_0_0)) {
            try {
                return spaceType.getKnnVectorSimilarityFunction().getVectorSimilarityFunction();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return SpaceType.DEFAULT.getKnnVectorSimilarityFunction().getVectorSimilarityFunction();
    }

    @Override
    protected List<Field> getFieldsForFloatVector(float[] array, boolean isDerivedSourceEnabled) {
        if (this.isLuceneEngine) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add((Field)new DerivedKnnFloatVectorField(this.name(), array, this.fieldType, isDerivedSourceEnabled));
            if (this.hasDocValues && this.vectorFieldType != null) {
                fields.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
            }
            if (this.stored) {
                fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
            }
            return fields;
        }
        return super.getFieldsForFloatVector(array, isDerivedSourceEnabled);
    }

    @Override
    protected List<Field> getFieldsForByteVector(byte[] array, boolean isDerivedSourceEnabled) {
        if (this.isLuceneEngine) {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add((Field)new DerivedKnnByteVectorField(this.name(), array, this.fieldType, isDerivedSourceEnabled));
            if (this.hasDocValues && this.vectorFieldType != null) {
                fields.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
            }
            if (this.stored) {
                fields.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
            }
            return fields;
        }
        return super.getFieldsForByteVector(array, isDerivedSourceEnabled);
    }

    @Override
    protected VectorValidator getVectorValidator() {
        return this.vectorValidator;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        return this.perDimensionProcessor;
    }

    @Override
    protected VectorTransformer getVectorTransformer() {
        if (this.isLuceneEngine) {
            return super.getVectorTransformer();
        }
        return this.vectorTransformer;
    }

    @Override
    void updateEngineStats() {
        Optional.ofNullable(this.originalMappingParameters).ifPresent(params -> params.getResolvedKnnMethodContext().getKnnEngine().setInitialized(true));
    }
}

