/**
 * Qt6 Common library
 *
 * The Qt6 Common library is auto-generated and available to users under the same license as the Qt which it is used with or built with. See available licenses below. 
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef QtOAI_BASEAPI_H
#define QtOAI_BASEAPI_H

#include "QtOAICommonExports.h"
#include "QtOAIHelpers.h"
#include "QtOAIHttpRequest.h"
#include "QtOAIServerConfiguration.h"

#include <QtCore/qmap.h>
#include <QtCore/qobject.h>
#include <QtCore/qstringlist.h>

#include <QtNetwork/qhttpheaders.h>
#if QT_CONFIG(ssl)
#include <QtNetwork/qsslconfiguration.h>
#endif // ssl

#include <memory>
#include <optional>

QT_BEGIN_NAMESPACE
class QNetworkAccessManager;
class QNetworkReply;
class QNetworkRequestFactory;
class QRestAccessManager;
QT_END_NAMESPACE

/*! is a list of typed data. */
#define QtOAI_VA_LIST(...) __VA_ARGS__
/**
* \def QtOAI_ADD_EMPTY_OPERATION_IMPL(OPERATION, DEPRECATED)
* Add an OPERATION with no input arguments and without any additional datatype content
* responded by the server. The expected OPERATION response is HTTP code.
*
* See ./doc/html/index.html for operations implementation details.
*
* @param[in] OPERATION - the API name that will be added by this macro.
* @param[in] DEPRECATED - sets Q_DECL_DEPRECATED if operation is deprecated.
**/
#define QtOAI_ADD_EMPTY_OPERATION_IMPL(OPERATION, DEPRECATED)                      \
public Q_SLOTS:                                                                         \
DEPRECATED virtual void OPERATION() \
{                                                                                       \
    OPERATION##WithDataImpl(nullptr, nullptr);                                          \
}                                                                                       \
protected:                                                                              \
virtual                             \
void OPERATION##WithDataImpl(const QObject *context, QtPrivate::QSlotObjectBase *slot); \
void OPERATION##Callback(const QRestReply &reply);                                      \
public:                                                                                 \
template <typename Functor, if_compatible_callback<Functor> = true>                     \
DEPRECATED void OPERATION(const ContextTypeForFunctor<Functor> *context, Functor &&callback)       \
{                                                                                                  \
    OPERATION##WithDataImpl(context,                                                               \
    QtPrivate::makeCallableObject<QtOAIEmptyCallbackReply>(std::forward<Functor>(callback))); \
}                                                                                                  \

/**
* \def QtOAI_ADD_NO_PARAMS_OPERATION_WITH_RESPONSE_IMPL(OPERATION, RESPONSE, DEPRECATED)
* Add an OPERATION with no input arguments, but with RESPONSE datatypes responded by the server.
*
* See ./doc/html/index.html for operations implementation details.
*
* @param[in] OPERATION - the API name that will be added by this macro.
* @param[in] RESPONSE  - the list objects that the server provides as a response to the OPERATION call.
* @param[in] DEPRECATED - sets Q_DECL_DEPRECATED if operation is deprecated.
**/
#define QtOAI_ADD_NO_PARAMS_OPERATION_WITH_RESPONSE_IMPL(OPERATION, RESPONSE, DEPRECATED)       \
public Q_SLOTS:                                                                                      \
DEPRECATED virtual void OPERATION()              \
{                                                                                                    \
    OPERATION##WithDataImpl(nullptr, nullptr);                                                       \
}                                                                                                    \
protected:                                                                                           \
using OPERATION##CallbackReply = void(*)(const QRestReply &, QtOAI_VA_LIST RESPONSE);           \
template <typename Functor>                                                                          \
using OPERATION##_compatible_callback =                                                              \
std::enable_if_t<QtPrivate::AreFunctionsCompatible<OPERATION##CallbackReply, Functor>::value, bool>; \
virtual                                    \
void OPERATION##WithDataImpl(const QObject *context, QtPrivate::QSlotObjectBase *slot);        \
void OPERATION##Callback(const QRestReply &reply);                                             \
public:                                                                                        \
template <typename Functor, OPERATION##_compatible_callback<Functor> = true>                   \
DEPRECATED void OPERATION(const ContextTypeForFunctor<Functor> *context, Functor &&callback)   \
{                                                                                              \
    OPERATION##WithDataImpl(context,                                                           \
    QtPrivate::makeCallableObject<OPERATION##CallbackReply>(std::forward<Functor>(callback))); \
}                                                                                              \

/**
* \def QtOAI_ADD_OPERATION_IMPL(OPERATION, PARAMS, ARGS, RESPONSE, DEPRECATED)
* Add an OPERATION with input parameters PARAMS and arguments ARGS and with RESPONSE datatypes
* responded by the server.
*
* See ./doc/html/index.html for operations implementation details.
*
* @param[in] OPERATION - the API name that will be added by this macro.
* @param[in] PARAMS    - the list of OPERATION data types.
* @param[in] ARGS      - the list of OPERATION arguments.
* @param[in] RESPONSE  - the list objects that the server provides as a response to the OPERATION call.
* @param[in] DEPRECATED - sets Q_DECL_DEPRECATED if operation is deprecated.
**/
#define QtOAI_ADD_OPERATION_IMPL(OPERATION, PARAMS, ARGS, RESPONSE, DEPRECATED)      \
public Q_SLOTS:                                                                           \
DEPRECATED virtual void OPERATION(QtOAI_VA_LIST PARAMS) \
{                                                                                         \
    OPERATION##WithDataImpl(QtOAI_VA_LIST ARGS, nullptr, nullptr);                   \
}                                                                                         \
protected:                                                                                \
virtual                               \
void OPERATION##WithDataImpl(QtOAI_VA_LIST PARAMS, const QObject *context = nullptr, \
                            QtPrivate::QSlotObjectBase *slot = nullptr);                  \
void OPERATION##Callback(const QRestReply &reply);                                        \
using OPERATION##CallbackReply = void(*)(const QRestReply &, QtOAI_VA_LIST RESPONSE);           \
template <typename Functor>                                                                          \
using OPERATION##_compatible_callback =                                                              \
std::enable_if_t<QtPrivate::AreFunctionsCompatible<OPERATION##CallbackReply, Functor>::value, bool>; \
public:                                                                                              \
template <typename Functor, OPERATION##_compatible_callback<Functor> = true>                         \
DEPRECATED void OPERATION(QtOAI_VA_LIST PARAMS, const ContextTypeForFunctor<Functor> *context = nullptr,   \
                    Functor &&callback = [](const QRestReply &, QtOAI_VA_LIST RESPONSE){})      \
{                                                                                                    \
    OPERATION##WithDataImpl(QtOAI_VA_LIST ARGS, context,                                        \
    QtPrivate::makeCallableObject<OPERATION##CallbackReply>(std::forward<Functor>(callback)));       \
}                                                                                                    \

/**
* \def QtOAI_ADD_OPERATION_WITH_NO_RESPONSE_IMPL(OPERATION, PARAMS, ARGS, DEPRECATED)
* Add an OPERATION with input arguments ARGS, but without any additional datatype content
* responded by the server. The expected OPERATION response is HTTP code.
*
* See ./doc/html/index.html for operations implementation details.
*
* @param[in] OPERATION - the API name that will be added by this macro.
* @param[in] PARAMS    - the list of OPERATION data types.
* @param[in] ARGS      - the list of OPERATION arguments.
* @param[in] DEPRECATED - sets Q_DECL_DEPRECATED if operation is deprecated.
**/
#define QtOAI_ADD_OPERATION_WITH_NO_RESPONSE_IMPL(OPERATION, PARAMS, ARGS, DEPRECATED)                      \
public Q_SLOTS:                                                                                                  \
DEPRECATED virtual void OPERATION(QtOAI_VA_LIST PARAMS) \
{                                                                                         \
    OPERATION##WithDataImpl(QtOAI_VA_LIST ARGS, nullptr, nullptr);                   \
}                                                                                         \
protected:                                                                                \
virtual                               \
void OPERATION##WithDataImpl(QtOAI_VA_LIST PARAMS, const QObject *context = nullptr, \
                            QtPrivate::QSlotObjectBase *slot = nullptr);                  \
void OPERATION##Callback(const QRestReply &reply);                                        \
public:                                                                                   \
template <typename Functor, if_compatible_callback<Functor> = true>                       \
DEPRECATED void OPERATION(QtOAI_VA_LIST PARAMS, const ContextTypeForFunctor<Functor> *context = nullptr, \
                    Functor &&callback = [](const QRestReply &){})                              \
{                                                                                         \
    OPERATION##WithDataImpl(QtOAI_VA_LIST ARGS, context,                             \
    QtPrivate::makeCallableObject<QtOAIEmptyCallbackReply>(std::forward<Functor>(callback))); \
}                                                                                                  \

namespace QtCommonOpenAPI {

class QtOAI_COMMON_EXPORT QtOAIBaseApi : public QObject {
    Q_OBJECT
public:
    using ServerError = QtOAIServerVariable::ServerError;
    Q_ENUM(ServerError)

    QtOAIBaseApi() : QtOAIBaseApi(nullptr) {}
    explicit QtOAIBaseApi(QObject *parent);
    ~QtOAIBaseApi() override;
public Q_SLOTS:
    ServerError setDefaultServerValue(int serverIndex,const QString &operation, const QString &variable,const QString &val);
    ServerError setServerIndex(const QString &operation, int serverIndex);
    void setApiKey(const QString &apiKeyName, const QString &apiKey);
    void setBearerToken(const QString &token);
    void setUsername(const QString &username);
    void setPassword(const QString &password);
    void setTimeOut(std::chrono::milliseconds timeOut);
#if QT_CONFIG(ssl)
    void setSslConfiguration(QSslConfiguration config);
#endif // ssl
    void setWorkingDirectory(const QString &path);
    void setNetworkAccessResources(std::shared_ptr<QNetworkAccessManager> manager, std::shared_ptr<QRestAccessManager> ram);
    void setNetworkRequestFactory(std::shared_ptr<QNetworkRequestFactory> factory);
    std::optional<int> addServerConfiguration(const QString &operation, const QString &urlTemplate, const QString &description = QString(), const QMap<QString, QtOAIServerVariable> &variables = QMap<QString, QtOAIServerVariable>());
    ServerError setNewServerForAllOperations(const QString &urlTemplate, const QString &description = QString(), const QMap<QString, QtOAIServerVariable> &variables = QMap<QString, QtOAIServerVariable>());
    ServerError setNewServer(const QString &operation, const QString &urlTemplate, const QString &description = QString(), const QMap<QString, QtOAIServerVariable> &variables = QMap<QString, QtOAIServerVariable>());
    void setHeader(QHttpHeaders::WellKnownHeader key, QAnyStringView value);
    void setHeader(QAnyStringView key, QAnyStringView value);
    void enableRequestCompression();
    void enableResponseCompression();
    QString errorString(ServerError error) const;

Q_SIGNALS:
    void abortRequest();
    void allPendingRequestsCompleted();

protected:
    QNetworkReply *execute(QtOAIHttpRequestInput &input, QNetworkRequest &request, QByteArray &requestContent);

protected:
    struct QtOAICallerInfo {
        const QObject *contextObject = nullptr;
        QtPrivate::QSlotObjectBase *slot = nullptr;
    };
    using QtOAIEmptyCallbackReply = void(*)(QRestReply&);
    template <typename Functor>
    using ContextTypeForFunctor = typename QtPrivate::ContextTypeForFunctor<Functor>::ContextType;
    template <typename Functor>
    using if_compatible_callback = std::enable_if_t<QtPrivate::AreFunctionsCompatible<QtOAIEmptyCallbackReply, Functor>::value, bool>;

    QMap<QString, int> m_serverIndices;
    QMap<QString, QList<QtOAIServerConfiguration>> m_serverConfigs;
    QMap<QString, QString> m_apiKeys;
    QMap<QNetworkReply *, QtOAICallerInfo> m_callerData;
    QString m_bearerToken;
    QString m_username;
    QString m_password;
    QString m_workingDirectory;
    // Networking API
    std::shared_ptr<QNetworkAccessManager> m_manager;
    std::shared_ptr<QRestAccessManager> m_restManager;
    std::shared_ptr<QNetworkRequestFactory> m_networkFactory;
    bool m_isResponseCompressionEnabled;
    bool m_isRequestCompressionEnabled;
    std::shared_ptr<QtOAIHttpRequestInput> m_latestInput;
};

} // namespace QtCommonOpenAPI
#endif

