'use strict';

exports.__esModule = true;
exports.isBuiltIn = isBuiltIn;
exports.default = resolveImportType;

var _lodash = require('lodash.cond');

var _lodash2 = _interopRequireDefault(_lodash);

var _builtinModules = require('builtin-modules');

var _builtinModules2 = _interopRequireDefault(_builtinModules);

var _path = require('path');

var _resolve = require('./resolve');

var _resolve2 = _interopRequireDefault(_resolve);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function constant(value) {
  return function () {
    return value;
  };
}

function isAbsolute(name) {
  return name.indexOf('/') === 0;
}

function isBuiltIn(name, settings) {
  var extras = settings && settings['import/core-modules'] || [];
  return _builtinModules2.default.indexOf(name) !== -1 || extras.indexOf(name) > -1;
}

function isExternalPath(path, name, settings) {
  var folders = settings && settings['import/external-module-folders'] || ['node_modules'];
  return !path || folders.some(function (folder) {
    return -1 < path.indexOf((0, _path.join)(folder, name));
  });
}

var externalModuleRegExp = /^\w/;
function isExternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && isExternalPath(path, name, settings);
}

var scopedRegExp = /^@\w+\/\w+/;
function isScoped(name) {
  return scopedRegExp.test(name);
}

function isInternalModule(name, settings, path) {
  return externalModuleRegExp.test(name) && !isExternalPath(path, name, settings);
}

function isRelativeToParent(name) {
  return name.indexOf('../') === 0;
}

var indexFiles = ['.', './', './index', './index.js'];
function isIndex(name) {
  return indexFiles.indexOf(name) !== -1;
}

function isRelativeToSibling(name) {
  return name.indexOf('./') === 0;
}

var typeTest = (0, _lodash2.default)([[isAbsolute, constant('absolute')], [isBuiltIn, constant('builtin')], [isExternalModule, constant('external')], [isScoped, constant('external')], [isInternalModule, constant('internal')], [isRelativeToParent, constant('parent')], [isIndex, constant('index')], [isRelativeToSibling, constant('sibling')], [constant(true), constant('unknown')]]);

function resolveImportType(name, context) {
  return typeTest(name, context.settings, (0, _resolve2.default)(name, context));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvcmUvaW1wb3J0VHlwZS5qcyJdLCJuYW1lcyI6WyJpc0J1aWx0SW4iLCJyZXNvbHZlSW1wb3J0VHlwZSIsImNvbnN0YW50IiwidmFsdWUiLCJpc0Fic29sdXRlIiwibmFtZSIsImluZGV4T2YiLCJzZXR0aW5ncyIsImV4dHJhcyIsImlzRXh0ZXJuYWxQYXRoIiwicGF0aCIsImZvbGRlcnMiLCJzb21lIiwiZm9sZGVyIiwiZXh0ZXJuYWxNb2R1bGVSZWdFeHAiLCJpc0V4dGVybmFsTW9kdWxlIiwidGVzdCIsInNjb3BlZFJlZ0V4cCIsImlzU2NvcGVkIiwiaXNJbnRlcm5hbE1vZHVsZSIsImlzUmVsYXRpdmVUb1BhcmVudCIsImluZGV4RmlsZXMiLCJpc0luZGV4IiwiaXNSZWxhdGl2ZVRvU2libGluZyIsInR5cGVUZXN0IiwiY29udGV4dCJdLCJtYXBwaW5ncyI6Ijs7O1FBY2dCQSxTLEdBQUFBLFM7a0JBaURRQyxpQjs7QUEvRHhCOzs7O0FBQ0E7Ozs7QUFDQTs7QUFFQTs7Ozs7O0FBRUEsU0FBU0MsUUFBVCxDQUFrQkMsS0FBbEIsRUFBeUI7QUFDdkIsU0FBTztBQUFBLFdBQU1BLEtBQU47QUFBQSxHQUFQO0FBQ0Q7O0FBRUQsU0FBU0MsVUFBVCxDQUFvQkMsSUFBcEIsRUFBMEI7QUFDeEIsU0FBT0EsS0FBS0MsT0FBTCxDQUFhLEdBQWIsTUFBc0IsQ0FBN0I7QUFDRDs7QUFFTSxTQUFTTixTQUFULENBQW1CSyxJQUFuQixFQUF5QkUsUUFBekIsRUFBbUM7QUFDeEMsTUFBTUMsU0FBVUQsWUFBWUEsU0FBUyxxQkFBVCxDQUFiLElBQWlELEVBQWhFO0FBQ0EsU0FBTyx5QkFBZUQsT0FBZixDQUF1QkQsSUFBdkIsTUFBaUMsQ0FBQyxDQUFsQyxJQUF1Q0csT0FBT0YsT0FBUCxDQUFlRCxJQUFmLElBQXVCLENBQUMsQ0FBdEU7QUFDRDs7QUFFRCxTQUFTSSxjQUFULENBQXdCQyxJQUF4QixFQUE4QkwsSUFBOUIsRUFBb0NFLFFBQXBDLEVBQThDO0FBQzVDLE1BQU1JLFVBQVdKLFlBQVlBLFNBQVMsZ0NBQVQsQ0FBYixJQUE0RCxDQUFDLGNBQUQsQ0FBNUU7QUFDQSxTQUFPLENBQUNHLElBQUQsSUFBU0MsUUFBUUMsSUFBUixDQUFhO0FBQUEsV0FBVSxDQUFDLENBQUQsR0FBS0YsS0FBS0osT0FBTCxDQUFhLGdCQUFLTyxNQUFMLEVBQWFSLElBQWIsQ0FBYixDQUFmO0FBQUEsR0FBYixDQUFoQjtBQUNEOztBQUVELElBQU1TLHVCQUF1QixLQUE3QjtBQUNBLFNBQVNDLGdCQUFULENBQTBCVixJQUExQixFQUFnQ0UsUUFBaEMsRUFBMENHLElBQTFDLEVBQWdEO0FBQzlDLFNBQU9JLHFCQUFxQkUsSUFBckIsQ0FBMEJYLElBQTFCLEtBQW1DSSxlQUFlQyxJQUFmLEVBQXFCTCxJQUFyQixFQUEyQkUsUUFBM0IsQ0FBMUM7QUFDRDs7QUFFRCxJQUFNVSxlQUFlLFlBQXJCO0FBQ0EsU0FBU0MsUUFBVCxDQUFrQmIsSUFBbEIsRUFBd0I7QUFDdEIsU0FBT1ksYUFBYUQsSUFBYixDQUFrQlgsSUFBbEIsQ0FBUDtBQUNEOztBQUVELFNBQVNjLGdCQUFULENBQTBCZCxJQUExQixFQUFnQ0UsUUFBaEMsRUFBMENHLElBQTFDLEVBQWdEO0FBQzlDLFNBQU9JLHFCQUFxQkUsSUFBckIsQ0FBMEJYLElBQTFCLEtBQW1DLENBQUNJLGVBQWVDLElBQWYsRUFBcUJMLElBQXJCLEVBQTJCRSxRQUEzQixDQUEzQztBQUNEOztBQUVELFNBQVNhLGtCQUFULENBQTRCZixJQUE1QixFQUFrQztBQUNoQyxTQUFPQSxLQUFLQyxPQUFMLENBQWEsS0FBYixNQUF3QixDQUEvQjtBQUNEOztBQUVELElBQU1lLGFBQWEsQ0FBQyxHQUFELEVBQU0sSUFBTixFQUFZLFNBQVosRUFBdUIsWUFBdkIsQ0FBbkI7QUFDQSxTQUFTQyxPQUFULENBQWlCakIsSUFBakIsRUFBdUI7QUFDckIsU0FBT2dCLFdBQVdmLE9BQVgsQ0FBbUJELElBQW5CLE1BQTZCLENBQUMsQ0FBckM7QUFDRDs7QUFFRCxTQUFTa0IsbUJBQVQsQ0FBNkJsQixJQUE3QixFQUFtQztBQUNqQyxTQUFPQSxLQUFLQyxPQUFMLENBQWEsSUFBYixNQUF1QixDQUE5QjtBQUNEOztBQUVELElBQU1rQixXQUFXLHNCQUFLLENBQ3BCLENBQUNwQixVQUFELEVBQWFGLFNBQVMsVUFBVCxDQUFiLENBRG9CLEVBRXBCLENBQUNGLFNBQUQsRUFBWUUsU0FBUyxTQUFULENBQVosQ0FGb0IsRUFHcEIsQ0FBQ2EsZ0JBQUQsRUFBbUJiLFNBQVMsVUFBVCxDQUFuQixDQUhvQixFQUlwQixDQUFDZ0IsUUFBRCxFQUFXaEIsU0FBUyxVQUFULENBQVgsQ0FKb0IsRUFLcEIsQ0FBQ2lCLGdCQUFELEVBQW1CakIsU0FBUyxVQUFULENBQW5CLENBTG9CLEVBTXBCLENBQUNrQixrQkFBRCxFQUFxQmxCLFNBQVMsUUFBVCxDQUFyQixDQU5vQixFQU9wQixDQUFDb0IsT0FBRCxFQUFVcEIsU0FBUyxPQUFULENBQVYsQ0FQb0IsRUFRcEIsQ0FBQ3FCLG1CQUFELEVBQXNCckIsU0FBUyxTQUFULENBQXRCLENBUm9CLEVBU3BCLENBQUNBLFNBQVMsSUFBVCxDQUFELEVBQWlCQSxTQUFTLFNBQVQsQ0FBakIsQ0FUb0IsQ0FBTCxDQUFqQjs7QUFZZSxTQUFTRCxpQkFBVCxDQUEyQkksSUFBM0IsRUFBaUNvQixPQUFqQyxFQUEwQztBQUN2RCxTQUFPRCxTQUFTbkIsSUFBVCxFQUFlb0IsUUFBUWxCLFFBQXZCLEVBQWlDLHVCQUFRRixJQUFSLEVBQWNvQixPQUFkLENBQWpDLENBQVA7QUFDRCIsImZpbGUiOiJjb3JlL2ltcG9ydFR5cGUuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgY29uZCBmcm9tICdsb2Rhc2guY29uZCdcbmltcG9ydCBidWlsdGluTW9kdWxlcyBmcm9tICdidWlsdGluLW1vZHVsZXMnXG5pbXBvcnQgeyBqb2luIH0gZnJvbSAncGF0aCdcblxuaW1wb3J0IHJlc29sdmUgZnJvbSAnLi9yZXNvbHZlJ1xuXG5mdW5jdGlvbiBjb25zdGFudCh2YWx1ZSkge1xuICByZXR1cm4gKCkgPT4gdmFsdWVcbn1cblxuZnVuY3Rpb24gaXNBYnNvbHV0ZShuYW1lKSB7XG4gIHJldHVybiBuYW1lLmluZGV4T2YoJy8nKSA9PT0gMFxufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNCdWlsdEluKG5hbWUsIHNldHRpbmdzKSB7XG4gIGNvbnN0IGV4dHJhcyA9IChzZXR0aW5ncyAmJiBzZXR0aW5nc1snaW1wb3J0L2NvcmUtbW9kdWxlcyddKSB8fCBbXVxuICByZXR1cm4gYnVpbHRpbk1vZHVsZXMuaW5kZXhPZihuYW1lKSAhPT0gLTEgfHwgZXh0cmFzLmluZGV4T2YobmFtZSkgPiAtMVxufVxuXG5mdW5jdGlvbiBpc0V4dGVybmFsUGF0aChwYXRoLCBuYW1lLCBzZXR0aW5ncykge1xuICBjb25zdCBmb2xkZXJzID0gKHNldHRpbmdzICYmIHNldHRpbmdzWydpbXBvcnQvZXh0ZXJuYWwtbW9kdWxlLWZvbGRlcnMnXSkgfHwgWydub2RlX21vZHVsZXMnXVxuICByZXR1cm4gIXBhdGggfHwgZm9sZGVycy5zb21lKGZvbGRlciA9PiAtMSA8IHBhdGguaW5kZXhPZihqb2luKGZvbGRlciwgbmFtZSkpKVxufVxuXG5jb25zdCBleHRlcm5hbE1vZHVsZVJlZ0V4cCA9IC9eXFx3L1xuZnVuY3Rpb24gaXNFeHRlcm5hbE1vZHVsZShuYW1lLCBzZXR0aW5ncywgcGF0aCkge1xuICByZXR1cm4gZXh0ZXJuYWxNb2R1bGVSZWdFeHAudGVzdChuYW1lKSAmJiBpc0V4dGVybmFsUGF0aChwYXRoLCBuYW1lLCBzZXR0aW5ncylcbn1cblxuY29uc3Qgc2NvcGVkUmVnRXhwID0gL15AXFx3K1xcL1xcdysvXG5mdW5jdGlvbiBpc1Njb3BlZChuYW1lKSB7XG4gIHJldHVybiBzY29wZWRSZWdFeHAudGVzdChuYW1lKVxufVxuXG5mdW5jdGlvbiBpc0ludGVybmFsTW9kdWxlKG5hbWUsIHNldHRpbmdzLCBwYXRoKSB7XG4gIHJldHVybiBleHRlcm5hbE1vZHVsZVJlZ0V4cC50ZXN0KG5hbWUpICYmICFpc0V4dGVybmFsUGF0aChwYXRoLCBuYW1lLCBzZXR0aW5ncylcbn1cblxuZnVuY3Rpb24gaXNSZWxhdGl2ZVRvUGFyZW50KG5hbWUpIHtcbiAgcmV0dXJuIG5hbWUuaW5kZXhPZignLi4vJykgPT09IDBcbn1cblxuY29uc3QgaW5kZXhGaWxlcyA9IFsnLicsICcuLycsICcuL2luZGV4JywgJy4vaW5kZXguanMnXVxuZnVuY3Rpb24gaXNJbmRleChuYW1lKSB7XG4gIHJldHVybiBpbmRleEZpbGVzLmluZGV4T2YobmFtZSkgIT09IC0xXG59XG5cbmZ1bmN0aW9uIGlzUmVsYXRpdmVUb1NpYmxpbmcobmFtZSkge1xuICByZXR1cm4gbmFtZS5pbmRleE9mKCcuLycpID09PSAwXG59XG5cbmNvbnN0IHR5cGVUZXN0ID0gY29uZChbXG4gIFtpc0Fic29sdXRlLCBjb25zdGFudCgnYWJzb2x1dGUnKV0sXG4gIFtpc0J1aWx0SW4sIGNvbnN0YW50KCdidWlsdGluJyldLFxuICBbaXNFeHRlcm5hbE1vZHVsZSwgY29uc3RhbnQoJ2V4dGVybmFsJyldLFxuICBbaXNTY29wZWQsIGNvbnN0YW50KCdleHRlcm5hbCcpXSxcbiAgW2lzSW50ZXJuYWxNb2R1bGUsIGNvbnN0YW50KCdpbnRlcm5hbCcpXSxcbiAgW2lzUmVsYXRpdmVUb1BhcmVudCwgY29uc3RhbnQoJ3BhcmVudCcpXSxcbiAgW2lzSW5kZXgsIGNvbnN0YW50KCdpbmRleCcpXSxcbiAgW2lzUmVsYXRpdmVUb1NpYmxpbmcsIGNvbnN0YW50KCdzaWJsaW5nJyldLFxuICBbY29uc3RhbnQodHJ1ZSksIGNvbnN0YW50KCd1bmtub3duJyldLFxuXSlcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gcmVzb2x2ZUltcG9ydFR5cGUobmFtZSwgY29udGV4dCkge1xuICByZXR1cm4gdHlwZVRlc3QobmFtZSwgY29udGV4dC5zZXR0aW5ncywgcmVzb2x2ZShuYW1lLCBjb250ZXh0KSlcbn1cbiJdfQ==