/*
  Copyright Jesus Perez <jesusprubio gmail com>

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

'use strict';

// https://developer.shodan.io/stream

const util = require('./util');


// Optional parameters for each function.
const optionalParams = {
  search: ['facets', 'page'],
  count: ['facets'],
};

// Part of all urls.
const apiSection = 'exploits';


// To run commands which don't reveice any parameter.
const run = (cfg, subPath, cb) => {
  const paramMandatory = 'query';
  let partialUrl = '/api/' + subPath + '?';

  if (!cfg[paramMandatory]) {
    cb(util.createErrMandatory(paramMandatory));

    return;
  }

  partialUrl = util.addParam(partialUrl, paramMandatory, cfg[paramMandatory]);
  partialUrl = util.addOptionals(partialUrl, optionalParams[subPath], cfg);

  // Doing the request.
  util.apiRequest(
    apiSection,
    util.createOpts(partialUrl, cfg.global.key, cfg.global.timeout),
    cb
  );
};


class Exploits {

  constructor(opts) {
    this.key = opts.key;
    this.timeout = opts.timeout;
  }


  search(cfg, cb) {
    cfg.global = {
      key: this.key,
      timeout: this.timeout,
    };

    run(cfg, 'search', cb);
  }


  count(cfg, cb) {
    cfg.global = {
      key: this.key,
      timeout: this.timeout,
    };

    run(cfg, 'count', cb);
  }

}


module.exports = Exploits;
