/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph;

import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jdesktop.swingx.color.ColorUtil;

public class BookmarkFactory {
    private static BookmarkFactory _instance;
    private Map<Integer, Color> _colors;
    private Map<Integer, Color> _noteColors;

    public static BookmarkFactory getDefault() {
        if (_instance == null) {
            _instance = new BookmarkFactory();
        }
        return _instance;
    }

    private BookmarkFactory() {
        int n;
        MaltegoLAF.Safe safe = new MaltegoLAF.Safe();
        Color color = ColorUtil.setAlpha((Color)safe.getColor("bookmark-none-color"), (int)safe.getInt("bookmark-none-alpha"));
        Integer n2 = safe.getInt("bookmark-count");
        this._colors = new HashMap<Integer, Color>(n2 + 1);
        this._colors.put(null, color);
        for (n = 0; n < n2; ++n) {
            this._colors.put(n, safe.getColor("bookmark" + (n + 1) + "-color"));
        }
        this._noteColors = new HashMap<Integer, Color>(n2 + 1);
        this._noteColors.put(null, safe.getColor("bookmark-none-note-color"));
        for (n = 0; n < n2; ++n) {
            this._noteColors.put(n, safe.getColor("bookmark" + (n + 1) + "-note-color"));
        }
    }

    public Integer getPrevious(Integer n) {
        int n2 = this.getBookmarkCount() - 1;
        if (n != null) {
            n2 = n;
            --n2;
        }
        n = n2 < 0 ? null : Integer.valueOf(n2);
        return n;
    }

    public Integer getNext(Integer n) {
        int n2 = 0;
        if (n != null) {
            n2 = n;
            ++n2;
        }
        n = n2 >= this.getBookmarkCount() ? null : Integer.valueOf(n2);
        return n;
    }

    public Color getColor(Integer n) {
        return this._colors.get(n);
    }

    public Color getNoteColor(Integer n) {
        return this._noteColors.get(n);
    }

    public int getBookmarkCount() {
        return this._colors.size() - 1;
    }

    public Icon getIcon(Integer n, int n2) {
        return new BookmarkIcon(this.getColor(n), n2);
    }

    private static class BookmarkIcon
    implements Icon {
        private final Color _color;
        private final int _size;

        public BookmarkIcon(Color color, int n) {
            this._color = color;
            this._size = n;
        }

        @Override
        public int getIconWidth() {
            return this._size;
        }

        @Override
        public int getIconHeight() {
            return this._size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AffineTransform affineTransform = graphics2D.getTransform();
                double d = 0.1f;
                graphics2D.scale(d, d);
                int n3 = (int)((double)n / d);
                int n4 = (int)((double)n2 / d);
                int n5 = (int)((double)this.getIconHeight() / d);
                graphics2D.translate(n3, n4);
                GraphicsUtils.drawShadedFatPentagram((Graphics2D)graphics2D, (int)0, (int)0, (int)n5, (int)n5, (Color)this._color, (boolean)false, (boolean)false);
                graphics2D.setTransform(affineTransform);
            }
        }
    }
}

