/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.EntityImageFactory;
import com.paterva.maltego.ui.graph.actions.EditorAction;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.actions.SelectionToggleAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import yguard.A.A.D;

public class SelectByTypeAction
extends EditorAction
implements RibbonPresenter.Button {
    private JCommandButton _button;

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getRibbonButtonPresenter().setEnabled(bl);
    }

    public String getName() {
        return "Select by Type";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/impl/Unknown.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            RichTooltip richTooltip = new RichTooltip(this.getName(), "Select entities by type");
            richTooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource()));
            richTooltip.addFooterSection("Click the help button to get more help on Maltego features");
            richTooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(richTooltip);
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton jCommandButton) {
                    return SelectByTypeAction.this.createPopup();
                }
            });
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        EntityRegistry entityRegistry;
        TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = SelectByTypeAction.find(topComponent);
        JCommandPopupMenu jCommandPopupMenu = new JCommandPopupMenu();
        if (explorerManager != null) {
            entityRegistry = this.getRegistry(explorerManager);
            EntityImageFactory entityImageFactory = this.getImageFactory(explorerManager);
            Set<String> set = this.getTypeNames(explorerManager, entityRegistry);
            List<MaltegoEntitySpec> list = this.getSortedSpecs(entityRegistry, set);
            for (MaltegoEntitySpec object2 : list) {
                this.addMenuButton(jCommandPopupMenu, object2.getTypeName(), entityRegistry, entityImageFactory);
            }
            List<String> list2 = this.getSortedUnknownTypes(entityRegistry, set);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.addMenuButton(jCommandPopupMenu, string, entityRegistry, entityImageFactory);
            }
        }
        if (jCommandPopupMenu.getMenuComponents().isEmpty()) {
            entityRegistry = new JCommandMenuButton("Graph is empty...", null);
            entityRegistry.setEnabled(false);
            jCommandPopupMenu.addMenuButton((JCommandMenuButton)entityRegistry);
        }
        return jCommandPopupMenu;
    }

    private void addMenuButton(JCommandPopupMenu jCommandPopupMenu, final String string, final EntityRegistry entityRegistry, EntityImageFactory entityImageFactory) {
        Image image;
        String string2 = string;
        MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string);
        if (maltegoEntitySpec != null) {
            string2 = maltegoEntitySpec.getDisplayName();
        }
        JCommandMenuButton jCommandMenuButton = new JCommandMenuButton(string2, (image = entityImageFactory.getSmallTypeImage(string, null)) == null ? null : ResizableIcons.fromImage((Image)image));
        jCommandMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectByTypeAction.this.selectByType(entityRegistry, string);
            }
        });
        jCommandPopupMenu.addMenuButton(jCommandMenuButton);
    }

    private Set<String> getTypeNames(ExplorerManager explorerManager, EntityRegistry entityRegistry) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        for (Node object2 : explorerManager.getRootContext().getChildren().getNodes(true)) {
            object = (MaltegoEntity)object2.getLookup().lookup(MaltegoEntity.class);
            if (object == null) continue;
            hashSet.add(object.getTypeName());
        }
        HashSet hashSet2 = new HashSet();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (String string : hashSet) {
            object = InheritanceHelper.getInheritanceList((SpecRegistry)entityRegistry, (String)string);
            boolean bl = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (bl) {
                    hashSet3.add(string2);
                    bl = false;
                    continue;
                }
                if (hashSet2.contains(string2)) {
                    hashSet3.add(string2);
                    continue;
                }
                hashSet2.add(string2);
            }
        }
        return hashSet3;
    }

    private EntityRegistry getRegistry(ExplorerManager explorerManager) {
        EntityRegistry entityRegistry = (EntityRegistry)explorerManager.getRootContext().getLookup().lookup(EntityRegistry.class);
        if (entityRegistry != null) {
            return entityRegistry;
        }
        return EntityRegistry.getDefault();
    }

    private EntityImageFactory getImageFactory(ExplorerManager explorerManager) {
        D d2 = (D)explorerManager.getRootContext().getLookup().lookup(D.class);
        if (d2 != null) {
            return EntityImageFactory.forGraph(d2);
        }
        return EntityImageFactory.getDefault();
    }

    private List<MaltegoEntitySpec> getSortedSpecs(EntityRegistry entityRegistry, Set<String> set) {
        ArrayList<MaltegoEntitySpec> arrayList = new ArrayList<MaltegoEntitySpec>();
        for (String string : set) {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string);
            if (maltegoEntitySpec == null || !maltegoEntitySpec.isVisible()) continue;
            arrayList.add(maltegoEntitySpec);
        }
        Collections.sort(arrayList, new Comparator<MaltegoEntitySpec>(){

            @Override
            public int compare(MaltegoEntitySpec maltegoEntitySpec, MaltegoEntitySpec maltegoEntitySpec2) {
                return maltegoEntitySpec.getDisplayName().compareTo(maltegoEntitySpec2.getDisplayName());
            }
        });
        return arrayList;
    }

    private List<String> getSortedUnknownTypes(EntityRegistry entityRegistry, Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            MaltegoEntitySpec maltegoEntitySpec = (MaltegoEntitySpec)entityRegistry.get(string);
            if (maltegoEntitySpec != null) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    protected void performAction(ExplorerManager explorerManager) throws PropertyVetoException {
    }

    private void selectByType(EntityRegistry entityRegistry, String string) {
        final TopComponent topComponent = this.getTopComponent();
        ExplorerManager explorerManager = SelectByTypeAction.find(topComponent);
        if (explorerManager != null) {
            if (SelectionMode.isLinks()) {
                ((SelectionToggleAction)SystemAction.get(SelectionToggleAction.class)).performAction();
            }
            List<Node> list = Arrays.asList(explorerManager.getRootContext().getChildren().getNodes());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : list) {
                List list2;
                MaltegoEntity maltegoEntity = (MaltegoEntity)node.getLookup().lookup(MaltegoEntity.class);
                if (maltegoEntity == null || (list2 = InheritanceHelper.getInheritanceList((SpecRegistry)entityRegistry, (String)maltegoEntity.getTypeName())) == null || !list2.contains(string)) continue;
                arrayList.add(node);
            }
            try {
                explorerManager.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                ZoomToSelectionAction zoomToSelectionAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class);
                if (zoomToSelectionAction != null) {
                    zoomToSelectionAction.zoomToSelection();
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    topComponent.requestActive();
                }
            });
        }
    }
}

