/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.openide.util.NbPreferences;

public class RecentFiles {
    protected static String DEFAULT_NODE_NAME = "prefs";
    protected String nodeName = "mrufiles";
    private EventListenerList listenerList;
    public static final String MRU_FILE_LIST_PROPERTY = "MRUFileList";
    private List<String> mruFileList = new ArrayList<String>(this.maxSize);
    private int maxSize = 12;
    private static RecentFiles instance = new RecentFiles();

    public static RecentFiles getInstance() {
        return instance;
    }

    protected RecentFiles() {
        this.listenerList = new EventListenerList();
        this.retrieve();
    }

    public List<String> getMRUFileList() {
        return this.mruFileList;
    }

    private void setMRUFileList(List<String> list) {
        this.mruFileList.clear();
        this.mruFileList.addAll(list.subList(0, Math.min(list.size(), this.maxSize)));
        this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
        this.store();
    }

    public void addFile(String string) {
        if (string != null && string.startsWith("file")) {
            this.mruFileList.remove(string);
            this.mruFileList.add(0, string);
            while (this.mruFileList.size() > this.maxSize) {
                this.mruFileList.remove(this.mruFileList.size() - 1);
            }
            this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
            this.store();
        }
    }

    public void removeFile(String string) {
        if (string != null && string.startsWith("file")) {
            this.mruFileList.remove(string);
            this.firePropertyChange(MRU_FILE_LIST_PROPERTY, null, this.mruFileList);
            this.store();
        }
    }

    protected void store() {
        Preferences preferences = this.getPreferences();
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < this.mruFileList.size(); ++i) {
            String string = this.mruFileList.get(i);
            preferences.put(MRU_FILE_LIST_PROPERTY + i, string);
        }
    }

    protected void retrieve() {
        String string;
        this.mruFileList.clear();
        Preferences preferences = this.getPreferences();
        for (int i = 0; i < this.maxSize && (string = preferences.get(MRU_FILE_LIST_PROPERTY + i, null)) != null; ++i) {
            this.mruFileList.add(string);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        Object[] objectArray = this.listenerList.getListenerList();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyChangeListener.class) continue;
            ((PropertyChangeListener)objectArray[i + 1]).propertyChange(propertyChangeEvent);
        }
    }

    protected final Preferences getPreferences() {
        String string = DEFAULT_NODE_NAME;
        if (this.nodeName != null) {
            string = this.nodeName;
        }
        Preferences preferences = NbPreferences.forModule(this.getClass()).node("options").node(string);
        return preferences;
    }
}

