/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.view2d.Graph2DPrintPreviewPanel;
import com.paterva.maltego.ui.graph.view2d.PrintOptions;
import com.paterva.maltego.ui.graph.view2d.PrintOptionsForm;
import com.paterva.maltego.ui.graph.view2d.PrintPreviewCookie;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.PrintCookie;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import yguard.A.I.LA;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.mB;
import yguard.A.I.oA;
import yguard.A.I.vA;

public class Graph2DViewPrinter
implements PrintCookie,
PrintPreviewCookie {
    S _view;

    public Graph2DViewPrinter(S s) {
        this._view = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        try {
            oA oA2 = this.getGraphPrinter();
            if (Graph2DViewPrinter.showOptions(oA2)) {
                Graph2DViewPrinter.print(oA2, PrintOptions.get().getPageFormat());
            }
        }
        finally {
            this.restoreOriginalView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPreview() {
        try {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            oA oA2 = this.getGraphPrinter();
            PrintOptions printOptions = PrintOptions.get();
            Graph2DViewPrinter.applyPrintOptions(oA2, printOptions);
            Graph2DPrintPreviewPanel graph2DPrintPreviewPanel = new Graph2DPrintPreviewPanel(printerJob, oA2, printOptions.getPageFormat());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)graph2DPrintPreviewPanel, "Print Preview", true, (Object[])new String[]{"Close"}, null, 0, HelpCtx.DEFAULT_HELP, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
            printOptions.setPageFormat(graph2DPrintPreviewPanel.getPageFormat());
        }
        finally {
            this.restoreOriginalView();
        }
    }

    public static void print(oA oA2, PageFormat pageFormat) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable((Printable)oA2);
        PrintRequestAttributeSet printRequestAttributeSet = Graph2DViewPrinter.getAttributeSetFromPageFormat(pageFormat);
        printRequestAttributeSet.add(new PageRanges(1, oA2.J() * oA2.H()));
        if (printerJob.printDialog(printRequestAttributeSet)) {
            try {
                printerJob.print(printRequestAttributeSet);
            }
            catch (PrinterException printerException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)printerException, (Object)"An error occurred while trying to print.");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)exception);
            }
        }
    }

    private static PrintRequestAttributeSet getAttributeSetFromPageFormat(PageFormat pageFormat) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (pageFormat.getOrientation() == 0) {
            hashPrintRequestAttributeSet.add(OrientationRequested.LANDSCAPE);
        } else if (pageFormat.getOrientation() == 1) {
            hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        } else if (pageFormat.getOrientation() == 2) {
            hashPrintRequestAttributeSet.add(OrientationRequested.REVERSE_LANDSCAPE);
        }
        Paper paper = pageFormat.getPaper();
        hashPrintRequestAttributeSet.add(new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400));
        hashPrintRequestAttributeSet.add(MediaSize.findMedia((float)(paper.getWidth() / 72.0), (float)(paper.getHeight() / 72.0), 25400));
        return hashPrintRequestAttributeSet;
    }

    public static boolean showOptions(oA oA2) {
        PrintOptions printOptions = PrintOptions.get();
        PrintOptionsForm printOptionsForm = new PrintOptionsForm();
        printOptionsForm.setPrintOptions(printOptions);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)printOptionsForm, "Print Options");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            printOptionsForm.getPrintOptions(printOptions);
            Graph2DViewPrinter.applyPrintOptions(oA2, printOptions);
            return true;
        }
        return false;
    }

    private static void applyPrintOptions(oA oA2, PrintOptions printOptions) {
        oA2.B(printOptions.getRows());
        oA2.A(printOptions.getColumns());
        oA2.A(printOptions.getShowPosterCoords());
        if (printOptions.getClipVisible()) {
            oA2.A((byte)0);
        } else {
            oA2.A((byte)1);
        }
        if (printOptions.getShowFooter()) {
            oA2.A((oA._C)new MaltegoFooter());
        } else {
            oA2.A(null);
        }
        if (printOptions.getTitle() != null && !printOptions.getTitle().isEmpty()) {
            oA._D _D2 = new oA._D();
            _D2.A(printOptions.getTitle());
            _D2.E(null);
            _D2.A(new Font("Dialog", 1, 20));
            oA2.A((oA._A)_D2);
        } else {
            oA2.A(null);
        }
    }

    private oA getGraphPrinter() {
        S s = this.replaceCurrentWithPrintingView();
        oA oA2 = new oA(s);
        return oA2;
    }

    private S replaceCurrentWithPrintingView() {
        QA qA = this._view.H();
        S s = new S(qA);
        s.B(this._view.\u00e1());
        s.setBounds(this._view.getBounds());
        s.K(this._view.\u00dd());
        s.D(this._view.\u00df().getX(), this._view.\u00df().getY());
        s.B((LA)new mB(s));
        qA.A((vA)s);
        return s;
    }

    private void restoreOriginalView() {
        QA qA = this._view.H();
        qA.C(qA.\u0106());
        qA.A((vA)this._view);
    }

    private static class MaltegoFooter
    implements oA._C {
        Image _footerImg = null;
        Rectangle _bounds = null;
        boolean _drawFooter = true;
        final int _textMargin = 2;
        final String _text = "Printed with " + System.getProperty("maltego.product-name") + " " + System.getProperty("maltego.displayversion");

        public MaltegoFooter() {
            this._footerImg = ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/view2d/PrintFooter.png");
        }

        public void setContext(oA._E _E2) {
            Graphics2D graphics2D = _E2.F();
            graphics2D.setFont(this.getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this._text, graphics2D);
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getWidth() + 2.0 + (double)this._footerImg.getWidth(null), Math.max(rectangle2D.getHeight() + 2.0, (double)this._footerImg.getHeight(null)));
            Paper paper = _E2.G().getPaper();
            double d2 = paper.getImageableX();
            double d3 = paper.getImageableY();
            double d4 = paper.getImageableWidth();
            double d5 = paper.getImageableHeight();
            if (_E2.G().getOrientation() == 0) {
                d3 = paper.getImageableX();
                d2 = paper.getHeight() - (paper.getImageableY() + paper.getImageableHeight());
                d4 = paper.getImageableHeight();
                d5 = paper.getImageableWidth();
            } else if (_E2.G().getOrientation() == 2) {
                d2 = paper.getImageableY();
                d3 = paper.getWidth() - (paper.getImageableX() + paper.getImageableWidth());
                d4 = paper.getImageableHeight();
                d5 = paper.getImageableWidth();
            }
            this._bounds = new Rectangle((int)(d2 + d4 - double_.x), (int)(d3 + d5 - double_.y), (int)double_.x, (int)double_.y);
            this._drawFooter = _E2.B() + 1 == _E2.D() * _E2.A();
        }

        public void paint(Graphics2D graphics2D) {
            if (this._drawFooter) {
                graphics2D.drawImage(this._footerImg, this._bounds.x + this._bounds.width - this._footerImg.getWidth(null), this._bounds.y, null);
                graphics2D.setColor(Color.LIGHT_GRAY);
                graphics2D.setFont(this.getFont());
                graphics2D.drawString(this._text, this._bounds.x, this._bounds.y + this._bounds.height - 2);
            }
        }

        public Rectangle getBounds() {
            return this._bounds;
        }

        private Font getFont() {
            return new Font("Dialog", 0, 12);
        }
    }
}

