/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.templates;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.favorites.templates.TemplatesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TemplatesAction
extends AbstractAction {
    private Reference<Dialog> dialogWRef = new WeakReference<Object>(null);

    public TemplatesAction() {
        this.putValue("ShortDescription", NbBundle.getMessage(TemplatesAction.class, (String)"HINT_TemplatesAction"));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Dialog dialog = this.dialogWRef.get();
        if (dialog == null || !dialog.isShowing()) {
            TemplatesPanel tp = new TemplatesPanel();
            JButton closeButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)NbBundle.getMessage(TemplatesAction.class, (String)"BTN_TemplatesPanel_CloseButton"));
            JButton openInEditor = new JButton();
            openInEditor.setEnabled(false);
            OpenInEditorListener l = new OpenInEditorListener(tp, openInEditor);
            openInEditor.addActionListener(l);
            tp.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)l);
            Mnemonics.setLocalizedText((AbstractButton)openInEditor, (String)NbBundle.getMessage(TemplatesAction.class, (String)"BTN_TemplatesPanel_OpenInEditorButton"));
            DialogDescriptor dd = new DialogDescriptor((Object)tp, NbBundle.getMessage(TemplatesAction.class, (String)"LBL_TemplatesPanel_Title"), false, new Object[]{openInEditor, closeButton}, (Object)closeButton, 0, null, null);
            dd.setClosingOptions(null);
            dd.setHelpCtx(null);
            dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            this.dialogWRef = new WeakReference<Dialog>(dialog);
        } else {
            dialog.toFront();
        }
    }

    private static Set<Node> getNodes2Open(Node[] nodes) {
        HashSet<Node> nodes2open = new HashSet<Node>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].isLeaf()) {
                nodes2open.add(nodes[i]);
                continue;
            }
            nodes2open.addAll(TemplatesAction.getNodes2Open(nodes[i].getChildren().getNodes(true)));
        }
        return nodes2open;
    }

    private static class OpenInEditorListener
    implements ActionListener,
    PropertyChangeListener {
        TemplatesPanel tp;
        JButton b;

        public OpenInEditorListener(TemplatesPanel panel, JButton button) {
            this.tp = panel;
            this.b = button;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Node[] nodes = this.tp.getExplorerManager().getSelectedNodes();
            assert (nodes != null && nodes.length > 0) : "Selected templates cannot be null or empty.";
            Set nodes2open = TemplatesAction.getNodes2Open(nodes);
            assert (!nodes2open.isEmpty()) : "Selected templates to open cannot by empty for nodes " + Arrays.asList(nodes);
            for (Node n : nodes2open) {
                EditCookie ec = (EditCookie)n.getLookup().lookup(EditCookie.class);
                if (ec != null) {
                    ec.edit();
                    continue;
                }
                OpenCookie oc = (OpenCookie)n.getLookup().lookup(OpenCookie.class);
                if (oc != null) {
                    oc.open();
                    continue;
                }
                assert (false) : "Node " + n + " has to have a EditCookie or OpenCookie.";
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = (Node[])evt.getNewValue();
                boolean res = nodes != null && nodes.length > 0;
                for (int i = 0; res && i < nodes.length; ++i) {
                    Node n = nodes[i];
                    EditCookie ec = (EditCookie)n.getLookup().lookup(EditCookie.class);
                    OpenCookie oc = (OpenCookie)n.getLookup().lookup(OpenCookie.class);
                    boolean bl = res = ec != null || oc != null;
                    if (!res) continue;
                    DataObject dobj = (DataObject)n.getLookup().lookup(DataObject.class);
                    assert (dobj != null) : "DataObject for node " + n;
                    FileObject fo = dobj.getPrimaryFile();
                    File f = FileUtil.toFile((FileObject)fo);
                    res = f != null || fo.getSize() > 0L;
                }
                this.b.setEnabled(res);
            }
        }
    }
}

