/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.descriptor.Visibility;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ListMap;
import com.paterva.maltego.util.StringUtilities;
import java.util.Map;

public class ListMapTransformSettings
implements TransformSettings {
    private boolean _enabled = true;
    private ListMap<String, TransformSetting> _map;
    private boolean _accepted = false;
    private boolean _showHelp = true;
    private boolean _dirty = true;

    private Map<String, TransformSetting> map() {
        if (this._map == null) {
            this._map = new ListMap();
        }
        return this._map;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    public void markClean() {
        this._dirty = false;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            this._dirty = true;
        }
    }

    public boolean isDisclaimerAccepted() {
        return this._accepted;
    }

    public void setDisclaimerAccepted(boolean bl) {
        if (this._accepted != bl) {
            this._accepted = bl;
            this._dirty = true;
        }
    }

    public Popup getPopup(PropertyDescriptor propertyDescriptor) {
        return this.isPopup(propertyDescriptor.getName());
    }

    public Popup isPopup(String string) {
        TransformSetting transformSetting = this.map().get(string);
        if (transformSetting == null) {
            return Popup.NotSet;
        }
        return transformSetting.popup;
    }

    public void setPopup(PropertyDescriptor propertyDescriptor, Popup popup) {
        this.setPopup(propertyDescriptor.getName(), popup);
    }

    public void setPopup(String string, Popup popup) {
        TransformSetting transformSetting = this.getOrMakeSetting(string);
        if (transformSetting.popup != popup) {
            transformSetting.popup = popup;
            this._dirty = true;
        }
    }

    public Object getValue(String string) {
        TransformSetting transformSetting = this.map().get(string);
        if (transformSetting == null) {
            return null;
        }
        return transformSetting.value;
    }

    public void setValue(String string, Object object) {
        TransformSetting transformSetting = this.getOrMakeSetting(string);
        if (transformSetting.value == null || !transformSetting.value.equals(object)) {
            transformSetting.value = StringUtilities.isNullString((Object)object) ? null : object;
            this._dirty = true;
        }
    }

    public Object getValue(PropertyDescriptor propertyDescriptor) {
        return this.getValue(propertyDescriptor.getName());
    }

    public void setValue(PropertyDescriptor propertyDescriptor, Object object) {
        this.setValue(propertyDescriptor.getName(), object);
    }

    public boolean showHelp() {
        return this._showHelp;
    }

    public void setShowHelp(boolean bl) {
        if (bl != this._showHelp) {
            this._showHelp = bl;
            this._dirty = true;
        }
    }

    public Visibility getVisibility(PropertyDescriptor propertyDescriptor) {
        TransformSetting transformSetting = this.map().get(propertyDescriptor.getName());
        if (transformSetting != null && transformSetting.visibility != null) {
            return transformSetting.visibility;
        }
        return Visibility.Public;
    }

    public void setVisibility(PropertyDescriptor propertyDescriptor, Visibility visibility) {
        this.setVisibility(propertyDescriptor.getName(), visibility);
    }

    public void setVisibility(String string, Visibility visibility) {
        TransformSetting transformSetting = this.getOrMakeSetting(string);
        if (transformSetting.visibility != visibility) {
            transformSetting.visibility = visibility;
            this._dirty = true;
        }
    }

    private TransformSetting getOrMakeSetting(String string) {
        TransformSetting transformSetting = this.map().get(string);
        if (transformSetting == null) {
            transformSetting = new TransformSetting();
            this.map().put(string, transformSetting);
            this._dirty = true;
        }
        return transformSetting;
    }

    private class TransformSetting {
        public Popup popup = Popup.NotSet;
        public Object value = null;
        public Visibility visibility = Visibility.Public;

        private TransformSetting() {
        }
    }
}

