/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.wizard;

import com.paterva.maltego.graph.table.io.convert.TabularGraphConvertResult;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openide.util.NbBundle;

public class ImportSuccessPanel
extends JPanel {
    private TabularGraphConvertResult _result;
    private JPanel _addToPanel;
    private JRadioButton _currentGraphRadioButton;
    private JLabel _errorsLabel;
    private JScrollPane _errorsScrollPane;
    private JTextArea _errorsTextArea;
    private JRadioButton _newGraphRadioButton;
    private JTextArea _overviewTextArea;
    private ButtonGroup buttonGroup1;

    public ImportSuccessPanel() {
        this.initComponents();
    }

    public void setResult(TabularGraphConvertResult tabularGraphConvertResult) {
        this._result = tabularGraphConvertResult;
        this._overviewTextArea.setText(this.getOverviewText());
        if (this._result.Errors.isEmpty()) {
            this._errorsLabel.setVisible(false);
            this._errorsScrollPane.setVisible(false);
            this._errorsTextArea.setVisible(false);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this._result.Errors) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            this._errorsTextArea.setText(stringBuilder.toString());
        }
    }

    public void setShowMergeOption(boolean bl) {
        this._newGraphRadioButton.setEnabled(bl);
        this._currentGraphRadioButton.setEnabled(bl);
    }

    public void setNewGraph(boolean bl) {
        this._newGraphRadioButton.setSelected(bl);
        this._currentGraphRadioButton.setSelected(!bl);
    }

    public boolean getNewGraph() {
        return this._newGraphRadioButton.isSelected();
    }

    private String getOverviewText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Imported items:\n");
        stringBuilder.append(String.format("%6d", this._result.RowsSucceeded + this._result.RowsFailed));
        stringBuilder.append(" Rows imported (");
        stringBuilder.append(this._result.RowsSucceeded);
        stringBuilder.append(" succeeded - ");
        stringBuilder.append(this._result.RowsFailed);
        stringBuilder.append(" failed)\n");
        stringBuilder.append(String.format("%6d", this._result.Graph.\u00e1()));
        stringBuilder.append(" Entities created\n");
        stringBuilder.append(String.format("%6d", this._result.Graph.\u00da()));
        stringBuilder.append(" Links created\n\n");
        stringBuilder.append("Click Finish to open the graph in a new window.\n");
        stringBuilder.append("Click Cancel to discard the graph.");
        return stringBuilder.toString();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this._overviewTextArea = new JTextArea();
        JLabel jLabel = new JLabel();
        this._addToPanel = new JPanel();
        this._newGraphRadioButton = new JRadioButton();
        this._currentGraphRadioButton = new JRadioButton();
        JPanel jPanel2 = new JPanel();
        this._errorsLabel = new JLabel();
        this._errorsScrollPane = new JScrollPane();
        this._errorsTextArea = new JTextArea();
        this.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout(10, 10));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel.jScrollPane1.border.title")));
        this._overviewTextArea.setColumns(20);
        this._overviewTextArea.setEditable(false);
        this._overviewTextArea.setFont(new Font("Tahoma", 0, 11));
        this._overviewTextArea.setLineWrap(true);
        this._overviewTextArea.setRows(7);
        this._overviewTextArea.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._overviewTextArea.text"));
        this._overviewTextArea.setWrapStyleWord(true);
        this._overviewTextArea.setOpaque(false);
        jScrollPane.setViewportView(this._overviewTextArea);
        jPanel.add((Component)jScrollPane, "South");
        jLabel.setFont(new Font("Tahoma", 1, 12));
        jLabel.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel.jLabel1.text"));
        jPanel.add((Component)jLabel, "North");
        this._addToPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._addToPanel.border.title")));
        this._addToPanel.setLayout(new BoxLayout(this._addToPanel, 1));
        this.buttonGroup1.add(this._newGraphRadioButton);
        this._newGraphRadioButton.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._newGraphRadioButton.text"));
        this._addToPanel.add(this._newGraphRadioButton);
        this.buttonGroup1.add(this._currentGraphRadioButton);
        this._currentGraphRadioButton.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._currentGraphRadioButton.text"));
        this._addToPanel.add(this._currentGraphRadioButton);
        jPanel.add((Component)this._addToPanel, "Center");
        this.add((Component)jPanel, "North");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout(5, 5));
        this._errorsLabel.setFont(new Font("Tahoma", 1, 11));
        this._errorsLabel.setForeground(new Color(100, 0, 0));
        this._errorsLabel.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._errorsLabel.text"));
        jPanel2.add((Component)this._errorsLabel, "North");
        this._errorsTextArea.setEditable(false);
        this._errorsTextArea.setFont(new Font("Tahoma", 0, 11));
        this._errorsTextArea.setForeground(new Color(100, 0, 0));
        this._errorsTextArea.setText(NbBundle.getMessage(ImportSuccessPanel.class, (String)"ImportSuccessPanel._errorsTextArea.text"));
        this._errorsTextArea.setWrapStyleWord(true);
        this._errorsTextArea.setOpaque(false);
        this._errorsScrollPane.setViewportView(this._errorsTextArea);
        jPanel2.add((Component)this._errorsScrollPane, "Center");
        this.add((Component)jPanel2, "Center");
    }
}

