/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class ActionsTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private boolean firstTimeExpand = true;
    private Cursor dragMoveCursor = DragSource.DefaultMoveDrop;
    private Cursor dragNoDropCursor = DragSource.DefaultMoveNoDrop;

    public ActionsTree(Node root) {
        super((TreeModel)new NodeTreeModel(root));
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        this.setShowsRootHandles(true);
        this.expandAll();
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 2, this);
    }

    private void expandAll() {
        int j;
        int i = 0;
        do {
            j = this.getRowCount();
            this.expandRow(i);
        } while (j != this.getRowCount() || ++i < this.getRowCount());
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.getPathForLocation(dge.getDragOrigin().x, dge.getDragOrigin().y);
        if (null != path) {
            Object obj = path.getLastPathComponent();
            if (this.getModel().isLeaf(obj)) {
                try {
                    Node node = Visualizer.findNode((Object)obj);
                    Transferable t = node.drag();
                    dge.getDragSource().addDragSourceListener(this);
                    dge.startDrag(this.dragNoDropCursor, t);
                }
                catch (IOException e) {
                    Logger.getLogger(ActionsTree.class.getName()).log(Level.WARNING, null, e);
                }
            }
        }
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(this.dragNoDropCursor);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int action = e.getDropAction();
        if ((action & 2) != 0) {
            context.setCursor(this.dragMoveCursor);
        } else {
            context.setCursor(this.dragNoDropCursor);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this.dragOver(dsde);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }
}

