/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class SimpleColorPicker
extends JComponent {
    public static final String PROP_SELECTED_COLOR = "selectedColor";
    private static Color[] _defaultColors = null;
    private static final int BUTTON_SIZE = 15;
    private static final int V_SPACING = 5;
    private static final int H_SPACING = 5;
    private static final int SELECTION_BLOCK_WIDTH = 30;
    private static final int SELECTION_BLOCK_HEIGHT = 35;
    private Color[] _colors;
    private Color _borderColor = Color.gray;
    private Color _borderHighlightColor = Color.lightGray;
    private ColorButton[] _buttons;
    private Color _selectedColor = Color.black;
    private Rectangle _selectionRect;
    private ColorButton _highlightedColor;

    public SimpleColorPicker() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SimpleColorPicker.this.handlePress(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SimpleColorPicker.this.setHighlightedColor(null);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                SimpleColorPicker.this.handleMove(mouseEvent);
            }
        });
        this._colors = SimpleColorPicker.getDefaultColors();
        this.updateButtons();
    }

    private static Color[] getDefaultColors() {
        if (_defaultColors == null) {
            MaltegoLAF.Safe safe = new MaltegoLAF.Safe();
            ArrayList<Color> arrayList = new ArrayList<Color>();
            for (int i = 0; i < safe.getInt("color-picker-count"); ++i) {
                arrayList.add(safe.getColor("color-picker-color" + (i + 1)));
            }
            _defaultColors = arrayList.toArray(new Color[arrayList.size()]);
        }
        return _defaultColors;
    }

    private void setHighlightedColor(ColorButton colorButton) {
        if (this._highlightedColor != colorButton) {
            if (this._highlightedColor != null) {
                this.repaint(this._highlightedColor.getRectangle());
            }
            if (colorButton != null) {
                this.repaint(colorButton.getRectangle());
            }
            this._highlightedColor = colorButton;
        }
    }

    private void handlePress(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        ColorButton colorButton = this.hitButton(point);
        if (colorButton != null) {
            Color color = this._selectedColor;
            this._selectedColor = colorButton.getColor();
            this.repaint(this._selectionRect);
            this.firePropertyChange(PROP_SELECTED_COLOR, color, this._selectedColor);
        }
    }

    private void handleMove(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        ColorButton colorButton = this.hitButton(point);
        this.setHighlightedColor(colorButton);
    }

    private ColorButton hitButton(Point point) {
        if (this._buttons != null) {
            for (ColorButton colorButton : this._buttons) {
                if (!colorButton.isHit(point)) continue;
                return colorButton;
            }
        }
        return null;
    }

    public void setAvailableColors(Color[] colorArray) {
        this._colors = colorArray;
        if (colorArray != null && colorArray.length > 0) {
            this.updateButtons();
        }
    }

    public Color[] getAvailableColors() {
        return this._colors;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintButtons(graphics);
        this.paintSelection(graphics);
    }

    private void updateButtons() {
        int n;
        this._buttons = new ColorButton[this._colors.length];
        int n2 = this.getColumnCount();
        Insets insets = this.getInsets();
        int n3 = insets.top;
        int n4 = insets.left;
        int n5 = 0;
        for (n = 0; n < this._buttons.length; ++n) {
            this._buttons[n] = new ColorButton(n4, n3, this._colors[n]);
            if ((n + 1) % n2 == 0) {
                n4 = insets.left;
                n3 = n3 + 15 + 5;
                if (n == this._buttons.length - 1) continue;
                n5 = n3 + 15 + 5;
                continue;
            }
            n4 = n4 + 15 + 5;
        }
        n4 = insets.left + n2 * 20 + 5;
        this._selectionRect = new Rectangle(n4, insets.top, 30, 35);
        n = (int)this._selectionRect.getMaxX() + insets.right;
        int n6 = Math.max((int)this._selectionRect.getMaxY(), n5);
        this.setPreferredSize(new Dimension(n, n6));
    }

    private int getColumnCount() {
        return (int)Math.ceil(Math.sqrt(this._colors.length));
    }

    private void paintButtons(Graphics graphics) {
        if (this._buttons != null) {
            for (ColorButton colorButton : this._buttons) {
                colorButton.paint(graphics, this._highlightedColor == colorButton);
            }
        }
    }

    private void paintSelection(Graphics graphics) {
        if (this._selectedColor != null && this._selectionRect != null) {
            graphics.setColor(this._selectedColor);
            graphics.fillRect(this._selectionRect.x, this._selectionRect.y, this._selectionRect.width, this._selectionRect.height);
        }
        graphics.setColor(this._borderColor);
        graphics.drawRect(this._selectionRect.x, this._selectionRect.y, this._selectionRect.width, this._selectionRect.height);
    }

    public Color getSelectedColor() {
        return this._selectedColor;
    }

    public void setSelectedColor(Color color) {
        this._selectedColor = color;
    }

    private class ColorButton {
        private int _x;
        private int _y;
        private Color _color;
        private Rectangle _rect;

        public ColorButton(int n, int n2, Color color) {
            this._color = color;
            this._x = n;
            this._y = n2;
            this._rect = new Rectangle(n, n2, 15, 15);
        }

        public boolean isHit(Point point) {
            return this._rect.contains(point);
        }

        public void paint(Graphics graphics, boolean bl) {
            graphics.setColor(this._color);
            graphics.fillRect(this._x, this._y, 15, 15);
            graphics.setColor(bl ? SimpleColorPicker.this._borderHighlightColor : SimpleColorPicker.this._borderColor);
            graphics.drawRect(this._x, this._y, 15, 15);
        }

        public Color getColor() {
            return this._color;
        }

        public Rectangle getRectangle() {
            return this._rect;
        }
    }
}

