/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.modules.editor.impl.CustomizableSideBar;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.editor.mimelookup.MimeLocation;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

@MimeLocation(subfolderName="SideBar", instanceProviderClass=SideBarFactoriesProvider.class)
public final class SideBarFactoriesProvider
implements InstanceProvider<SideBarFactoriesProvider> {
    private static final Logger LOG = Logger.getLogger(SideBarFactoriesProvider.class.getName());
    public static final String SIDEBAR_COMPONENTS_FOLDER_NAME = "SideBar";
    private final List<FileObject> instanceFiles;
    private Map<CustomizableSideBar.SideBarPosition, List<SideBarFactory>> factories;

    public SideBarFactoriesProvider() {
        this(Collections.emptyList());
    }

    private SideBarFactoriesProvider(List<FileObject> instanceFiles) {
        this.instanceFiles = instanceFiles;
    }

    public Map<CustomizableSideBar.SideBarPosition, List<SideBarFactory>> getFactories() {
        if (this.factories == null) {
            this.factories = this.computeInstances();
        }
        return this.factories;
    }

    public SideBarFactoriesProvider createInstance(List<FileObject> fileObjectList) {
        return new SideBarFactoriesProvider(fileObjectList);
    }

    private Map<CustomizableSideBar.SideBarPosition, List<SideBarFactory>> computeInstances() {
        HashMap<CustomizableSideBar.SideBarPosition, List<SideBarFactory>> factoriesMap = new HashMap<CustomizableSideBar.SideBarPosition, List<SideBarFactory>>();
        for (FileObject f : this.instanceFiles) {
            SideBarFactory factory;
            block5: {
                factory = null;
                if (!f.isValid() || !f.isData()) continue;
                try {
                    DataObject dob = DataObject.find((FileObject)f);
                    InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                    if (ic == null || !SideBarFactory.class.isAssignableFrom(ic.instanceClass())) break block5;
                    factory = (SideBarFactory)ic.instanceCreate();
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.log(Level.INFO, null, cnfe);
                    continue;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, null, e);
                    continue;
                }
            }
            if (factory == null) continue;
            CustomizableSideBar.SideBarPosition position = new CustomizableSideBar.SideBarPosition(f);
            ArrayList<SideBarFactory> factoriesList = (ArrayList<SideBarFactory>)factoriesMap.get(position);
            if (factoriesList == null) {
                factoriesList = new ArrayList<SideBarFactory>();
                factoriesMap.put(position, factoriesList);
            }
            factoriesList.add(factory);
        }
        return factoriesMap;
    }
}

