/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Rectangle;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.openide.util.WeakSet;

final class DebugRepaintManager
extends RepaintManager {
    private static final DebugRepaintManager INSTANCE = new DebugRepaintManager();
    private static final Logger LOG = Logger.getLogger(DebugRepaintManager.class.getName());
    private final Set<JComponent> debugComponents = new WeakSet();

    public static void register(JComponent component) {
        if (RepaintManager.currentManager(component) != INSTANCE) {
            RepaintManager.setCurrentManager(INSTANCE);
        }
        INSTANCE.addDebugComponent(component);
    }

    private DebugRepaintManager() {
    }

    public void addDebugComponent(JComponent component) {
        this.debugComponents.add(component);
    }

    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        if (this.debugComponents.contains(c)) {
            LOG.fine("cREPAINT: " + ViewUtils.toString(new Rectangle(x, y, w, h)) + " c:" + ViewUtils.toString(c) + '\n');
        }
        super.addDirtyRegion(c, x, y, w, h);
    }
}

