/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.layout.view;

import com.paterva.maltego.layout.LayoutFactory;
import com.paterva.maltego.layout.view.LayoutHandler;
import com.paterva.maltego.ui.graph.view2d.InteractiveMoveSelectionMode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import yguard.A.A.C;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.A._;
import yguard.A.G.A.F;
import yguard.A.G.A.L;
import yguard.A.G.JA;
import yguard.A.G.NA;
import yguard.A.G.W;
import yguard.A.G.l;
import yguard.A.I.QA;
import yguard.A.I.S;
import yguard.A.I.fB;
import yguard.A.I.o;
import yguard.A.J.M;

public class InteractiveLayoutViewHandler
implements LayoutHandler {
    private S _view;
    private Timer _timer;
    private l _layouter;
    private UpdateHandler _updater;
    private static final int RELAYOUT_NODE_COUNT = 2000;
    private int _nodesChanged = 0;
    private boolean _preparingView = false;
    private final Object _relayoutLock = new Object();
    private LayoutFactory.LayoutMode _layoutMode;
    private boolean _preventWakeUp = false;
    private boolean _showing = false;

    InteractiveLayoutViewHandler(S s) {
        this._view = s;
        this._updater = new UpdateHandler();
        this._timer = new Timer(21, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = InteractiveLayoutViewHandler.this._relayoutLock;
                synchronized (object) {
                    if (InteractiveLayoutViewHandler.this._preparingView) {
                        return;
                    }
                }
                if (InteractiveLayoutViewHandler.this._layouter instanceof L && (object = (L)InteractiveLayoutViewHandler.this._layouter).A(50.0, 0.1) > 0.0) {
                    InteractiveLayoutViewHandler.this.clearBendsAndResetPorts();
                    InteractiveLayoutViewHandler.this._view.H().\u011b();
                }
            }
        });
    }

    public void setLayoutMode(LayoutFactory.LayoutMode layoutMode) {
        if (this._layoutMode == layoutMode) {
            return;
        }
        this._layoutMode = layoutMode;
        if (this._layoutMode == null) {
            if (this._timer != null) {
                this._timer.stop();
            }
            this._layouter = null;
            return;
        }
        if (this._showing) {
            this.createLayouter();
        }
    }

    private void clearBendsAndResetPorts() {
        QA qA = this._view.H();
        this._preventWakeUp = true;
        qA.\u00e3();
        Z z = qA.\u00c9();
        while (z.ok()) {
            H h = z.edge();
            o o2 = qA.X(h);
            o2.clearBends();
            qA.A(h, M.B);
            qA.C(h, M.B);
            z.next();
        }
        qA.\u00d0();
        this._preventWakeUp = false;
    }

    public fB getMoveSelectionMode() {
        if (this._layouter instanceof L) {
            L l2 = (L)this._layouter;
            return new InteractiveMoveSelectionMode(l2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGraphChanged(QA qA, QA qA2) {
        if (qA != null) {
            qA.B((_)this._updater);
        }
        if (qA2 != null) {
            Object object = this._relayoutLock;
            synchronized (object) {
                this._nodesChanged = qA2.\u00ca();
            }
            if (this._showing) {
                this.createLayouter();
            } else {
                this._layouter = null;
            }
            qA2.A((_)this._updater);
        }
    }

    @Override
    public void onGraphUpdated(Set<Y> set) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareToShow() {
        boolean bl;
        Object object = this._relayoutLock;
        synchronized (object) {
            bl = this._nodesChanged >= 2000;
            this._preparingView = true;
        }
        if (bl) {
            object = new F();
            object.\u010c();
            object._(760.0);
            object.a(0.48);
            object.u(false);
            object.t(true);
            object.b(0.72);
            object.p(false);
            object.n(false);
            new JA((l)object).doLayout((NA)this._view.H());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InteractiveLayoutViewHandler.this._view.\u00de();
                }
            });
        }
        object = this._relayoutLock;
        synchronized (object) {
            this._nodesChanged = 0;
            this._preparingView = false;
        }
    }

    private void createLayouter() {
        double d = this._view.H().\u00ca();
        int n = (int)(d * d / 100000.0 + 21.0);
        n = Math.min(n, 1000);
        this._timer.setDelay(n);
        this._layouter = LayoutFactory.getLayouter(this._layoutMode);
        if (this._layouter instanceof L) {
            L l2 = (L)this._layouter;
            if (!l2.O()) {
                l2.A((NA)new W((NA)this._view.H()));
            }
            l2.G();
        }
        this._timer.start();
    }

    @Override
    public void onComponentShowing() {
        this._showing = true;
        if (this._layoutMode != null) {
            if (this._layouter == null) {
                this.createLayouter();
            }
            this._timer.start();
        }
    }

    @Override
    public void onComponentHidden() {
        this._showing = false;
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    @Override
    public void onComponentClosed() {
        if (this._layouter != null) {
            if (this._layouter instanceof L) {
                L l2 = (L)this._layouter;
                l2.M();
            }
            this._layouter = null;
        }
    }

    private class UpdateHandler
    implements _ {
        private int block = 0;

        private UpdateHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onGraphEvent(C c) {
            if (c.B() instanceof QA) {
                Object object;
                switch (c.C()) {
                    case 12: {
                        ++this.block;
                        break;
                    }
                    case 13: {
                        --this.block;
                        break;
                    }
                    case 0: 
                    case 3: {
                        object = InteractiveLayoutViewHandler.this._relayoutLock;
                        synchronized (object) {
                            if (!InteractiveLayoutViewHandler.this._view.isShowing()) {
                                InteractiveLayoutViewHandler.this._nodesChanged++;
                            }
                            break;
                        }
                    }
                }
                if (this.block == 0) {
                    object = InteractiveLayoutViewHandler.this._relayoutLock;
                    synchronized (object) {
                        if (!InteractiveLayoutViewHandler.this._preparingView && !InteractiveLayoutViewHandler.this._preventWakeUp && InteractiveLayoutViewHandler.this._layouter instanceof L) {
                            ((L)InteractiveLayoutViewHandler.this._layouter).G();
                        }
                    }
                }
            }
        }
    }
}

