/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.descriptor;

import com.paterva.maltego.imgfactory.ImageFactory;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.descriptor.ToolboxItem;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Image;

public class ToolboxItemSpec<TInstance>
extends TypeSpec
implements ToolboxItem {
    private String _description;
    private String _helpUrl;
    private String _helpText;
    private Class<? extends TInstance> _class;
    private boolean _canBeRoot = true;
    private Image _smallIcon;
    private Image _largeIcon;
    private String _smallIconResource;
    private String _largeIconResource;
    private Color _color;
    private static final String VALUE_PROPERTY = "value";
    private static final String DISPLAY_VALUE_PROPERTY = "displayValue";

    public ToolboxItemSpec() {
    }

    public ToolboxItemSpec(String string, DisplayDescriptorCollection displayDescriptorCollection) {
        super(string, displayDescriptorCollection);
    }

    public ToolboxItemSpec(String string, DisplayDescriptorCollection displayDescriptorCollection, GroupDefinitions groupDefinitions) {
        super(string, displayDescriptorCollection, groupDefinitions);
    }

    public ToolboxItemSpec(String string, PropertyConfiguration propertyConfiguration) {
        super(string, propertyConfiguration);
    }

    public void setDisplayValueProperty(DisplayDescriptor displayDescriptor) {
        if (displayDescriptor == this.getValueProperty()) {
            displayDescriptor = null;
        }
        this.setSpecialProperty(DISPLAY_VALUE_PROPERTY, displayDescriptor);
    }

    public void setValueProperty(DisplayDescriptor displayDescriptor) {
        this.setSpecialProperty(VALUE_PROPERTY, displayDescriptor);
    }

    public DisplayDescriptor getDisplayValueProperty() {
        DisplayDescriptor displayDescriptor = this.getSpecialProperty(DISPLAY_VALUE_PROPERTY);
        if (displayDescriptor == null) {
            return this.getValueProperty();
        }
        return displayDescriptor;
    }

    public DisplayDescriptor getValueProperty() {
        return this.getSpecialProperty(VALUE_PROPERTY);
    }

    @Override
    public String getHelpUrl() {
        return this._helpUrl;
    }

    @Override
    public void setHelpUrl(String string) {
        this._helpUrl = string;
    }

    public void setInstanceClass(Class<? extends TInstance> clazz) {
        this._class = clazz;
    }

    public Class<? extends TInstance> getInstanceClass() {
        return this._class;
    }

    @Override
    public boolean isToolboxItem() {
        return this._canBeRoot;
    }

    @Override
    public void setToolboxItem(boolean bl) {
        this._canBeRoot = bl;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public void setDescription(String string) {
        this._description = string;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String string) {
        this._helpText = string;
    }

    @Override
    public Image getSmallIcon() {
        if (this._smallIcon != null) {
            return this._smallIcon;
        }
        if (!StringUtilities.isNullOrEmpty((String)this._smallIconResource)) {
            return ToolboxItemSpec.getImageFromResource(this._smallIconResource, 16, 16);
        }
        return null;
    }

    @Override
    public Image getLargeIcon() {
        if (this._largeIcon != null) {
            return this._largeIcon;
        }
        if (!StringUtilities.isNullOrEmpty((String)this._largeIconResource)) {
            return ToolboxItemSpec.getImageFromResource(this._largeIconResource, 48, 48);
        }
        return null;
    }

    @Override
    public void setSmallIcon(Image image) {
        if (image != null) {
            this._smallIcon = image;
            this._smallIconResource = null;
        }
    }

    @Override
    public void setLargeIcon(Image image) {
        if (image != null) {
            this._largeIcon = image;
            this._largeIconResource = null;
        }
    }

    @Override
    public String getHelp() {
        return this._helpText;
    }

    @Override
    public void setHelp(String string) {
        this._helpText = string;
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    @Override
    public void setColor(Color color) {
        this._color = color;
    }

    public String getSmallIconResource() {
        if (StringUtilities.isNullOrEmpty((String)this._smallIconResource)) {
            return this.getLargeIconResource();
        }
        return this._smallIconResource;
    }

    public void setSmallIconResource(String string) {
        if (!StringUtilities.isNullOrEmpty((String)string)) {
            this._smallIconResource = string;
            this._smallIcon = null;
        }
    }

    public String getLargeIconResource() {
        return this._largeIconResource;
    }

    public void setLargeIconResource(String string) {
        if (!StringUtilities.isNullOrEmpty((String)string)) {
            this._largeIconResource = string;
            this._largeIcon = null;
        }
    }

    public Image getIcon(int n) {
        return this.getIcon(n, n);
    }

    public Image getIcon(int n, int n2) {
        if (n2 >= 0 && n2 <= 20) {
            if (!StringUtilities.isNullOrEmpty((String)this.getSmallIconResource())) {
                return ToolboxItemSpec.getImageFromResource(this.getSmallIconResource(), n, n2);
            }
            return this._smallIcon;
        }
        if (!StringUtilities.isNullOrEmpty((String)this.getLargeIconResource())) {
            return ToolboxItemSpec.getImageFromResource(this.getLargeIconResource(), n, n2);
        }
        return this._largeIcon;
    }

    private static Image getImageFromResource(String string, int n, int n2) {
        Image image = ImageFactory.getDefault().getImage((Object)string, n, n2, null);
        return image;
    }
}

