/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory;

import com.paterva.maltego.imgfactory.ImageCache;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.openide.util.Lookup;

public abstract class ImageFactory {
    private static ImageFactory _default;

    public abstract ImageIcon getImageIcon(Object var1, ImageCallback var2);

    public abstract ImageIcon getImageIcon(Object var1, int var2, int var3, ImageCallback var4);

    public abstract Image getImage(Object var1, ImageCallback var2);

    public abstract Image getImage(Object var1, int var2, int var3, ImageCallback var4);

    public static ImageFactory getDefault() {
        if (_default == null && (_default = (ImageFactory)Lookup.getDefault().lookup(ImageCache.class)) == null) {
            _default = new TrivialImageFactory();
        }
        return _default;
    }

    static class TrivialImageFactory
    extends ImageFactory {
        TrivialImageFactory() {
        }

        @Override
        public ImageIcon getImageIcon(Object object, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public ImageIcon getImageIcon(Object object, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public Image getImage(Object object, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }

        @Override
        public Image getImage(Object object, int n, int n2, ImageCallback imageCallback) {
            throw new UnsupportedOperationException("No image factory registered.");
        }
    }
}

