/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.impl;

import com.paterva.maltego.imgfactory.impl.ImageID;
import com.paterva.maltego.imgfactory.impl.ImageIconContainer;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ImageUtils;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

class ImageIconDiskCache
implements ImageIconContainer {
    private String _cacheDir;
    private HashMap<ImageID, String> _cacheIndex = new HashMap();

    public ImageIconDiskCache() {
        this.createCacheDir();
        this.clear();
    }

    @Override
    public boolean contains(ImageID imageID) {
        return this._cacheIndex.containsKey(imageID);
    }

    @Override
    public ImageIcon get(ImageID imageID) {
        File file = new File(this._cacheDir + this._cacheIndex.get(imageID));
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(ImageIO.read(file));
        }
        catch (IOException iOException) {
            Logger.getLogger(ImageIconDiskCache.class.getName()).log(Level.SEVERE, null, iOException);
        }
        return imageIcon;
    }

    @Override
    public void put(ImageID imageID, ImageIcon imageIcon) {
        try {
            File file = File.createTempFile("temp", ".png", new File(this._cacheDir));
            ImageIconDiskCache.writeImageIconToFile(imageIcon, file);
            this._cacheIndex.put(imageID, file.getName());
        }
        catch (IOException iOException) {
            Logger.getLogger(ImageIconDiskCache.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    @Override
    public void remove(ImageID imageID, boolean bl) {
        if (!bl) {
            String string = this._cacheIndex.get(imageID);
            if (string != null) {
                this.removeFile(string);
                this._cacheIndex.remove(imageID);
            }
        } else {
            Iterator<Map.Entry<ImageID, String>> iterator = this._cacheIndex.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ImageID, String> entry = iterator.next();
                if (!entry.getKey().Key.equals(imageID.Key)) continue;
                this.removeFile(entry.getValue());
                iterator.remove();
            }
        }
    }

    private void removeFile(String string) {
        File file = new File(this._cacheDir + string);
        if (!file.delete()) {
            Logger.getLogger(ImageIconDiskCache.class.getName()).log(Level.SEVERE, null, "Failed to delete " + file);
        }
    }

    @Override
    public final void clear() {
        File[] fileArray;
        this._cacheIndex.clear();
        File file = new File(this._cacheDir);
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.delete()) continue;
            Logger.getLogger(ImageIconDiskCache.class.getName()).log(Level.SEVERE, null, "Failed to delete " + file2);
        }
    }

    private void createCacheDir() {
        this._cacheDir = FileUtilities.createTempDir((String)"ImageCache");
    }

    private static void writeImageIconToFile(ImageIcon imageIcon, File file) throws IOException {
        ImageIO.write((RenderedImage)ImageUtils.createBufferedImage((Image)imageIcon.getImage()), "png", file);
    }

    public String getStatus() {
        return "";
    }
}

