/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.ColorUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class GraphicsUtils {
    public static void drawShadedFatPentagram(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        GraphicsUtils.drawShadedFatPentagram(graphics2D, n, n2, n3, n4, color, color, color2, true, false);
    }

    public static void drawShadedFatPentagram(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, boolean bl, boolean bl2) {
        Color color2 = ColorUtilities.brighterTranslucent((Color)color, (int)50, (int)color.getAlpha());
        GraphicsUtils.drawShadedFatPentagram(graphics2D, n, n2, n3, n4, color, color2, color, bl, bl2);
    }

    public static void drawShadedFatPentagram(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, boolean bl, boolean bl2) {
        Color color4 = new Color(50, 50, 50, color.getAlpha());
        double[] dArray = new double[]{0.5, 0.64, 0.95, 0.74, 0.77, 0.5, 0.23, 0.26, 0.05, 0.36};
        double[] dArray2 = new double[]{0.0, 0.27, 0.33, 0.57, 0.88, 0.73, 0.88, 0.57, 0.33, 0.27};
        int[] nArray = new int[dArray.length];
        int[] nArray2 = new int[dArray.length];
        int n5 = 3;
        double d = 0.5;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n + (int)((double)(n3 - 6) * dArray[i] + 0.5) + 3;
            nArray2[i] = n2 + (int)((double)(n4 - 6) * dArray2[i] + 0.5) + 3;
        }
        if (bl) {
            GradientPaint gradientPaint = new GradientPaint(n, n2, color2, n + n3, n2 + n4, color3);
            graphics2D.setPaint(gradientPaint);
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        if (bl2) {
            graphics2D.setStroke(new BasicStroke(5.0f, 1, 1));
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setStroke(new BasicStroke(2.0f, 1, 1));
            graphics2D.setColor(color4);
        }
        graphics2D.drawPolygon(nArray, nArray2, nArray.length);
    }

    public static void drawPaperClip(Graphics2D graphics2D, double d, double d2) {
        AffineTransform affineTransform = graphics2D.getTransform();
        double d3 = 0.5;
        graphics2D.scale(d3, d3);
        int n = (int)(d / d3);
        int n2 = (int)(d2 / d3);
        graphics2D.translate(n, n2);
        int n3 = (int)(18.0 / d3);
        int n4 = (int)(9.0 / d3);
        int n5 = (int)(3.0 / d3);
        int[] nArray = new int[]{n4, n4, n4 / 2, 0, 0, n4 - n5, n4 - n5, n4 / 2, n5, n5};
        int[] nArray2 = new int[]{n5, n3 - n4 / 2, n3, n3 - n4 / 2, 0, 0, n3 - n4 / 2 - n5, n3 - n5 * 2, n3 - n4 / 2 - n5, n5};
        int n6 = 5;
        for (int i = 5; i >= 1; --i) {
            double d4 = Math.sqrt(25 - i * i) / 5.0;
            graphics2D.setColor(new Color((int)(d4 * 128.0), (int)(d4 * 128.0), (int)(d4 * 128.0)));
            graphics2D.setStroke(new BasicStroke(i));
            graphics2D.drawPolyline(nArray, nArray2, nArray.length);
        }
        graphics2D.setTransform(affineTransform);
    }
}

