/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import com.paterva.maltego.util.IconResourceProvider;
import com.paterva.maltego.util.ImageUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.ImageUtilities;

public class IconSelectorPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    public static final String PROP_SELECTED_VALUE = "selectedValue";
    private JRadioButton _fileButton = new JRadioButton("Select from file");
    private JRadioButton _resourceButton = new JRadioButton("Select from standard icon list");
    private JPanel _innerPane = new JPanel(new CardLayout());
    private JTabbedPane _tabbedPane = new JTabbedPane();
    private static final String RESOURCE = "resource";
    private static final String FILE = "file";
    private Map<String, JList> _lists = new HashMap<String, JList>();
    private JFileChooser _chooser;
    private int _iconSize = 48;
    private Object _selectedValue;
    private PreviewPanel _preview = new PreviewPanel();

    public IconSelectorPanel() {
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IconSelectorPanel.this.setSelectedValueImpl(IconSelectorPanel.this.getSelectedResource());
            }
        });
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel = new JPanel(new GridLayout(2, 0));
        jPanel.add(this._resourceButton);
        jPanel.add(this._fileButton);
        this._innerPane.add((Component)this._tabbedPane, RESOURCE);
        this._innerPane.add(this.createFileView(), FILE);
        this.add((Component)jPanel, "North");
        this.add((Component)this._innerPane, "Center");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._fileButton);
        buttonGroup.add(this._resourceButton);
        this._resourceButton.setSelected(true);
        this._fileButton.addActionListener(this);
        this._resourceButton.addActionListener(this);
        this.setPreferredSize(new Dimension(600, 450));
        this.checkPanes();
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void setAvailableResources(Map<String, String[]> map) {
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            this.addResourceView(entry.getKey(), entry.getValue());
        }
    }

    public Object getSelectedValue() {
        return this._selectedValue;
    }

    public void setSelectedValue(Object object) {
        if (object == null || object instanceof String) {
            this._resourceButton.setSelected(true);
            this.setSelectedResource((String)object);
        } else if (object instanceof File) {
            this._fileButton.setSelected(true);
            this.setSelectedFile((File)object);
        } else {
            throw new IllegalArgumentException("Type " + object.getClass() + " is not a valid selection type.");
        }
        this.setSelectedValueImpl(object);
        this.checkPanes();
    }

    private void setSelectedValueImpl(Object object) {
        if (object != this._selectedValue) {
            Object object2 = this._selectedValue;
            this._selectedValue = object;
            this.fireSelectedValueChanged(object2, object);
        }
    }

    protected void fireSelectedValueChanged(Object object, Object object2) {
        this.firePropertyChange(PROP_SELECTED_VALUE, object, object2);
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    protected void fireIconSelected() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, "iconSelected");
        for (ActionListener actionListener : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void addResourceView(String string, String[] stringArray) {
        final JList<Object> jList = new JList<Object>(new ArrayListModel(new String[0]));
        jList.setCellRenderer(new IconListCellRenderer());
        jList.setSelectionMode(0);
        jList.setLayoutOrientation(2);
        jList.setVisibleRowCount(-1);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent.getClickCount() == 2 && (n = jList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    IconSelectorPanel.this.fireIconSelected();
                }
            }
        };
        jList.addMouseListener(mouseAdapter);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IconSelectorPanel.this.setSelectedValueImpl(IconSelectorPanel.this.getSelectedResource());
            }
        });
        ArrayListModel arrayListModel = new ArrayListModel(stringArray);
        jList.setModel(arrayListModel);
        this._lists.put(string, jList);
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 31);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), jScrollPane.getBorder()));
        this._tabbedPane.add(string, jScrollPane);
    }

    private Component createFileView() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setControlButtonsAreShown(false);
        jFileChooser.setAccessory(this._preview);
        jFileChooser.addPropertyChangeListener(this);
        this._chooser = jFileChooser;
        return jFileChooser;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.checkPanes();
    }

    private void checkPanes() {
        CardLayout cardLayout = (CardLayout)this._innerPane.getLayout();
        if (this._resourceButton.isSelected()) {
            this.setSelectedValueImpl(this.getSelectedResource());
            cardLayout.show(this._innerPane, RESOURCE);
        } else {
            this.setSelectedValueImpl(this.getSelectedFile());
            cardLayout.show(this._innerPane, FILE);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            this._preview.setImageFile((File)propertyChangeEvent.getNewValue());
            this.setSelectedValueImpl(propertyChangeEvent.getNewValue());
        }
    }

    protected void setSelectedFile(File file) {
        this._chooser.setSelectedFile(file);
    }

    protected void setSelectedResource(String string) {
        if (string != null) {
            String string2 = IconResourceProvider.getDefault().getCategory(string);
            this._tabbedPane.setSelectedIndex(this.getTabIndex(string2));
            JList jList = this._lists.get(string2);
            jList.setSelectedValue(string, false);
        }
    }

    private int getTabIndex(String string) {
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            if (!this._tabbedPane.getTitleAt(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected File getSelectedFile() {
        return this._chooser.getSelectedFile();
    }

    protected String getSelectedResource() {
        int n = this._tabbedPane.getSelectedIndex();
        if (n >= 0) {
            return (String)this._lists.get(this._tabbedPane.getTitleAt(this._tabbedPane.getSelectedIndex())).getSelectedValue();
        }
        return null;
    }

    public int getIconSize() {
        return this._iconSize;
    }

    public void setIconSize(int n) {
        this._iconSize = n;
        for (JList jList : this._lists.values()) {
            jList.setFixedCellHeight(n + 5);
            jList.setFixedCellWidth(n + 5);
        }
        this._preview.setClipSize(n);
    }

    private static class ArrayListModel
    implements ListModel {
        private String[] _data;

        public ArrayListModel(String[] stringArray) {
            this._data = stringArray;
        }

        public String[] getData() {
            return this._data;
        }

        @Override
        public int getSize() {
            return this._data.length;
        }

        public Object getElementAt(int n) {
            return this._data[n];
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static class PreviewPanel
    extends JPanel {
        private JLabel _icon = new JLabel();
        private JCheckBox _preview = new JCheckBox("Preview");
        private File _imageFile;
        private Icon _defaultIcon;
        private int _clipSize = 80;
        private static final int MAX_CLIP = 80;

        public PreviewPanel() {
            this._preview.setSelected(true);
            this._preview.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PreviewPanel.this.update();
                }
            });
            this.add(this._preview);
            this.add(this._icon);
            this.setPreferredSize(new Dimension(90, 100));
        }

        public File getImageFile() {
            return this._imageFile;
        }

        public void setImageFile(File file) {
            if (file != this._imageFile) {
                this._imageFile = file;
                this.update();
            }
        }

        public void update() {
            Icon icon = this.getDefaultIcon();
            if (this._preview.isSelected() && this._imageFile != null) {
                try {
                    icon = this.load(this._imageFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._icon.setIcon(icon);
        }

        private Icon load(File file) throws IOException {
            Image image = ImageIO.read(file);
            if ((image = this.resize(image)) == null) {
                return null;
            }
            return new ImageIcon(image);
        }

        private Image resize(Image image) {
            if (image == null) {
                return null;
            }
            if (this.getClipSize() <= 0) {
                return image;
            }
            BufferedImage bufferedImage = ImageUtils.createBufferedImage((Image)image);
            BufferedImage bufferedImage2 = ImageUtils.smartClip((BufferedImage)bufferedImage, (double)Math.min(80, this.getClipSize()));
            return bufferedImage2;
        }

        private Icon getDefaultIcon() {
            if (this._defaultIcon == null) {
                this._defaultIcon = new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/util/ui/EmptyImage48.png"));
            }
            return this._defaultIcon;
        }

        public int getClipSize() {
            return this._clipSize;
        }

        public void setClipSize(int n) {
            this._clipSize = n;
        }

        @Override
        public void doLayout() {
            Dimension dimension = this._preview.getPreferredSize();
            int n = Math.min(80, this.getClipSize());
            int n2 = 5;
            int n3 = (this.getHeight() - n) / 2 - 20;
            this._preview.setBounds(n2, n3, (int)dimension.getWidth(), (int)dimension.getHeight());
            n3 = (int)((double)n3 + dimension.getHeight());
            this._icon.setBounds(n2, n3, n, n);
        }
    }

    private class IconListCellRenderer
    extends DefaultListCellRenderer {
        private IconListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                String string = ImageUtils.getImageFile((String)object.toString(), (int)IconSelectorPanel.this.getIconSize());
                Image image = ImageUtilities.loadImage((String)string);
                if (image != null) {
                    this.setIcon(new ImageIcon(image));
                    this.setText("");
                } else {
                    this.setIcon(null);
                    this.setText("<null>");
                }
            } else {
                this.setIcon(null);
                this.setText("<null>");
            }
            return component;
        }
    }
}

