from checkov.common.models.enums import CheckResult
from checkov.terraform.checks.resource.base_resource_check import BaseResourceCheck

# Reference: https://cloud.google.com/iam/docs/best-practices-service-accounts
# Lookup: https://cloud.google.com/iam/docs/permissions-reference

IMPERSONATION_ROLES = [
    "roles/owner",
    "roles/editor",
    "roles/iam.securityAdmin",
    "roles/iam.serviceAccountAdmin",
    "roles/iam.serviceAccountKeyAdmin",
    "roles/iam.serviceAccountUser",
    "roles/iam.serviceAccountTokenCreator",
    "roles/iam.workloadIdentityUser",
    "roles/dataflow.developer",
    "roles/serverless.serviceAgent",
    "roles/dataproc.serviceAgent",
    "roles/deploymentmanager.editor",
    "roles/cloudbuild.builds.editor",
    "roles/aiplatform.customCodeServiceAgent",
    "roles/aiplatform.extensionServiceAgent",
    "roles/aiplatform.serviceAgent",
    "roles/apigateway.serviceAgent",
    "roles/apigee.serviceAgent",
    "roles/appengine.serviceAgent",
    "roles/appengineflex.serviceAgent",
    "roles/bigquerycontinuousquery.serviceAgent",
    "roles/bigquerydatatransfer.serviceAgent",
    "roles/bigqueryspark.serviceAgent",
    "roles/cloudbuild.serviceAgent",
    "roles/cloudconfig.serviceAgent",
    "roles/clouddeploy.serviceAgent",
    "roles/cloudfunctions.serviceAgent",
    "roles/cloudscheduler.serviceAgent",
    "roles/cloudtasks.serviceAgent",
    "roles/composer.serviceAgent",
    "roles/compute.serviceAgent",
    "roles/connectors.serviceAgent",
    "roles/dataflow.serviceAgent",
    "roles/eventarc.serviceAgent",
    "roles/integrations.serviceAgent",
    "roles/ml.serviceAgent",
    "roles/notebooks.serviceAgent",
    "roles/pubsub.serviceAgent",
    "roles/run.serviceAgent",
    "roles/sourcerepo.serviceAgent",
    "roles/workflows.serviceAgent",
    "roles/iam.serviceAccountOpenIdTokenCreator",
    "roles/aiplatform.colabServiceAgent",
    "roles/backupdr.computeEngineOperator",
    "roles/backupdr.serviceAgent",
    "roles/batch.serviceAgent",
    "roles/clouddeploymentmanager.serviceAgent",
    "roles/cloudtpu.serviceAgent",
    "roles/compute.instanceGroupManagerServiceAgent",
    "roles/configdelivery.serviceAgent",
    "roles/container.serviceAgent",
    "roles/datapipelines.serviceAgent",
    "roles/dataplex.serviceAgent",
    "roles/dataprep.serviceAgent",
    "roles/dataproc.hubAgent",
    "roles/firebaseapphosting.serviceAgent",
    "roles/firebasemods.serviceAgent",
    "roles/gameservices.serviceAgent",
    "roles/genomics.serviceAgent",
    "roles/krmapihosting.anthosApiEndpointServiceAgent",
    "roles/krmapihosting.serviceAgent",
    "roles/lifesciences.serviceAgent",
    "roles/osconfig.serviceAgent",
    "roles/runapps.serviceAgent",
    "roles/securitycenter.securityResponseServiceAgent",
    "roles/workstations.serviceAgent",
    "roles/securesourcemanager.serviceAgent",
    "roles/assuredoss.admin",
    "roles/securitycenter.admin",
    "roles/vpcaccess.serviceAgent",
    "roles/cloudbuild.builds.builder",
    "roles/composer.worker",
    "roles/dataflow.admin",
    "roles/run.sourceDeveloper",
]


class AbsGoogleImpersonationRoles(BaseResourceCheck):
    def scan_resource_conf(self, conf):
        self.evaluated_keys = ['role']
        if 'role' in conf and conf['role'][0] in IMPERSONATION_ROLES:
            return CheckResult.FAILED
        return CheckResult.PASSED
