# OpenAPI

The [OpenAPI specification] has moved from `openapi.yaml` to the `openapi.json`
and `openapi.yaml` files in `httptransport/api/v1`.

These files are autogenerated from files in `httptransport/api` and
`httptransport/types` via the `httptransport/api/openapi.zsh` script. This
script requires `zsh` to run and `sha256sum`, `git`, `jq`, `yq`, and `npx`
commands in `PATH`.

## Modifications

To modify the OpenAPI spec, edit the relevant `httptransport/api/*/openapi.jq`
file (a [`jq`] script) or the `httptransport/api/lib/oapi.jq` library as needed,
then run `go generate ./httptransport`.

The `go generate` command also needs to be run if files in `httptransport/types`
are modified.

## Script

The `openapi.zsh` script works by:
- for each `v*` directory under `httptransport/api`:
  - for all [JSON Schema] files in the corresponding `httptransport/types/v*` directory:
    - lint the schema
    - slip-steam examples from the corresponding `examples` file
  - amalgamate all the files from the previous step
  - run the `openapi.jq` script with `null` input
  - merge the outputs of the previous two steps
  - ~~validate and lint the OpenAPI spec~~[^note]
  - generate a `yaml` representation
  - write out a `sha256` checksum in [Etag] format

[^note]: The OpenAPI spec _should_ also be validated or linted, but there's not a known tool that handles JSON Schema [reference resolution] correctly.

[OpenAPI specification]: https://spec.openapis.org/oas/v3.1.0.html
[`jq`]: https://jqlang.org/manual/
[JSON Schema]: https://json-schema.org/
[Etag]: https://developer.mozilla.org/en-US/docs/Web/HTTP/Reference/Headers/ETag
[reference resolution]: https://www.learnjsonschema.com/2020-12/core/ref/
