// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Creates an {@link AccountSasServices} from the specified services string. This method will throw an
 * Error if it encounters a character that does not correspond to a valid service.
 *
 * @param services -
 */
export function accountSasServicesFromString(services) {
    const accountSasServices = {};
    for (const c of services) {
        switch (c) {
            case "b":
                accountSasServices.blob = true;
                break;
            case "f":
                accountSasServices.file = true;
                break;
            case "q":
                accountSasServices.queue = true;
                break;
            case "t":
                accountSasServices.table = true;
                break;
            default:
                throw new RangeError(`Invalid service character: ${c}`);
        }
    }
    return accountSasServices;
}
/**
 * Converts the given services to a string.
 *
 */
export function accountSasServicesToString(services = { table: true }) {
    const servicesString = [];
    if (services.blob) {
        servicesString.push("b");
    }
    if (services.table) {
        servicesString.push("t");
    }
    if (services.queue) {
        servicesString.push("q");
    }
    if (services.file) {
        servicesString.push("f");
    }
    return servicesString.join("");
}
//# sourceMappingURL=accountSasServices.js.map