import { FileCreateOptionalParams, FileCreateResponse, FileDownloadOptionalParams, FileDownloadResponse, FileGetPropertiesOptionalParams, FileGetPropertiesResponse, FileDeleteOptionalParams, FileDeleteResponse, FileSetHttpHeadersOptionalParams, FileSetHttpHeadersResponse, FileSetMetadataOptionalParams, FileSetMetadataResponse, FileAcquireLeaseOptionalParams, FileAcquireLeaseResponse, FileReleaseLeaseOptionalParams, FileReleaseLeaseResponse, FileChangeLeaseOptionalParams, FileChangeLeaseResponse, FileBreakLeaseOptionalParams, FileBreakLeaseResponse, FileRangeWriteType, FileUploadRangeOptionalParams, FileUploadRangeResponse, FileUploadRangeFromURLOptionalParams, FileUploadRangeFromURLResponse, FileGetRangeListOptionalParams, FileGetRangeListResponse, FileStartCopyOptionalParams, FileStartCopyResponse, FileAbortCopyOptionalParams, FileAbortCopyResponse, FileListHandlesOptionalParams, FileListHandlesResponse, FileForceCloseHandlesOptionalParams, FileForceCloseHandlesResponse, FileRenameOptionalParams, FileRenameResponse, FileCreateSymbolicLinkOptionalParams, FileCreateSymbolicLinkResponse, FileGetSymbolicLinkOptionalParams, FileGetSymbolicLinkResponse, FileCreateHardLinkOptionalParams, FileCreateHardLinkResponse } from "../models/index.js";
/** Interface representing a File. */
export interface File {
    /**
     * Creates a new file or replaces a file. Note it only initializes the file with no content.
     * @param fileContentLength Specifies the maximum size for the file, up to 4 TB.
     * @param options The options parameters.
     */
    create(fileContentLength: number, options?: FileCreateOptionalParams): Promise<FileCreateResponse>;
    /**
     * Reads or downloads a file from the system, including its metadata and properties.
     * @param options The options parameters.
     */
    download(options?: FileDownloadOptionalParams): Promise<FileDownloadResponse>;
    /**
     * Returns all user-defined metadata, standard HTTP properties, and system properties for the file. It
     * does not return the content of the file.
     * @param options The options parameters.
     */
    getProperties(options?: FileGetPropertiesOptionalParams): Promise<FileGetPropertiesResponse>;
    /**
     * removes the file from the storage account.
     * @param options The options parameters.
     */
    delete(options?: FileDeleteOptionalParams): Promise<FileDeleteResponse>;
    /**
     * Sets HTTP headers on the file.
     * @param options The options parameters.
     */
    setHttpHeaders(options?: FileSetHttpHeadersOptionalParams): Promise<FileSetHttpHeadersResponse>;
    /**
     * Updates user-defined metadata for the specified file.
     * @param options The options parameters.
     */
    setMetadata(options?: FileSetMetadataOptionalParams): Promise<FileSetMetadataResponse>;
    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete
     * operations
     * @param options The options parameters.
     */
    acquireLease(options?: FileAcquireLeaseOptionalParams): Promise<FileAcquireLeaseResponse>;
    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete
     * operations
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    releaseLease(leaseId: string, options?: FileReleaseLeaseOptionalParams): Promise<FileReleaseLeaseResponse>;
    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete
     * operations
     * @param leaseId Specifies the current lease ID on the resource.
     * @param options The options parameters.
     */
    changeLease(leaseId: string, options?: FileChangeLeaseOptionalParams): Promise<FileChangeLeaseResponse>;
    /**
     * [Update] The Lease File operation establishes and manages a lock on a file for write and delete
     * operations
     * @param options The options parameters.
     */
    breakLease(options?: FileBreakLeaseOptionalParams): Promise<FileBreakLeaseResponse>;
    /**
     * Upload a range of bytes to a file.
     * @param range Specifies the range of bytes to be written. Both the start and end of the range must be
     *              specified. For an update operation, the range can be up to 4 MB in size. For a clear operation, the
     *              range can be up to the value of the file's full size. The File service accepts only a single byte
     *              range for the Range and 'x-ms-range' headers, and the byte range must be specified in the following
     *              format: bytes=startByte-endByte.
     * @param fileRangeWrite Specify one of the following options: - Update: Writes the bytes specified by
     *                       the request body into the specified range. The Range and Content-Length headers must match to
     *                       perform the update. - Clear: Clears the specified range and releases the space used in storage for
     *                       that range. To clear a range, set the Content-Length header to zero, and set the Range header to a
     *                       value that indicates the range to clear, up to maximum file size.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the
     *                      x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param options The options parameters.
     */
    uploadRange(range: string, fileRangeWrite: FileRangeWriteType, contentLength: number, options?: FileUploadRangeOptionalParams): Promise<FileUploadRangeResponse>;
    /**
     * Upload a range of bytes to a file where the contents are read from a URL.
     * @param range Writes data to the specified byte range in the file.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file
     *                   to another file within the same storage account, you may use Shared Key to authenticate the source
     *                   file. If you are copying a file from another storage account, or if you are copying a blob from the
     *                   same storage account or another storage account, then you must authenticate the source file or blob
     *                   using a shared access signature. If the source is a public blob, no authentication is required to
     *                   perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param contentLength Specifies the number of bytes being transmitted in the request body. When the
     *                      x-ms-write header is set to clear, the value of this header must be set to zero.
     * @param options The options parameters.
     */
    uploadRangeFromURL(range: string, copySource: string, contentLength: number, options?: FileUploadRangeFromURLOptionalParams): Promise<FileUploadRangeFromURLResponse>;
    /**
     * Returns the list of valid ranges for a file.
     * @param options The options parameters.
     */
    getRangeList(options?: FileGetRangeListOptionalParams): Promise<FileGetRangeListResponse>;
    /**
     * Copies a blob or file to a destination file within the storage account.
     * @param copySource Specifies the URL of the source file or blob, up to 2 KB in length. To copy a file
     *                   to another file within the same storage account, you may use Shared Key to authenticate the source
     *                   file. If you are copying a file from another storage account, or if you are copying a blob from the
     *                   same storage account or another storage account, then you must authenticate the source file or blob
     *                   using a shared access signature. If the source is a public blob, no authentication is required to
     *                   perform the copy operation. A file in a share snapshot can also be specified as a copy source.
     * @param options The options parameters.
     */
    startCopy(copySource: string, options?: FileStartCopyOptionalParams): Promise<FileStartCopyResponse>;
    /**
     * Aborts a pending Copy File operation, and leaves a destination file with zero length and full
     * metadata.
     * @param copyId The copy identifier provided in the x-ms-copy-id header of the original Copy File
     *               operation.
     * @param options The options parameters.
     */
    abortCopy(copyId: string, options?: FileAbortCopyOptionalParams): Promise<FileAbortCopyResponse>;
    /**
     * Lists handles for file
     * @param options The options parameters.
     */
    listHandles(options?: FileListHandlesOptionalParams): Promise<FileListHandlesResponse>;
    /**
     * Closes all handles open for given file
     * @param handleId Specifies handle ID opened on the file or directory to be closed. Asterisk (‘*’) is
     *                 a wildcard that specifies all handles.
     * @param options The options parameters.
     */
    forceCloseHandles(handleId: string, options?: FileForceCloseHandlesOptionalParams): Promise<FileForceCloseHandlesResponse>;
    /**
     * Renames a file
     * @param renameSource Required. Specifies the URI-style path of the source file, up to 2 KB in length.
     * @param options The options parameters.
     */
    rename(renameSource: string, options?: FileRenameOptionalParams): Promise<FileRenameResponse>;
    /**
     * Creates a symbolic link.
     * @param linkText NFS only. Required. The path to the original file, the symbolic link is pointing to.
     *                 The path is of type string which is not resolved and is stored as is. The path can be absolute path
     *                 or the relative path depending on the content stored in the symbolic link file.
     * @param options The options parameters.
     */
    createSymbolicLink(linkText: string, options?: FileCreateSymbolicLinkOptionalParams): Promise<FileCreateSymbolicLinkResponse>;
    /** @param options The options parameters. */
    getSymbolicLink(options?: FileGetSymbolicLinkOptionalParams): Promise<FileGetSymbolicLinkResponse>;
    /**
     * Creates a hard link.
     * @param targetFile NFS only. Required. Specifies the path of the target file to which the link will
     *                   be created, up to 2 KiB in length. It should be full path of the target from the root.The target
     *                   file must be in the same share and hence the same storage account.
     * @param options The options parameters.
     */
    createHardLink(targetFile: string, options?: FileCreateHardLinkOptionalParams): Promise<FileCreateHardLinkResponse>;
}
//# sourceMappingURL=file.d.ts.map