from dateutil.parser import parse as parse_datetime

data = {
    "cves": [
        {
            "id": "CVE-2015-0001",
            "assigner": "secure@microsoft.com",
            "status": "Deferred",
            "published": parse_datetime("2015-01-13T22:59:00.050Z", ignoretz=True),
            "modified": parse_datetime("2025-04-12T10:46:40.837Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-12T10:46:40.837Z", ignoretz=True),
            "summary": 'The Windows Error Reporting (WER) component in Microsoft Windows 8, Windows 8.1, Windows Server 2012 Gold and R2, and Windows RT Gold and 8.1 allows local users to bypass the Protected Process Light protection mechanism and read the contents of arbitrary process-memory locations by leveraging administrative privileges, aka "Windows Error Reporting Security Feature Bypass Vulnerability."',
            "access": {
                "authentication": "NONE",
                "complexity": "MEDIUM",
                "vector": "LOCAL",
            },
            "impact": {
                "availability": "NONE",
                "confidentiality": "PARTIAL",
                "integrity": "NONE",
            },
            "cvss4": None,
            "cvss3": None,
            "cvss": 1.9,
            "exploitabilityScore": 3.4,
            "impactScore": 2.9,
            "cvssTime": parse_datetime("2025-04-12T10:46:40.837Z", ignoretz=True),
            "cvssVector": "AV:L/AC:M/Au:N/C:P/I:N/A:N",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:L/AC:M/Au:N/C:P/I:N/A:N",
                            "baseScore": 1.9,
                            "authentication": "NONE",
                            "accessComplexity": "MEDIUM",
                            "accessVector": "LOCAL",
                            "confidentialityImpact": "PARTIAL",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "NONE",
                        }
                    ]
                },
                "cvss3": {},
                "cvss4": {},
            },
            "references": [
                "http://packetstormsecurity.com/files/134392/Microsoft-Windows-8.1-Ahcache.sys-NtApphelpCacheControl-Privilege-Escalation.html",
                "http://secunia.com/advisories/62134",
                "http://www.securityfocus.com/bid/71927",
                "https://docs.microsoft.com/en-us/security-updates/securitybulletins/2015/ms15-006",
                "https://exchange.xforce.ibmcloud.com/vulnerabilities/99513",
                "https://exchange.xforce.ibmcloud.com/vulnerabilities/99514",
                "http://packetstormsecurity.com/files/134392/Microsoft-Windows-8.1-Ahcache.sys-NtApphelpCacheControl-Privilege-Escalation.html",
                "http://secunia.com/advisories/62134",
                "http://www.securityfocus.com/bid/71927",
                "https://docs.microsoft.com/en-us/security-updates/securitybulletins/2015/ms15-006",
                "https://exchange.xforce.ibmcloud.com/vulnerabilities/99513",
                "https://exchange.xforce.ibmcloud.com/vulnerabilities/99514",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:microsoft:windows_8:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_8.1:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_rt:-:gold:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_rt_8.1:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2012:-:gold:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2012:r2:*:*:*:*:x64:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:microsoft:windows_8:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_8.1:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_rt:-:gold:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_rt_8.1:-:*:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2012:-:gold:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2012:r2:*:*:*:*:x64:*:*",
            ],
            "vendors": ["microsoft"],
            "products": [
                "windows_8",
                "windows_8.1",
                "windows_rt",
                "windows_rt_8.1",
                "windows_server_2012",
            ],
            "vulnerable_product_stems": [
                "cpe:2.3:o:microsoft:windows_8",
                "cpe:2.3:o:microsoft:windows_8.1",
                "cpe:2.3:o:microsoft:windows_rt",
                "cpe:2.3:o:microsoft:windows_rt_8.1",
                "cpe:2.3:o:microsoft:windows_server_2012",
            ],
            "vulnerable_configuration_stems": [
                "cpe:2.3:o:microsoft:windows_8",
                "cpe:2.3:o:microsoft:windows_8.1",
                "cpe:2.3:o:microsoft:windows_rt",
                "cpe:2.3:o:microsoft:windows_rt_8.1",
                "cpe:2.3:o:microsoft:windows_server_2012",
            ],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_8:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "0D229E41-A971-4284-9657-16D78414B93F",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_8.1:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E93068DB-549B-45AB-8E5C-00EB5D8B5CF8",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_rt:-:gold:*:*:*:*:*:*",
                                    "matchCriteriaId": "DC5F631C-5461-4C0B-AE80-079A987912DA",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_rt_8.1:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "C6CE5198-C498-4672-AF4C-77AB4BE06C5C",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_server_2012:-:gold:*:*:*:*:*:*",
                                    "matchCriteriaId": "AB506484-7F0C-46BF-8EA6-4FB5AF454CED",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_server_2012:r2:*:*:*:*:x64:*:*",
                                    "matchCriteriaId": "D29A1464-D228-4E0D-8FEA-06B9CBCA7F74",
                                },
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-264"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.00548",
            "epssMetric": {
                "percentile": "0.66972",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2018-0004",
            "assigner": "sirt@juniper.net",
            "status": "Modified",
            "published": parse_datetime("2018-01-10T22:29:01.057Z", ignoretz=True),
            "modified": parse_datetime("2024-11-21T03:37:20.233Z", ignoretz=True),
            "lastModified": parse_datetime("2024-11-21T03:37:20.233Z", ignoretz=True),
            "summary": "A sustained sequence of different types of normal transit traffic can trigger a high CPU consumption denial of service condition in the Junos OS register and schedule software interrupt handler subsystem when a specific command is issued to the device. This affects one or more threads and conversely one or more running processes running on the system. Once this occurs, the high CPU event(s) affects either or both the forwarding and control plane. As a result of this condition the device can become inaccessible in either or both the control and forwarding plane and stops forwarding traffic until the device is rebooted. The issue will reoccur after reboot upon receiving further transit traffic. Score: 5.7 MEDIUM (CVSS:3.0/AV:A/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H) For network designs utilizing layer 3 forwarding agents or other ARP through layer 3 technologies, the score is slightly higher. Score: 6.5 MEDIUM (CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H) If the following entry exists in the RE message logs then this may indicate the issue is present. This entry may or may not appear when this issue occurs. /kernel: Expensive timeout(9) function: Affected releases are Juniper Networks Junos OS: 12.1X46 versions prior to 12.1X46-D50; 12.3X48 versions prior to 12.3X48-D30; 12.3R versions prior to 12.3R12-S7; 14.1 versions prior to 14.1R8-S4, 14.1R9; 14.1X53 versions prior to 14.1X53-D30, 14.1X53-D34; 14.2 versions prior to 14.2R8; 15.1 versions prior to 15.1F6, 15.1R3; 15.1X49 versions prior to 15.1X49-D40; 15.1X53 versions prior to 15.1X53-D31, 15.1X53-D33, 15.1X53-D60. No other Juniper Networks products or platforms are affected by this issue.",
            "access": {
                "authentication": "NONE",
                "complexity": "MEDIUM",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "COMPLETE",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "cvss4": None,
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "exploitability3": {
                "attackvector": "NETWORK",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "REQUIRED",
                "scope": "UNCHANGED",
            },
            "cvss3": 6.5,
            "impactScore3": 3.6,
            "exploitabilityScore3": 2.8,
            "cvss3Time": parse_datetime("2024-11-21T03:37:20.233Z", ignoretz=True),
            "cvss3Type": "Secondary",
            "cvss3Source": "sirt@juniper.net",
            "cvss": 7.1,
            "exploitabilityScore": 8.6,
            "impactScore": 6.9,
            "cvssTime": parse_datetime("2024-11-21T03:37:20.233Z", ignoretz=True),
            "cvssVector": "AV:N/AC:M/Au:N/C:N/I:N/A:C",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:M/Au:N/C:N/I:N/A:C",
                            "baseScore": 7.1,
                            "authentication": "NONE",
                            "accessComplexity": "MEDIUM",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "COMPLETE",
                        }
                    ]
                },
                "cvss3": {
                    "sirt@juniper-net": [
                        {
                            "type": "Secondary",
                            "vectorString": "CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H",
                            "baseScore": 6.5,
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "REQUIRED",
                            "scope": "UNCHANGED",
                        }
                    ],
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:N/I:N/A:H",
                            "baseScore": 6.5,
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "REQUIRED",
                            "scope": "UNCHANGED",
                        }
                    ],
                },
                "cvss4": {},
            },
            "references": [
                "http://www.securitytracker.com/id/1040183",
                "https://kb.juniper.net/JSA10832",
                "http://www.securitytracker.com/id/1040183",
                "https://kb.juniper.net/JSA10832",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:juniper:junos:12.1x46:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d35:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d40:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d45:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r11:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r12:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r8:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r9:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r9:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d16:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d26:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d27:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d34:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:a1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d35:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d21:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d210:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d33:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d60:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:juniper:junos:12.1x46:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d35:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d40:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.1x46:d45:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3x48:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r11:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r12:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r8:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:12.3:r9:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1:r9:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d15:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d16:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d26:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d27:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.1x53:d34:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r6:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:14.2:r7:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:a1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s1:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s2:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f2-s4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f4:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:f5:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1:r3:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x49:d35:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:*:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d10:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d20:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d21:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d210:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d25:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d30:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d33:*:*:*:*:*:*",
                "cpe:2.3:o:juniper:junos:15.1x53:d60:*:*:*:*:*:*",
            ],
            "vendors": ["juniper"],
            "products": ["junos"],
            "vulnerable_product_stems": ["cpe:2.3:o:juniper:junos"],
            "vulnerable_configuration_stems": ["cpe:2.3:o:juniper:junos"],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CFB89F64-16BB-4A14-9084-B338668D7FF1",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d10:*:*:*:*:*:*",
                                    "matchCriteriaId": "A71742CF-50B1-44BB-AB7B-27E5DCC9CF70",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d15:*:*:*:*:*:*",
                                    "matchCriteriaId": "4FD4237A-C257-4D8A-ABC4-9B2160530A4E",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d20:*:*:*:*:*:*",
                                    "matchCriteriaId": "5A449C87-C5C3-48FE-9E46-64ED5DD5F193",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d25:*:*:*:*:*:*",
                                    "matchCriteriaId": "F4B6215F-76BF-473F-B325-0975B0EB101E",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d30:*:*:*:*:*:*",
                                    "matchCriteriaId": "A1C4A10C-49A3-4103-9E56-F881113BC5D7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d35:*:*:*:*:*:*",
                                    "matchCriteriaId": "50E7FD07-A309-48EC-A520-C7F0FA35865C",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d40:*:*:*:*:*:*",
                                    "matchCriteriaId": "F868948A-04D7-473B-971F-721302653633",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.1x46:d45:*:*:*:*:*:*",
                                    "matchCriteriaId": "830A9EBA-88F1-4277-B98F-75AC52A60824",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3x48:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7192552C-7D4A-4D95-BA79-CDF465E27D37",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3x48:d10:*:*:*:*:*:*",
                                    "matchCriteriaId": "4B7066A4-CD05-4E1A-89E8-71B4CB92CFF3",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3x48:d15:*:*:*:*:*:*",
                                    "matchCriteriaId": "A4AC2E1E-74FB-4DA3-8292-B2079F83FF54",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3x48:d20:*:*:*:*:*:*",
                                    "matchCriteriaId": "5FF83BD0-3B28-481E-8C8F-09ECDA493DA4",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3x48:d25:*:*:*:*:*:*",
                                    "matchCriteriaId": "6E296274-AFC1-4F56-A4B3-827C2E0BC9D5",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r1:*:*:*:*:*:*",
                                    "matchCriteriaId": "371A7DF8-3F4B-439D-8990-D1BC6F0C25C5",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r11:*:*:*:*:*:*",
                                    "matchCriteriaId": "F0DD051A-E486-4A9D-A978-A5A980AAF237",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r12:*:*:*:*:*:*",
                                    "matchCriteriaId": "D4ED9ACC-B6BA-4128-8934-759BB9EC904F",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r2:*:*:*:*:*:*",
                                    "matchCriteriaId": "7CC3BCFD-2B0F-4994-9FE4-9D37FA85F1E2",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r3:*:*:*:*:*:*",
                                    "matchCriteriaId": "C6F309FD-0A5A-4C86-B227-B2B511A5CEB4",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r4:*:*:*:*:*:*",
                                    "matchCriteriaId": "960059B5-0701-4B75-AB51-0A430247D9F0",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r5:*:*:*:*:*:*",
                                    "matchCriteriaId": "1D1DCA52-DA81-495B-B516-5571F01E3B0A",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r6:*:*:*:*:*:*",
                                    "matchCriteriaId": "05E187F6-BACD-4DD5-B393-B2FE4349053A",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r7:*:*:*:*:*:*",
                                    "matchCriteriaId": "3C240840-A6BC-4E3D-A60D-22F08E67E2B2",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r8:*:*:*:*:*:*",
                                    "matchCriteriaId": "CC90563F-6BCB-4D77-8FD4-584E3A6C7741",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:12.3:r9:*:*:*:*:*:*",
                                    "matchCriteriaId": "5AD03BA7-D9EC-420F-97C4-383F79D6873F",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6237291A-B861-4D53-B7AA-C53A44B76896",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r1:*:*:*:*:*:*",
                                    "matchCriteriaId": "9C778627-820A-48F5-9680-0205D6DB5EB6",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r2:*:*:*:*:*:*",
                                    "matchCriteriaId": "FA7F03DC-73A2-4760-B386-2A57E9C97E65",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r3:*:*:*:*:*:*",
                                    "matchCriteriaId": "0CA10003-D52B-4110-9D7A-F50895E6BA17",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r4:*:*:*:*:*:*",
                                    "matchCriteriaId": "1B2D843A-8ADE-4888-8960-B48394DEA1D2",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r5:*:*:*:*:*:*",
                                    "matchCriteriaId": "3BE66516-A06D-4C0F-8346-DFC8865C8FE8",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r6:*:*:*:*:*:*",
                                    "matchCriteriaId": "EEBDFC9E-7753-42A8-A5C8-4D40D219F93A",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r7:*:*:*:*:*:*",
                                    "matchCriteriaId": "25E5D543-D779-482D-AA8A-6E77C1949FBD",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1:r9:*:*:*:*:*:*",
                                    "matchCriteriaId": "8A76DAC5-AEC4-47E8-9876-71EE5BAD73E2",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9C7FCCC1-B151-465A-8327-26DB5DC074F0",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d10:*:*:*:*:*:*",
                                    "matchCriteriaId": "09771B8F-8B2A-4E8B-B4D3-80677697FCF3",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d15:*:*:*:*:*:*",
                                    "matchCriteriaId": "55E2F909-E1CC-45AA-ABA9-58178B751808",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d16:*:*:*:*:*:*",
                                    "matchCriteriaId": "E1AA12C5-4520-4F79-80BE-66112F7AFC2A",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d25:*:*:*:*:*:*",
                                    "matchCriteriaId": "807C8110-5CC2-45F0-B094-BBF9C0B63BDD",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d26:*:*:*:*:*:*",
                                    "matchCriteriaId": "547E5737-D385-49B9-A69F-A3B185A34116",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d27:*:*:*:*:*:*",
                                    "matchCriteriaId": "2ED257ED-A56B-48A6-8568-65F36FFFC753",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.1x53:d34:*:*:*:*:*:*",
                                    "matchCriteriaId": "0F0F3845-0966-469E-B6C6-8FA372208733",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D59449C6-5BD5-4C07-AEF6-EEBC70D9C4C7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r1:*:*:*:*:*:*",
                                    "matchCriteriaId": "79149AA0-17D1-4522-894F-C025F7A30FD7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r2:*:*:*:*:*:*",
                                    "matchCriteriaId": "30726286-7CB1-4E5D-AE44-2B4D84795900",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r3:*:*:*:*:*:*",
                                    "matchCriteriaId": "33BE028F-2961-414A-9D42-C4861566C2DC",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r4:*:*:*:*:*:*",
                                    "matchCriteriaId": "E85AB30C-03FC-44DB-A8AA-B916A905CA66",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r5:*:*:*:*:*:*",
                                    "matchCriteriaId": "D01CA25F-E1E1-4831-8561-D3B0300BF4A7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r6:*:*:*:*:*:*",
                                    "matchCriteriaId": "A117A0D6-6356-49DF-8B21-F6D47C6B8E94",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:14.2:r7:*:*:*:*:*:*",
                                    "matchCriteriaId": "8C31AA11-FA95-4927-9E48-D46BBE4945B1",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "BD0952C4-FFCC-4A78-ADFC-289BD6E269DB",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:a1:*:*:*:*:*:*",
                                    "matchCriteriaId": "83AB8877-3DC0-4B8C-B864-1BF18C368337",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f1:*:*:*:*:*:*",
                                    "matchCriteriaId": "C56F5C48-BA48-4EE1-88BE-782B3CFB3B90",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f2:*:*:*:*:*:*",
                                    "matchCriteriaId": "1C56E6C3-BBB6-4853-91D9-99C7676D0CD4",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f2-s1:*:*:*:*:*:*",
                                    "matchCriteriaId": "AC196685-3B0C-4754-AE6A-6BE456CC6B52",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f2-s2:*:*:*:*:*:*",
                                    "matchCriteriaId": "F0146AA9-C513-4871-A62A-52C9F40EB958",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f2-s3:*:*:*:*:*:*",
                                    "matchCriteriaId": "A18672EF-E33D-4ACE-BB0A-561812F502C7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f2-s4:*:*:*:*:*:*",
                                    "matchCriteriaId": "CEF0E75F-831E-40B8-926D-B2E92A84E31B",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f3:*:*:*:*:*:*",
                                    "matchCriteriaId": "0E0ECBD8-3D66-49DA-A557-5695159F0C06",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f4:*:*:*:*:*:*",
                                    "matchCriteriaId": "0EAA2998-A0D6-4818-9E7C-25E8099403E7",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:f5:*:*:*:*:*:*",
                                    "matchCriteriaId": "2D4ADFC5-D4B8-4A68-95D8-8ADF92C1CFE8",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1:r3:*:*:*:*:*:*",
                                    "matchCriteriaId": "C7620D01-1A6B-490F-857E-0D803E0AEE56",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x49:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "20DABA6A-FA7A-4289-8C6A-2B93689A5440",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x49:d10:*:*:*:*:*:*",
                                    "matchCriteriaId": "D90D8985-34EF-44CC-A9A7-CB0FD22676F2",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x49:d20:*:*:*:*:*:*",
                                    "matchCriteriaId": "18468579-0195-4DDE-BAA5-4BE4068F3A69",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x49:d30:*:*:*:*:*:*",
                                    "matchCriteriaId": "0E5FAA97-171F-4DB9-B78E-6E1A5F34336A",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x49:d35:*:*:*:*:*:*",
                                    "matchCriteriaId": "870244F3-1C05-4F10-A205-5189BB860F46",
                                },
                            ],
                        }
                    ]
                },
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B71FB14A-67D4-4EDD-BB32-07764F5AFA6E",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d10:*:*:*:*:*:*",
                                    "matchCriteriaId": "6E87C765-8D68-404A-AC71-3F22A7260E8C",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d20:*:*:*:*:*:*",
                                    "matchCriteriaId": "1E3B807C-196D-42B8-9042-7582A1366772",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d21:*:*:*:*:*:*",
                                    "matchCriteriaId": "83FEEE8F-9279-46F2-BAF9-A60537020C61",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d210:*:*:*:*:*:*",
                                    "matchCriteriaId": "BBD36C0D-0F44-4349-968D-4CD60F281D84",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d25:*:*:*:*:*:*",
                                    "matchCriteriaId": "1DD0B95A-7C9F-4A18-9CD8-BA344DEFC9D4",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d30:*:*:*:*:*:*",
                                    "matchCriteriaId": "1F294E43-73FA-4EF3-90F2-EE29C56D6573",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d33:*:*:*:*:*:*",
                                    "matchCriteriaId": "CC517CD0-FF35-498F-AD33-683B43CA3829",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:juniper:junos:15.1x53:d60:*:*:*:*:*:*",
                                    "matchCriteriaId": "962CCED8-E321-4878-9BE6-0DC33778559A",
                                },
                            ],
                        }
                    ]
                },
            ],
            "cwe": ["CWE-400"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.00288",
            "epssMetric": {
                "percentile": "0.51863",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2020-0079",
            "assigner": "security@android.com",
            "status": "Modified",
            "published": parse_datetime("2020-04-17T19:15:13.793Z", ignoretz=True),
            "modified": parse_datetime("2024-11-21T04:52:52.010Z", ignoretz=True),
            "lastModified": parse_datetime("2024-11-21T04:52:52.010Z", ignoretz=True),
            "summary": "In decrypt_1_2 of CryptoPlugin.cpp, there is a possible out of bounds write due to stale pointer. This could lead to local escalation of privilege with no additional execution privileges needed. User interaction is not needed for exploitation.Product: AndroidVersions: Android-9 Android-10Android ID: A-144506242",
            "access": {
                "authentication": "NONE",
                "complexity": "LOW",
                "vector": "LOCAL",
            },
            "impact": {
                "availability": "PARTIAL",
                "confidentiality": "PARTIAL",
                "integrity": "PARTIAL",
            },
            "cvss4": None,
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "HIGH",
                "integrity": "HIGH",
            },
            "exploitability3": {
                "attackvector": "LOCAL",
                "attackcomplexity": "LOW",
                "privilegesrequired": "LOW",
                "userinteraction": "NONE",
                "scope": "UNCHANGED",
            },
            "cvss3": 7.8,
            "cvss3Vector": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H",
            "impactScore3": 5.9,
            "exploitabilityScore3": 1.8,
            "cvss3Time": parse_datetime("2024-11-21T04:52:52.010Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": 4.6,
            "exploitabilityScore": 3.9,
            "impactScore": 6.4,
            "cvssTime": parse_datetime("2024-11-21T04:52:52.010Z", ignoretz=True),
            "cvssVector": "AV:L/AC:L/Au:N/C:P/I:P/A:P",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:L/AC:L/Au:N/C:P/I:P/A:P",
                            "baseScore": 4.6,
                            "authentication": "NONE",
                            "accessComplexity": "LOW",
                            "accessVector": "LOCAL",
                            "confidentialityImpact": "PARTIAL",
                            "integrityImpact": "PARTIAL",
                            "availabilityImpact": "PARTIAL",
                        }
                    ]
                },
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:H/I:H/A:H",
                            "baseScore": 7.8,
                            "confidentialityImpact": "HIGH",
                            "integrityImpact": "HIGH",
                            "availabilityImpact": "HIGH",
                            "attackVector": "LOCAL",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "LOW",
                            "userInteraction": "NONE",
                            "scope": "UNCHANGED",
                        }
                    ]
                },
                "cvss4": {},
            },
            "references": [
                "https://source.android.com/security/bulletin/2020-04-01",
                "https://source.android.com/security/bulletin/2020-04-01",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:google:android:9.0:*:*:*:*:*:*:*",
                "cpe:2.3:o:google:android:10.0:*:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:google:android:9.0:*:*:*:*:*:*:*",
                "cpe:2.3:o:google:android:10.0:*:*:*:*:*:*:*",
            ],
            "vendors": ["google"],
            "products": ["android"],
            "vulnerable_product_stems": ["cpe:2.3:o:google:android"],
            "vulnerable_configuration_stems": ["cpe:2.3:o:google:android"],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:google:android:9.0:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8DFAAD08-36DA-4C95-8200-C29FE5B6B854",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:google:android:10.0:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D558D965-FA70-4822-A770-419E73BA9ED3",
                                },
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-787"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.00034",
            "epssMetric": {
                "percentile": "0.08298",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2010-3333",
            "assigner": "secure@microsoft.com",
            "status": "Deferred",
            "published": parse_datetime("2010-11-10T03:00:02.087Z", ignoretz=True),
            "modified": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "summary": 'Stack-based buffer overflow in Microsoft Office XP SP3, Office 2003 SP3, Office 2007 SP2, Office 2010, Office 2004 and 2008 for Mac, Office for Mac 2011, and Open XML File Format Converter for Mac allows remote attackers to execute arbitrary code via crafted RTF data, aka "RTF Stack Buffer Overflow Vulnerability."',
            "access": {
                "authentication": "NONE",
                "complexity": "MEDIUM",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "COMPLETE",
                "confidentiality": "COMPLETE",
                "integrity": "COMPLETE",
            },
            "cvss4": None,
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "HIGH",
                "integrity": "HIGH",
            },
            "exploitability3": {
                "attackvector": "LOCAL",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "REQUIRED",
                "scope": "UNCHANGED",
            },
            "cvss3": 7.8,
            "cvss3Vector": "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H",
            "impactScore3": 5.9,
            "exploitabilityScore3": 1.8,
            "cvss3Time": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": 9.3,
            "exploitabilityScore": 8.6,
            "impactScore": 10,
            "cvssTime": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "cvssVector": "AV:N/AC:M/Au:N/C:C/I:C/A:C",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:M/Au:N/C:C/I:C/A:C",
                            "baseScore": 9.3,
                            "authentication": "NONE",
                            "accessComplexity": "MEDIUM",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "COMPLETE",
                            "integrityImpact": "COMPLETE",
                            "availabilityImpact": "COMPLETE",
                        }
                    ]
                },
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H",
                            "baseScore": 7.8,
                            "confidentialityImpact": "HIGH",
                            "integrityImpact": "HIGH",
                            "availabilityImpact": "HIGH",
                            "attackVector": "LOCAL",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "REQUIRED",
                            "scope": "UNCHANGED",
                        }
                    ],
                    "134c704f-9b21-4f2e-91b3-4a467353bcc0": [
                        {
                            "type": "Secondary",
                            "vectorString": "CVSS:3.1/AV:L/AC:L/PR:N/UI:R/S:U/C:H/I:H/A:H",
                            "baseScore": 7.8,
                            "confidentialityImpact": "HIGH",
                            "integrityImpact": "HIGH",
                            "availabilityImpact": "HIGH",
                            "attackVector": "LOCAL",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "REQUIRED",
                            "scope": "UNCHANGED",
                        }
                    ],
                },
                "cvss4": {},
            },
            "references": [
                "http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=880",
                "http://secunia.com/advisories/38521",
                "http://secunia.com/advisories/42144",
                "http://securityreason.com/securityalert/8293",
                "http://www.securityfocus.com/bid/44652",
                "http://www.securitytracker.com/id?1024705",
                "http://www.us-cert.gov/cas/techalerts/TA10-313A.html",
                "http://www.vupen.com/english/advisories/2010/2923",
                "https://docs.microsoft.com/en-us/security-updates/securitybulletins/2010/ms10-087",
                "https://oval.cisecurity.org/repository/search/definition/oval%3Aorg.mitre.oval%3Adef%3A11931",
                "http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=880",
                "http://secunia.com/advisories/38521",
                "http://secunia.com/advisories/42144",
                "http://securityreason.com/securityalert/8293",
                "http://www.securityfocus.com/bid/44652",
                "http://www.securitytracker.com/id?1024705",
                "http://www.us-cert.gov/cas/techalerts/TA10-313A.html",
                "http://www.vupen.com/english/advisories/2010/2923",
                "https://docs.microsoft.com/en-us/security-updates/securitybulletins/2010/ms10-087",
                "https://oval.cisecurity.org/repository/search/definition/oval%3Aorg.mitre.oval%3Adef%3A11931",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:a:microsoft:office:2003:sp3:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2004:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:2007:sp2:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2008:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:2010:*:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2011:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:xp:sp3:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:open_xml_file_format_converter:-:*:*:*:*:macos:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:a:microsoft:office:2003:sp3:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2004:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:2007:sp2:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2008:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:2010:*:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:office:2011:*:*:*:*:macos:*:*",
                "cpe:2.3:a:microsoft:office:xp:sp3:*:*:*:*:*:*",
                "cpe:2.3:a:microsoft:open_xml_file_format_converter:-:*:*:*:*:macos:*:*",
            ],
            "vendors": ["microsoft"],
            "products": ["office", "open_xml_file_format_converter"],
            "vulnerable_product_stems": [
                "cpe:2.3:a:microsoft:office",
                "cpe:2.3:a:microsoft:open_xml_file_format_converter",
            ],
            "vulnerable_configuration_stems": [
                "cpe:2.3:a:microsoft:office",
                "cpe:2.3:a:microsoft:open_xml_file_format_converter",
            ],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2003:sp3:*:*:*:*:*:*",
                                    "matchCriteriaId": "A332D04D-CC8C-4F68-A261-BA2F2D8EAD1E",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2004:*:*:*:*:macos:*:*",
                                    "matchCriteriaId": "0B191155-67F2-4C6E-BD0C-AF5AF6F04BA1",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2007:sp2:*:*:*:*:*:*",
                                    "matchCriteriaId": "08AF794A-435D-4171-9DBB-EB7FAED96DBA",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2008:*:*:*:*:macos:*:*",
                                    "matchCriteriaId": "421ACF1B-1B21-4416-98ED-BAA5C210EAE5",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2010:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6F68DBEC-7A95-43B4-9174-79F89FC93BC5",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:2011:*:*:*:*:macos:*:*",
                                    "matchCriteriaId": "BCB90D64-B7B2-4301-91E3-A113569371F2",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:office:xp:sp3:*:*:*:*:*:*",
                                    "matchCriteriaId": "79BA1175-7F02-4435-AEA6-1BA8AADEB7EF",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:microsoft:open_xml_file_format_converter:-:*:*:*:*:macos:*:*",
                                    "matchCriteriaId": "4BC69733-551E-4535-B851-4A3EF71E98CD",
                                },
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-787"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.93964",
            "epssMetric": {
                "percentile": "0.99879",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2017-12231",
            "assigner": "psirt@cisco.com",
            "status": "Deferred",
            "published": parse_datetime("2017-09-29T01:34:48.747Z", ignoretz=True),
            "modified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "summary": "A vulnerability in the implementation of Network Address Translation (NAT) functionality in Cisco IOS 12.4 through 15.6 could allow an unauthenticated, remote attacker to cause a denial of service (DoS) condition on an affected device. The vulnerability is due to the improper translation of H.323 messages that use the Registration, Admission, and Status (RAS) protocol and are sent to an affected device via IPv4 packets. An attacker could exploit this vulnerability by sending a crafted H.323 RAS packet through an affected device. A successful exploit could allow the attacker to cause the affected device to crash and reload, resulting in a DoS condition. This vulnerability affects Cisco devices that are configured to use an application layer gateway with NAT (NAT ALG) for H.323 RAS messages. By default, a NAT ALG is enabled for H.323 RAS messages. Cisco Bug IDs: CSCvc57217.",
            "access": {
                "authentication": "NONE",
                "complexity": "LOW",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "COMPLETE",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "cvss4": None,
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "exploitability3": {
                "attackvector": "NETWORK",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "NONE",
                "scope": "UNCHANGED",
            },
            "cvss3": 7.5,
            "cvss3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
            "impactScore3": 3.6,
            "exploitabilityScore3": 3.9,
            "cvss3Time": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": 7.8,
            "exploitabilityScore": 10,
            "impactScore": 6.9,
            "cvssTime": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvssVector": "AV:N/AC:L/Au:N/C:N/I:N/A:C",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:L/Au:N/C:N/I:N/A:C",
                            "baseScore": 7.8,
                            "authentication": "NONE",
                            "accessComplexity": "LOW",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "COMPLETE",
                        }
                    ]
                },
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "baseScore": 7.5,
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "NONE",
                            "scope": "UNCHANGED",
                        }
                    ]
                },
                "cvss4": {},
            },
            "references": [
                "http://www.securityfocus.com/bid/101039",
                "http://www.securitytracker.com/id/1039449",
                "https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20170927-nat",
                "http://www.securityfocus.com/bid/101039",
                "http://www.securitytracker.com/id/1039449",
                "https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20170927-nat",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:cisco:ios:12.4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(21a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb10:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb11:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb12:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb9:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3h\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3i\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3j\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc1:*:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:cisco:ios:12.4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(21a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb10:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb11:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb12:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb9:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3h\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3i\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3j\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc1:*:*:*:*:*:*:*",
            ],
            "vendors": ["cisco"],
            "products": ["ios"],
            "vulnerable_product_stems": ["cpe:2.3:o:cisco:ios"],
            "vulnerable_configuration_stems": [
                "cpe:2.3:o:cisco:ios",
                "cpe:2.3:h:cisco:1100-4g\\/6g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4gltegb_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4gltena_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4p_integrated_services_router",
                "cpe:2.3:h:cisco:1100-6g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-8p_integrated_services_router",
                "cpe:2.3:h:cisco:1100-lte_integrated_services_router",
                "cpe:2.3:h:cisco:1100_integrated_services_router",
                "cpe:2.3:h:cisco:1100_terminal_services_gateways",
                "cpe:2.3:h:cisco:1101-4p_integrated_services_router",
                "cpe:2.3:h:cisco:1101_integrated_services_router",
                "cpe:2.3:h:cisco:1109-2p_integrated_services_router",
                "cpe:2.3:h:cisco:1109-4p_integrated_services_router",
                "cpe:2.3:h:cisco:1109_integrated_services_router",
                "cpe:2.3:h:cisco:1111x-8p_integrated_services_router",
                "cpe:2.3:h:cisco:111x_integrated_services_router",
                "cpe:2.3:h:cisco:1120_integrated_services_router",
                "cpe:2.3:h:cisco:1131_integrated_services_router",
                "cpe:2.3:h:cisco:1160_integrated_services_router",
                "cpe:2.3:h:cisco:1801_integrated_service_router",
                "cpe:2.3:h:cisco:1802_integrated_service_router",
                "cpe:2.3:h:cisco:1803_integrated_service_router",
                "cpe:2.3:h:cisco:1811_integrated_service_router",
                "cpe:2.3:h:cisco:1812_integrated_service_router",
                "cpe:2.3:h:cisco:1841_integrated_service_router",
                "cpe:2.3:h:cisco:1861_integrated_service_router",
                "cpe:2.3:h:cisco:1905_integrated_services_router",
                "cpe:2.3:h:cisco:1906c_integrated_services_router",
                "cpe:2.3:h:cisco:1921_integrated_services_router",
                "cpe:2.3:h:cisco:1941_integrated_services_router",
                "cpe:2.3:h:cisco:1941w_integrated_services_router",
                "cpe:2.3:h:cisco:4000_integrated_services_router",
                "cpe:2.3:h:cisco:4221_integrated_services_router",
                "cpe:2.3:h:cisco:8101-32fh",
                "cpe:2.3:h:cisco:8101-32h",
                "cpe:2.3:h:cisco:8102-64h",
                "cpe:2.3:h:cisco:8201",
                "cpe:2.3:h:cisco:8201-32fh",
                "cpe:2.3:h:cisco:8202",
                "cpe:2.3:h:cisco:8208",
                "cpe:2.3:h:cisco:8212",
                "cpe:2.3:h:cisco:8218",
                "cpe:2.3:h:cisco:8800_12-slot",
                "cpe:2.3:h:cisco:8800_18-slot",
                "cpe:2.3:h:cisco:8800_4-slot",
                "cpe:2.3:h:cisco:8800_8-slot",
                "cpe:2.3:h:cisco:8804",
                "cpe:2.3:h:cisco:8808",
                "cpe:2.3:h:cisco:8812",
                "cpe:2.3:h:cisco:8818",
                "cpe:2.3:h:cisco:9800-40",
                "cpe:2.3:h:cisco:9800-80",
                "cpe:2.3:h:cisco:9800-cl",
                "cpe:2.3:h:cisco:9800-l",
                "cpe:2.3:h:cisco:asr_1000",
                "cpe:2.3:h:cisco:asr_1000-esp100",
                "cpe:2.3:h:cisco:asr_1000-esp100-x",
                "cpe:2.3:h:cisco:asr_1000-esp200-x",
                "cpe:2.3:h:cisco:asr_1001",
                "cpe:2.3:h:cisco:asr_1001-hx",
                "cpe:2.3:h:cisco:asr_1001-hx_r",
                "cpe:2.3:h:cisco:asr_1001-x",
                "cpe:2.3:h:cisco:asr_1001-x_r",
                "cpe:2.3:h:cisco:asr_1002-hx",
                "cpe:2.3:h:cisco:asr_1002-hx_r",
                "cpe:2.3:h:cisco:asr_1002-x",
                "cpe:2.3:h:cisco:asr_1002-x_r",
                "cpe:2.3:h:cisco:asr_1002_fixed_router",
                "cpe:2.3:h:cisco:asr_1004",
                "cpe:2.3:h:cisco:asr_1006",
                "cpe:2.3:h:cisco:asr_1006-x",
                "cpe:2.3:h:cisco:asr_1009-x",
                "cpe:2.3:h:cisco:asr_1013",
                "cpe:2.3:h:cisco:asr_1023",
                "cpe:2.3:h:cisco:asr_900",
                "cpe:2.3:h:cisco:asr_9000",
                "cpe:2.3:h:cisco:asr_9000v",
                "cpe:2.3:h:cisco:asr_9001",
                "cpe:2.3:h:cisco:asr_9006",
                "cpe:2.3:h:cisco:asr_901-12c-f-d",
                "cpe:2.3:h:cisco:asr_901-12c-ft-d",
                "cpe:2.3:h:cisco:asr_901-4c-f-d",
                "cpe:2.3:h:cisco:asr_901-4c-ft-d",
                "cpe:2.3:h:cisco:asr_901-6cz-f-a",
                "cpe:2.3:h:cisco:asr_901-6cz-f-d",
                "cpe:2.3:h:cisco:asr_901-6cz-fs-a",
                "cpe:2.3:h:cisco:asr_901-6cz-fs-d",
                "cpe:2.3:h:cisco:asr_901-6cz-ft-a",
                "cpe:2.3:h:cisco:asr_901-6cz-ft-d",
                "cpe:2.3:h:cisco:asr_9010",
                "cpe:2.3:h:cisco:asr_901s-2sg-f-ah",
                "cpe:2.3:h:cisco:asr_901s-2sg-f-d",
                "cpe:2.3:h:cisco:asr_901s-3sg-f-ah",
                "cpe:2.3:h:cisco:asr_901s-3sg-f-d",
                "cpe:2.3:h:cisco:asr_901s-4sg-f-d",
                "cpe:2.3:h:cisco:asr_902",
                "cpe:2.3:h:cisco:asr_902u",
                "cpe:2.3:h:cisco:asr_903",
            ],
            "configurations": [
                {
                    "operator": "AND",
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:cisco:ios:*:*:*:*:*:*:*:*",
                                    "versionStartIncluding": "12.4",
                                    "versionEndIncluding": "15.6",
                                    "matchCriteriaId": "3AE09220-EF68-4DFE-AA9C-E4F5508EDF3D",
                                }
                            ],
                        },
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4g\\/6g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A6F668B9-2C1D-4306-8286-35E67D0F67C7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "0F77CD6A-83DA-4F31-A128-AD6DAECD623B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4gltegb_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "62564BB8-1282-4597-A645-056298BE7CCB",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4gltena_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "80E9CC47-3D7C-437A-85BE-4BB94C8AF1B8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A2D2305B-B69E-4F74-A44E-07B3205CE9F7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-6g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2B68B363-3C57-4E95-8B13-0F9B59D551F7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-8p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "26DD41B3-1D1D-44D3-BA8E-5A66AFEE77E6",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-lte_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "EBE4E146-1D77-4F15-AE58-3C1CE5DB62C5",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "1952B64C-4AE0-4CCB-86C5-8D1FF6A12822",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100_terminal_services_gateways:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F9A4ED65-7DED-4EAD-BF37-FCA71E807CA1",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1101-4p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "5AAD4397-6DCF-493A-BD61-3A890F6F3AB2",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1101_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "5EB8A757-7888-4AC2-BE44-B89DB83C6C77",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1109-2p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3F2F0A8E-97F6-41AC-BE67-4B2D60F9D36B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1109-4p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "BB9229F3-7BCE-46C4-9879-D57B5BAAE44E",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1109_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B80890A8-E3D3-462C-B125-9E9BC6525B02",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1111x-8p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A5A606FE-E6F1-43F9-B1CD-D9DF35FC3573",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:111x_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "802CBFC1-8A2F-4BF7-A1D3-00622C33BE16",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1120_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7AFE0FC1-EEBC-42F0-88B0-4AF5B76DDD97",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1131_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F3F374DC-B9F7-4515-A064-01BB436CA984",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1160_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D916389F-54DB-44CB-91DD-7CE3C7059350",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1801_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6D5E48D7-2266-4649-90A9-62C476AFE6DE",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1802_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "99581637-E184-4A02-8313-57C7C31E5479",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1803_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9C6D4A90-31B9-4B6C-ADAC-44C49DB44115",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1811_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B3AF3F75-0BD8-4AA6-B696-3624BEE86681",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1812_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6C58CEA6-69F8-4021-98C9-4676C70AB167",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1841_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "DF156D97-7C39-49CF-9938-D9681066FF05",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1861_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "459FEB4E-54E3-4FE5-82A5-6E4ECE855DD6",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1905_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "871AC0F6-5C01-43A1-8436-7885439BD81F",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1906c_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B1DEFFA8-11A6-43CC-A886-DD38EFF22ACB",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1921_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2147DBF8-B733-4F76-90C5-9D94F1E93625",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1941_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6F42D5B4-BB07-4C9C-852F-0D839E9F2AA7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1941w_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9222CA59-F4FD-478D-83C9-566B389140B8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:4000_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CE82335E-ECEC-47BD-BC4A-5FDEA08D1A18",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:4221_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6C8AED7C-DDA3-4C29-BB95-6518C02C551A",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8101-32fh:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E055F58F-F9FB-4B27-841E-61ECAB5F42B8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8101-32h:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2B832863-E366-46ED-BC35-838762F0CE29",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8102-64h:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A3C3DDAC-7D0F-4D1D-9632-F001F2EB5D34",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8201:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3D8E7FFF-82A8-4ECB-BA0C-CBF0C2FDA3A3",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8201-32fh:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "528BE0D3-E5ED-4836-B0D8-0C8508C5BDD7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8202:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "87DC4C2F-01C5-4D89-8D79-E5D28EDAD0F2",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8208:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A34DAD43-0C95-4830-8078-EFE3E6C0A930",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8212:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "46F5CBF0-7F55-44C0-B321-896BDBA22679",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8218:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D381E343-416F-42AF-A780-D330954F238F",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8800_12-slot:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "4B4318C0-0FD0-46B3-8E23-94EC53A34A20",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8800_18-slot:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "16FC6220-78E1-44A6-A596-6368D3EF7CC4",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8800_4-slot:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "DCAEDE0A-E6F9-4727-8DC2-F47579220BE0",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8800_8-slot:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8E289FAD-04F0-4E3A-BC4D-8E5116F01AF0",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8804:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6655851F-58D9-49D9-A56E-8440A7F7BB45",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8808:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F5E2AE67-DED3-4414-A194-386ADB2C8DC7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8812:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3920133A-684D-4A9F-B65A-FF4EAE5052E5",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:8818:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9ED06361-5A68-4656-AEA5-240C290594CD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:9800-40:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "C2C3816C-95F4-443C-9C79-72F0251528F4",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:9800-80:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E1810C73-93B8-4EB5-85FC-3585AD5256BA",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:9800-cl:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CE2BC76E-A166-4E71-B058-F49FF84A9E19",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:9800-l:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "542244A0-300C-4630-812A-BF45F61E38DD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1000:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "91209C16-A620-44A0-9134-8AA456343F29",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1000-esp100:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3C5C1005-0C12-4EDA-BC4A-B52201C4F516",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1000-esp100-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "917B52DF-4210-4DD6-97EF-8A033497A954",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1000-esp200-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D7F413FB-D4F9-4113-9D67-2956BF1DC30D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1001:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "ED7C321E-F083-4AB6-96A0-D6358980441E",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1001-hx:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7594E307-AC80-41EC-AE94-07E664A7D701",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1001-hx_r:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "33208B25-0CBB-4E31-A892-60B7B5625155",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1001-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "09C913FF-63D5-43FB-8B39-598EF436BA5A",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1001-x_r:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "241EEBD9-76E4-4AE6-96B8-1C1ACD834F17",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1002-hx:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CD2794BD-C8CE-46EF-9857-1723FCF04E46",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1002-hx_r:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CC03A84F-C8F2-4225-9A00-8FA35368CD57",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1002-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "444F688F-79D0-4F22-B530-7BD520080B8F",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1002-x_r:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "51F2A755-556C-4C5E-8622-96D124319AF7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1002_fixed_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "0EAE214D-8DD8-4DA3-872A-609E7CE6E606",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1004:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "55DD2272-10C2-43B9-9F13-6DC41DBE179B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1006:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7428E0A8-1641-47FB-9CA9-34311DEF660D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1006-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "DE7401B7-094C-46EB-9869-2F0372E8B26B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1009-x:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8D8A72FD-D8B0-45B5-8FAD-6D8395BB218A",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1013:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "854D9594-FE84-4E7B-BA21-A3287F2DC302",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_1023:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "C81CC6E3-B989-4730-820E-46734E3E608D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_900:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "EA873342-542E-4FC8-9C22-B5A43F9F3E9D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9000:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3FEF8271-315F-4756-931F-015F790BE693",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9000v:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "71BD158E-71D8-4DCA-8C09-F8AB7EF0EBDD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9001:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "324C97E6-1810-404F-9F45-6240F99FF039",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9006:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "57EB55BB-41B7-40A1-B6F5-142FE8AB4C16",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-12c-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D6279A69-2F9D-4CD9-9C19-62E701C3C4F9",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-12c-ft-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A46BB1E3-D813-4C19-81FA-96B8EF3E2F7B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-4c-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "64E9CCC6-CA54-44C4-9A41-D2CA3A25BE8C",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-4c-ft-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "BC4E0CC8-9C67-4EB0-97A1-BAEFC6E9708A",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-f-a:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "DDB1A95C-8513-4CC7-8CDF-012B212FF02F",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "AE761B1C-D749-4E1B-9A4A-7F41D1DF9C8C",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-fs-a:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "97B64B28-7F3F-40BC-B289-0D1DB55B6461",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-fs-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F5603296-34B3-4EEB-B242-C44BC56BFBB8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-ft-a:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6C2A515C-797D-47EE-8051-F3FBE417BCE9",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901-6cz-ft-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E673A75F-EFF8-4591-8E0F-A21083563DBA",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9010:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "433F4A82-04A4-4EAA-8C19-F7581DCD8D29",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_9010:-:*:*:*:*:*:-:*",
                                    "matchCriteriaId": "A50A1CA4-F928-4787-ADB4-0274301B7EF6",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901s-2sg-f-ah:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E5456C70-6BA4-456A-BCFA-06FD052E44EF",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901s-2sg-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "515CD97F-DDBD-4F75-A6DB-646890A30B32",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901s-3sg-f-ah:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6E181FC9-6790-4C12-874F-67252B6879BA",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901s-3sg-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "CAD4F12D-3F97-44D2-9DE2-571425E75F4E",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_901s-4sg-f-d:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "FB1288DB-5946-4091-A6E8-42E0A0E7B2B9",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_902:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "70352B04-C3FD-47F5-A2F8-691CF63EB50D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_902u:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "FE063AF2-5579-4D7E-8829-9102FC7CB994",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:asr_903:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "51938C0A-AFDB-4B12-BB64-9C67FC0C738F",
                                },
                            ],
                        },
                    ],
                }
            ],
            "cwe": ["CWE-399"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.1085",
            "epssMetric": {
                "percentile": "0.93121",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2017-12233",
            "assigner": "psirt@cisco.com",
            "status": "Deferred",
            "published": parse_datetime("2017-09-29T01:34:48.827Z", ignoretz=True),
            "modified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "summary": "Multiple vulnerabilities in the implementation of the Common Industrial Protocol (CIP) feature in Cisco IOS 12.4 through 15.6 could allow an unauthenticated, remote attacker to cause an affected device to reload, resulting in a denial of service (DoS) condition. The vulnerabilities are due to the improper parsing of crafted CIP packets destined to an affected device. An attacker could exploit these vulnerabilities by sending crafted CIP packets to be processed by an affected device. A successful exploit could allow the attacker to cause the affected device to reload, resulting in a DoS condition. Cisco Bug IDs: CSCuz95334.",
            "access": {
                "authentication": "NONE",
                "complexity": "LOW",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "COMPLETE",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "cvss4": None,
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "exploitability3": {
                "attackvector": "NETWORK",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "NONE",
                "scope": "UNCHANGED",
            },
            "cvss3": 7.5,
            "cvss3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
            "impactScore3": 3.6,
            "exploitabilityScore3": 3.9,
            "cvss3Time": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": 7.8,
            "exploitabilityScore": 10,
            "impactScore": 6.9,
            "cvssTime": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvssVector": "AV:N/AC:L/Au:N/C:N/I:N/A:C",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:L/Au:N/C:N/I:N/A:C",
                            "baseScore": 7.8,
                            "authentication": "NONE",
                            "accessComplexity": "LOW",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "COMPLETE",
                        }
                    ]
                },
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H",
                            "baseScore": 7.5,
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "NONE",
                            "scope": "UNCHANGED",
                        }
                    ]
                },
                "cvss4": {},
            },
            "references": [
                "http://www.securityfocus.com/bid/101038",
                "http://www.securitytracker.com/id/1039459",
                "https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20170927-cip",
                "http://www.securityfocus.com/bid/101038",
                "http://www.securitytracker.com/id/1039459",
                "https://tools.cisco.com/security/center/content/CiscoSecurityAdvisory/cisco-sa-20170927-cip",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:cisco:ios:12.4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(21a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb10:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb11:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb12:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb9:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3h\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3i\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3j\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc1:*:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:cisco:ios:12.4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(10c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(12c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(13f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(16b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(17b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(18e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(19b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(1c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(21a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(23e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(25g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xa2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb10:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb11:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb12:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(2\\)xb9:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3a\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3b\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3c\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3d\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3e\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3f\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3g\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3h\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3i\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3j\\):*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jk4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(3\\)jl3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t2:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t3:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t4:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t5:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t6:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t7:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)t8:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)mr1:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc:*:*:*:*:*:*:*",
                "cpe:2.3:o:cisco:ios:12.4\\(4\\)xc1:*:*:*:*:*:*:*",
            ],
            "vendors": ["cisco"],
            "products": ["ios"],
            "vulnerable_product_stems": ["cpe:2.3:o:cisco:ios"],
            "vulnerable_configuration_stems": [
                "cpe:2.3:o:cisco:ios",
                "cpe:2.3:h:cisco:1000_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4g\\/6g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4gltegb_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4gltena_integrated_services_router",
                "cpe:2.3:h:cisco:1100-4p",
                "cpe:2.3:h:cisco:1100-4p_integrated_services_router",
                "cpe:2.3:h:cisco:1100-6g_integrated_services_router",
                "cpe:2.3:h:cisco:1100-8p",
                "cpe:2.3:h:cisco:1100-8p_integrated_services_router",
                "cpe:2.3:h:cisco:1100-lte_integrated_services_router",
                "cpe:2.3:h:cisco:1100_integrated_services_router",
                "cpe:2.3:h:cisco:1100_terminal_services_gateways",
                "cpe:2.3:h:cisco:1101-4p",
                "cpe:2.3:h:cisco:1101-4p_integrated_services_router",
                "cpe:2.3:h:cisco:1101_integrated_services_router",
                "cpe:2.3:h:cisco:1109-2p",
                "cpe:2.3:h:cisco:1109-4p",
                "cpe:2.3:h:cisco:1111-4pwe",
                "cpe:2.3:h:cisco:1111-8pwb",
                "cpe:2.3:h:cisco:1111x-8p",
                "cpe:2.3:h:cisco:1113-8plteeawe",
                "cpe:2.3:h:cisco:1113-8pmwe",
                "cpe:2.3:h:cisco:1113-8pwe",
                "cpe:2.3:h:cisco:1116-4plteeawe",
                "cpe:2.3:h:cisco:1116-4pwe",
                "cpe:2.3:h:cisco:1117-4plteeawe",
                "cpe:2.3:h:cisco:1117-4pmlteeawe",
                "cpe:2.3:h:cisco:1117-4pmwe",
                "cpe:2.3:h:cisco:1117-4pwe",
                "cpe:2.3:h:cisco:1120",
                "cpe:2.3:h:cisco:1120_connected_grid_router",
                "cpe:2.3:h:cisco:1120_integrated_services_router",
                "cpe:2.3:h:cisco:1131_integrated_services_router",
                "cpe:2.3:h:cisco:1160_integrated_services_router",
                "cpe:2.3:h:cisco:1801_integrated_service_router",
                "cpe:2.3:h:cisco:1802_integrated_service_router",
                "cpe:2.3:h:cisco:1803_integrated_service_router",
                "cpe:2.3:h:cisco:1811_integrated_service_router",
                "cpe:2.3:h:cisco:1812_integrated_service_router",
                "cpe:2.3:h:cisco:1841_integrated_service_router",
                "cpe:2.3:h:cisco:1861_integrated_service_router",
                "cpe:2.3:h:cisco:1905_integrated_services_router",
                "cpe:2.3:h:cisco:1906c_integrated_services_router",
                "cpe:2.3:h:cisco:1921_integrated_services_router",
                "cpe:2.3:h:cisco:1941_integrated_services_router",
                "cpe:2.3:h:cisco:1941w_integrated_services_router",
                "cpe:2.3:h:cisco:catalyst_ie3200_rugged_switch",
                "cpe:2.3:h:cisco:catalyst_ie3300_rugged_switch",
                "cpe:2.3:h:cisco:catalyst_ie3400_heavy_duty_switch",
                "cpe:2.3:h:cisco:catalyst_ie3400_rugged_switch",
                "cpe:2.3:h:cisco:catalyst_ie9300",
                "cpe:2.3:h:cisco:esr-6300-con-k9",
                "cpe:2.3:h:cisco:esr-6300-ncp-k9",
            ],
            "configurations": [
                {
                    "operator": "AND",
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:cisco:ios:*:*:*:*:*:*:*:*",
                                    "versionStartIncluding": "12.4",
                                    "versionEndIncluding": "15.6",
                                    "matchCriteriaId": "3AE09220-EF68-4DFE-AA9C-E4F5508EDF3D",
                                }
                            ],
                        },
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1000_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F4856E07-B3C2-4674-9584-866F6AF643B2",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4g\\/6g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A6F668B9-2C1D-4306-8286-35E67D0F67C7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "0F77CD6A-83DA-4F31-A128-AD6DAECD623B",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4gltegb_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "62564BB8-1282-4597-A645-056298BE7CCB",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4gltena_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "80E9CC47-3D7C-437A-85BE-4BB94C8AF1B8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "AA8D5057-138A-42C4-BA35-8077A0A60068",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-4p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "A2D2305B-B69E-4F74-A44E-07B3205CE9F7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-6g_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2B68B363-3C57-4E95-8B13-0F9B59D551F7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-8p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "ED555B12-41F4-4D62-B519-22601FB7AF8D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-8p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "26DD41B3-1D1D-44D3-BA8E-5A66AFEE77E6",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100-lte_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "EBE4E146-1D77-4F15-AE58-3C1CE5DB62C5",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "1952B64C-4AE0-4CCB-86C5-8D1FF6A12822",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1100_terminal_services_gateways:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F9A4ED65-7DED-4EAD-BF37-FCA71E807CA1",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1101-4p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "21B10158-5235-483E-BACD-C407609EA6BE",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1101-4p_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "5AAD4397-6DCF-493A-BD61-3A890F6F3AB2",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1101_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "5EB8A757-7888-4AC2-BE44-B89DB83C6C77",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1109-2p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8964F9BA-6E6C-44BF-9A8C-93D081B6678C",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1109-4p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "51251FE1-67D2-4903-B7D3-E0C727B9A93C",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1111-4pwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7262ADAB-296F-4DC2-9CD7-A86D7F6441C8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1111-8pwb:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "E3056B31-1977-4472-BC74-19A5B8B5EC44",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1111x-8p:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "784E4562-FE26-4049-9D23-4CA46432EE14",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1113-8plteeawe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9261A638-E2E4-4EF0-84E9-A585BF763263",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1113-8pmwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8C85463D-0B37-4746-B7EA-80F3096305E7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1113-8pwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "58C04E5B-AC03-440F-9007-0D6761B41F68",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1116-4plteeawe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "29A5E963-2987-4927-862A-6375624FC876",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1116-4pwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "3601499F-AD3B-47EA-816A-A01379CA1A33",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1117-4plteeawe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "303129EF-9107-4B39-8683-1BD917B3E68D",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1117-4pmlteeawe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "76B2B271-555B-4439-95D8-086E516F1169",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1117-4pmwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6CB321CD-9096-4F75-AD2F-4EAE1CA75D76",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1117-4pwe:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "98F31C77-0303-4FD9-B968-6B430202C6AD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1120:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D2D64BDE-0D00-4FBE-873B-F5D52AD0C5A2",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1120_connected_grid_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6835F8AD-B55D-4B57-B3B5-0095E309B2B3",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1120_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "7AFE0FC1-EEBC-42F0-88B0-4AF5B76DDD97",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1131_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "F3F374DC-B9F7-4515-A064-01BB436CA984",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1160_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "D916389F-54DB-44CB-91DD-7CE3C7059350",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1801_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6D5E48D7-2266-4649-90A9-62C476AFE6DE",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1802_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "99581637-E184-4A02-8313-57C7C31E5479",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1803_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9C6D4A90-31B9-4B6C-ADAC-44C49DB44115",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1811_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B3AF3F75-0BD8-4AA6-B696-3624BEE86681",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1812_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6C58CEA6-69F8-4021-98C9-4676C70AB167",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1841_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "DF156D97-7C39-49CF-9938-D9681066FF05",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1861_integrated_service_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "459FEB4E-54E3-4FE5-82A5-6E4ECE855DD6",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1905_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "871AC0F6-5C01-43A1-8436-7885439BD81F",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1906c_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B1DEFFA8-11A6-43CC-A886-DD38EFF22ACB",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1921_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2147DBF8-B733-4F76-90C5-9D94F1E93625",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1941_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "6F42D5B4-BB07-4C9C-852F-0D839E9F2AA7",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:1941w_integrated_services_router:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9222CA59-F4FD-478D-83C9-566B389140B8",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:catalyst_ie3200_rugged_switch:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "86879AC0-890E-42F4-9561-6851F38FE0AD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:catalyst_ie3300_rugged_switch:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "19017B10-F630-42CD-ACD2-E817FEF0E7F1",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:catalyst_ie3400_heavy_duty_switch:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "04A41A34-58D2-4DBC-ABC9-20A62BC8A838",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:catalyst_ie3400_rugged_switch:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "9C7CCC02-113E-4EA1-B0CA-9FDF1108BB71",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:catalyst_ie9300:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "8DF0025D-8DE1-437D-9A4E-72C3AC6B46CD",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:esr-6300-con-k9:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "B5E69A6F-DFC0-4C8A-B77F-B7329FA5F567",
                                },
                                {
                                    "vulnerable": False,
                                    "criteria": "cpe:2.3:h:cisco:esr-6300-ncp-k9:-:*:*:*:*:*:*:*",
                                    "matchCriteriaId": "2BA015C4-7163-4FCD-ADE1-D5481B10EACA",
                                },
                            ],
                        },
                    ],
                }
            ],
            "cwe": ["CWE-20"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.10011",
            "epssMetric": {
                "percentile": "0.92786",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2017-0123",
            "assigner": "secure@microsoft.com",
            "status": "Deferred",
            "published": parse_datetime("2017-03-17T00:59:03.417Z", ignoretz=True),
            "modified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "summary": 'Uniscribe in Microsoft Windows Vista SP2, Windows Server 2008 SP2 and R2 SP1, and Windows 7 SP1 allows remote attackers to obtain sensitive information from process memory via a crafted web site, aka "Uniscribe Information Disclosure Vulnerability." CVE-2017-0085, CVE-2017-0091, CVE-2017-0092, CVE-2017-0111, CVE-2017-0112, CVE-2017-0113, CVE-2017-0114, CVE-2017-0115, CVE-2017-0116, CVE-2017-0117, CVE-2017-0118, CVE-2017-0119, CVE-2017-0120, CVE-2017-0121, CVE-2017-0122, CVE-2017-0124, CVE-2017-0125, CVE-2017-0126, CVE-2017-0127, and CVE-2017-0128.',
            "access": {
                "authentication": "NONE",
                "complexity": "MEDIUM",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "NONE",
                "confidentiality": "PARTIAL",
                "integrity": "NONE",
            },
            "cvss4": None,
            "impact3": {
                "availability": "NONE",
                "confidentiality": "LOW",
                "integrity": "NONE",
            },
            "exploitability3": {
                "attackvector": "NETWORK",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "REQUIRED",
                "scope": "UNCHANGED",
            },
            "cvss3": 4.3,
            "impactScore3": 1.4,
            "exploitabilityScore3": 2.8,
            "cvss3Time": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": 4.3,
            "exploitabilityScore": 8.6,
            "impactScore": 2.9,
            "cvssTime": parse_datetime("2025-04-20T01:37:25.860Z", ignoretz=True),
            "cvssVector": "AV:N/AC:M/Au:N/C:P/I:N/A:N",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:M/Au:N/C:P/I:N/A:N",
                            "baseScore": 4.3,
                            "authentication": "NONE",
                            "accessComplexity": "MEDIUM",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "PARTIAL",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "NONE",
                        }
                    ]
                },
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.0/AV:N/AC:L/PR:N/UI:R/S:U/C:L/I:N/A:N",
                            "baseScore": 4.3,
                            "confidentialityImpact": "LOW",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "NONE",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "REQUIRED",
                            "scope": "UNCHANGED",
                        }
                    ]
                },
                "cvss4": {},
            },
            "references": [
                "http://www.securityfocus.com/bid/96669",
                "http://www.securitytracker.com/id/1037992",
                "https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2017-0123",
                "https://www.exploit-db.com/exploits/41655/",
                "http://www.securityfocus.com/bid/96669",
                "http://www.securitytracker.com/id/1037992",
                "https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2017-0123",
                "https://www.exploit-db.com/exploits/41655/",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:o:microsoft:windows_7:*:sp1:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2008:*:sp2:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2008:r2:sp1:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_vista:*:sp2:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:o:microsoft:windows_7:*:sp1:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2008:*:sp2:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_server_2008:r2:sp1:*:*:*:*:*:*",
                "cpe:2.3:o:microsoft:windows_vista:*:sp2:*:*:*:*:*:*",
            ],
            "vendors": ["microsoft"],
            "products": ["windows_7", "windows_server_2008", "windows_vista"],
            "vulnerable_product_stems": [
                "cpe:2.3:o:microsoft:windows_7",
                "cpe:2.3:o:microsoft:windows_server_2008",
                "cpe:2.3:o:microsoft:windows_vista",
            ],
            "vulnerable_configuration_stems": [
                "cpe:2.3:o:microsoft:windows_7",
                "cpe:2.3:o:microsoft:windows_server_2008",
                "cpe:2.3:o:microsoft:windows_vista",
            ],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_7:*:sp1:*:*:*:*:*:*",
                                    "matchCriteriaId": "7519928D-0FF2-4584-8058-4C7764CD5671",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_server_2008:*:sp2:*:*:*:*:*:*",
                                    "matchCriteriaId": "0C28897B-044A-447B-AD76-6397F8190177",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_server_2008:r2:sp1:*:*:*:*:*:*",
                                    "matchCriteriaId": "2ACA9287-B475-4AF7-A4DA-A7143CEF9E57",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:o:microsoft:windows_vista:*:sp2:*:*:*:*:*:*",
                                    "matchCriteriaId": "0A0D2704-C058-420B-B368-372D1129E914",
                                },
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-200"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.1081",
            "epssMetric": {
                "percentile": "0.93101",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2013-0270",
            "assigner": "secalert@redhat.com",
            "status": "Deferred",
            "published": parse_datetime("2013-04-12T22:55:01.070Z", ignoretz=True),
            "modified": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "lastModified": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "summary": "OpenStack Keystone Grizzly before 2013.1, Folsom, and possibly earlier allows remote attackers to cause a denial of service (CPU and memory consumption) via a large HTTP request, as demonstrated by a long tenant_name when requesting a token.",
            "access": {
                "authentication": "NONE",
                "complexity": "LOW",
                "vector": "NETWORK",
            },
            "impact": {
                "availability": "PARTIAL",
                "confidentiality": "NONE",
                "integrity": "NONE",
            },
            "cvss4": None,
            "cvss3": None,
            "cvss": 5,
            "exploitabilityScore": 10,
            "impactScore": 2.9,
            "cvssTime": parse_datetime("2025-04-11T00:51:21.963Z", ignoretz=True),
            "cvssVector": "AV:N/AC:L/Au:N/C:N/I:N/A:P",
            "cvssType": "Primary",
            "cvssSource": "nvd@nist.gov",
            "cvss_data": {
                "cvss2": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "AV:N/AC:L/Au:N/C:N/I:N/A:P",
                            "baseScore": 5,
                            "authentication": "NONE",
                            "accessComplexity": "LOW",
                            "accessVector": "NETWORK",
                            "confidentialityImpact": "NONE",
                            "integrityImpact": "NONE",
                            "availabilityImpact": "PARTIAL",
                        }
                    ]
                },
                "cvss3": {},
                "cvss4": {},
            },
            "references": [
                "http://rhn.redhat.com/errata/RHSA-2013-0708.html",
                "https://bugs.launchpad.net/keystone/+bug/1099025",
                "https://bugzilla.redhat.com/show_bug.cgi?id=909012",
                "https://github.com/openstack/keystone/commit/7691276b869a86c2b75631d5bede9f61e030d9d8",
                "https://github.com/openstack/keystone/commit/82c87e5638ebaf9f166a9b07a0155291276d6fdc",
                "https://launchpad.net/keystone/grizzly/2013.1",
                "http://rhn.redhat.com/errata/RHSA-2013-0708.html",
                "https://bugs.launchpad.net/keystone/+bug/1099025",
                "https://bugzilla.redhat.com/show_bug.cgi?id=909012",
                "https://github.com/openstack/keystone/commit/7691276b869a86c2b75631d5bede9f61e030d9d8",
                "https://github.com/openstack/keystone/commit/82c87e5638ebaf9f166a9b07a0155291276d6fdc",
                "https://launchpad.net/keystone/grizzly/2013.1",
            ],
            "vulnerable_configuration": [
                "cpe:2.3:a:openstack:keystone:2012.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.3:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.3:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.4:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone1:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone2:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone3:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:a:openstack:keystone:2012.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.1.3:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.2:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.3:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2012.2.4:*:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone1:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone2:*:*:*:*:*:*",
                "cpe:2.3:a:openstack:keystone:2013.1:milestone3:*:*:*:*:*:*",
            ],
            "vendors": ["openstack"],
            "products": ["keystone"],
            "vulnerable_product_stems": ["cpe:2.3:a:openstack:keystone"],
            "vulnerable_configuration_stems": ["cpe:2.3:a:openstack:keystone"],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:openstack:keystone:*:*:*:*:*:*:*:*",
                                    "versionStartIncluding": "2012.1",
                                    "versionEndIncluding": "2012.1.3",
                                    "matchCriteriaId": "AE76C61F-B954-4861-9FA8-56D80F6E4DC4",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:openstack:keystone:*:*:*:*:*:*:*:*",
                                    "versionStartIncluding": "2012.2",
                                    "versionEndIncluding": "2012.2.4",
                                    "matchCriteriaId": "95213D95-6636-4265-A68D-F5B990E95E0C",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:openstack:keystone:2013.1:milestone1:*:*:*:*:*:*",
                                    "matchCriteriaId": "BFA7239D-3977-48E8-913A-1BEF326765BB",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:openstack:keystone:2013.1:milestone2:*:*:*:*:*:*",
                                    "matchCriteriaId": "80E947C9-3BB0-4143-8039-BFC97F0E9327",
                                },
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:openstack:keystone:2013.1:milestone3:*:*:*:*:*:*",
                                    "matchCriteriaId": "D98E4B2C-CA20-4803-BE45-5DDE2D7068B3",
                                },
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-119"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.01809",
            "epssMetric": {
                "percentile": "0.82133",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
        {
            "id": "CVE-2025-26606",
            "assigner": "security-advisories@github.com",
            "status": "Analyzed",
            "published": parse_datetime("2025-02-18T21:15:28.583Z", ignoretz=True),
            "modified": parse_datetime("2025-02-28T19:24:45.760Z", ignoretz=True),
            "lastModified": parse_datetime("2025-02-28T19:24:45.760Z", ignoretz=True),
            "summary": "WeGIA is an open source Web Manager for Institutions with a focus on Portuguese language users. A SQL Injection vulnerability was discovered in the WeGIA application, `informacao_adicional.php` endpoint. This vulnerability could allow an attacker to execute arbitrary SQL queries, allowing unauthorized access to sensitive information. This issue has been addressed in version 3.2.13 and all users are advised to upgrade. There are no known workarounds for this vulnerability.",
            "access": {},
            "impact": {},
            "impact4": {
                "vulnerable_system_confidentiality": "HIGH",
                "vulnerable_system_integrity": "HIGH",
                "vulnerable_system_availability": "HIGH",
                "subsequent_system_confidentiality": "HIGH",
                "subsequent_system_integrity": "HIGH",
                "subsequent_system_availability": "HIGH",
                "attackvector": "NETWORK",
            },
            "exploitability4": {
                "attackcomplexity": "LOW",
                "attackrequirements": "NONE",
                "privilegesrequired": "NONE",
                "userinteraction": "NONE",
                "exploitmaturity": "NOT_DEFINED",
            },
            "cvss4": 10,
            "cvss4Vector": "CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:H/VI:H/VA:H/SC:H/SI:H/SA:H/E:X/CR:X/IR:X/AR:X/MAV:X/MAC:X/MAT:X/MPR:X/MUI:X/MVC:X/MVI:X/MVA:X/MSC:X/MSI:X/MSA:X/S:X/AU:X/R:X/V:X/RE:X/U:X",
            "cvss4Time": parse_datetime("2025-02-28T19:24:45.760Z", ignoretz=True),
            "cvss4Type": "Secondary",
            "cvss4Source": "security-advisories@github.com",
            "impact3": {
                "availability": "HIGH",
                "confidentiality": "HIGH",
                "integrity": "HIGH",
            },
            "exploitability3": {
                "attackvector": "NETWORK",
                "attackcomplexity": "LOW",
                "privilegesrequired": "NONE",
                "userinteraction": "NONE",
                "scope": "UNCHANGED",
            },
            "cvss3": 9.8,
            "cvss3Vector": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H",
            "impactScore3": 5.9,
            "exploitabilityScore3": 3.9,
            "cvss3Time": parse_datetime("2025-02-28T19:24:45.760Z", ignoretz=True),
            "cvss3Type": "Primary",
            "cvss3Source": "nvd@nist.gov",
            "cvss": None,
            "cvss_data": {
                "cvss2": {},
                "cvss3": {
                    "nvd@nist-gov": [
                        {
                            "type": "Primary",
                            "vectorString": "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H",
                            "baseScore": 9.8,
                            "confidentialityImpact": "HIGH",
                            "integrityImpact": "HIGH",
                            "availabilityImpact": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "privilegesRequired": "NONE",
                            "userInteraction": "NONE",
                            "scope": "UNCHANGED",
                        }
                    ]
                },
                "cvss4": {
                    "security-advisories@github-com": [
                        {
                            "type": "Secondary",
                            "vectorString": "CVSS:4.0/AV:N/AC:L/AT:N/PR:N/UI:N/VC:H/VI:H/VA:H/SC:H/SI:H/SA:H/E:X/CR:X/IR:X/AR:X/MAV:X/MAC:X/MAT:X/MPR:X/MUI:X/MVC:X/MVI:X/MVA:X/MSC:X/MSI:X/MSA:X/S:X/AU:X/R:X/V:X/RE:X/U:X",
                            "baseScore": 10,
                            "vulnerable_system_confidentiality": "HIGH",
                            "vulnerable_system_integrity": "HIGH",
                            "vulnerable_system_availability": "HIGH",
                            "subsequent_system_confidentiality": "HIGH",
                            "subsequent_system_integrity": "HIGH",
                            "subsequent_system_availability": "HIGH",
                            "attackVector": "NETWORK",
                            "attackComplexity": "LOW",
                            "attackRequirements": "NONE",
                            "privilegesRequired": "NONE",
                            "userInteraction": "NONE",
                            "exploitMaturity": "NOT_DEFINED",
                        }
                    ]
                },
            },
            "references": [
                "https://github.com/LabRedesCefetRJ/WeGIA/security/advisories/GHSA-rxjr-cw9q-cwwg"
            ],
            "vulnerable_configuration": [
                "cpe:2.3:a:wegia:wegia:0.9.4:beta:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:1.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:2.0:-:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:2.0:beta:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.6:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.7:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.8:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.9:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.10:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.11:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.12:*:*:*:*:*:*:*",
            ],
            "vulnerable_product": [
                "cpe:2.3:a:wegia:wegia:0.9.4:beta:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:1.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:2.0:-:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:2.0:beta:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.1:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.0:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.6:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.7:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.8:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.9:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.10:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.11:*:*:*:*:*:*:*",
                "cpe:2.3:a:wegia:wegia:3.2.12:*:*:*:*:*:*:*",
            ],
            "vendors": ["wegia"],
            "products": ["wegia"],
            "vulnerable_product_stems": ["cpe:2.3:a:wegia:wegia"],
            "vulnerable_configuration_stems": ["cpe:2.3:a:wegia:wegia"],
            "configurations": [
                {
                    "nodes": [
                        {
                            "operator": "OR",
                            "negate": False,
                            "cpeMatch": [
                                {
                                    "vulnerable": True,
                                    "criteria": "cpe:2.3:a:wegia:wegia:*:*:*:*:*:*:*:*",
                                    "versionEndExcluding": "3.2.13",
                                    "matchCriteriaId": "F000C11C-CDF1-4B99-A1F7-11357DF030BF",
                                }
                            ],
                        }
                    ]
                }
            ],
            "cwe": ["CWE-284", "CWE-89"],
            "vulnerable_configuration_cpe_2_2": [],
            "epss": "0.00096",
            "epssMetric": {
                "percentile": "0.27553",
                "lastModified": parse_datetime(
                    "2025-09-04T13:31:03.000Z", ignoretz=True
                ),
            },
        },
    ],
    "cpe": [
        {
            "title": "WordPress Plugin Newsletter plugin 1.5",
            "cpeName": "cpe:2.3:a:wordpress:plugin_newsletter_plugin:1.5:*:*:*:*:*:*:*",
            "vendor": "wordpress",
            "product": "plugin_newsletter_plugin",
            "version": "1.5",
            "padded_version": "00001.00005",
            "stem": "cpe:2.3:a:wordpress:plugin_newsletter_plugin",
            "cpeNameId": "41D3F01E-00C8-4E85-9D81-441EC9131725",
            "lastModified": parse_datetime("2012-08-24T19:57:36.973Z", ignoretz=True),
            "created": parse_datetime("2012-06-20T17:48:00.853Z", ignoretz=True),
            "deprecated": False,
            "deprecatedBy": "",
            "id": "81e939910d5d68f4ca103690634283a45eae3273",
        },
        {
            "title": "Wordpress Slideshow Gallery2 plugin for Wordpress",
            "cpeName": "cpe:2.3:a:wordpress:slideshow_gallery2:-:*:*:*:*:*:*:*",
            "vendor": "wordpress",
            "product": "slideshow_gallery2",
            "version": "-",
            "padded_version": "-",
            "stem": "cpe:2.3:a:wordpress:slideshow_gallery2",
            "cpeNameId": "115B34C6-0E93-4DFB-AC78-87229A808BF0",
            "lastModified": parse_datetime("2012-10-05T18:28:34.473Z", ignoretz=True),
            "created": parse_datetime("2012-10-02T18:08:58.757Z", ignoretz=True),
            "deprecated": False,
            "deprecatedBy": "",
            "id": "22b9e049ea1b888baef0a07c4822c958ae413552",
        },
        {
            "title": "WordPress 2.0.6",
            "cpeName": "cpe:2.3:a:wordpress:wordpress:2.0.6:-:*:*:*:*:*:*",
            "vendor": "wordpress",
            "product": "wordpress",
            "version": "2.0.6",
            "padded_version": "00002.00000.00006",
            "stem": "cpe:2.3:a:wordpress:wordpress",
            "cpeNameId": "9E345661-ED9A-4BCB-900D-7A42D32B8494",
            "lastModified": parse_datetime("2019-06-10T21:28:59.817Z", ignoretz=True),
            "created": parse_datetime("2019-06-10T21:28:59.817Z", ignoretz=True),
            "deprecated": False,
            "deprecatedBy": "",
            "id": "1f1a7d3f9d63f5cdb238ae2d29e5cbd17c7f463f",
        },
        {
            "title": "WordPress 3.9.9",
            "cpeName": "cpe:2.3:a:wordpress:wordpress:3.9.9:*:*:*:*:*:*:*",
            "vendor": "wordpress",
            "product": "wordpress",
            "version": "3.9.9",
            "padded_version": "00003.00009.00009",
            "stem": "cpe:2.3:a:wordpress:wordpress",
            "cpeNameId": "1EB3F45E-F91D-44C5-BD7A-8F297DE41AF6",
            "lastModified": parse_datetime("2018-07-11T14:00:44.777Z", ignoretz=True),
            "created": parse_datetime("2018-07-11T14:00:44.777Z", ignoretz=True),
            "deprecated": False,
            "deprecatedBy": "",
            "id": "ba766d4345b53cb8b682b4cf25e015143fa87c98",
        },
        {
            "title": "WordPress 3.3",
            "cpeName": "cpe:2.3:a:wordpress:wordpress:3.3:-:*:*:*:*:*:*",
            "vendor": "wordpress",
            "product": "wordpress",
            "version": "3.3",
            "padded_version": "00003.00003",
            "stem": "cpe:2.3:a:wordpress:wordpress",
            "cpeNameId": "B084D51E-8B4A-4CBC-B3FD-1FFC806B44DF",
            "lastModified": parse_datetime("2019-06-10T21:29:05.253Z", ignoretz=True),
            "created": parse_datetime("2019-06-10T21:29:05.253Z", ignoretz=True),
            "deprecated": False,
            "deprecatedBy": "",
            "id": "f0b8f6ac6f58b213b9cf112db59fa00b724224d3",
        },
    ],
}
