#!/usr/bin/env python

try:
    from ..core.style import style
    from ..core.config import get_config_value
except ImportError:  # pragma: no cover - legacy script execution
    from core.style import style
    from core.config import get_config_value

import sys
import requests
from termcolor import colored

ENABLED = True
MODULE_NAME = "Domain Github"
REQUIRES = ("github_access_token",)

def github_search(query):
    github_access_token = get_config_value('github_access_token')
    endpoint_git = "https://api.github.com/search/code?q=\"%s\"&access_token=%s" % (query, github_access_token)
    req = requests.get(endpoint_git)
    data = req.json()
    return data.get('total_count'), data.get('items')

def banner():
    return f"Running {MODULE_NAME}"

def main(domain):
    if get_config_value('github_access_token') != None:
        count, results = github_search(domain)
        return [count, results]
    else:
        return [False, "INVALID_API"]

def output(data, domain=""):
    if isinstance(data, list) and not data[0]:
        if data[1] == "INVALID_API":
            print(colored(style.BOLD + '\n[-] Github Access Token not configured, skipping Github Search.\nPlease refer to http://datasploit.readthedocs.io/en/latest/apiGeneration/.\n' + style.END, 'red'))
        else:
            print(colored("Sad! Nothing found on github", 'red'))
    else:
        print(colored("[+] Found %s results on github." % data[0], 'green'))
        if data[0] >= 30:
            print("Top 30 results shown below")
        else:
            print("Top %s results shown below" % data[0])
        count = 1
        for snip in data[1]:
            print("%s. File: %s" % (str(count).zfill(2), snip['html_url']))
            print("    Owner: %s" % snip['repository']['full_name'])
            print("    Repository: %s" % snip['repository']['html_url'])
            count += 1
        print('\nCheck results here: https://github.com/search?q="%s"&type=Code&utf8=%%E2%%9C%%93"' % domain)
        print("-----------------------------\n")

if __name__ == "__main__":
    try:
        domain = sys.argv[1]
        banner()
        result = main(domain)
        if result:
            output(result, domain)
    except Exception as e:
        print(e)
        print("Please provide a domain name as argument")
