# Anteon Security Policy 🐝

We are committed to maintaining the security and integrity of [Anteon](https://github.com/getanteon/anteon), and we appreciate your help in identifying and addressing potential vulnerabilities.

This document outlines the process for reporting security issues, as well as our commitment to addressing them in a timely manner.

## Supported Versions

We provide security updates for the following versions:

| Version    | Supported |
| ---------- | --------- |
| > `0.15.x` | ✅        |

⚠️ Please note that older versions may not receive security updates. We encourage you to use the [latest version](https://github.com/getanteon/anteon/releases) of the software to benefit from the most recent security enhancements.

## Reporting a Vulnerability

If you believe you have discovered a security vulnerability, please follow these steps to report it:

1. Do not create a public issue on GitHub. Disclosing security vulnerabilities publicly can put users at risk.
2. Send an email to our security team at security@getanteon.com with a detailed description of the vulnerability, including the steps to reproduce it, and any relevant information about your environment (e.g., OS, Go version, etc.).
3. If possible, provide a minimal code sample or test case that demonstrates the vulnerability.
4. Allow us a reasonable amount of time to investigate and address the issue before publicly disclosing it. We will make every effort to resolve the issue as soon as possible.

We keep you informed of our progress in addressing the issue.

## Our Commitment

We take security issues very seriously and are committed to working with you to address any vulnerabilities that you report. We will:

- Investigate and validate reported vulnerabilities.
- Work on a fix or mitigation for the issue.
- Provide regular updates on our progress in resolving the issue.
- Notify you when the issue has been resolved and provide details on the changes made.
- We appreciate your assistance in maintaining the security of Anteon, and we thank you for your responsible disclosure.
