---
title: "SSH Exploiter"
draft: false
description: "Exploits SSH"
tags: ["exploiter", "ssh", "brute force"]
pre: "<i class='fa fa-terminal'></i> "
---

## SSH

[SSH (Secure Shell)](https://en.wikipedia.org/wiki/Secure_Shell) is a network
protocol designed for Unix-like operating systems that provides a secure way to
access a remote computer over an unsecured network. After establishing an
encrypted connection to a remote machine, it can be used to execute arbitrary
commands directly through the SSH terminal or by specifying commands in the SSH
client. This allows for secure remote administration and automation of tasks on
the target system.

## Exploitation

Attackers that can successfully authenticate to a machine via SSH can run
arbitrary commands on the victim machine. This allows the attacker to perform
actions such as installing malware, exfiltrating data, or pivoting and moving
laterally through the network. Infection Monkey's SSH exploiter uses
brute-force to attempt to propagate to a victim via SSH.

![SSH Configuration](
/images/island/configuration-page/ssh-exploiter-configuration.png
"SSH Configuration")

### Credentials used

The SSH exploiter uses [user-configured credentials](
/usage/configuration/credentials) as well as credentials collected from other
victims for brute-forcing. All possible combinations of usernames, passwords,
and SSH keypairs are used, prioritizing pairs provided by the user in the
configuration.

## Mitigation

1. Change user passwords to complex passwords that are not shared with other
computers on the network.

1. [Store private keys securely.](
https://www.ssldragon.com/blog/best-practices-to-store-the-private-key/)

## See also
- [SSH exploiter reference documentation](/reference/exploiters/ssh)
