# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------

use LWP::UserAgent; # http://search.cpan.org/~gaas/libwww-perl-6.03/lib/LWP/UserAgent.pm
use HTTP::Request::Common; #http://search.cpan.org/~gaas/HTTP-Message-6.02/lib/HTTP/Request/Common.pm
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;
use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
use Tk::Photo;
use Tk::JPEG;
use Tk::NoteBook;
use Tk::ProgressBar;



# Variable for web brute forcer
my $Web_ScanToBruteForce = "";
my $WebScanType = "scan";
my $Web_ipaddress = "";
my $Results = "";
my $Subnet_to_scan = "";

my @colors = (  0, '#ff002a',  1, '#ff0014',  2, '#ff000a',  3, '#ff0500',  4, '#ff1000',
	     5, '#ff1b00',  6, '#ff3000',  7, '#ff3b00',  8, '#ff4600',  9, '#ff5100',
	    10, '#ff6100', 11, '#ff7600', 12, '#ff8100', 13, '#ff8c00', 14, '#ff9700',
	    15, '#ffa100', 16, '#ffbc00', 17, '#ffc700', 18, '#ffd200', 19, '#ffdd00',
	    20, '#ffe700', 21, '#fffd00', 22, '#f0ff00', 23, '#e5ff00', 24, '#dbff00',
	    25, '#d0ff00', 26, '#baff00', 27, '#afff00', 28, '#9fff00', 29, '#95ff00',
	    30, '#8aff00', 31, '#74ff00', 32, '#6aff00', 33, '#5fff00', 34, '#54ff00',
	    35, '#44ff00', 36, '#2eff00', 37, '#24ff00', 38, '#19ff00', 39, '#0eff00',
	    40, '#03ff00', 41, '#00ff17', 42, '#00ff21', 43, '#00ff2c', 44, '#00ff37',
	    45, '#00ff42', 46, '#00ff57', 47, '#00ff67', 48, '#00ff72', 49, '#00ff7d',
	    50, '#00ff87', 51, '#00ff9d', 52, '#00ffa8', 53, '#00ffb8', 54, '#00ffc3',
	    55, '#00ffcd', 56, '#00ffe3', 57, '#00ffee', 58, '#00fff8', 59, '#00faff',
	    60, '#00eaff', 61, '#00d4ff', 62, '#00c9ff', 63, '#00bfff', 64, '#00b4ff',
	    65, '#00a9ff', 66, '#008eff', 67, '#0083ff', 68, '#0079ff', 69, '#006eff',
	    70, '#0063ff', 71, '#004eff', 72, '#003eff', 73, '#0033ff', 74, '#0028ff',
	    75, '#001dff', 76, '#0008ff', 77, '#0200ff', 78, '#1200ff', 79, '#1d00ff',
	    80, '#2800ff', 81, '#3d00ff', 82, '#4800ff', 83, '#5300ff', 84, '#5d00ff',
	    85, '#6e00ff', 86, '#8300ff', 87, '#8e00ff', 88, '#9900ff', 89, '#a300ff',
	    90, '#ae00ff', 91, '#c900ff', 92, '#d400ff', 93, '#df00ff', 94, '#e900ff',
	    95, '#f400ff', 96, '#ff00f3', 97, '#ff00e3', 98, '#ff00d9', 99, '#ff00ce' );




# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

	
my $subweb_mw = MainWindow->new(
						-title => 'Test default Aastra Login/Password');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
	
$file_mb->command(
		-label=>'Select subnet scan to load',
		-command => sub {&WEB_SELECTSCANFILE}
		);
		
$file_mb->command(
		-label=>'Launch brute force attack',
		-command => 
			sub	{&LAUNCH}
		);
$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
#------------- Button menu --------------
my $FrameButton = $subweb_mw -> Frame ();

my $ImageDetail = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_oeil.jpg",
									 );									 
my $ImageOpen = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_open.jpg",
									 );	
my $ImageLaunch = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_launch.jpg",
									 );									 
my $ImageSave = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_save.jpg",
									 );		
my $ImageExit = $FrameButton->Photo( 
									-format => 'jpeg',
									-file => "./Image/IMG_exit.jpg",
									 );	
									 									 									 
my $ButtonDetail = $FrameButton->Button (
    								-image => $ImageDetail, 
								    -command => sub {&EXPLANATION}
									)->pack(-side => 'left');
my $ButtonOpen = $FrameButton->Button (
    								-image => $ImageOpen, 
								    -command => sub {&WEB_SELECTSCANFILE}
									)->pack(-side => 'left');
my $ButtonLaunch = $FrameButton->Button (
    								-image => $ImageLaunch, 
								    -command => sub {&LAUNCH}
									)->pack(-side => 'left');
my $ButtonSave = $FrameButton->Button (
    								-image => $ImageSave, 
								    -command => sub {&SAVERESULTS}
									)->pack(-side => 'left');
my $ButtonExit = $FrameButton->Button (
    								-image => $ImageExit, 
								    -command => [$subweb_mw => 'destroy']
									)->pack(-side => 'right');									
																		
$FrameButton -> pack (-side => 'top', -anchor => 'w'); 	

#---------- LABEL FRAME CONFIGURE -------------------------------------
my $labeled_frame = $subweb_mw ->LabFrame(
										-label => "Configure",
                                   		-labelside => "acrosstop"
                                   		)->pack(-side => 'top', -anchor => 'w');

#----------
my $FrameTOP = $labeled_frame -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Phone from scanned subnet",
												-value=>"scan",
												-variable=>\$WebScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $labeled_frame -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Selected scan file (.isme):'
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$Web_ScanToBruteForce,
	- width => 59,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single IP Phone",  
												-value=>"single",  
												-variable=>\$WebScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $labeled_frame -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'IP address to scan (192.168.0.154):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$Web_ipaddress,
	- width => 51,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE5 = $labeled_frame -> Frame ();
my $rdb_single = $FrameMIDDLE5 -> Radiobutton(-text=>"Scan a subnet",  
												-value=>"subnet",  
												-variable=>\$WebScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE5 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE6 = $labeled_frame -> Frame ();
$FrameMIDDLE6->Label(
	-text => 'Subnet to scan (192.168.0.0/24):    '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE6 -> Entry(
	-textvariable => \$Subnet_to_scan,
	- width => 51,
	)->pack(-side => 'left');
$FrameMIDDLE6 -> pack (-side => 'top', -anchor => 'w');

#-------------PROGRESS BAR ----------------------------

$bar1 = $subweb_mw->ProgressBar( -borderwidth=>2, -blocks=>100, -gap=>0,
			  -troughcolor=>'white',-colors=>\@colors,
			  -length=>106 )->pack( -padx=>5, -pady=>5, -fill=>'x' );
#$bar1->value( 100 - $val );

#------------- TAB BOOK -------------------------------

my $FrameTab= $subweb_mw -> Frame (-width => 40, -height => 20);
my $book = $FrameTab->NoteBook()->pack( -fill=>'both', -expand=>1 );

$tab1 = $book->add( "Sheet 1", -label=>"Details");
$tab2 = $book->add( "Sheet 2", -label=>"Positive results" );
$tab3 = $book->add( "Sheet 3", -label=>"All logs");
$book->raise("Sheet 1");

my $TextWidget_tab1 = $tab1->Text(); 
$TextWidget_tab1 ->configure(-height => 28);
my $scrollbar_tab1 = $tab1 ->Scrollbar(-command => ['yview', $TextWidget_tab1 ]);
$TextWidget_tab1 ->configure(-yscrollcommand => ['set', $scrollbar_tab1]);

my $TextWidget_tab2 = $tab2->Text(); 
$TextWidget_tab2 ->configure(-height => 28);
my $scrollbar_tab2 = $tab2 ->Scrollbar(-command => ['yview', $TextWidget_tab2 ]);
$TextWidget_tab2 ->configure(-yscrollcommand => ['set', $scrollbar_tab2]);

my $TextWidget_tab3 = $tab3->Text(); 
$TextWidget_tab3 ->configure(-height => 28);
my $scrollbar_tab3 = $tab3 ->Scrollbar(-command => ['yview', $TextWidget_tab3 ]);
$TextWidget_tab3 ->configure(-yscrollcommand => ['set', $scrollbar_tab3]);


$TextWidget_tab1 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab2 ->pack(-side => 'left', -fill => 'both', -expand => 1);
$TextWidget_tab3 ->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar_tab1->pack(-side => 'right', -fill => 'y');
$scrollbar_tab2->pack(-side => 'right', -fill => 'y');
$scrollbar_tab3->pack(-side => 'right', -fill => 'y');

$FrameTab -> pack (-side => 'top', -anchor => 'w');

#------------ LAUNCHING THE MAIN LOOP --------
&EXPLANATION;
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------
sub LAUNCH
{
	# variable initialization
	$Results = "";
	$TextWidget_tab3 -> delete('0.0', 'end');
	$TextWidget_tab2 -> delete('0.0', 'end');
	$bar1->value(0);
	$book->raise("Sheet 3");

	if ($WebScanType =~ /single/)
	{
		&WEBBRUTEFORCESINGLE;	
	}
	elsif ($WebScanType =~ /scan/)
	{
		&WEBBRUTEFORCESCAN;
	}
	elsif ($WebScanType =~ /subnet/)
	{
		&WEBBRUTEFORCEFULLSUBNET;
	}
}

sub WEB_SELECTSCANFILE
{
                              
	my $types = [ ['isme files', '.isme']];
	my $Web_SelectScan = $subweb_mw->getOpenFile(-filetypes => $types,
	                         	  -defaultextension => '.isme',
	                              -initialdir => "scan_history"
	                              );  
	$Web_ScanToBruteForce = $Web_SelectScan;
	$TextLabel->update();
	 
}

sub WEBBRUTEFORCESINGLE
{
	if ($Web_ipaddress =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
    {
		$TextWidget_tab3 -> delete('0.0', 'end');
		$TextWidget_tab3 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3 -> insert("end", "Starting to test $Web_ipaddress for default Aastra Login/Password.\n");
		$TextWidget_tab3 -> insert("end", "-------------------------------------------------------------------------------\n");

		$TextWidget_tab2 -> delete('0.0', 'end');
		$TextWidget_tab2 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2 -> insert("end", "Starting to test $Web_ipaddress for default Aastra Login/Password.\n");
		$TextWidget_tab2 -> insert("end", "-------------------------------------------------------------------------------\n");

		$Results = $Results."-------------------------------------------------------------------------------\n";		
		$Results = $Results."Starting to test $Web_ipaddress for default Aastra Login/Password.\n";	
		$Results = $Results."-------------------------------------------------------------------------------\n";


		my $url_AastraPhone = "http://".$Web_ipaddress;
		#192.168.12.76 & 87
		#my $url_AastraPhone = "http://192.168.12.87";
		my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
		$ua->timeout(3);	
		my $request = HTTP::Request->new(GET => $url_AastraPhone);				
		$request->authorization_basic('admin', '22222');	
		my $answer=$ua->request($request);
		my $content = $answer->content();

	    if (($content =~ /HTTP 401 Unauthorized/) || ($content =~ /HTTP 401 - File unauthorized/) || ($content =~ /HTTP 401/))
	    {
	    	$TextWidget_tab3 -> insert ("end","$Web_ipaddress: No default login/password.\n");
			$Results = $Results."$Web_ipaddress:  No default login/password.\n";
	    }
	    elsif ($content =~ /aastra/)
		{
		   	$TextWidget_tab3 -> insert ("end","$Web_ipaddress: test admin/22222 - WARNING => used\n");

		   	$TextWidget_tab2 -> insert ("end","$Web_ipaddress: test admin/22222 - WARNING => used\n");
		   	
			$Results = $Results."$Web_ipaddress: test admin/22222 - WARNING => used\n";
		}
		else
	    {
	    	$TextWidget_tab3 -> insert ("end","$Web_ipaddress:  No default login/password.\n");
			$Results = $Results."$Web_ipaddress:  No default login/password.\n";
	    }
	    
    	$bar1->value(100);
	    	
   		$TextWidget_tab3 -> insert ("end", "\n");					    
   		$TextWidget_tab3 -> insert ("end", "------------------------ END --------------------------------------------------\n");					    
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

   		$TextWidget_tab2 -> insert ("end", "\n");					    
   		$TextWidget_tab2 -> insert ("end", "------------------------ END --------------------------------------------------\n");					    
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');

		$Results = $Results."\n";
		$Results = $Results."------------------------ END --------------------------------------------------\n";  	
    } 
    else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Bad IP address syntax !',
					)->Show( );		
    }   	
}

sub WEBBRUTEFORCESCAN
{
	$counter = 0;
	if (open (FILE, "$Web_ScanToBruteForce"))
	{
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3 -> insert ("end", "Starting to test detected IP Phones for default Aastra Login/Password.\n");
		$TextWidget_tab3 -> insert ("end", "File loaded: $Web_ScanToBruteForce\n");
		$TextWidget_tab3 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2 -> insert ("end", "Starting to test detected IP Phones for default Aastra Login/Password.\n");
		$TextWidget_tab2 -> insert ("end", "File loaded: $Web_ScanToBruteForce\n");
		$TextWidget_tab2 -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');

		$Results = $Results."-------------------------------------------------------------------------------\n";		
		$Results = $Results."Starting to test detected IP Phones for default Aastra Login/Password.\n";		
		$Results = $Results."File loaded: $Web_ScanToBruteForce\n";		
		$Results = $Results."-------------------------------------------------------------------------------\n";		

		while (<FILE>)
		{
			my $LineToAnalyze=$_;
			my $ToFind = "IP adresse:";
			my $ToFindBis = "Web server available";
			my $loc = 0;
			my $locbis=0;
			
			$loc = index($LineToAnalyze, $ToFind); # if $loc = -1 the string is not found.
			$locbis = index($LineToAnalyze, $ToFindBis); # if $loc = -1 the string is not found.			
			$TextWidget_tab3 -> insert ("end","------- Analyzing line $counter\n");	
			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end');						

			$Results = $Results."------- Analyzing line $counter\n";
					
			if ($loc >= 0)
			{
				if ($locbis >= 0)# if there is not a web server, no interest in testing it.
				{
					my @splitAnalyze= split (/[*]/, $LineToAnalyze);
					my $loc2 = 0;
					$loc2 = index(@splitAnalyze[0], $ToFind); # if $loc = -1 the string is not found.
					{
						#if we are there, we need to scan the IP address (not a cisco IP Phone for sure). Let fetch it in the file.
						my @splitIP= split (/[ ]/, @splitAnalyze[0]);
						
						#IP address should be in @splitIP[1];
						my $url_AastraPhone = "http://".@splitIP[2];

				    	$TextWidget_tab3 -> insert ("end","   ----- Testing @splitIP[2]\n");
						$Results = $Results."   ----- Testing @splitIP[2]\n";						

						# Let's test the IP Phone for real now.
						my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
						$ua->timeout(3);	
						my $request = HTTP::Request->new(GET => $url_AastraPhone);
						$request->authorization_basic('admin', '22222');# Default Aastra login: admin default password: 22222				
						my $answer=$ua->request($request);
						my $content = $answer->content();
					    if (($content =~ /HTTP 401 Unauthorized/) || ($content =~ /HTTP 401 - File unauthorized/) || ($content =~ /HTTP 401/))
					    {
					    	$TextWidget_tab3 -> insert ("end","   @splitIP[2]: No default login/password.\n");
	   				    	$Results = $Results."   @splitIP[2]: No default login/password.\n";
					    }
					    #ajouter un cas u on test pour verifier si Aastra web page					    
						elsif ($content =~ /aastra/)
					    {
					    	$TextWidget_tab3 -> insert ("end","   @splitIP[2]: test admin/22222 - WARNING => used\n");

					    	$TextWidget_tab2 -> insert ("end","   @splitIP[2]: test admin/22222 - WARNING => used\n");
					    	
	   				    	$Results = $Results."   @splitIP[2]: test admin/22222 - WARNING => used\n";
					    }
					    else #all the other cases.
					    {
					    	$TextWidget_tab3 -> insert ("end","   @splitIP[2]: No default login/password.\n");
	   				    	$Results = $Results."   @splitIP[2]: No default login/password.\n";
					    }		
					}
				}
				$TextWidget_tab3  -> update ();	
				$TextWidget_tab3  -> see ('end');
			}
			$counter=$counter+1;
		}
		$TextWidget_tab3 -> insert ("end", "------------------------ END --------------------------------------------------\n");	
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert ("end", "------------------------ END --------------------------------------------------\n");	
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		close (FILE);
		$Results = $Results."\n";
		$Results = $Results."------------------------ END --------------------------------------------------\n";  	
	}
	else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Unable to open selected file. The scan won\'t be launch',
					)->Show( );		
	}
	
}

sub WEBBRUTEFORCEFULLSUBNET
{	
	if ($Subnet_to_scan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{
		$TextWidget_tab3 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3 -> insert("end", "Starting to test $Subnet_to_scan for default Aastra Login/Password\n");
		$TextWidget_tab3 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

		$TextWidget_tab2 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2 -> insert("end", "Starting to test $Subnet_to_scan for default Aastra Login/Password\n");
		$TextWidget_tab2 -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');

    	$Results = $Results."-------------------------------------------------------------------------------\n";
    	$Results = $Results."Starting to test $Subnet_to_scan for default Aastra Login/Password\n";
    	$Results = $Results."-------------------------------------------------------------------------------\n";

		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$Subnet_to_scan );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );

		my $counter_global = 0;
		my $counter_temp = 0;
		my $percentage = 0;
				
		foreach my $scan_count ( @{ $listref } ) 
		{
			$counter_global++;	
		}

		foreach my $scan_address ( @{ $listref } ) 
		{
			$counter_temp++;
			if ($p->ping($scan_address))
		    {
		    	$TextWidget_tab3 -> insert ("end","------- Testing $scan_address\n");
				$Results = $Results."------- Testing $scan_address\n";
	
				my $url_AastraPhone = "http://".$scan_address;
				#192.168.12.76 & 87
				#my $url_AastraPhone = "http://192.168.12.87";
				my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
				$ua->timeout(3);	
				my $request = HTTP::Request->new(GET => $url_AastraPhone);				
				$request->authorization_basic('admin', '22222');	
				my $answer=$ua->request($request);
				my $content = $answer->content();
		
			    if (($content =~ /HTTP 401 Unauthorized/) || ($content =~ /HTTP 401 - File unauthorized/) || ($content =~ /HTTP 401/))
			    {
			    	$TextWidget_tab3 -> insert ("end","$scan_address: No default login/password.\n");
			    	$Results = $Results."$scan_address: No default login/password.\n";
			    }
			    elsif ($content =~ /aastra/)
				{
				   	$TextWidget_tab3 -> insert ("end","$scan_address: test admin/22222 - WARNING => used\n");

				   	$TextWidget_tab2 -> insert ("end","$scan_address: test admin/22222 - WARNING => used\n");
				   	
			    	$Results = $Results."$scan_address: test admin/22222 - WARNING => used\n";
				}
				else
			    {
			    	$TextWidget_tab3 -> insert ("end","$scan_address: No default login/password.\n");
			    	$Results = $Results."$scan_address: No default login/password.\n";
			    }	
		    }
			else
			{
			   	$TextWidget_tab3 -> insert ("end","------- Testing $scan_address\n");
			   	$TextWidget_tab3 -> insert ("end","Unreachable\n");
			   	$Results = $Results."------- Testing $scan_address\n";
			   	$Results = $Results."Unreachable\n";

			}
   			$TextWidget_tab3  -> update ();	
			$TextWidget_tab3  -> see ('end'); 

	    	$percentage = int (($counter_temp/$counter_global)*100);
	    	$bar1->value($percentage);
		}
   		$TextWidget_tab3 -> insert ("end", "\n");					    
   		$TextWidget_tab3 -> insert ("end", "------------------------ END --------------------------------------------------\n");					    
		$TextWidget_tab3  -> update ();	
		$TextWidget_tab3  -> see ('end');

   		$TextWidget_tab2 -> insert ("end", "\n");					    
   		$TextWidget_tab2 -> insert ("end", "------------------------ END --------------------------------------------------\n");					    
		$TextWidget_tab2  -> update ();	
		$TextWidget_tab2  -> see ('end');
		
		$Results = $Results."\n";
		$Results = $Results."------------------------ END --------------------------------------------------\n";  	
	}
    else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Bad subnet syntax !',
					)->Show( );		
    }
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}

sub EXPLANATION
{
	$TextWidget_tab1 -> delete('0.0', 'end');
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1 -> insert ("end", "Many SIP IP Phones have an embedded web server to work on their configurations. Basic authentication is the usual way to get in. The idea of this module is to test those web servers with the usual default passwords (admin/22222 for Aastra).\n");
	$TextWidget_tab1 -> insert ("end", "\n");	
	$TextWidget_tab1 -> insert ("end", "The attack could be done in three ways:\n");
	$TextWidget_tab1 -> insert ("end", "- The attack is launched on the current load subnet scan. It will analyze it to get all the devices with a web server and launch the test.\n");
	$TextWidget_tab1 -> insert ("end", "- The attack is launched on the current load subnet scan. It will analyze it to get all the devices with a web server and launch the test.\n");
	$TextWidget_tab1 -> insert ("end", "- The attack could be launch on a specific subnet.\n");
	$TextWidget_tab1 -> insert ("end", "\n");
	$TextWidget_tab1  -> insert ("end", "Date: August 2012\n");
	$TextWidget_tab1 -> insert ("end", "-------------------------------------------------------------------------------\n");
	$TextWidget_tab1  -> update ();	
	$TextWidget_tab1  -> see ('end'); 
	
	$book->raise("Sheet 1");			
}

	
