/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.hook;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.agent.SnoopAgent;
import com.aspect.snoop.ui.choose.clazz.ChooseClassView;
import com.aspect.snoop.ui.hook.FunctionSearchView;
import com.aspect.snoop.util.ReflectionUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;

public class AddFunctionHookView
extends JDialog {
    private static AccessibleObject selectedMethod;
    private static Class selectedClass;
    private static Class[] parameterTypes;
    private static Class returnType;
    private static boolean shouldInherit;
    private Class currentClass;
    private Method[] loadedMethods;
    private Constructor[] loadedConstructors;
    private JButton btnAddWatch;
    private JButton btnBrowseForClass;
    private JButton btnSearchForFunction;
    private JCheckBox chkShouldInherit;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JList lstMethods;
    private JTextField txtClass;

    public boolean getShouldInherit() {
        return shouldInherit;
    }

    public Class getSelectedClass() {
        return selectedClass;
    }

    public AccessibleObject getSelectedMethod() {
        return selectedMethod;
    }

    public Class[] getParameterTypes() {
        return parameterTypes;
    }

    public AddFunctionHookView(Frame parent, boolean modal, String classpath) {
        super(parent, modal);
        this.initComponents();
        this.lstMethods.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = new JLabel();
                if (isSelected) {
                    lbl.setForeground(Color.white);
                    lbl.setBackground(Color.blue);
                    lbl.setOpaque(true);
                }
                Member m = (Member)value;
                String toShow = ReflectionUtil.getMethodDescription(m);
                lbl.setText(" " + toShow);
                return lbl;
            }
        });
        this.lstMethods.setListData(new Method[0]);
        selectedClass = null;
        selectedMethod = null;
        parameterTypes = null;
        returnType = null;
        this.lstMethods.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AddFunctionHookView.this.finalizeSelection();
                    AddFunctionHookView.this.dispose();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.txtClass = new JTextField();
        this.btnBrowseForClass = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstMethods = new JList();
        this.btnAddWatch = new JButton();
        this.chkShouldInherit = new JCheckBox();
        this.btnSearchForFunction = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(JavaSnoop.class).getContext().getResourceMap(AddFunctionHookView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("Form");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.txtClass.setText(resourceMap.getString("txtClass.text", new Object[0]));
        this.txtClass.setToolTipText(resourceMap.getString("txtClass.toolTipText", new Object[0]));
        this.txtClass.setName("txtClass");
        this.txtClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFunctionHookView.this.txtClassActionPerformed(evt);
            }
        });
        this.txtClass.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AddFunctionHookView.this.txtClassKeyTyped(evt);
            }
        });
        ApplicationActionMap actionMap = Application.getInstance(JavaSnoop.class).getContext().getActionMap(AddFunctionHookView.class, this);
        this.btnBrowseForClass.setAction(actionMap.get("showChooseClassForm"));
        this.btnBrowseForClass.setText(resourceMap.getString("btnBrowseForClass.text", new Object[0]));
        this.btnBrowseForClass.setToolTipText(resourceMap.getString("btnBrowseForClass.toolTipText", new Object[0]));
        this.btnBrowseForClass.setFocusable(false);
        this.btnBrowseForClass.setName("btnBrowseForClass");
        this.btnBrowseForClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFunctionHookView.this.btnBrowseForClassActionPerformed(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jScrollPane1.setName("jScrollPane1");
        this.lstMethods.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstMethods.setName("lstMethods");
        this.lstMethods.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                AddFunctionHookView.this.lstMethodsKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.lstMethods);
        this.btnAddWatch.setFont(resourceMap.getFont("btnAddWatch.font"));
        this.btnAddWatch.setText(resourceMap.getString("btnAddWatch.text", new Object[0]));
        this.btnAddWatch.setToolTipText(resourceMap.getString("btnAddWatch.toolTipText", new Object[0]));
        this.btnAddWatch.setFocusable(false);
        this.btnAddWatch.setName("btnAddWatch");
        this.btnAddWatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddFunctionHookView.this.btnAddWatchActionPerformed(evt);
            }
        });
        this.chkShouldInherit.setText(resourceMap.getString("chkShouldInherit.text", new Object[0]));
        this.chkShouldInherit.setToolTipText(resourceMap.getString("chkShouldInherit.toolTipText", new Object[0]));
        this.chkShouldInherit.setFocusable(false);
        this.chkShouldInherit.setName("chkShouldInherit");
        this.btnSearchForFunction.setAction(actionMap.get("searchForFunction"));
        this.btnSearchForFunction.setText(resourceMap.getString("btnSearchForFunction.text", new Object[0]));
        this.btnSearchForFunction.setToolTipText(resourceMap.getString("btnSearchForFunction.toolTipText", new Object[0]));
        this.btnSearchForFunction.setFocusable(false);
        this.btnSearchForFunction.setName("btnSearchForFunction");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(15, 15, 15).addComponent(this.txtClass, -1, 308, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowseForClass)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.chkShouldInherit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSearchForFunction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddWatch)).addComponent(this.jScrollPane1, -1, 393, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtClass, -2, -1, -2).addComponent(this.btnBrowseForClass)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 91, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSearchForFunction).addComponent(this.chkShouldInherit).addComponent(this.btnAddWatch)))).addContainerGap()));
        this.pack();
    }

    private void btnAddWatchActionPerformed(ActionEvent evt) {
        if (this.lstMethods.getSelectedIndex() != -1) {
            this.finalizeSelection();
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please select a method to hook!");
        }
    }

    private void btnBrowseForClassActionPerformed(ActionEvent evt) {
        List<Class> classes = SnoopAgent.getAgentManager().getLoadedClasses();
        ChooseClassView view = new ChooseClassView(this, classes);
        view.setVisible(true);
        UIUtil.waitForInput(view);
        if (view.getChosenClass() != null) {
            this.loadClassMethods(view.getChosenClass(), true);
        }
    }

    private void txtClassKeyTyped(KeyEvent evt) {
        String substring = this.txtClass.getText();
        if (evt.getKeyChar() != '\n' && evt.getKeyChar() != '\b' && evt.getKeyChar() != '\u001b') {
            int pos = this.txtClass.getCaretPosition();
            if (pos != 0) {
                String s1 = substring.substring(0, pos);
                String s2 = substring.substring(pos, this.txtClass.getText().length());
                substring = s1 + evt.getKeyChar() + s2;
            } else {
                substring = substring + evt.getKeyChar();
            }
        }
        try {
            this.currentClass = SnoopAgent.getAgentManager().getFromAllClasses(substring);
            this.loadClassMethods(this.currentClass, false);
        }
        catch (ClassNotFoundException ex) {
            this.lstMethods.setListData(new String[0]);
        }
    }

    private void txtClassActionPerformed(ActionEvent evt) {
        if (this.lstMethods.getModel().getSize() > 0) {
            this.lstMethods.setSelectedIndex(0);
            this.lstMethods.requestFocus();
        }
    }

    private void lstMethodsKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n' && this.lstMethods.getSelectedIndex() != -1) {
            this.btnAddWatch.doClick();
        }
    }

    private void finalizeSelection() {
        selectedClass = this.currentClass;
        selectedMethod = (AccessibleObject)this.lstMethods.getSelectedValue();
        parameterTypes = ReflectionUtil.getParameterTypes(selectedMethod);
        returnType = ReflectionUtil.getReturnType(selectedMethod);
        shouldInherit = this.chkShouldInherit.isSelected();
    }

    private void loadClassMethods(Class clazz, boolean setClassName) {
        this.currentClass = clazz;
        this.loadedMethods = this.currentClass.getDeclaredMethods();
        this.loadedConstructors = this.currentClass.getDeclaredConstructors();
        Member[] entries = new Member[this.loadedMethods.length + this.loadedConstructors.length];
        System.arraycopy(this.loadedMethods, 0, entries, 0, this.loadedMethods.length);
        System.arraycopy(this.loadedConstructors, 0, entries, this.loadedMethods.length, this.loadedConstructors.length);
        this.lstMethods.setListData(entries);
        if (setClassName) {
            this.txtClass.setText(this.currentClass.getName());
        }
        if (ReflectionUtil.isInterfaceOrAbstract(this.currentClass)) {
            this.chkShouldInherit.setSelected(true);
            this.chkShouldInherit.setEnabled(false);
        } else {
            this.chkShouldInherit.setSelected(false);
            this.chkShouldInherit.setEnabled(true);
        }
    }

    @Action
    public void searchForFunction() {
        List<Class> classes = SnoopAgent.getAgentManager().getLoadedClasses();
        FunctionSearchView view = new FunctionSearchView(this, true, classes);
        view.setVisible(true);
        UIUtil.waitForInput(view);
        Method method = view.getMethodChosen();
        if (method == null) {
            return;
        }
        selectedClass = ReflectionUtil.getDeclaringClass(method);
        selectedMethod = method;
        parameterTypes = ReflectionUtil.getParameterTypes(method);
        shouldInherit = ReflectionUtil.isInterfaceOrAbstract(method);
        returnType = ReflectionUtil.getReturnType(method);
        this.dispose();
    }

    public Class getReturnType() {
        return returnType;
    }
}

