/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.ByteArray;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class AuxiliaryForDecryptThreads {
    public static final byte[] getIntermediateChainedHash(byte[] b, String chainedAlgorithmCase, int pos) {
        byte[] returnValue = null;
        if (chainedAlgorithmCase.charAt(pos) == 'L') {
            returnValue = ByteArray.toByteArrayLower(b);
        } else if (chainedAlgorithmCase.charAt(pos) == 'U') {
            returnValue = ByteArray.toByteArrayUpper(b);
        } else if (chainedAlgorithmCase.charAt(pos) == 'R') {
            returnValue = b;
        }
        return returnValue;
    }

    public static final List<byte[]> removeFromEncryptedHashes(List<byte[]> myByteList, byte[] ba) {
        int index = -1;
        for (byte[] elem : myByteList) {
            ++index;
            if (Arrays.equals(elem, ba)) break;
        }
        if (index >= 0) {
            myByteList.remove(index);
        }
        return myByteList;
    }

    public static final byte[] processSalt(byte[] result, byte[] salt, boolean preSalt) {
        byte[] resultSalt = null;
        resultSalt = salt == null ? result : (preSalt ? ByteArray.concat(salt, result) : ByteArray.concat(result, salt));
        return resultSalt;
    }

    public static final byte[] getRandom(int length) {
        byte[] returnValue = new byte[length];
        new Random().nextBytes(returnValue);
        return returnValue;
    }

    public static final String bytes2Utf8(byte[] ba) {
        try {
            return new String(ba, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final String getRandomString(int length) {
        return AuxiliaryForDecryptThreads.bytes2Utf8(AuxiliaryForDecryptThreads.getRandom(length));
    }

    public static final boolean equalsTo(StringBuilder source, StringBuilder destination) {
        boolean returnValue = true;
        if (source == null || destination == null) {
            return false;
        }
        if (source.length() != destination.length()) {
            return false;
        }
        int myLength = source.length();
        int i = 0;
        while (i < myLength) {
            if (source.charAt(i) != destination.charAt(i)) {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }
}

