# Leo colorizer control file for lilypond mode.
# This file is in the public domain.

# Properties for lilypond mode.
properties = {
    "commentEnd": "%}",
    "commentStart": "%{",
    "doubleBracketIndent": "false",
    "indentCloseBrackets": "}",
    "indentOpenBrackets": "{",
    "lineComment": "%",
    "lineUpClosingBracket": "true",
    "wordBreakChars": "=",
}

# Attributes dict for lilypond_main ruleset.
lilypond_main_attributes_dict = {
    "default": "null",
    "digit_re": "",
    "escape": "",
    "highlight_digits": "false",
    "ignore_case": "false",
    "no_word_sep": "",
}

# Dictionary of attributes dictionaries for lilypond mode.
attributesDictDict = {
    "lilypond_main": lilypond_main_attributes_dict,
}

# Keywords dict for lilypond_main ruleset.
lilypond_main_keywords_dict = {
    "Accidental_engraver": "keyword3",
    "Arpeggio_engraver": "keyword3",
    "Auto_beam_engraver": "keyword3",
    "Bar_engraver": "keyword3",
    "Bar_number_engraver": "keyword3",
    "Beam_engraver": "keyword3",
    "Beam_performer": "keyword3",
    "Break_align_engraver": "keyword3",
    "Breathing_sign_engraver": "keyword3",
    "ChoirStaff": "keyword3",
    "ChordNameVoice": "keyword3",
    "ChordNames": "keyword3",
    "Chord_name_engraver": "keyword3",
    "Chord_tremolo_engraver": "keyword3",
    "Clef_engraver": "keyword3",
    "Cluster_spanner_engraver": "keyword3",
    "Collision_engraver": "keyword3",
    "Custos_engraver": "keyword3",
    "Devnull": "keyword3",
    "Dot_column_engraver": "keyword3",
    "DrumStaff": "keyword3",
    "DrumVoice": "keyword3",
    "Drum_note_performer": "keyword3",
    "Drum_notes_engraver": "keyword3",
    "Dynamic_engraver": "keyword3",
    "Dynamic_performer": "keyword3",
    "Extender_engraver": "keyword3",
    "FiguredBass": "keyword3",
    "Figured_bass_engraver": "keyword3",
    "Fingering_engraver": "keyword3",
    "Font_size_engraver": "keyword3",
    "Forbid_line_break_engraver": "keyword3",
    "Glissando_engraver": "keyword3",
    "Global": "keyword3",
    "Grace_beam_engraver": "keyword3",
    "GrandStaff": "keyword3",
    "GregorianTranscriptionStaff": "keyword3",
    "GregorianTranscriptionVoice": "keyword3",
    "Grob_pq_engraver": "keyword3",
    "Hyphen_engraver": "keyword3",
    "InnerChoirStaff": "keyword3",
    "InnerStaffGroup": "keyword3",
    "Instrument_name_engraver": "keyword3",
    "Key_engraver": "keyword3",
    "Key_performer": "keyword3",
    "Ligature_bracket_engraver": "keyword3",
    "Lyric_engraver": "keyword3",
    "Lyric_performer": "keyword3",
    "Lyrics": "keyword3",
    "Mark_engraver": "keyword3",
    "Melisma_translator": "keyword3",
    "Metronome_mark_engraver": "keyword3",
    "Multi_measure_rest_engraver": "keyword3",
    "New_fingering_engraver": "keyword3",
    "NoteNames": "keyword3",
    "Note_head_line_engraver": "keyword3",
    "Note_heads_engraver": "keyword3",
    "Note_name_engraver": "keyword3",
    "Note_performer": "keyword3",
    "Note_swallow_translator": "keyword3",
    "Ottava_spanner_engraver": "keyword3",
    "Output_property_engraver": "keyword3",
    "Part_combine_engraver": "keyword3",
    "Percent_repeat_engraver": "keyword3",
    "Phrasing_slur_engraver": "keyword3",
    "PianoStaff": "keyword3",
    "Piano_pedal_engraver": "keyword3",
    "Piano_pedal_performer": "keyword3",
    "Pitch_squash_engraver": "keyword3",
    "Repeat_acknowledge_engraver": "keyword3",
    "Rest_collision_engraver": "keyword3",
    "Rest_engraver": "keyword3",
    "Rest_swallow_translator": "keyword3",
    "RhythmicStaff": "keyword3",
    "Rhythmic_column_engraver": "keyword3",
    "Score": "keyword3",
    "Script_column_engraver": "keyword3",
    "Script_engraver": "keyword3",
    "Separating_line_group_engraver": "keyword3",
    "Skip_event_swallow_translator": "keyword3",
    "Slash_repeat_engraver": "keyword3",
    "Slur_engraver": "keyword3",
    "Slur_performer": "keyword3",
    "Spacing_engraver": "keyword3",
    "Span_arpeggio_engraver": "keyword3",
    "Span_bar_engraver": "keyword3",
    "Span_dynamic_performer": "keyword3",
    "Staff": "keyword3",
    "StaffGroup": "keyword3",
    "Staff_collecting_engraver": "keyword3",
    "Staff_symbol_engraver": "keyword3",
    "Stanza_number_align_engraver": "keyword3",
    "Stanza_number_engraver": "keyword3",
    "Stem_engraver": "keyword3",
    "String_number_engraver": "keyword3",
    "Swallow_engraver": "keyword3",
    "Swallow_performer": "keyword3",
    "System_start_delimiter_engraver": "keyword3",
    "TabStaff": "keyword3",
    "TabVoice": "keyword3",
    "Tab_note_heads_engraver": "keyword3",
    "Tab_staff_symbol_engraver": "keyword3",
    "Tempo_performer": "keyword3",
    "Text_engraver": "keyword3",
    "Text_spanner_engraver": "keyword3",
    "Tie_engraver": "keyword3",
    "Tie_performer": "keyword3",
    "Time_signature_engraver": "keyword3",
    "Time_signature_performer": "keyword3",
    "Timing_engraver": "keyword3",
    "Timing_translator": "keyword3",
    "Tuplet_engraver": "keyword3",
    "VaticanaStaff": "keyword3",
    "VaticanaVoice": "keyword3",
    "Vaticana_ligature_engraver": "keyword3",
    "Vertical_align_engraver": "keyword3",
    "Vocal_name_engraver": "keyword3",
    "Voice": "keyword3",
    "Volta_engraver": "keyword3",
}

# Dictionary of keywords dictionaries for lilypond mode.
keywordsDictDict = {
    "lilypond_main": lilypond_main_keywords_dict,
}

# Rules for lilypond_main ruleset.

def lilypond_rule0(colorer, s, i):
    return colorer.match_span(s, i, kind="comment2", begin="%{", end="%}")

def lilypond_rule1(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment1", seq="%")

def lilypond_rule2(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="null", seq="\\\"")

def lilypond_rule3(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="null", seq="\\'")

def lilypond_rule4(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="null", seq="\\H")

def lilypond_rule5(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="digit", seq="\\breve")

def lilypond_rule6(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="digit", seq="\\longa")

def lilypond_rule7(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="digit", seq="\\maxima")

def lilypond_rule8(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="function", pattern="=",
          at_whitespace_end=True)

def lilypond_rule9(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="function", pattern="=",
          at_whitespace_end=True)

def lilypond_rule10(colorer, s, i):
    return colorer.match_span(s, i, kind="literal2", begin="#(", end=")",
          delegate="scheme::main")

def lilypond_rule11(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="{")

def lilypond_rule12(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="}")

def lilypond_rule13(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="[")

def lilypond_rule14(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="]")

def lilypond_rule15(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="<<")

def lilypond_rule16(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=">>")

def lilypond_rule17(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="null", seq="-<")

def lilypond_rule18(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="null", seq="->")

def lilypond_rule19(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="|")

def lilypond_rule20(colorer, s, i):
    return colorer.match_span(s, i, kind="literal1", begin="\"", end="\"")

def lilypond_rule21(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="-[[:digit:]]+>")

def lilypond_rule22(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq="'")

def lilypond_rule23(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="markup", seq=",")

def lilypond_rule24(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="comment2", regexp="r([[:digit:]]*)\\>")

def lilypond_rule25(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="comment2", regexp="R([[:digit:]]*)\\>")

def lilypond_rule26(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="comment2", regexp="s([[:digit:]]*)\\>")

def lilypond_rule27(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="1[[:digit:]]*\\>")

def lilypond_rule28(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="2[[:digit:]]*\\>")

def lilypond_rule29(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="3[[:digit:]]*\\>")

def lilypond_rule30(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="4[[:digit:]]*\\>")

def lilypond_rule31(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="5[[:digit:]]*\\>")

def lilypond_rule32(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="6[[:digit:]]*\\>")

def lilypond_rule33(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="7[[:digit:]]*\\>")

def lilypond_rule34(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="8[[:digit:]]*\\>")

def lilypond_rule35(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="9[[:digit:]]*\\>")

def lilypond_rule36(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="digit", regexp="0[[:digit:]]*\\>")

def lilypond_rule37(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\with\\>")

def lilypond_rule38(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\whiteTriangleMarkup\\>")

def lilypond_rule39(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\vsize\\>")

def lilypond_rule40(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\voiceTwo\\>")

def lilypond_rule41(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\voiceThree\\>")

def lilypond_rule42(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\voiceOne\\>")

def lilypond_rule43(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\voiceFour\\>")

def lilypond_rule44(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\virgula\\>")

def lilypond_rule45(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\virga\\>")

def lilypond_rule46(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\verylongfermata\\>")

def lilypond_rule47(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\version\\>")

def lilypond_rule48(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\varcoda\\>")

def lilypond_rule49(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\upprall\\>")

def lilypond_rule50(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\upmordent\\>")

def lilypond_rule51(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\upbow\\>")

def lilypond_rule52(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\up\\>")

def lilypond_rule53(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\unusedEntry\\>")

def lilypond_rule54(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\unset\\>")

def lilypond_rule55(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\unit\\>")

def lilypond_rule56(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\unaCorda\\>")

def lilypond_rule57(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\unHideNotes\\>")

def lilypond_rule58(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\type\\>")

def lilypond_rule59(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\turnOff\\>")

def lilypond_rule60(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\turn\\>")

def lilypond_rule61(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tupletUp\\>")

def lilypond_rule62(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tupletDown\\>")

def lilypond_rule63(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tupletBoth\\>")

def lilypond_rule64(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\trill\\>")

def lilypond_rule65(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\treCorde\\>")

def lilypond_rule66(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\transposition\\>")

def lilypond_rule67(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\transpose\\>")

def lilypond_rule68(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tiny\\>")

def lilypond_rule69(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\times\\>")

def lilypond_rule70(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\time\\>")

def lilypond_rule71(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tieUp\\>")

def lilypond_rule72(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tieSolid\\>")

def lilypond_rule73(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tieDown\\>")

def lilypond_rule74(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tieDotted\\>")

def lilypond_rule75(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tieBoth\\>")

def lilypond_rule76(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\thumb\\>")

def lilypond_rule77(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tenuto\\>")

def lilypond_rule78(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tempo\\>")

def lilypond_rule79(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\tag\\>")

def lilypond_rule80(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sustainUp\\>")

def lilypond_rule81(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sustainDown\\>")

def lilypond_rule82(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stropha\\>")

def lilypond_rule83(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopped\\>")

def lilypond_rule84(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopTextSpan\\>")

def lilypond_rule85(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopGroup\\>")

def lilypond_rule86(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopGraceMusic\\>")

def lilypond_rule87(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopAppoggiaturaMusic\\>")

def lilypond_rule88(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stopAcciaccaturaMusic\\>")

def lilypond_rule89(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stop\\>")

def lilypond_rule90(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stemUp\\>")

def lilypond_rule91(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stemDown\\>")

def lilypond_rule92(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\stemBoth\\>")

def lilypond_rule93(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\startTextSpan\\>")

def lilypond_rule94(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\startGroup\\>")

def lilypond_rule95(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\startGraceMusic\\>")

def lilypond_rule96(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\startAppoggiaturaMusic\\>")

def lilypond_rule97(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\startAcciaccaturaMusic\\>")

def lilypond_rule98(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\start\\>")

def lilypond_rule99(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\staccato\\>")

def lilypond_rule100(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\staccatissimo\\>")

def lilypond_rule101(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\spp\\>")

def lilypond_rule102(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sp\\>")

def lilypond_rule103(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sostenutoUp\\>")

def lilypond_rule104(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sostenutoDown\\>")

def lilypond_rule105(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\smaller\\>")

def lilypond_rule106(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\small\\>")

def lilypond_rule107(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\slurUp\\>")

def lilypond_rule108(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\slurSolid\\>")

def lilypond_rule109(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\slurDown\\>")

def lilypond_rule110(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\slurDotted\\>")

def lilypond_rule111(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\slurBoth\\>")

def lilypond_rule112(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\skip\\>")

def lilypond_rule113(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\simultaneous\\>")

def lilypond_rule114(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\signumcongruentiae\\>")

def lilypond_rule115(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\showStaffSwitch\\>")

def lilypond_rule116(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\shortfermata\\>")

def lilypond_rule117(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\shiftOnnn\\>")

def lilypond_rule118(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\shiftOnn\\>")

def lilypond_rule119(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\shiftOn\\>")

def lilypond_rule120(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\shiftOff\\>")

def lilypond_rule121(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sfz\\>")

def lilypond_rule122(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sfp\\>")

def lilypond_rule123(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sff\\>")

def lilypond_rule124(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sf\\>")

def lilypond_rule125(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setTextDim\\>")

def lilypond_rule126(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setTextDecresc\\>")

def lilypond_rule127(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setTextCresc\\>")

def lilypond_rule128(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setMmRestFermata\\>")

def lilypond_rule129(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setHairpinCresc\\>")

def lilypond_rule130(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\setEasyHeads\\>")

def lilypond_rule131(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\set\\>")

def lilypond_rule132(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\sequential\\>")

def lilypond_rule133(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\semicirculus\\>")

def lilypond_rule134(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\semiGermanChords\\>")

def lilypond_rule135(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\segno\\>")

def lilypond_rule136(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\scriptUp\\>")

def lilypond_rule137(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\scriptDown\\>")

def lilypond_rule138(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\scriptBoth\\>")

def lilypond_rule139(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\score\\>")

def lilypond_rule140(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\rtoe\\>")

def lilypond_rule141(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\right\\>")

def lilypond_rule142(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\rheel\\>")

def lilypond_rule143(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\rfz\\>")

def lilypond_rule144(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\revert\\>")

def lilypond_rule145(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\reverseturn\\>")

def lilypond_rule146(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\rest\\>")

def lilypond_rule147(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\repeat\\>")

def lilypond_rule148(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\remove\\>")

def lilypond_rule149(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\relative\\>")

def lilypond_rule150(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\recordEventSequence\\>")

def lilypond_rule151(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\raggedright\\>")

def lilypond_rule152(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\raggedlast\\>")

def lilypond_rule153(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\quote\\>")

def lilypond_rule154(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\quilisma\\>")

def lilypond_rule155(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\pt\\>")

def lilypond_rule156(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\prallup\\>")

def lilypond_rule157(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\prallprall\\>")

def lilypond_rule158(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\prallmordent\\>")

def lilypond_rule159(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\pralldown\\>")

def lilypond_rule160(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\prall\\>")

def lilypond_rule161(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ppppp\\>")

def lilypond_rule162(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\pppp\\>")

def lilypond_rule163(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ppp\\>")

def lilypond_rule164(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\pp\\>")

def lilypond_rule165(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\portato\\>")

def lilypond_rule166(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\phrygian\\>")

def lilypond_rule167(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\phrasingSlurUp\\>")

def lilypond_rule168(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\phrasingSlurDown\\>")

def lilypond_rule169(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\phrasingSlurBoth\\>")

def lilypond_rule170(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\pes\\>")

def lilypond_rule171(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\partialJazzMusic\\>")

def lilypond_rule172(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\partialJazzExceptions\\>")

def lilypond_rule173(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\partial\\>")

def lilypond_rule174(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\partcombine\\>")

def lilypond_rule175(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\partCombineListener\\>")

def lilypond_rule176(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperTwentythree\\>")

def lilypond_rule177(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperTwentysix\\>")

def lilypond_rule178(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperTwenty\\>")

def lilypond_rule179(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperThirteen\\>")

def lilypond_rule180(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperSixteen\\>")

def lilypond_rule181(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperEleven\\>")

def lilypond_rule182(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paperEightteen\\>")

def lilypond_rule183(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\paper\\>")

def lilypond_rule184(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\packed\\>")

def lilypond_rule185(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\p\\>")

def lilypond_rule186(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\override\\>")

def lilypond_rule187(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\oriscus\\>")

def lilypond_rule188(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\open\\>")

def lilypond_rule189(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\oneVoice\\>")

def lilypond_rule190(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\once\\>")

def lilypond_rule191(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\octave\\>")

def lilypond_rule192(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\notes\\>")

def lilypond_rule193(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\normalsize\\>")

def lilypond_rule194(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\noBreak\\>")

def lilypond_rule195(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\noBeam\\>")

def lilypond_rule196(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\newpage\\>")

def lilypond_rule197(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\new\\>")

def lilypond_rule198(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\name\\>")

def lilypond_rule199(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mp\\>")

def lilypond_rule200(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mordent\\>")

def lilypond_rule201(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mm\\>")

def lilypond_rule202(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mixolydian\\>")

def lilypond_rule203(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\minor\\>")

def lilypond_rule204(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\midi\\>")

def lilypond_rule205(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mf\\>")

def lilypond_rule206(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\melismaEnd\\>")

def lilypond_rule207(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\melisma\\>")

def lilypond_rule208(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\maxima\\>")

def lilypond_rule209(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\markup\\>")

def lilypond_rule210(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\mark\\>")

def lilypond_rule211(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\marcato\\>")

def lilypond_rule212(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\major\\>")

def lilypond_rule213(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\maininput\\>")

def lilypond_rule214(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\lyricsto\\>")

def lilypond_rule215(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\lyrics\\>")

def lilypond_rule216(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\lydian\\>")

def lilypond_rule217(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ltoe\\>")

def lilypond_rule218(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\longfermata\\>")

def lilypond_rule219(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\longa\\>")

def lilypond_rule220(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\locrian\\>")

def lilypond_rule221(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\lineprall\\>")

def lilypond_rule222(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\linea\\>")

def lilypond_rule223(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\lheel\\>")

def lilypond_rule224(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\left\\>")

def lilypond_rule225(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\key\\>")

def lilypond_rule226(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ionian\\>")

def lilypond_rule227(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\include\\>")

def lilypond_rule228(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\inclinatum\\>")

def lilypond_rule229(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\in\\>")

def lilypond_rule230(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ignatzekExceptions\\>")

def lilypond_rule231(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ignatzekExceptionMusic\\>")

def lilypond_rule232(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ictus\\>")

def lilypond_rule233(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\hsize\\>")

def lilypond_rule234(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\hideStaffSwitch\\>")

def lilypond_rule235(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\hideNotes\\>")

def lilypond_rule236(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\header\\>")

def lilypond_rule237(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\harmonic\\>")

def lilypond_rule238(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\grobdescriptions\\>")

def lilypond_rule239(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\grace\\>")

def lilypond_rule240(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\glissando\\>")

def lilypond_rule241(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\germanChords\\>")

def lilypond_rule242(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fz\\>")

def lilypond_rule243(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fullJazzExceptions\\>")

def lilypond_rule244(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fp\\>")

def lilypond_rule245(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\flexa\\>")

def lilypond_rule246(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\flageolet\\>")

def lilypond_rule247(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\finalis\\>")

def lilypond_rule248(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\figures\\>")

def lilypond_rule249(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ffff\\>")

def lilypond_rule250(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fff\\>")

def lilypond_rule251(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ff\\>")

def lilypond_rule252(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fermataMarkup\\>")

def lilypond_rule253(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fermata\\>")

def lilypond_rule254(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\fatText\\>")

def lilypond_rule255(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\f\\>")

def lilypond_rule256(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\episemInitium\\>")

def lilypond_rule257(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\episemFinis\\>")

def lilypond_rule258(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\endincipit\\>")

def lilypond_rule259(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\enddim\\>")

def lilypond_rule260(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\enddecr\\>")

def lilypond_rule261(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\endcresc\\>")

def lilypond_rule262(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\endcr\\>")

def lilypond_rule263(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\emptyText\\>")

def lilypond_rule264(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dynamicUp\\>")

def lilypond_rule265(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dynamicDown\\>")

def lilypond_rule266(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dynamicBoth\\>")

def lilypond_rule267(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\drums\\>")

def lilypond_rule268(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\downprall\\>")

def lilypond_rule269(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\downmordent\\>")

def lilypond_rule270(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\downbow\\>")

def lilypond_rule271(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\down\\>")

def lilypond_rule272(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dotsUp\\>")

def lilypond_rule273(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dotsDown\\>")

def lilypond_rule274(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dotsBoth\\>")

def lilypond_rule275(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dorian\\>")

def lilypond_rule276(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\divisioMinima\\>")

def lilypond_rule277(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\divisioMaxima\\>")

def lilypond_rule278(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\divisioMaior\\>")

def lilypond_rule279(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dim\\>")

def lilypond_rule280(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\description\\>")

def lilypond_rule281(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\descendens\\>")

def lilypond_rule282(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\denies\\>")

def lilypond_rule283(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\deminutum\\>")

def lilypond_rule284(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\default\\>")

def lilypond_rule285(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\decr\\>")

def lilypond_rule286(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashUnderscore\\>")

def lilypond_rule287(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashPlus\\>")

def lilypond_rule288(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashLarger\\>")

def lilypond_rule289(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashHat\\>")

def lilypond_rule290(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashDot\\>")

def lilypond_rule291(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashDash\\>")

def lilypond_rule292(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\dashBar\\>")

def lilypond_rule293(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cresc\\>")

def lilypond_rule294(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cr\\>")

def lilypond_rule295(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\context\\>")

def lilypond_rule296(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\consistsend\\>")

def lilypond_rule297(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\consists\\>")

def lilypond_rule298(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\coda\\>")

def lilypond_rule299(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cm\\>")

def lilypond_rule300(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\clef\\>")

def lilypond_rule301(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\circulus\\>")

def lilypond_rule302(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\chords\\>")

def lilypond_rule303(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\chordmodifiers\\>")

def lilypond_rule304(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\change\\>")

def lilypond_rule305(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\center\\>")

def lilypond_rule306(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cavum\\>")

def lilypond_rule307(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\caesura\\>")

def lilypond_rule308(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cadenzaOn\\>")

def lilypond_rule309(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\cadenzaOff\\>")

def lilypond_rule310(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\breve\\>")

def lilypond_rule311(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\breathe\\>")

def lilypond_rule312(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\break\\>")

def lilypond_rule313(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\blackTriangleMarkup\\>")

def lilypond_rule314(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\bigger\\>")

def lilypond_rule315(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\bar\\>")

def lilypond_rule316(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\autochange\\>")

def lilypond_rule317(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\autoBeamOn\\>")

def lilypond_rule318(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\autoBeamOff\\>")

def lilypond_rule319(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\auctum\\>")

def lilypond_rule320(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\ascendens\\>")

def lilypond_rule321(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\arpeggioUp\\>")

def lilypond_rule322(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\arpeggioDown\\>")

def lilypond_rule323(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\arpeggioBracket\\>")

def lilypond_rule324(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\arpeggioBoth\\>")

def lilypond_rule325(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\arpeggio\\>")

def lilypond_rule326(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\appoggiatura\\>")

def lilypond_rule327(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\applyoutput\\>")

def lilypond_rule328(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\applycontext\\>")

def lilypond_rule329(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\apply\\>")

def lilypond_rule330(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\alternative\\>")

def lilypond_rule331(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\alias\\>")

def lilypond_rule332(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\aeolian\\>")

def lilypond_rule333(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\addquote\\>")

def lilypond_rule334(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\addlyrics\\>")

def lilypond_rule335(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\acciaccatura\\>")

def lilypond_rule336(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\accepts\\>")

def lilypond_rule337(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\accentus\\>")

def lilypond_rule338(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword1", regexp="\\\\accent\\>")

def lilypond_rule339(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword2", regexp="\\\\RemoveEmptyStaffContext\\>")

def lilypond_rule340(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword2", regexp="\\\\OrchestralScoreContext\\>")

def lilypond_rule341(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword2", regexp="\\\\EasyNotation\\>")

def lilypond_rule342(colorer, s, i):
    return colorer.match_seq_regexp(s, i, kind="keyword2", regexp="\\\\AncientRemoveEmptyStaffContext\\>")

def lilypond_rule343(colorer, s, i):
    return colorer.match_mark_following(s, i, kind="function", pattern="\\")

def lilypond_rule344(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for lilypond_main ruleset.
rulesDict1 = {
    "\"": [lilypond_rule20,],
    "#": [lilypond_rule10,],
    "%": [lilypond_rule0, lilypond_rule1,],
    "'": [lilypond_rule22,],
    ",": [lilypond_rule23,],
    "-": [lilypond_rule17, lilypond_rule18, lilypond_rule21,],
    "0": [lilypond_rule36, lilypond_rule344,],
    "1": [lilypond_rule27, lilypond_rule344,],
    "2": [lilypond_rule28, lilypond_rule344,],
    "3": [lilypond_rule29, lilypond_rule344,],
    "4": [lilypond_rule30, lilypond_rule344,],
    "5": [lilypond_rule31, lilypond_rule344,],
    "6": [lilypond_rule32, lilypond_rule344,],
    "7": [lilypond_rule33, lilypond_rule344,],
    "8": [lilypond_rule34, lilypond_rule344,],
    "9": [lilypond_rule35, lilypond_rule344,],
    "<": [lilypond_rule15,],
    "=": [lilypond_rule8, lilypond_rule9,],
    ">": [lilypond_rule16,],
    "@": [lilypond_rule344,],
    "A": [lilypond_rule344,],
    "B": [lilypond_rule344,],
    "C": [lilypond_rule344,],
    "D": [lilypond_rule344,],
    "E": [lilypond_rule344,],
    "F": [lilypond_rule344,],
    "G": [lilypond_rule344,],
    "H": [lilypond_rule344,],
    "I": [lilypond_rule344,],
    "J": [lilypond_rule344,],
    "K": [lilypond_rule344,],
    "L": [lilypond_rule344,],
    "M": [lilypond_rule344,],
    "N": [lilypond_rule344,],
    "O": [lilypond_rule344,],
    "P": [lilypond_rule344,],
    "Q": [lilypond_rule344,],
    "R": [lilypond_rule25, lilypond_rule344,],
    "S": [lilypond_rule344,],
    "T": [lilypond_rule344,],
    "U": [lilypond_rule344,],
    "V": [lilypond_rule344,],
    "W": [lilypond_rule344,],
    "X": [lilypond_rule344,],
    "Y": [lilypond_rule344,],
    "Z": [lilypond_rule344,],
    "[": [lilypond_rule13,],
    "\\": [lilypond_rule2, lilypond_rule3, lilypond_rule4, lilypond_rule5, lilypond_rule6, lilypond_rule7, lilypond_rule37, lilypond_rule38, lilypond_rule39, lilypond_rule40, lilypond_rule41, lilypond_rule42, lilypond_rule43, lilypond_rule44, lilypond_rule45, lilypond_rule46, lilypond_rule47, lilypond_rule48, lilypond_rule49, lilypond_rule50, lilypond_rule51, lilypond_rule52, lilypond_rule53, lilypond_rule54, lilypond_rule55, lilypond_rule56, lilypond_rule57, lilypond_rule58, lilypond_rule59, lilypond_rule60, lilypond_rule61, lilypond_rule62, lilypond_rule63, lilypond_rule64, lilypond_rule65, lilypond_rule66, lilypond_rule67, lilypond_rule68, lilypond_rule69, lilypond_rule70, lilypond_rule71, lilypond_rule72, lilypond_rule73, lilypond_rule74, lilypond_rule75, lilypond_rule76, lilypond_rule77, lilypond_rule78, lilypond_rule79, lilypond_rule80, lilypond_rule81, lilypond_rule82, lilypond_rule83, lilypond_rule84, lilypond_rule85, lilypond_rule86, lilypond_rule87, lilypond_rule88, lilypond_rule89, lilypond_rule90, lilypond_rule91, lilypond_rule92, lilypond_rule93, lilypond_rule94, lilypond_rule95, lilypond_rule96, lilypond_rule97, lilypond_rule98, lilypond_rule99, lilypond_rule100, lilypond_rule101, lilypond_rule102, lilypond_rule103, lilypond_rule104, lilypond_rule105, lilypond_rule106, lilypond_rule107, lilypond_rule108, lilypond_rule109, lilypond_rule110, lilypond_rule111, lilypond_rule112, lilypond_rule113, lilypond_rule114, lilypond_rule115, lilypond_rule116, lilypond_rule117, lilypond_rule118, lilypond_rule119, lilypond_rule120, lilypond_rule121, lilypond_rule122, lilypond_rule123, lilypond_rule124, lilypond_rule125, lilypond_rule126, lilypond_rule127, lilypond_rule128, lilypond_rule129, lilypond_rule130, lilypond_rule131, lilypond_rule132, lilypond_rule133, lilypond_rule134, lilypond_rule135, lilypond_rule136, lilypond_rule137, lilypond_rule138, lilypond_rule139, lilypond_rule140, lilypond_rule141, lilypond_rule142, lilypond_rule143, lilypond_rule144, lilypond_rule145, lilypond_rule146, lilypond_rule147, lilypond_rule148, lilypond_rule149, lilypond_rule150, lilypond_rule151, lilypond_rule152, lilypond_rule153, lilypond_rule154, lilypond_rule155, lilypond_rule156, lilypond_rule157, lilypond_rule158, lilypond_rule159, lilypond_rule160, lilypond_rule161, lilypond_rule162, lilypond_rule163, lilypond_rule164, lilypond_rule165, lilypond_rule166, lilypond_rule167, lilypond_rule168, lilypond_rule169, lilypond_rule170, lilypond_rule171, lilypond_rule172, lilypond_rule173, lilypond_rule174, lilypond_rule175, lilypond_rule176, lilypond_rule177, lilypond_rule178, lilypond_rule179, lilypond_rule180, lilypond_rule181, lilypond_rule182, lilypond_rule183, lilypond_rule184, lilypond_rule185, lilypond_rule186, lilypond_rule187, lilypond_rule188, lilypond_rule189, lilypond_rule190, lilypond_rule191, lilypond_rule192, lilypond_rule193, lilypond_rule194, lilypond_rule195, lilypond_rule196, lilypond_rule197, lilypond_rule198, lilypond_rule199, lilypond_rule200, lilypond_rule201, lilypond_rule202, lilypond_rule203, lilypond_rule204, lilypond_rule205, lilypond_rule206, lilypond_rule207, lilypond_rule208, lilypond_rule209, lilypond_rule210, lilypond_rule211, lilypond_rule212, lilypond_rule213, lilypond_rule214, lilypond_rule215, lilypond_rule216, lilypond_rule217, lilypond_rule218, lilypond_rule219, lilypond_rule220, lilypond_rule221, lilypond_rule222, lilypond_rule223, lilypond_rule224, lilypond_rule225, lilypond_rule226, lilypond_rule227, lilypond_rule228, lilypond_rule229, lilypond_rule230, lilypond_rule231, lilypond_rule232, lilypond_rule233, lilypond_rule234, lilypond_rule235, lilypond_rule236, lilypond_rule237, lilypond_rule238, lilypond_rule239, lilypond_rule240, lilypond_rule241, lilypond_rule242, lilypond_rule243, lilypond_rule244, lilypond_rule245, lilypond_rule246, lilypond_rule247, lilypond_rule248, lilypond_rule249, lilypond_rule250, lilypond_rule251, lilypond_rule252, lilypond_rule253, lilypond_rule254, lilypond_rule255, lilypond_rule256, lilypond_rule257, lilypond_rule258, lilypond_rule259, lilypond_rule260, lilypond_rule261, lilypond_rule262, lilypond_rule263, lilypond_rule264, lilypond_rule265, lilypond_rule266, lilypond_rule267, lilypond_rule268, lilypond_rule269, lilypond_rule270, lilypond_rule271, lilypond_rule272, lilypond_rule273, lilypond_rule274, lilypond_rule275, lilypond_rule276, lilypond_rule277, lilypond_rule278, lilypond_rule279, lilypond_rule280, lilypond_rule281, lilypond_rule282, lilypond_rule283, lilypond_rule284, lilypond_rule285, lilypond_rule286, lilypond_rule287, lilypond_rule288, lilypond_rule289, lilypond_rule290, lilypond_rule291, lilypond_rule292, lilypond_rule293, lilypond_rule294, lilypond_rule295, lilypond_rule296, lilypond_rule297, lilypond_rule298, lilypond_rule299, lilypond_rule300, lilypond_rule301, lilypond_rule302, lilypond_rule303, lilypond_rule304, lilypond_rule305, lilypond_rule306, lilypond_rule307, lilypond_rule308, lilypond_rule309, lilypond_rule310, lilypond_rule311, lilypond_rule312, lilypond_rule313, lilypond_rule314, lilypond_rule315, lilypond_rule316, lilypond_rule317, lilypond_rule318, lilypond_rule319, lilypond_rule320, lilypond_rule321, lilypond_rule322, lilypond_rule323, lilypond_rule324, lilypond_rule325, lilypond_rule326, lilypond_rule327, lilypond_rule328, lilypond_rule329, lilypond_rule330, lilypond_rule331, lilypond_rule332, lilypond_rule333, lilypond_rule334, lilypond_rule335, lilypond_rule336, lilypond_rule337, lilypond_rule338, lilypond_rule339, lilypond_rule340, lilypond_rule341, lilypond_rule342, lilypond_rule343,],
    "]": [lilypond_rule14,],
    "_": [lilypond_rule344,],
    "a": [lilypond_rule344,],
    "b": [lilypond_rule344,],
    "c": [lilypond_rule344,],
    "d": [lilypond_rule344,],
    "e": [lilypond_rule344,],
    "f": [lilypond_rule344,],
    "g": [lilypond_rule344,],
    "h": [lilypond_rule344,],
    "i": [lilypond_rule344,],
    "j": [lilypond_rule344,],
    "k": [lilypond_rule344,],
    "l": [lilypond_rule344,],
    "m": [lilypond_rule344,],
    "n": [lilypond_rule344,],
    "o": [lilypond_rule344,],
    "p": [lilypond_rule344,],
    "q": [lilypond_rule344,],
    "r": [lilypond_rule24, lilypond_rule344,],
    "s": [lilypond_rule26, lilypond_rule344,],
    "t": [lilypond_rule344,],
    "u": [lilypond_rule344,],
    "v": [lilypond_rule344,],
    "w": [lilypond_rule344,],
    "x": [lilypond_rule344,],
    "y": [lilypond_rule344,],
    "z": [lilypond_rule344,],
    "{": [lilypond_rule11,],
    "|": [lilypond_rule19,],
    "}": [lilypond_rule12,],
}

# x.rulesDictDict for lilypond mode.
rulesDictDict = {
    "lilypond_main": rulesDict1,
}

# Import dict for lilypond mode.
importDict = {}
