# Leo colorizer control file for ahk mode.
# This file is in the public domain.

# Properties for ahk mode.
properties = {
    "doubleBracketIndent": "false",
    "indentCloseBrackets": "}",
    "indentOpenBrackets": "{",
    "lineComment": ";",
    "lineUpClosingBracket": "true",
    "wordBreakChars": ",+-=<>/?^&*",
}

# Attributes dict for ahk_main ruleset.
ahk_main_attributes_dict = {
    "default": "null",
    "digit_re": "(0x[[:xdigit:]]+[lL]?|[[:digit:]]+(e[[:digit:]]*)?[lLdDfF]?)",
    "escape": "`",
    "highlight_digits": "true",
    "ignore_case": "true",
    "no_word_sep": "",
}

# Dictionary of attributes dictionaries for ahk mode.
attributesDictDict = {
    "ahk_main": ahk_main_attributes_dict,
}

# Keywords dict for ahk_main ruleset.
ahk_main_keywords_dict = {
    "!": "literal2",
    "#": "literal2",
    "#allowsamelinecomments": "keyword1",
    "#clipboardtimeout": "keyword1",
    "#commentflag": "keyword1",
    "#errorstdout": "keyword1",
    "#escapechar": "keyword1",
    "#hotkeyinterval": "keyword1",
    "#hotkeymodifiertimeout": "keyword1",
    "#hotstring": "keyword1",
    "#ifwinactive": "keyword1",
    "#ifwinexist": "keyword1",
    "#ifwinnotactive": "keyword1",
    "#ifwinnotexist": "keyword1",
    "#include": "keyword1",
    "#includeagain": "keyword1",
    "#installkeybdhook": "keyword1",
    "#installmousehook": "keyword1",
    "#keyhistory": "keyword1",
    "#ltrim": "keyword1",
    "#maxhotkeysperinterval": "keyword1",
    "#maxmem": "keyword1",
    "#maxthreads": "keyword1",
    "#maxthreadsbuffer": "keyword1",
    "#maxthreadsperhotkey": "keyword1",
    "#noenv": "keyword1",
    "#notrayicon": "keyword1",
    "#persistent": "keyword1",
    "#singleinstance": "keyword1",
    "#usehook": "keyword1",
    "#winactivateforce": "keyword1",
    "$": "literal2",
    "+": "literal2",
    "^": "literal2",
    "`": "literal2",
    "a_ahkpath": "keyword3",
    "a_ahkversion": "keyword3",
    "a_appdata": "keyword3",
    "a_appdatacommon": "keyword3",
    "a_autotrim": "keyword3",
    "a_batchlines": "keyword3",
    "a_caretx": "keyword3",
    "a_carety": "keyword3",
    "a_computername": "keyword3",
    "a_controldelay": "keyword3",
    "a_cursor": "keyword3",
    "a_dd": "keyword3",
    "a_ddd": "keyword3",
    "a_dddd": "keyword3",
    "a_defaultmousespeed": "keyword3",
    "a_desktop": "keyword3",
    "a_desktopcommon": "keyword3",
    "a_detecthiddentext": "keyword3",
    "a_detecthiddenwindows": "keyword3",
    "a_endchar": "keyword3",
    "a_eventinfo": "keyword3",
    "a_exitreason": "keyword3",
    "a_formatfloat": "keyword3",
    "a_formatinteger": "keyword3",
    "a_gui": "keyword3",
    "a_guicontrol": "keyword3",
    "a_guicontrolevent": "keyword3",
    "a_guievent": "keyword3",
    "a_guiheight": "keyword3",
    "a_guiwidth": "keyword3",
    "a_guix": "keyword3",
    "a_guiy": "keyword3",
    "a_hour": "keyword3",
    "a_iconfile": "keyword3",
    "a_iconhidden": "keyword3",
    "a_iconnumber": "keyword3",
    "a_icontip": "keyword3",
    "a_index": "keyword3",
    "a_ipaddress1": "keyword3",
    "a_ipaddress2": "keyword3",
    "a_ipaddress3": "keyword3",
    "a_ipaddress4": "keyword3",
    "a_isadmin": "keyword3",
    "a_iscompiled": "keyword3",
    "a_issuspended": "keyword3",
    "a_keydelay": "keyword3",
    "a_language": "keyword3",
    "a_lasterror": "keyword3",
    "a_linefile": "keyword3",
    "a_linenumber": "keyword3",
    "a_loopfield": "keyword3",
    "a_loopfileattrib": "keyword3",
    "a_loopfiledir": "keyword3",
    "a_loopfileext": "keyword3",
    "a_loopfilefullpath": "keyword3",
    "a_loopfilelongpath": "keyword3",
    "a_loopfilename": "keyword3",
    "a_loopfileshortname": "keyword3",
    "a_loopfileshortpath": "keyword3",
    "a_loopfilesize": "keyword3",
    "a_loopfilesizekb": "keyword3",
    "a_loopfilesizemb": "keyword3",
    "a_loopfiletimeaccessed": "keyword3",
    "a_loopfiletimecreated": "keyword3",
    "a_loopfiletimemodified": "keyword3",
    "a_loopreadline": "keyword3",
    "a_loopregkey": "keyword3",
    "a_loopregname": "keyword3",
    "a_loopregsubkey": "keyword3",
    "a_loopregtimemodified": "keyword3",
    "a_loopregtype": "keyword3",
    "a_mday": "keyword3",
    "a_min": "keyword3",
    "a_mm": "keyword3",
    "a_mmm": "keyword3",
    "a_mmmm": "keyword3",
    "a_mon": "keyword3",
    "a_mousedelay": "keyword3",
    "a_msec": "keyword3",
    "a_mydocuments": "keyword3",
    "a_now": "keyword3",
    "a_nowutc": "keyword3",
    "a_numbatchlines": "keyword3",
    "a_ostype": "keyword3",
    "a_osversion": "keyword3",
    "a_priorhotkey": "keyword3",
    "a_programfiles": "keyword3",
    "a_programs": "keyword3",
    "a_programscommon": "keyword3",
    "a_screenheight": "keyword3",
    "a_screenwidth": "keyword3",
    "a_scriptdir": "keyword3",
    "a_scriptfullpath": "keyword3",
    "a_scriptname": "keyword3",
    "a_sec": "keyword3",
    "a_space": "keyword3",
    "a_startmenu": "keyword3",
    "a_startmenucommon": "keyword3",
    "a_startup": "keyword3",
    "a_startupcommon": "keyword3",
    "a_stringcasesense": "keyword3",
    "a_tab": "keyword3",
    "a_temp": "keyword3",
    "a_thisfunc": "keyword3",
    "a_thishotkey": "keyword3",
    "a_thislabel": "keyword3",
    "a_thismenu": "keyword3",
    "a_thismenuitem": "keyword3",
    "a_thismenuitempos": "keyword3",
    "a_tickcount": "keyword3",
    "a_timeidle": "keyword3",
    "a_timeidlephysical": "keyword3",
    "a_timesincepriorhotkey": "keyword3",
    "a_timesincethishotkey": "keyword3",
    "a_titlematchmode": "keyword3",
    "a_titlematchmodespeed": "keyword3",
    "a_username": "keyword3",
    "a_wday": "keyword3",
    "a_windelay": "keyword3",
    "a_windir": "keyword3",
    "a_workingdir": "keyword3",
    "a_yday": "keyword3",
    "a_year": "keyword3",
    "a_yweek": "keyword3",
    "a_yyyy": "keyword3",
    "abort": "keyword2",
    "abovenormal": "keyword2",
    "abs": "keyword2",
    "acos": "keyword2",
    "add": "keyword2",
    "ahk_class": "keyword2",
    "ahk_group": "keyword2",
    "ahk_id": "keyword2",
    "ahk_pid": "keyword2",
    "all": "keyword2",
    "alnum": "keyword2",
    "alpha": "keyword2",
    "alt": "literal2",
    "altdown": "literal2",
    "altsubmit": "keyword2",
    "alttab": "keyword2",
    "alttabandmenu": "keyword2",
    "alttabmenu": "keyword2",
    "alttabmenudismiss": "keyword2",
    "altup": "literal2",
    "alwaysontop": "keyword2",
    "and": "keyword2",
    "appskey": "literal2",
    "asc": "keyword2",
    "asin": "keyword2",
    "atan": "keyword2",
    "autosize": "keyword2",
    "autotrim": "keyword1",
    "background": "keyword2",
    "backgroundtrans": "keyword2",
    "backspace": "literal2",
    "belownormal": "keyword2",
    "between": "keyword2",
    "bitand": "keyword2",
    "bitnot": "keyword2",
    "bitor": "keyword2",
    "bitshiftleft": "keyword2",
    "bitshiftright": "keyword2",
    "bitxor": "keyword2",
    "blockinput": "keyword1",
    "bold": "keyword2",
    "border": "keyword2",
    "bottom": "keyword2",
    "break": "keyword1",
    "browser_back": "literal2",
    "browser_favorites": "literal2",
    "browser_forward": "literal2",
    "browser_home": "literal2",
    "browser_refresh": "literal2",
    "browser_search": "literal2",
    "browser_stop": "literal2",
    "bs": "literal2",
    "button": "keyword2",
    "buttons": "keyword2",
    "byref": "keyword2",
    "cancel": "keyword2",
    "capacity": "keyword2",
    "capslock": "literal2",
    "caption": "keyword2",
    "ceil": "keyword2",
    "center": "keyword2",
    "check": "keyword2",
    "check3": "keyword2",
    "checkbox": "keyword2",
    "checked": "keyword2",
    "checkedgray": "keyword2",
    "choose": "keyword2",
    "choosestring": "keyword2",
    "chr": "keyword2",
    "click": "keyword2",
    "clipboard": "keyword3",
    "clipboardall": "keyword3",
    "clipwait": "keyword1",
    "close": "keyword2",
    "color": "keyword2",
    "combobox": "keyword2",
    "comspec": "keyword3",
    "contains": "keyword2",
    "continue": "keyword1",
    "control": "literal2",
    "controlclick": "keyword1",
    "controlfocus": "keyword1",
    "controlget": "keyword1",
    "controlgetfocus": "keyword1",
    "controlgetpos": "keyword1",
    "controlgettext": "keyword1",
    "controllist": "keyword2",
    "controlmove": "keyword1",
    "controlsend": "keyword1",
    "controlsendraw": "keyword1",
    "controlsettext": "keyword1",
    "coordmode": "keyword1",
    "cos": "keyword2",
    "count": "keyword2",
    "critical": "keyword1",
    "ctrl": "literal2",
    "ctrlbreak": "literal2",
    "ctrldown": "literal2",
    "ctrlup": "literal2",
    "date": "keyword2",
    "datetime": "keyword2",
    "days": "keyword2",
    "ddl": "keyword2",
    "default": "keyword2",
    "del": "literal2",
    "delete": "literal2",
    "deleteall": "keyword2",
    "delimiter": "keyword2",
    "deref": "keyword2",
    "destroy": "keyword2",
    "detecthiddentext": "keyword1",
    "detecthiddenwindows": "keyword1",
    "digit": "keyword2",
    "disable": "keyword2",
    "disabled": "keyword2",
    "down": "literal2",
    "drive": "keyword1",
    "driveget": "keyword1",
    "drivespacefree": "keyword1",
    "dropdownlist": "keyword2",
    "edit": "keyword1",
    "eject": "keyword2",
    "else": "keyword1",
    "enable": "keyword2",
    "enabled": "keyword2",
    "end": "literal2",
    "enter": "literal2",
    "envadd": "keyword1",
    "envdiv": "keyword1",
    "envget": "keyword1",
    "envmult": "keyword1",
    "envset": "keyword1",
    "envsub": "keyword1",
    "envupdate": "keyword1",
    "error": "keyword2",
    "errorlevel": "keyword3",
    "esc": "literal2",
    "escape": "literal2",
    "exist": "keyword2",
    "exit": "keyword1",
    "exitapp": "keyword1",
    "exp": "keyword2",
    "expand": "keyword2",
    "exstyle": "keyword2",
    "f1": "literal2",
    "f10": "literal2",
    "f11": "literal2",
    "f12": "literal2",
    "f13": "literal2",
    "f14": "literal2",
    "f15": "literal2",
    "f16": "literal2",
    "f17": "literal2",
    "f18": "literal2",
    "f19": "literal2",
    "f2": "literal2",
    "f20": "literal2",
    "f21": "literal2",
    "f22": "literal2",
    "f23": "literal2",
    "f24": "literal2",
    "f3": "literal2",
    "f4": "literal2",
    "f5": "literal2",
    "f6": "literal2",
    "f7": "literal2",
    "f8": "literal2",
    "f9": "literal2",
    "false": "keyword3",
    "fileappend": "keyword1",
    "filecopy": "keyword1",
    "filecopydir": "keyword1",
    "filecreatedir": "keyword1",
    "filecreateshortcut": "keyword1",
    "filedelete": "keyword1",
    "filegetattrib": "keyword1",
    "filegetshortcut": "keyword1",
    "filegetsize": "keyword1",
    "filegettime": "keyword1",
    "filegetversion": "keyword1",
    "fileinstall": "keyword1",
    "filemove": "keyword1",
    "filemovedir": "keyword1",
    "fileread": "keyword1",
    "filereadline": "keyword1",
    "filerecycle": "keyword1",
    "filerecycleempty": "keyword1",
    "fileremovedir": "keyword1",
    "fileselectfile": "keyword1",
    "fileselectfolder": "keyword1",
    "filesetattrib": "keyword1",
    "filesettime": "keyword1",
    "filesystem": "keyword2",
    "first": "keyword2",
    "flash": "keyword2",
    "float": "keyword2",
    "floor": "keyword2",
    "focus": "keyword2",
    "font": "keyword2",
    "formattime": "keyword1",
    "getkeystate": "keyword1",
    "global": "keyword2",
    "gosub": "keyword1",
    "goto": "keyword1",
    "grid": "keyword2",
    "group": "keyword2",
    "groupactivate": "keyword1",
    "groupadd": "keyword1",
    "groupbox": "keyword2",
    "groupclose": "keyword1",
    "groupdeactivate": "keyword1",
    "gui": "keyword1",
    "guiclose": "keyword2",
    "guicontextmenu": "keyword2",
    "guicontrol": "keyword1",
    "guicontrolget": "keyword1",
    "guidropfiles": "keyword2",
    "guiescape": "keyword2",
    "guisize": "keyword2",
    "hdr": "keyword2",
    "hidden": "keyword2",
    "hide": "keyword2",
    "high": "keyword2",
    "hkcc": "keyword2",
    "hkcr": "keyword2",
    "hkcu": "keyword2",
    "hkey_classes_root": "keyword2",
    "hkey_current_config": "keyword2",
    "hkey_current_user": "keyword2",
    "hkey_local_machine": "keyword2",
    "hkey_users": "keyword2",
    "hklm": "keyword2",
    "hku": "keyword2",
    "home": "literal2",
    "hotkey": "keyword1",
    "hours": "keyword2",
    "hscroll": "keyword2",
    "icon": "keyword2",
    "iconsmall": "keyword2",
    "id": "keyword2",
    "idlast": "keyword2",
    "if": "keyword1",
    "ifequal": "keyword1",
    "ifexist": "keyword1",
    "ifgreater": "keyword1",
    "ifgreaterorequal": "keyword1",
    "ifinstring": "keyword1",
    "ifless": "keyword1",
    "iflessorequal": "keyword1",
    "ifmsgbox": "keyword1",
    "ifnotequal": "keyword1",
    "ifnotexist": "keyword1",
    "ifnotinstring": "keyword1",
    "ifwinactive": "keyword1",
    "ifwinexist": "keyword1",
    "ifwinnotactive": "keyword1",
    "ifwinnotexist": "keyword1",
    "ignore": "keyword2",
    "imagelist": "keyword2",
    "imagesearch": "keyword1",
    "in": "keyword2",
    "inidelete": "keyword1",
    "iniread": "keyword1",
    "iniwrite": "keyword1",
    "input": "keyword1",
    "inputbox": "keyword1",
    "ins": "literal2",
    "insert": "literal2",
    "integer": "keyword2",
    "interrupt": "keyword2",
    "is": "keyword2",
    "italic": "keyword2",
    "join": "keyword2",
    "joy1": "literal2",
    "joy10": "literal2",
    "joy11": "literal2",
    "joy12": "literal2",
    "joy13": "literal2",
    "joy14": "literal2",
    "joy15": "literal2",
    "joy16": "literal2",
    "joy17": "literal2",
    "joy18": "literal2",
    "joy19": "literal2",
    "joy2": "literal2",
    "joy20": "literal2",
    "joy21": "literal2",
    "joy22": "literal2",
    "joy23": "literal2",
    "joy24": "literal2",
    "joy25": "literal2",
    "joy26": "literal2",
    "joy27": "literal2",
    "joy28": "literal2",
    "joy29": "literal2",
    "joy3": "literal2",
    "joy30": "literal2",
    "joy31": "literal2",
    "joy32": "literal2",
    "joy4": "literal2",
    "joy5": "literal2",
    "joy6": "literal2",
    "joy7": "literal2",
    "joy8": "literal2",
    "joy9": "literal2",
    "joyaxes": "literal2",
    "joybuttons": "literal2",
    "joyinfo": "literal2",
    "joyname": "literal2",
    "joypov": "literal2",
    "joyr": "literal2",
    "joyu": "literal2",
    "joyv": "literal2",
    "joyx": "literal2",
    "joyy": "literal2",
    "joyz": "literal2",
    "keyhistory": "keyword1",
    "keywait": "keyword1",
    "label": "keyword2",
    "lalt": "literal2",
    "lastfound": "keyword2",
    "lastfoundexist": "keyword2",
    "launch_app1": "literal2",
    "launch_app2": "literal2",
    "launch_mail": "literal2",
    "launch_media": "literal2",
    "lbutton": "literal2",
    "lcontrol": "literal2",
    "lctrl": "literal2",
    "left": "literal2",
    "limit": "keyword2",
    "lines": "keyword2",
    "list": "keyword2",
    "listbox": "keyword2",
    "listhotkeys": "keyword1",
    "listlines": "keyword1",
    "listvars": "keyword1",
    "listview": "keyword2",
    "ln": "keyword2",
    "local": "keyword2",
    "lock": "keyword2",
    "log": "keyword2",
    "logoff": "keyword2",
    "loop": "keyword1",
    "low": "keyword2",
    "lower": "keyword2",
    "lowercase": "keyword2",
    "lshift": "literal2",
    "ltrim": "keyword2",
    "lwin": "literal2",
    "lwindown": "literal2",
    "lwinup": "literal2",
    "mainwindow": "keyword2",
    "margin": "keyword2",
    "maximize": "keyword2",
    "maximizebox": "keyword2",
    "maxsize": "keyword2",
    "mbutton": "literal2",
    "media_next": "literal2",
    "media_play_pause": "literal2",
    "media_prev": "literal2",
    "media_stop": "literal2",
    "menu": "keyword1",
    "minimize": "keyword2",
    "minimizebox": "keyword2",
    "minmax": "keyword2",
    "minsize": "keyword2",
    "minutes": "keyword2",
    "mod": "keyword2",
    "monthcal": "keyword2",
    "mouse": "keyword2",
    "mouseclick": "keyword1",
    "mouseclickdrag": "keyword1",
    "mousegetpos": "keyword1",
    "mousemove": "keyword1",
    "move": "keyword2",
    "msgbox": "keyword1",
    "multi": "keyword2",
    "na": "keyword2",
    "no": "keyword2",
    "noactivate": "keyword2",
    "nodefault": "keyword2",
    "nohide": "keyword2",
    "noicon": "keyword2",
    "nomainwindow": "keyword2",
    "norm": "keyword2",
    "normal": "keyword2",
    "nosort": "keyword2",
    "nosorthdr": "keyword2",
    "nostandard": "keyword2",
    "not": "keyword2",
    "notab": "keyword2",
    "notimers": "keyword2",
    "number": "keyword2",
    "numlock": "literal2",
    "numpad0": "literal2",
    "numpad1": "literal2",
    "numpad2": "literal2",
    "numpad3": "literal2",
    "numpad4": "literal2",
    "numpad5": "literal2",
    "numpad6": "literal2",
    "numpad7": "literal2",
    "numpad8": "literal2",
    "numpad9": "literal2",
    "numpadadd": "literal2",
    "numpadclear": "literal2",
    "numpaddel": "literal2",
    "numpaddiv": "literal2",
    "numpaddot": "literal2",
    "numpaddown": "literal2",
    "numpadend": "literal2",
    "numpadenter": "literal2",
    "numpadhome": "literal2",
    "numpadins": "literal2",
    "numpadleft": "literal2",
    "numpadmult": "literal2",
    "numpadpgdn": "literal2",
    "numpadpgup": "literal2",
    "numpadright": "literal2",
    "numpadsub": "literal2",
    "numpadup": "literal2",
    "off": "keyword2",
    "ok": "keyword2",
    "on": "keyword2",
    "onexit": "keyword1",
    "or": "keyword2",
    "outputdebug": "keyword1",
    "owndialogs": "keyword2",
    "owner": "keyword2",
    "parse": "keyword2",
    "password": "keyword2",
    "pause": "literal2",
    "pgdn": "literal2",
    "pgup": "literal2",
    "pic": "keyword2",
    "picture": "keyword2",
    "pixel": "keyword2",
    "pixelgetcolor": "keyword1",
    "pixelsearch": "keyword1",
    "pos": "keyword2",
    "postmessage": "keyword1",
    "pow": "keyword2",
    "printscreen": "literal2",
    "priority": "keyword2",
    "process": "keyword1",
    "processname": "keyword2",
    "programfiles": "keyword3",
    "progress": "keyword1",
    "radio": "keyword2",
    "ralt": "literal2",
    "random": "keyword1",
    "range": "keyword2",
    "rbutton": "literal2",
    "rcontrol": "literal2",
    "rctrl": "literal2",
    "read": "keyword2",
    "readonly": "keyword2",
    "realtime": "keyword2",
    "redraw": "keyword2",
    "reg_binary": "keyword2",
    "reg_dword": "keyword2",
    "reg_expand_sz": "keyword2",
    "reg_multi_sz": "keyword2",
    "reg_sz": "keyword2",
    "regdelete": "keyword1",
    "region": "keyword2",
    "regread": "keyword1",
    "regwrite": "keyword1",
    "relative": "keyword2",
    "reload": "keyword1",
    "rename": "keyword2",
    "repeat": "keyword1",
    "report": "keyword2",
    "resize": "keyword2",
    "restore": "keyword2",
    "retry": "keyword2",
    "return": "keyword1",
    "rgb": "keyword2",
    "right": "literal2",
    "round": "keyword2",
    "rshift": "literal2",
    "rtrim": "keyword2",
    "run": "keyword1",
    "runas": "keyword1",
    "runwait": "keyword1",
    "rwin": "literal2",
    "rwindown": "literal2",
    "rwinup": "literal2",
    "screen": "keyword2",
    "scrolllock": "literal2",
    "seconds": "keyword2",
    "section": "keyword2",
    "send": "keyword1",
    "sendevent": "keyword1",
    "sendinput": "keyword1",
    "sendmessage": "keyword1",
    "sendmode": "keyword1",
    "sendplay": "keyword1",
    "sendraw": "keyword1",
    "serial": "keyword2",
    "setbatchlines": "keyword1",
    "setcapslockstate": "keyword1",
    "setcontroldelay": "keyword1",
    "setdefaultmousespeed": "keyword1",
    "setenv": "keyword1",
    "setformat": "keyword1",
    "setkeydelay": "keyword1",
    "setlabel": "keyword2",
    "setmousedelay": "keyword1",
    "setnumlockstate": "keyword1",
    "setscrolllockstate": "keyword1",
    "setstorecapslockmode": "keyword1",
    "settimer": "keyword1",
    "settitlematchmode": "keyword1",
    "setwindelay": "keyword1",
    "setworkingdir": "keyword1",
    "shift": "literal2",
    "shiftalttab": "keyword2",
    "shiftdown": "literal2",
    "shiftup": "literal2",
    "show": "keyword2",
    "shutdown": "keyword1",
    "sin": "keyword2",
    "single": "keyword2",
    "sleep": "keyword1",
    "slider": "keyword2",
    "sort": "keyword1",
    "sortdesc": "keyword2",
    "soundbeep": "keyword1",
    "soundget": "keyword1",
    "soundgetwavevolume": "keyword1",
    "soundplay": "keyword1",
    "soundset": "keyword1",
    "soundsetwavevolume": "keyword1",
    "space": "literal2",
    "splashimage": "keyword1",
    "splashtextoff": "keyword1",
    "splashtexton": "keyword1",
    "splitpath": "keyword1",
    "sqrt": "keyword2",
    "standard": "keyword2",
    "static": "keyword2",
    "status": "keyword2",
    "statusbar": "keyword2",
    "statusbargettext": "keyword1",
    "statusbarwait": "keyword1",
    "statuscd": "keyword2",
    "strike": "keyword2",
    "stringcasesense": "keyword1",
    "stringgetpos": "keyword1",
    "stringleft": "keyword1",
    "stringlen": "keyword1",
    "stringlower": "keyword1",
    "stringmid": "keyword1",
    "stringreplace": "keyword1",
    "stringright": "keyword1",
    "stringsplit": "keyword1",
    "stringtrimleft": "keyword1",
    "stringtrimright": "keyword1",
    "stringupper": "keyword1",
    "style": "keyword2",
    "submit": "keyword2",
    "suspend": "keyword1",
    "sysget": "keyword1",
    "sysmenu": "keyword2",
    "tab": "literal2",
    "tab2": "keyword2",
    "tabstop": "keyword2",
    "tan": "keyword2",
    "text": "keyword2",
    "theme": "keyword2",
    "thread": "keyword1",
    "tile": "keyword2",
    "time": "keyword2",
    "tip": "keyword2",
    "togglecheck": "keyword2",
    "toggleenable": "keyword2",
    "tooltip": "keyword1",
    "toolwindow": "keyword2",
    "top": "keyword2",
    "topmost": "keyword2",
    "transcolor": "keyword2",
    "transform": "keyword1",
    "transparent": "keyword2",
    "tray": "keyword2",
    "traytip": "keyword1",
    "treeview": "keyword2",
    "true": "keyword3",
    "tryagain": "keyword2",
    "type": "keyword2",
    "uncheck": "keyword2",
    "underline": "keyword2",
    "unicode": "keyword2",
    "unlock": "keyword2",
    "up": "literal2",
    "updown": "keyword2",
    "upper": "keyword2",
    "uppercase": "keyword2",
    "urldownloadtofile": "keyword1",
    "useerrorlevel": "keyword2",
    "vis": "keyword2",
    "visfirst": "keyword2",
    "visible": "keyword2",
    "volume_down": "literal2",
    "volume_mute": "literal2",
    "volume_up": "literal2",
    "vscroll": "keyword2",
    "wait": "keyword2",
    "waitclose": "keyword2",
    "wantctrla": "keyword2",
    "wantf2": "keyword2",
    "wantreturn": "keyword2",
    "wheeldown": "literal2",
    "wheelup": "literal2",
    "winactivate": "keyword1",
    "winactivatebottom": "keyword1",
    "winclose": "keyword1",
    "winget": "keyword1",
    "wingetactivestats": "keyword1",
    "wingetactivetitle": "keyword1",
    "wingetclass": "keyword1",
    "wingetpos": "keyword1",
    "wingettext": "keyword1",
    "wingettitle": "keyword1",
    "winhide": "keyword1",
    "winkill": "keyword1",
    "winmaximize": "keyword1",
    "winmenuselectitem": "keyword1",
    "winminimize": "keyword1",
    "winminimizeall": "keyword1",
    "winminimizeallundo": "keyword1",
    "winmove": "keyword1",
    "winrestore": "keyword1",
    "winset": "keyword1",
    "winsettitle": "keyword1",
    "winshow": "keyword1",
    "winwait": "keyword1",
    "winwaitactive": "keyword1",
    "winwaitclose": "keyword1",
    "winwaitnotactive": "keyword1",
    "wrap": "keyword2",
    "xbutton1": "literal2",
    "xbutton2": "literal2",
    "xdigit": "keyword2",
    "xm": "keyword2",
    "xp": "keyword2",
    "xs": "keyword2",
    "yes": "keyword2",
    "ym": "keyword2",
    "yp": "keyword2",
    "ys": "keyword2",
    "{!}": "literal2",
    "{#}": "literal2",
    "{$}": "literal2",
    "{+}": "literal2",
    "{^}": "literal2",
    "{`}": "literal2",
    "{altdown}": "literal2",
    "{altup}": "literal2",
    "{alt}": "literal2",
    "{appskey}": "literal2",
    "{backspace}": "literal2",
    "{blind}": "keyword2",
    "{browser_back}": "literal2",
    "{browser_favorites}": "literal2",
    "{browser_forward}": "literal2",
    "{browser_home}": "literal2",
    "{browser_refresh}": "literal2",
    "{browser_search}": "literal2",
    "{browser_stop}": "literal2",
    "{bs}": "literal2",
    "{capslock}": "literal2",
    "{click}": "keyword2",
    "{control}": "literal2",
    "{ctrlbreak}": "literal2",
    "{ctrldown}": "literal2",
    "{ctrlup}": "literal2",
    "{ctrl}": "literal2",
    "{delete}": "literal2",
    "{del}": "literal2",
    "{down}": "literal2",
    "{end}": "literal2",
    "{enter}": "literal2",
    "{escape}": "literal2",
    "{esc}": "literal2",
    "{f10}": "literal2",
    "{f11}": "literal2",
    "{f12}": "literal2",
    "{f13}": "literal2",
    "{f14}": "literal2",
    "{f15}": "literal2",
    "{f16}": "literal2",
    "{f17}": "literal2",
    "{f18}": "literal2",
    "{f19}": "literal2",
    "{f1}": "literal2",
    "{f20}": "literal2",
    "{f21}": "literal2",
    "{f22}": "literal2",
    "{f23}": "literal2",
    "{f24}": "literal2",
    "{f2}": "literal2",
    "{f3}": "literal2",
    "{f4}": "literal2",
    "{f5}": "literal2",
    "{f6}": "literal2",
    "{f7}": "literal2",
    "{f8}": "literal2",
    "{f9}": "literal2",
    "{home}": "literal2",
    "{insert}": "literal2",
    "{ins}": "literal2",
    "{joy10}": "literal2",
    "{joy11}": "literal2",
    "{joy12}": "literal2",
    "{joy13}": "literal2",
    "{joy14}": "literal2",
    "{joy15}": "literal2",
    "{joy16}": "literal2",
    "{joy17}": "literal2",
    "{joy18}": "literal2",
    "{joy19}": "literal2",
    "{joy1}": "literal2",
    "{joy20}": "literal2",
    "{joy21}": "literal2",
    "{joy22}": "literal2",
    "{joy23}": "literal2",
    "{joy24}": "literal2",
    "{joy25}": "literal2",
    "{joy26}": "literal2",
    "{joy27}": "literal2",
    "{joy28}": "literal2",
    "{joy29}": "literal2",
    "{joy2}": "literal2",
    "{joy30}": "literal2",
    "{joy31}": "literal2",
    "{joy32}": "literal2",
    "{joy3}": "literal2",
    "{joy4}": "literal2",
    "{joy5}": "literal2",
    "{joy6}": "literal2",
    "{joy7}": "literal2",
    "{joy8}": "literal2",
    "{joy9}": "literal2",
    "{joyaxes}": "literal2",
    "{joybuttons}": "literal2",
    "{joyinfo}": "literal2",
    "{joyname}": "literal2",
    "{joypov}": "literal2",
    "{joyr}": "literal2",
    "{joyu}": "literal2",
    "{joyv}": "literal2",
    "{joyx}": "literal2",
    "{joyy}": "literal2",
    "{joyz}": "literal2",
    "{lalt}": "literal2",
    "{launch_app1}": "literal2",
    "{launch_app2}": "literal2",
    "{launch_mail}": "literal2",
    "{launch_media}": "literal2",
    "{lbutton}": "literal2",
    "{lcontrol}": "literal2",
    "{lctrl}": "literal2",
    "{left}": "literal2",
    "{lshift}": "literal2",
    "{lwindown}": "literal2",
    "{lwinup}": "literal2",
    "{lwin}": "literal2",
    "{mbutton}": "literal2",
    "{media_next}": "literal2",
    "{media_play_pause}": "literal2",
    "{media_prev}": "literal2",
    "{media_stop}": "literal2",
    "{numlock}": "literal2",
    "{numpad0}": "literal2",
    "{numpad1}": "literal2",
    "{numpad2}": "literal2",
    "{numpad3}": "literal2",
    "{numpad4}": "literal2",
    "{numpad5}": "literal2",
    "{numpad6}": "literal2",
    "{numpad7}": "literal2",
    "{numpad8}": "literal2",
    "{numpad9}": "literal2",
    "{numpadadd}": "literal2",
    "{numpadclear}": "literal2",
    "{numpaddel}": "literal2",
    "{numpaddiv}": "literal2",
    "{numpaddot}": "literal2",
    "{numpaddown}": "literal2",
    "{numpadend}": "literal2",
    "{numpadenter}": "literal2",
    "{numpadhome}": "literal2",
    "{numpadins}": "literal2",
    "{numpadleft}": "literal2",
    "{numpadmult}": "literal2",
    "{numpadpgdn}": "literal2",
    "{numpadpgup}": "literal2",
    "{numpadright}": "literal2",
    "{numpadsub}": "literal2",
    "{numpadup}": "literal2",
    "{pause}": "literal2",
    "{pgdn}": "literal2",
    "{pgup}": "literal2",
    "{printscreen}": "literal2",
    "{ralt}": "literal2",
    "{raw}": "keyword2",
    "{rbutton}": "literal2",
    "{rcontrol}": "literal2",
    "{rctrl}": "literal2",
    "{right}": "literal2",
    "{rshift}": "literal2",
    "{rwindown}": "literal2",
    "{rwinup}": "literal2",
    "{rwin}": "literal2",
    "{scrolllock}": "literal2",
    "{shiftdown}": "literal2",
    "{shiftup}": "literal2",
    "{shift}": "literal2",
    "{space}": "literal2",
    "{tab}": "literal2",
    "{up}": "literal2",
    "{volume_down}": "literal2",
    "{volume_mute}": "literal2",
    "{volume_up}": "literal2",
    "{wheeldown}": "literal2",
    "{wheelup}": "literal2",
    "{xbutton1}": "literal2",
    "{xbutton2}": "literal2",
    "{~}": "literal2",
    "~": "literal2",
}

# Dictionary of keywords dictionaries for ahk mode.
keywordsDictDict = {
    "ahk_main": ahk_main_keywords_dict,
}

# Rules for ahk_main ruleset.

def ahk_rule0(colorer, s, i):
    return colorer.match_eol_span(s, i, kind="comment1", seq=";")

def ahk_rule1(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="<")

def ahk_rule2(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="<=")

def ahk_rule3(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq=">=")

def ahk_rule4(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq=">")

def ahk_rule5(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="=")

def ahk_rule6(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="<>")

def ahk_rule7(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="+")

def ahk_rule8(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="-")

def ahk_rule9(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="*")

def ahk_rule10(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="/")

def ahk_rule11(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq="\\")

def ahk_rule12(colorer, s, i):
    return colorer.match_plain_seq(s, i, kind="operator", seq=":=")

def ahk_rule13(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="label", pattern=":",
          at_whitespace_end=True,
          exclude_match=True)

def ahk_rule14(colorer, s, i):
    return colorer.match_mark_previous(s, i, kind="label", pattern="::",
          at_whitespace_end=True,
          exclude_match=True)

def ahk_rule15(colorer, s, i):
    return colorer.match_keywords(s, i)

# Rules dict for ahk_main ruleset.
rulesDict1 = {
    "!": [ahk_rule15,],
    "#": [ahk_rule15,],
    "$": [ahk_rule15,],
    "*": [ahk_rule9,],
    "+": [ahk_rule7, ahk_rule15,],
    "-": [ahk_rule8,],
    "/": [ahk_rule10,],
    "0": [ahk_rule15,],
    "1": [ahk_rule15,],
    "2": [ahk_rule15,],
    "3": [ahk_rule15,],
    "4": [ahk_rule15,],
    "5": [ahk_rule15,],
    "6": [ahk_rule15,],
    "7": [ahk_rule15,],
    "8": [ahk_rule15,],
    "9": [ahk_rule15,],
    ":": [ahk_rule12, ahk_rule13, ahk_rule14,],
    ";": [ahk_rule0,],
    "<": [ahk_rule1, ahk_rule2, ahk_rule6,],
    "=": [ahk_rule5,],
    ">": [ahk_rule3, ahk_rule4,],
    "@": [ahk_rule15,],
    "A": [ahk_rule15,],
    "B": [ahk_rule15,],
    "C": [ahk_rule15,],
    "D": [ahk_rule15,],
    "E": [ahk_rule15,],
    "F": [ahk_rule15,],
    "G": [ahk_rule15,],
    "H": [ahk_rule15,],
    "I": [ahk_rule15,],
    "J": [ahk_rule15,],
    "K": [ahk_rule15,],
    "L": [ahk_rule15,],
    "M": [ahk_rule15,],
    "N": [ahk_rule15,],
    "O": [ahk_rule15,],
    "P": [ahk_rule15,],
    "Q": [ahk_rule15,],
    "R": [ahk_rule15,],
    "S": [ahk_rule15,],
    "T": [ahk_rule15,],
    "U": [ahk_rule15,],
    "V": [ahk_rule15,],
    "W": [ahk_rule15,],
    "X": [ahk_rule15,],
    "Y": [ahk_rule15,],
    "Z": [ahk_rule15,],
    "\\": [ahk_rule11,],
    "^": [ahk_rule15,],
    "_": [ahk_rule15,],
    "`": [ahk_rule15,],
    "a": [ahk_rule15,],
    "b": [ahk_rule15,],
    "c": [ahk_rule15,],
    "d": [ahk_rule15,],
    "e": [ahk_rule15,],
    "f": [ahk_rule15,],
    "g": [ahk_rule15,],
    "h": [ahk_rule15,],
    "i": [ahk_rule15,],
    "j": [ahk_rule15,],
    "k": [ahk_rule15,],
    "l": [ahk_rule15,],
    "m": [ahk_rule15,],
    "n": [ahk_rule15,],
    "o": [ahk_rule15,],
    "p": [ahk_rule15,],
    "q": [ahk_rule15,],
    "r": [ahk_rule15,],
    "s": [ahk_rule15,],
    "t": [ahk_rule15,],
    "u": [ahk_rule15,],
    "v": [ahk_rule15,],
    "w": [ahk_rule15,],
    "x": [ahk_rule15,],
    "y": [ahk_rule15,],
    "z": [ahk_rule15,],
    "{": [ahk_rule15,],
    "}": [ahk_rule15,],
    "~": [ahk_rule15,],
}

# x.rulesDictDict for ahk mode.
rulesDictDict = {
    "ahk_main": rulesDict1,
}

# Import dict for ahk mode.
importDict = {}
