#!/usr/bin/env python3

# ----------------------------------------------------------------------
# Follow Creator of Tool on Social Midia:
# Creator of Tool: Edu0x01
# Follow on Instagram: @edu0x01 --> https://www.instagram.com/edu0x01/
# ----------------------------------------------------------------------
# Thx for use my Tool! It is still in the testing phase :D
# ----------------------------------------------------------------------

import requests
import json
import os
import re
import sys
from time import sleep


# Cores de Saída


class c:
    PURPLE = '\033[95m'
    BLUE = '\033[94m'
    CYAN = '\033[96m'
    GREEN = '\033[92m'
    YELLOW = '\033[93m'
    RED = '\033[91m'
    END = '\033[0m'
    UNDERLINE = '\033[4m'


# bibliotecas
try:
    import requests
    import re
    import socket
    import json
    import argparse
    import platform
    import dns.zone
    import warnings
    import dns.resolver
    import pydig
    from time import sleep
    import os
    import urllib3
except Exception as e:
    print(e)
    print(c.YELLOW + "\n[" + c.RED + "-" + c.YELLOW +
          "] ERROR requirements missing try to install the requirements: pip3 install -r requirements.txt" + c.END)
    sys.exit(0)

# Função de banner


def banner():
    banner = """ 
                         
███████╗    ██████╗               ███████╗     ██╗       
██╔════╝    ██╔══██╗              ╚════██║    ███║       
███████╗    ██████╔╝    █████╗        ██╔╝    ╚██║   - Edu0x01 
╚════██║    ██╔══██╗    ╚════╝       ██╔╝      ██║       
███████║    ██║  ██║                 ██║       ██║       
╚══════╝    ╚═╝  ╚═╝                 ╚═╝       ╚═╝                      
                                        
    """

    print(banner)
    print(c.BLUE + "\nPython version: " + c.GREEN +
          platform.python_version() + c.END)
    print(c.BLUE + "Current OS: " + c.GREEN +
          platform.system() + " " + platform.release() + c.END)

    internet_check = socket.gethostbyname(socket.gethostname())
    if internet_check == "127.0.0.1":
        if platform.system() == "Windows":
            print(c.BLUE + "Internet connection: " + c.RED + "-" + c.END)
        else:
            print(c.BLUE + "Internet connection: " + c.RED + "✕" + c.END)
    else:
        if platform.system() == "Windows":
            print(c.BLUE + "Internet connection: " + c.GREEN + "+" + c.END)
        else:
            print(c.BLUE + "Internet connection: " + c.GREEN + "✔" + c.END)

    print(c.BLUE + "Target: " + c.GREEN + domain + c.END)

# Função do analisador de argumentos


def parseArgs():
    p = argparse.ArgumentParser(
        description="SR-71 - All in One Recon Tool")
    p.add_argument("-d", "--domain",
                   help="domain to search its subdomains", required=True)
    p.add_argument("-o", "--output",
                   help="file to store the scan output", required=False)
    p.add_argument(
        '-t', '--token', help="api token of hunter.io to discover mail accounts and employees", required=False)
    p.add_argument("-p", "--portscan", help="perform a fast and stealthy scan of the most common ports",
                   action='store_true', required=False)
    p.add_argument("-a", "--axfr", help="try a domain zone transfer attack",
                   action='store_true', required=False)
    p.add_argument("-m", "--mail", help="try to enumerate mail servers",
                   action='store_true', required=False)
    p.add_argument('-e', '--extra', help="look for extra dns information",
                   action='store_true', required=False)
    p.add_argument("-n", "--nameservers", help="try to enumerate the name servers",
                   action='store_true', required=False)
    p.add_argument("-i", "--ip", help="it reports the ip or ips of the domain",
                   action='store_true', required=False)
    p.add_argument('-6', '--ipv6', help="enumerate the ipv6 of the domain",
                   action='store_true', required=False)
    p.add_argument("-w", "--waf", help="discover the WAF of the domain main page",
                   action='store_true', required=False)
    p.add_argument("-b", "--backups", help="discover common backups files in the web page",
                   action='store_true', required=False)
    p.add_argument("-s", "--subtakeover", help="check if any of the subdomains are vulnerable to Subdomain Takeover",
                   action='store_true', required=False)
    p.add_argument("-r", "--repos", help="try to discover valid repositories and s3 servers of the domain (still improving it)",
                   action='store_true', required=False)
    p.add_argument("-c", "--check", help="check active subdomains and store them into a file",
                   action='store_true', required=False)
    p.add_argument("--secrets", help="crawl the web page to find secrets and api keys (e.g. Google Maps API Key)",
                   action='store_true', required=False)
    p.add_argument("--enum", help="stealthily enumerate and identify common technologies",
                   action='store_true', required=False)
    p.add_argument("--whois", help="perform a whois query to the domain",
                   action='store_true', required=False)
    p.add_argument("--wayback", help="find useful information about the domain and his different endpoints using The Wayback Machine and other services",
                   action="store_true", required=False)
    # p.add_argument("--fuzz", help="use a fuzzing wordlist with common files and directories", actionn='store_true', require=False)
    p.add_argument("--all", help="perform all the enumeration at once (best choice)",
                   action='store_true', required=False)
    p.add_argument("--quiet", help="don't print the banner",
                   action='store_true', required=False)
    p.add_argument("--version", help="display the script version",
                   action='store_true', required=False)
    return p.parse_args()

# Função dos NameServer


def ns_enum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Trying to discover valid name servers...\n" + c.END)
    sleep(0.2)
    """
    Consulta para obter o DNS do domínio
    """
    data = ""
    try:
        data = dns.resolver.resolve(f"{domain}", 'NS')
    except:
        pass
    if data:
        for ns in data:
            print(c.YELLOW + str(ns) + c.END)
    else:
        print(c.YELLOW + "Unable to enumerate" + c.END)

# Função para descoberta de IPs


def ip_enum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Discovering IPs of the domain...\n" + c.END)
    sleep(0.2)
    """
    consulta para obter Ips
    """
    data = ""
    try:
        data = dns.resolver.resolve(f"{domain}", 'A')
    except:
        pass
    if data:
        for ip in data:
            print(c.YELLOW + ip.to_text() + c.END)
    else:
        print(c.YELLOW + "Unable to enumerate" + c.END)

# Função para obter informação DNS extra


def txt_enum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Enumerating extra DNS information...\n" + c.END)
    sleep(0.2)
    """
  Consulta oara obter informacoes extras de um DNS
    """
    data = ""
    try:
        data = dns.resolver.resolve(domain, 'TXT')
    except:
        pass
    if data:
        for info in data:
            print(c.YELLOW + info.to_text() + c.END)
    else:
        print(c.YELLOW + "Unable to enumerate" + c.END)

# Função para descobrir o IPv6 do destino


def ipv6_enum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Getting ipv6 of the domain...\n" + c.END)
    sleep(0.2)
    """
   Consulta para obter ipv6
    """
    data = ""
    try:
        data = pydig.query(domain, 'AAAA')
    except:
        pass
    if data:
        for info in data:
            print(c.YELLOW + info + c.END)
    else:
        print(c.YELLOW + "Unable to enumerate" + c.END)

# Função para descobrir Servidores de email


def mail_enum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Finding valid mail servers...\n" + c.END)
    sleep(0.2)
    """
    Consulta para descobri servidores de email
    """
    data = ""
    try:
        data = dns.resolver.resolve(f"{domain}", 'MX')
    except:
        pass
    if data:
        for server in data:
            print(c.YELLOW + str(server).split(" ")[1] + c.END)
    else:
        print(c.YELLOW + "Unable to enumerate" + c.END)

# Função de ataque de transferência de zona de domínio


def axfr(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Starting Domain Zone Transfer attack...\n" + c.END)
    sleep(0.2)
    """
    Itere pelos servidores de nomes e tente um ataque AXFR em todos
    """
    ns_answer = dns.resolver.resolve(domain, 'NS')
    for server in ns_answer:
        ip_answer = dns.resolver.resolve(server.target, 'A')
        for ip in ip_answer:
            try:
                zone = dns.zone.from_xfr(dns.query.xfr(str(ip), domain))
                for host in zone:
                    print(c.YELLOW + "Found Host: {}".format(host) + c.END)
            except Exception as e:
                print(c.YELLOW + "NS {} refused zone transfer!".format(server) + c.END)
                continue

# Função modificada de https://github.com/Nefcore/CRLFsuite WAF detector script <3


def wafDetector(domain):
    """
    Obter lista de WAFs em um arquivo
    """
    r = requests.get("https://gitlab.com/Edu0x01/SR-71/-/raw/master/utils/wafsign.json?ref_type=heads")
    f = open('wafsign.json', 'w')
    f.write(r.text)
    f.close()

    with open('wafsign.json', 'r') as file:
        wafsigns = json.load(file)

    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Discovering active WAF on the main web page...\n" + c.END)
    sleep(1)
    """
    Payload para acionar o possível WAF
    """
    payload = "../../../../etc/passwd"

    try:
        """
        Verifique o domínio e modifique se necessário
        """
        if domain.endswith("/") and domain.startswith("https://"):
            response = requests.get(domain + payload, verify=False)
        elif domain.endswith("/") and not domain.startswith("https://"):
            response = requests.get(
                'https://' + domain + payload, verify=False)
        elif not domain.endswith("/") and domain.startswith("https://"):
            response = requests.get(domain + '/' + payload, verify=False)
        elif not domain.endswith("/") and not domain.startswith("https://"):
            response = requests.get(
                'https://' + domain + '/' + payload, verify=False)
    except:
        print(c.YELLOW + "An error has ocurred" + c.END)
        try:
            os.remove('wafsign.json')
        except:
            pass
        return None

    code = str(response.status_code)
    page = response.text
    headers = str(response.headers)
    cookie = str(response.cookies.get_dict())
    """
    Verifique se o WAF bloqueou a solicitação
    """
    if int(code) >= 400:
        bmatch = [0, None]
        for wafname, wafsign in wafsigns.items():
            total_score = 0
            pSign = wafsign["page"]
            cSign = wafsign["code"]
            hSign = wafsign["headers"]
            ckSign = wafsign["cookie"]
            if pSign:
                if re.search(pSign, page, re.I):
                    total_score += 1
            if cSign:
                if re.search(cSign, code, re.I):
                    total_score += 0.5
            if hSign:
                if re.search(hSign, headers, re.I):
                    total_score += 1
            if ckSign:
                if re.search(ckSign, cookie, re.I):
                    total_score += 1
            if total_score > bmatch[0]:
                del bmatch[:]
                bmatch.extend([total_score, wafname])

        if bmatch[0] != 0:
            print(c.YELLOW + bmatch[1] + c.END)
        else:
            print(c.YELLOW + "WAF not detected or doesn't exists" + c.END)
    else:
        print(c.YELLOW + "An error has ocurred or unable to enumerate" + c.END)

    try:
        os.remove('wafsign.json')
    except:
        pass

# funçao para Usar o Token


def crawlMails(domain, api_token):
    print(c.BLUE + "\n[" + c.GREEN + "+" + c.BLUE +
          "] Discovering valid mail accounts and employees..." + c.END)
    """
    Use a API do hunter.io com seu token para obter e-mails válidos
    """
    sleep(1)
    api_url = f"""https://api.hunter.io/v2/domain-search?domain={domain}&api_key={api_token}"""
    r = requests.get(api_url)
    response_data = json.loads(r.text)
    domain_name = domain.split(".")[0]
    print()
    file = open(f"{domain_name}-mails-data.txt", "w")
    file.write(r.text)
    file.close()

    counter = 0
    for value in response_data["data"]["emails"]:
        if value["first_name"] and value["last_name"]:
            counter = 1
            print(c.YELLOW + value["first_name"] + " " +
                  value["last_name"] + " - " + value["value"] + c.END)
        else:
            counter = 1
            print(c.YELLOW + value["value"] + c.END)
    if counter == 0:
        print(c.YELLOW + "\nNo mails or employees found" + c.END)
    else:
        print(c.YELLOW + "\nMore mail data stored in " +
              domain_name + "-mails-data.txt" + c.END)

# Função para verificar aquisição de subdomínio


def subTakeover(all_subdomains):
    """
    Percorra todos os subdomínios para verificar se alguém está vulnerável ao controle de subdomínio
    """
    vuln_counter = 0
    print(c.BLUE + "\n[" + c.GREEN + "+" + c.BLUE +
          "] Checking if any subdomain is vulnerable to takeover\n" + c.END)
    sleep(1)

    for subdom in all_subdomains:
        try:
            sleep(0.05)
            resquery = dns.resolver.resolve(subdom, 'CNAME')
            for resdata in resquery:
                resdata = (resdata.to_text())
                if subdom[-8:] in resdata:
                    r = requests.get("https://" + subdom,
                                     allow_redirects=False)
                    if r.status_code == 200:
                        vuln_counter += 1
                        print(c.YELLOW + subdom +
                              " appears to be vulnerable" + c.END)
                else:
                    pass
        except KeyboardInterrupt:
            sys.exit(
                c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
        except:
            pass

    if vuln_counter <= 0:
        print(c.YELLOW + "No subdomains are vulnerable" + c.END)

# Função para enumerar github e cloud


def cloudgitEnum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Looking for git repositories and public development info\n" + c.END)
    sleep(0.2)
    try:
        r = requests.get("https://" + domain + "/.git/", verify=False)
        print(c.YELLOW + "Git repository URL: https://" + domain +
              "/.git/ - " + str(r.status_code) + " status code" + c.END)
    except:
        pass
    try:
        r = requests.get("https://bitbucket.org/" + domain.split(".")[0])
        print(c.YELLOW + "Bitbucket account URL: https://bitbucket.org/" +
              domain.split(".")[0] + " - " + str(r.status_code) + " status code" + c.END)
    except:
        pass
    try:
        r = requests.get("https://github.com/" + domain.split(".")[0])
        print(c.YELLOW + "Github account URL: https://github.com/" +
              domain.split(".")[0] + " - " + str(r.status_code) + " status code" + c.END)
        # if r.status_code == 200:
        # git_option = input("Do you want to analyze further the github account and its repos? [y/n]: ")
        # if git_option == "y" or git_option == "yes":
        # domain_name = domain.split(".")[0]
        # r = requests.get("https://api.github.com/users/{domain_name}/repos")
        # __import__('pdb').set_trace()
    except:
        pass
    try:
        r = requests.get("https://gitlab.com/" + domain.split(".")[0])
        print(c.YELLOW + "Gitlab account URL: https://gitlab.com/" +
              domain.split(".")[0] + " - " + str(r.status_code) + " status code" + c.END)
    except:
        pass
    # try: # Função para enumerar gitlab e cloud, podendo adcionar qualquer dominio (apenas para testes internos)
    #     r = requests.get("https://gitlab.****.com.br/" + domain.split(".")[0])
    #     print(c.YELLOW + "Gitlab account URL: https://gitlab.****.com.br/" +
    #           domain.split(".")[0] + " - " + str(r.status_code) + " status code" + c.END)
    # except:
    #     pass

# Função Wayback Machine

def wayback(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Using The Wayback Machine to discover endpoints" + c.END)
    wayback_url = f"http://web.archive.org/cdx/search/cdx?url=*.{domain}/*&output=json&fl=original&collapse=urlkey"
    
    # Obtenha informações da Wayback Machine
    try:
        r = requests.get(wayback_url, timeout=20)
        r.raise_for_status()  # Adiciona verificação de status HTTP
        results = r.json()
        results = results[1:]  # Remove o cabeçalho, se necessário
    except requests.RequestException as e:
        print(f"Erro na requisição: {e}")
        return
    except json.JSONDecodeError:
        print("Erro ao decodificar o JSON da resposta")
        return

    domain_name = domain.split(".")[0]
    try:
        os.remove(f"{domain_name}-wayback.txt")
    except FileNotFoundError:
        pass
    except Exception as e:
        print(f"Erro ao remover arquivo: {e}")

    # Salvar dados em um arquivo
    with open(f"{domain_name}-wayback.txt", "a") as file:
        for result in results:
            file.write(result[0] + "\n")

    # Obtenha URLs e endpoints do URLScan
    try:
        r = requests.get(f"https://urlscan.io/api/v1/search/?q=domain:{domain}", timeout=20)
        r.raise_for_status()
        myresp = r.json()
        urlscan_results = myresp.get("results", [])
        
        with open(f"{domain_name}-wayback.txt", "a") as file:
            for res in urlscan_results:
                url = res["task"]["url"]
                file.write(url + "\n")
    except requests.RequestException as e:
        print(f"Erro na requisição ao URLScan: {e}")
    except KeyError:
        print("Erro ao acessar os resultados do URLScan")
    except json.JSONDecodeError:
        print("Erro ao decodificar o JSON do URLScan")

    print(c.YELLOW + f"\nAll URLs stored in {domain_name}-wayback.txt" + c.END)
    sleep(0.3)

    # Inicialize wayback_content com um valor padrão vazio
    wayback_content = []

    try:
        with open(f"{domain_name}-wayback.txt", "r") as file:
            wayback_content = file.readlines()
    except FileNotFoundError:
        print(f"O arquivo {domain_name}-wayback.txt não foi encontrado")
        return
    except Exception as e:
        print(f"Erro ao ler o arquivo: {e}")
        return

    # Filtrar e organizar os endpoints .json
    print(c.YELLOW + f"\nGetting .json endpoints from URLs..." + c.END)
    sleep(0.5)

    try:
        os.remove(f"{domain_name}-json.txt")
    except FileNotFoundError:
        pass
    except Exception as e:
        print(f"Erro ao remover arquivo: {e}")

    json_endpoints = []
    for url in wayback_content:
        url = url.strip()
        if ".json" in url and url not in json_endpoints:
            json_endpoints.append(url)

    # Armazenar pontos de extremidade .json
    with open(f"{domain_name}-json-endpoints.txt", "a") as f:
        for json_url in json_endpoints:
            f.write(json_url + "\n")

    json_len = len(json_endpoints)
    print(c.YELLOW +
          f"JSON endpoints stored in {domain_name}-json.txt ({json_len} endpoints)" + c.END)
    sleep(0.4)

    # Filtrar URLs para XSS e Redirecionamentos
    print(c.YELLOW + f"Filtering out URLs to find potential XSS and Open Redirect vulnerable endpoints..." + c.END)
    sleep(0.2)

    redirects_file_exists = os.path.exists("redirects.json")
    if not redirects_file_exists:
        try:
            r = requests.get("https://gitlab.com/Edu0x01/SR-71/-/raw/master/utils/redirects.json?ref_type=heads")
            r.raise_for_status()
            with open("redirects.json", "w") as redirects_file:
                redirects_file.write(r.text)
        except requests.RequestException as e:
            print(f"Erro ao baixar redirects.json: {e}")
            return

    redirect_urls = []
    try:
        with open("redirects.json") as redirects_raw:
            redirects_json = json.load(redirects_raw)
            for line in wayback_content:
                line = line.strip()
                for json_line in redirects_json.get("patterns", []):
                    if re.findall(rf".*{json_line}.*?", line):
                        endpoint_url = re.findall(rf".*{json_line}.*?", line)[0] + "FUZZ"
                        if endpoint_url not in redirect_urls:
                            redirect_urls.append(endpoint_url)
    except FileNotFoundError:
        print("O arquivo redirects.json não foi encontrado")
        return
    except json.JSONDecodeError:
        print("Erro ao decodificar o JSON do redirects.json")
        return

    try:
        os.remove(f"{domain_name}-redirects.txt")
    except FileNotFoundError:
        pass
    except Exception as e:
        print(f"Erro ao remover arquivo: {e}")

    with open(f"{domain_name}-redirects.txt", "a") as f:
        for filtered_url in redirect_urls:
            f.write(filtered_url + "\n")

    end_info = len(redirect_urls)
    print(c.YELLOW +
          f"Open Redirects endpoints stored in {domain_name}-redirects.txt ({end_info} endpoints)" + c.END)

    xss_file_exists = os.path.exists("xss.json")
    if not xss_file_exists:
        try:
            r = requests.get("https://gitlab.com/Edu0x01/SR-71/-/raw/master/utils/xss.json?ref_type=heads")
            r.raise_for_status()
            with open("xss.json", "w") as xss_file:
                xss_file.write(r.text)
        except requests.RequestException as e:
            print(f"Erro ao baixar xss.json: {e}")
            return

    xss_urls = []
    try:
        with open("xss.json") as xss_raw:
            xss_json = json.load(xss_raw)
            for line in wayback_content:
                line = line.strip()
                for json_line in xss_json.get("patterns", []):
                    if re.findall(rf".*{json_line}.*?", line):
                        endpoint_url = re.findall(rf".*{json_line}.*?", line)[0] + "FUZZ"
                        if endpoint_url not in xss_urls:
                            xss_urls.append(endpoint_url)
    except FileNotFoundError:
        print("O arquivo xss.json não foi encontrado")
        return
    except json.JSONDecodeError:
        print("Erro ao decodificar o JSON do xss.json")
        return

    try:
        with open(f"{domain_name}-xss.txt", "a") as f:
            for filtered_url in xss_urls:
                f.write(filtered_url + "\n")
    except Exception as e:
        print(f"Erro ao escrever no arquivo xss.txt: {e}")

    end_info = len(xss_urls)
    print(c.YELLOW +
          f"XSS endpoints stored in {domain_name}-xss.txt ({end_info} endpoints)" + c.END)
    sleep(0.1)

    if not redirects_file_exists:
        os.remove("redirects.json")
    if not xss_file_exists:
        os.remove("xss.json")

# Consultar o domínio


def whoisLookup(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Performing Whois lookup..." + c.END)
    import whois
    sleep(1.2)

    try:
        w = whois.whois(domain)  # Duas maneiras diferentes de evitar um erro estranho
    except:
        w = whois.query(domain)
    try:
        print(c.YELLOW + f"\n{w}" + c.END)
    except:
        print(c.YELLOW + "\nAn error has ocurred or unable to whois " + domain + c.END)

# Função para encadear ao sondar subdomínios ativos


def checkStatus(subdomain, file):
    try:
        r = requests.get("https://" + subdomain, timeout=2)
        # Basta verificar se a web está ativa e https
        if r.status_code:
            file.write("https://" + subdomain + "\n")
    except:
        try:
            r = requests.get("http://" + subdomain, timeout=2)
            # Verifique se está ativo e http
            if r.status_code:
                file.write("http://" + subdomain + "\n")
        except:
            pass

# Verifique a função de status


def checkActiveSubs(domain, doms):
    global file
    import threading

    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Probing active subdomains..." + c.END)

    if len(doms) >= 100:
        subs_total = len(doms)
        option = input(
            c.YELLOW + f"\nThere are a lot of subdomains to check, ({subs_total}) do you want to check all of them [y/n]: " + c.END)

        if option == "n" or option == "no":
            sleep(0.2)
            return
    """ Define filename """
    domain_name = domain.split(".")[0]
    file = open(f"{domain_name}-active-subs.txt", "w")
    """
    Iterar por todos os subdomínios em threads
    """
    threads_list = []
    for subdomain in doms:
        t = threading.Thread(target=checkStatus, args=(subdomain, file))
        t.start()
        threads_list.append(t)
    for proc_thread in threads_list:  # Aguarde até que todas as linhas terminem
        proc_thread.join()

    print(c.YELLOW +
          f"\nActive subdomains stored in {domain_name}-active-subs.txt" + c.END)

# Verifique se as portas comuns estão abertas


def portScan(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Scanning most common ports on " + domain + "\n" + c.END)
    """ Define ports array """
    ports = [21, 22, 23, 25, 26, 43, 53, 69, 80, 81, 88, 110, 135, 389, 443, 445, 636, 873, 1433,
             2049, 3000, 3001, 3306, 4000, 4040, 5000, 5001, 5985, 5986, 8000, 8001, 8080, 8081, 27017]
    """
    Itere pelas portas para verificar se estão abertas
    """
    for port in ports:
        sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        sock.settimeout(0.40)
        result = sock.connect_ex((domain, port))
        if result == 0:
            print(c.YELLOW + "Port " + str(port) + " - OPEN" + c.END)
        sock.close()

# Fuzz um pouco procurando por backups


def findBackups(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Looking for common backup files...\n" + c.END)
    back_counter = 0
    hostname = domain.split(".")[0]
    protocols = ["http", "https"]
    filenames = [hostname, domain, "backup", "admin"]
    extensions = ["sql.tar", "tar", "tar.gz", "gz",
                  "tar.bzip2", "sql.bz2", "sql.7z", "zip", "sql.gz", "7z"]
    # Alguns nomes de arquivos de backup comuns com várias extensões
    for protocol in protocols:
        for filename in filenames:
            for ext in extensions:
                url = protocol + "://" + domain + "/" + filename + "." + ext
                try:
                    r = requests.get(url, verify=False)
                    code = r.status_code
                except:
                    continue
                if code != 404:
                    back_counter += 1
                    print(c.YELLOW + url + " - " + str(code) + c.END)

    if back_counter == 0:
        print(c.YELLOW + "No backup files found" + c.END)

# Procure a chave da API do Google Maps e teste se ela é vulnerável


def findSecrets(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Trying to found possible secrets and api keys..." + c.END)
    for protocol in ["https", "http"]:
        findSecretsFromUrl(protocol + "://" + domain)


def findSecretsFromUrl(url):
    # Pedido inicial
    try:
        r = requests.get(url, verify=False)
    except:
        return
    js_list = []
    key_counter = 0
    url_list = re.findall(r'src="(.*?)"', r.text) + \
        re.findall(r'href="(.*?)"', r.text)
    # Obter pontos de extremidade JS
    for endpoint in url_list:
        if ".js" in endpoint and "https://" not in endpoint:
            js_list.append(endpoint)

    if len(js_list) >= 1:
        print(c.YELLOW + "\nDiscovered JS endpoints:" + c.END)
    for js in js_list:
        print(c.YELLOW + url + js + c.END)

    for js_endpoint in js_list:
        try:
            r = requests.get(url + js_endpoint, verify=False)
        except:
            pass
        if "https://maps.googleapis.com/" in r.text:
            maps_api_key = re.findall(
                r'src="https://maps.googleapis.com/(.*?)"', r.text)[0]
            print(c.YELLOW + "\nMaps API key found: " + maps_api_key + c.END)
            key_counter = 1
        try:
            google_api = re.findall(r'AIza[0-9A-Za-z-_]{35}', r.text)[0]
            if google_api:
                print(c.YELLOW + "\nGoogle api found: " + google_api + c.END)
                key_counter = 1
        except:
            pass
        try:
            google_oauth = re.findall(r'ya29\.[0-9A-Za-z\-_]+', r.text)[0]
            if google_oauth:
                print(c.YELLOW + "\nGoogle Oauth found: " + google_oauth + c.END)
                key_counter = 1
        except:
            pass
        try:
            amazon_aws_url = re.findall(
                r's3\.amazonaws.com[/]+|[a-zA-Z0-9_-]*\.s3\.amazonaws.com', r.text)[0]
            if amazon_aws_url:
                print(c.YELLOW + "\nAmazon AWS url found on " + js_endpoint + c.END)
                key_counter = 1
        except:
            pass
        try:
            stripe_key = re.findall(
                r'"pk_live_.*"', r.text)[0].replace('"', '')
            if stripe_key:
                print(c.YELLOW + "\nStripe key found on " + js_endpoint + c.END)
                key_counter = 1
        except:
            pass

    if key_counter != 1:
        print(c.YELLOW + "\nNo secrets found" + c.END)

# Executar enumeração básica


def basicEnum(domain):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END +
          c.BLUE + "] Performing some basic enumeration...\n" + c.END)
    """
    Use python-Wappalyzer
    """
    try:
        print()
        from Wappalyzer import Wappalyzer, WebPage
        wappalyzer = Wappalyzer.latest()
        webpage = WebPage.new_from_url('https://' + domain)
        info = wappalyzer.analyze_with_versions(webpage)

        if info != "{}":
            print(c.YELLOW + json.dumps(info, sort_keys=True, indent=4) + c.END)
        else:
            print(c.YELLOW + "\nNo common technologies found" + c.END)

        endpoints = ["robots.txt", "xmlrpc.php", "wp-cron.php", "actuator/heapdump", "datahub/heapdump", "datahub/actuator/heapdump", "heapdump", "admin/", ".env", ".config",
                     "version.txt", "README.md", "license.txt", "config.php.bak", "api/", "feed.xml", "CHANGELOG.md", "config.json", "cgi-bin/", "env.json", ".htaccess", "js/", "kibana/", "log.txt"]
        for end in endpoints:
            r = requests.get(f"https://{domain}/{end}", timeout=4)
            print(
                c.YELLOW + f"https://{domain}/{end} - " + str(r.status_code) + c.END)
    except:
        print(c.YELLOW + "An error has ocurred or unable to enumerate" + c.END)

# Função de Descoberta do Domínio Principal


def SDom(domain, filename):
    print(c.BLUE + "\n[" + c.END + c.GREEN + "+" + c.END + c.BLUE +
          "] Discovering subdomains using passive techniques...\n" + c.END)
    sleep(0.1)
    global doms
    doms = []
    """
    Obter subdomínios válidos de crt.sh
    """
    try:
        r = requests.get("https://crt.sh/?q=" + domain +
                         "&output=json", timeout=20)
        formatted_json = json.dumps(json.loads(r.text), indent=4)
        crt_domains = sorted(
            set(re.findall(r'"common_name": "(.*?)"', formatted_json)))
        # Anexar apenas novos subdomínios válidos
        for dom in crt_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)

    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
    Obter subdomínios do AlienVault
    """
    try:
        r = requests.get(
            f"https://otx.alienvault.com/api/v1/indicators/domain/{domain}/passive_dns", timeout=20)
        alienvault_domains = sorted(
            set(re.findall(r'"hostname": "(.*?)"', r.text)))
        # Anexar apenas novos subdomínios válidos
        for dom in alienvault_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
    Obter subdomínios do Hackertarget
    """
    try:
        r = requests.get(
            f"https://api.hackertarget.com/hostsearch/?q={domain}", timeout=20)
        hackertarget_domains = re.findall(r'(.*?),', r.text)
        # Anexar apenas novos subdomínios válidos
        for dom in hackertarget_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
    Obter subdomínios do RapidDNS
    """
    try:
        r = requests.get(f"https://rapiddns.io/subdomain/{domain}", timeout=20)
        rapiddns_domains = re.findall(r'target="_blank".*?">(.*?)</a>', r.text)
        #Anexar apenas novos subdomínios válidos
        for dom in rapiddns_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
    Obter subdomínios do Riddler
    """
    try:
        r = requests.get(
            f"https://riddler.io/search/exportcsv?q=pld:{domain}", timeout=20)
        riddler_domains = re.findall(r'\[.*?\]",.*?,(.*?),\[', r.text)
        # Anexar apenas novos subdomínios válidos
        for dom in riddler_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
    Obter subdomínios do ThreatMiner
    """
    try:
        r = requests.get(
            f"https://api.threatminer.org/v2/domain.php?q={domain}&rt=5", timeout=20)
        raw_domains = json.loads(r.content)
        threatminer_domains = raw_domains['results']
        # Anexar apenas novos subdomínios válidos
        for dom in threatminer_domains:
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass
    """
   Obter subdomínios do URLScan
    """
    try:
        r = requests.get(
            f"https://urlscan.io/api/v1/search/?q={domain}", timeout=20)
        urlscan_domains = sorted(
            set(re.findall(r'https://(.*?).' + domain, r.text)))
        # Anexar apenas novos subdomínios válidos
        for dom in urlscan_domains:
            dom = dom + "." + domain
            if dom.endswith(domain) and dom not in doms:
                doms.append(dom)
    except KeyboardInterrupt:
        sys.exit(
            c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
    except:
        pass

    if filename != None:
        f = open(filename, "a")

    if doms:
        """
        Percorra os subdomínios e verifique o comprimento para imprimi-los em um formato de tabela
        """
        print(c.YELLOW + "+" + "-"*47 + "+")
        for value in doms:

            if len(value) >= 10 and len(value) <= 14:
                print("| " + value + "    \t\t\t\t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 15 and len(value) <= 19:
                print("| " + value + "\t\t\t\t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 20 and len(value) <= 24:
                print("| " + value + "   \t\t\t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 25 and len(value) <= 29:
                print("| " + value + "\t\t\t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 30 and len(value) <= 34:
                print("| " + value + " \t\t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 35 and len(value) <= 39:
                print("| " + value + "   \t|")
                if filename != None:
                    f.write(value + "\n")
            if len(value) >= 40 and len(value) <= 44:
                print("| " + value + " \t|")
                if filename != None:
                    f.write(value + "\n")
        """
        Imprimir resumo
        """
        print("+" + "-"*47 + "+" + c.END)
        print(c.YELLOW + "\nTotal discovered sudomains: " + str(len(doms)) + c.END)
        """
        Feche o arquivo se o parâmetro "-o" foi especificado
        """
        if filename != None:
            f.close()
            print(c.BLUE + "\n[" + c.GREEN + "+" +
                  c.BLUE + "] Output stored in " + filename)
    else:
        print(c.YELLOW + "No subdomains discovered through SSL transparency" + c.END)

# Verifique se o alvo fornecido está ativo


def checkDomain(domain):

    try:
        addr = socket.gethostbyname(domain)
    except:
        print(c.YELLOW + "\nTarget doesn't exists or is down" + c.END)
        sys.exit(1)


# O fluxo de trabalho do programa começa aqui
if __name__ == '__main__':
    program_version = 1.7
    urllib3.disable_warnings()
    warnings.simplefilter('ignore')

    if "--version" in sys.argv:
        print("\nAll in One Recon Tool v" +
              str(program_version) + " - By Edu0x01 ")
        print("Contact me: eduardo.barbosa1@proton.me\n")
        sys.exit(0)

    parse = parseArgs()

    # Verifique o formato do domínio
    if "." not in parse.domain:
        print(c.YELLOW + "\nInvalid domain format, example: domain.com" + c.END)
        sys.exit(0)

    # Se --output for passado (armazenar subdomínios no arquivo)
    if parse.output:
        store_info = 1
        filename = parse.output
    else:
        filename = None

    global domain

    domain = parse.domain
    checkDomain(domain)
    """
    Se --all for passado, faça todos os processos de enumeração
    """
    if parse.domain and parse.all:

        if domain.startswith('https://'):
            domain = domain.split('https://')[1]
        if domain.startswith('http://'):
            domain = domain.split('http://')[1]

        try:
            if not parse.quiet:
                banner()
            SDom(domain, filename)
            portScan(domain)
            ns_enum(domain)
            axfr(domain)
            mail_enum(domain)
            ip_enum(domain)
            ipv6_enum(domain)
            txt_enum(domain)
            whoisLookup(domain)
            basicEnum(domain)
            findBackups(domain)
            findSecrets(domain)
            cloudgitEnum(domain)
            wafDetector(domain)
            checkActiveSubs(domain, doms)
            wayback(domain)
            subTakeover(doms)

            if parse.token:
                crawlMails(domain, parse.token)
            else:
                print(c.BLUE + "\n[" + c.GREEN + "-" + c.BLUE +
                      "] No API token provided, skipping email crawling" + c.END)
            try:
                file.close()
            except:
                pass
        except KeyboardInterrupt:
            sys.exit(
                c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)

        sys.exit(0)

    """
    Digite nesta parte se --all não for passado
    """
    if parse.domain:
        domain = parse.domain

        if domain.startswith('https://'):
            domain = domain.split('https://')[1]
        if domain.startswith('http://'):
            domain = domain.split('http://')[1]

        try:
            if not parse.quiet:
                banner()
            SDom(domain, filename)
            """
            Verifique os argumentos passados via linha de comando
            """
            if parse.portscan:
                portScan(domain)
            if parse.nameservers:
                ns_enum(domain)
            if parse.axfr:
                axfr(domain)
            if parse.mail:
                mail_enum(domain)
            if parse.ip:
                ip_enum(domain)
            if parse.ipv6:
                ipv6_enum(domain)
            if parse.extra:
                txt_enum(domain)
            if parse.whois:
                whoisLookup(domain)
            if parse.enum:
                basicEnum(domain)
            if parse.backups:
                findBackups(domain)
            if parse.secrets:
                findSecrets(domain)
            if parse.repos:
                cloudgitEnum(domain)
            if parse.waf:
                wafDetector(domain)
            if parse.check:
                checkActiveSubs(domain, doms)
            if parse.wayback:
                wayback(domain)
            if parse.subtakeover:
                subTakeover(doms)
            if parse.token:
                crawlMails(domain, parse.token)

        except KeyboardInterrupt:
            sys.exit(
                c.RED + "\n[!] Interrupt handler received, exiting...\n" + c.END)
