/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactory.icons.DefaultIconLayerRegistry;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.util.IconSize;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class IconLayerRegistry
extends IconRegistry {
    private static IconLayerRegistry _default;

    public static synchronized IconLayerRegistry getDefault() {
        if (_default == null && (_default = (IconLayerRegistry)((Object)Lookup.getDefault().lookup(IconLayerRegistry.class))) == null) {
            _default = new DefaultIconLayerRegistry();
        }
        return _default;
    }

    public abstract FileObject getFileObject(RegistryIcon var1, IconSize var2);

    public static String[] splitName(String iconFileName) {
        Matcher matcher = Pattern.compile("^([\\w ]+?)(\\d*)\\.([^\\.]+)$").matcher(iconFileName);
        if (matcher.matches() && matcher.groupCount() == 3) {
            String iconName = matcher.group(1);
            String size = matcher.group(2);
            String extension = matcher.group(3);
            if (!iconName.isEmpty() && !extension.isEmpty()) {
                return new String[]{iconName, size, extension};
            }
        }
        throw new IllegalArgumentException("Invalid icon name: " + iconFileName);
    }
}

