/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.undo.Bundle;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class UndoStackTopComponent
extends TopComponent
implements PropertyChangeListener,
LookupListener,
ChangeListener,
Runnable {
    private UndoRedo _last = UndoRedo.NONE;
    private final Lookup.Result<UndoRedo.Provider> _result;
    private final boolean _fallback = true;
    private PropertyChangeListener _weakPCL;
    private ChangeListener _weakCL;
    private LookupListener _weakLL;
    private JList _redoStackList;
    private JList _undoStackList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;

    public UndoStackTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_UndoStackTopComponent());
        this.setToolTipText(Bundle.HINT_UndoStackTopComponent());
        this._result = Utilities.actionsGlobalContext().lookupResult(UndoRedo.Provider.class);
        this.initializeUndoRedo();
    }

    void initializeUndoRedo() {
        assert (EventQueue.isDispatchThread());
        if (this._weakLL != null) {
            return;
        }
        TopComponent.Registry r = WindowManager.getDefault().getRegistry();
        this._weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)r);
        r.addPropertyChangeListener(this._weakPCL);
        this._weakCL = WeakListeners.change((ChangeListener)this, null);
        this._weakLL = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this._result);
        this._result.addLookupListener(this._weakLL);
        this._last = UndoRedo.NONE;
        this.run();
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this);
            return;
        }
        UndoRedo ur = this.getUndoAndRedo();
        if (!Utilities.compareObjects((Object)this._last, (Object)ur)) {
            this._last.removeChangeListener(this._weakCL);
            this.update();
            this._last = ur;
            this._last.addChangeListener(this._weakCL);
        }
    }

    private UndoRedo getUndoAndRedo() {
        UndoRedo ur;
        assert (EventQueue.isDispatchThread());
        for (UndoRedo.Provider provider : this._result.allInstances()) {
            UndoRedo ur2 = provider.getUndoRedo();
            if (ur2 == null) continue;
            return ur2;
        }
        TopComponent el = GraphEditorRegistry.getDefault().getTopmost();
        if (el != null && (ur = el.getUndoRedo()) != null) {
            return ur;
        }
        return UndoRedo.NONE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("activated".equals(ev.getPropertyName())) {
            this.run();
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.run();
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.update();
    }

    private void update() {
        UndoRedoModel undoRedo;
        GraphID graphID;
        GraphCookie cookie;
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null && (graphID = cookie.getGraphID()) != null && (undoRedo = UndoRedoManager.getDefault().get(graphID)) != null) {
            this._undoStackList.setListData(undoRedo.getUndoStack());
            this._redoStackList.setListData(undoRedo.getRedoStack());
            return;
        }
        this._undoStackList.setListData(new Object[0]);
        this._redoStackList.setListData(new Object[0]);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this._undoStackList = new JList();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this._redoStackList = new JList();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UndoStackTopComponent.class, (String)"UndoStackTopComponent.jLabel1.text"));
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel1.add((Component)this.jLabel1, "North");
        this.jScrollPane1.setViewportView(this._undoStackList);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UndoStackTopComponent.class, (String)"UndoStackTopComponent.jLabel2.text"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.jPanel2.add((Component)this.jLabel2, "North");
        this.jScrollPane3.setViewportView(this._redoStackList);
        this.jPanel2.add((Component)this.jScrollPane3, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.add(this.jSplitPane1, "Center");
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

