/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.exp;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.table.TableIO;
import com.paterva.maltego.graph.table.TableIOFactory;
import com.paterva.maltego.graph.table.format.LinkTableFormatter;
import com.paterva.maltego.graph.table.format.PropertyFlatMapFormat;
import com.paterva.maltego.graph.table.io.exp.GraphTableBuilder;
import com.paterva.maltego.graph.table.io.exp.TabularGraphExportResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PropertyFlatMapBuilder
extends GraphTableBuilder {
    @Override
    protected TabularGraphExportResult build(Set<EntityID> entityIDs, Set<LinkID> linkIDs, List<List<String>> table) throws Exception {
        TabularGraphExportResult result = new TabularGraphExportResult();
        TableIO tableIO = TableIOFactory.createTable(table);
        if (this.progressHandle != null) {
            tableIO = TableIOFactory.createTable(tableIO, this.progressHandle);
        }
        Comparator byType = (left, right) -> left.getTypeName().compareTo(right.getTypeName());
        List<MaltegoEntity> entities = entityIDs.stream().map(entityID -> this.getEntity((EntityID)entityID)).filter(Objects::nonNull).collect(Collectors.toList());
        Collections.sort(entities, byType);
        PropertyFlatMapFormat entityFormat = new PropertyFlatMapFormat(tableIO);
        entityFormat.addEntities(entities);
        result.setEntitiesExported(entities.size());
        List links = linkIDs.stream().map(linkID -> this.getLink((LinkID)linkID)).filter(Objects::nonNull).collect(Collectors.toList());
        LinkTableFormatter linkFormat = new LinkTableFormatter(tableIO);
        for (MaltegoLink link : links) {
            EntityID sourceID = this.getSourceID((LinkID)link.getID());
            EntityID targetID = this.getTargetID((LinkID)link.getID());
            linkFormat.addLink(sourceID, link, targetID);
        }
        if (entities.size() > 0 && links.size() > 0) {
            tableIO.mergeHeader(LinkTableFormatter.LINK_START_ID);
        }
        result.setLinksExported(links.size());
        result.setLinesGenerated(table.size());
        return result;
    }
}

